/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.vr;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.vr.IVrListener;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.SystemService;
import com.android.server.utils.ManagedApplicationService;
import com.android.server.vr.EnabledComponentsObserver;
import com.android.server.vr.VrManagerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class VrManagerService
extends SystemService
implements EnabledComponentsObserver.EnabledComponentChangeListener {
    public static final String TAG = "VrManagerService";
    public static final String VR_MANAGER_BINDER_SERVICE = "vrmanager";
    private static final int PENDING_STATE_DELAY_MS = 300;
    private static final int EVENT_LOG_SIZE = 32;
    private static final int INVALID_APPOPS_MODE = -1;
    private final Object mLock = new Object();
    private final IBinder mOverlayToken = new Binder();
    private boolean mVrModeEnabled;
    private EnabledComponentsObserver mComponentObserver;
    private ManagedApplicationService mCurrentVrService;
    private Context mContext;
    private ComponentName mCurrentVrModeComponent;
    private int mCurrentVrModeUser;
    private boolean mWasDefaultGranted;
    private boolean mGuard;
    private final RemoteCallbackList<IVrStateCallbacks> mRemoteCallbacks = new RemoteCallbackList();
    private int mPreviousCoarseLocationMode = -1;
    private int mPreviousManageOverlayMode = -1;
    private VrState mPendingState;
    private final ArrayDeque<VrState> mLoggingDeque = new ArrayDeque(32);
    private final NotificationAccessManager mNotifAccessManager = new NotificationAccessManager();
    private static final int MSG_VR_STATE_CHANGE = 0;
    private static final int MSG_PENDING_VR_STATE_CHANGE = 1;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    boolean state = msg.arg1 == 1;
                    int i = VrManagerService.this.mRemoteCallbacks.beginBroadcast();
                    while (i > 0) {
                        --i;
                        try {
                            ((IVrStateCallbacks)VrManagerService.this.mRemoteCallbacks.getBroadcastItem(i)).onVrStateChanged(state);
                        }
                        catch (RemoteException remoteException) {}
                    }
                    VrManagerService.this.mRemoteCallbacks.finishBroadcast();
                    break;
                }
                case 1: {
                    Object object = VrManagerService.this.mLock;
                    synchronized (object) {
                        VrManagerService.this.consumeAndApplyPendingStateLocked();
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException("Unknown message type: " + msg.what);
                }
            }
        }
    };
    private static final ManagedApplicationService.BinderChecker sBinderChecker = new ManagedApplicationService.BinderChecker(){

        @Override
        public IInterface asInterface(IBinder binder) {
            return IVrListener.Stub.asInterface(binder);
        }

        @Override
        public boolean checkType(IInterface service) {
            return service instanceof IVrListener;
        }
    };
    private final IVrManager mVrManager = new IVrManager.Stub(){

        @Override
        public void registerListener(IVrStateCallbacks cb) {
            VrManagerService.this.enforceCallerPermission("android.permission.ACCESS_VR_MANAGER");
            if (cb == null) {
                throw new IllegalArgumentException("Callback binder object is null.");
            }
            VrManagerService.this.addStateCallback(cb);
        }

        @Override
        public void unregisterListener(IVrStateCallbacks cb) {
            VrManagerService.this.enforceCallerPermission("android.permission.ACCESS_VR_MANAGER");
            if (cb == null) {
                throw new IllegalArgumentException("Callback binder object is null.");
            }
            VrManagerService.this.removeStateCallback(cb);
        }

        @Override
        public boolean getVrModeState() {
            return VrManagerService.this.getVrMode();
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (VrManagerService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("permission denied: can't dump VrManagerService from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            pw.println("********* Dump of VrManagerService *********");
            pw.println("Previous state transitions:\n");
            String tab = "  ";
            VrManagerService.this.dumpStateTransitions(pw);
            pw.println("\n\nRemote Callbacks:");
            int i = VrManagerService.this.mRemoteCallbacks.beginBroadcast();
            while (i-- > 0) {
                pw.print(tab);
                pw.print(VrManagerService.this.mRemoteCallbacks.getBroadcastItem(i));
                if (i <= 0) continue;
                pw.println(",");
            }
            VrManagerService.this.mRemoteCallbacks.finishBroadcast();
            pw.println("\n");
            pw.println("Installed VrListenerService components:");
            int userId = VrManagerService.this.mCurrentVrModeUser;
            ArraySet<ComponentName> installed = VrManagerService.this.mComponentObserver.getInstalled(userId);
            if (installed == null || installed.size() == 0) {
                pw.println("None");
            } else {
                for (ComponentName n : installed) {
                    pw.print(tab);
                    pw.println(n.flattenToString());
                }
            }
            pw.println("Enabled VrListenerService components:");
            ArraySet<ComponentName> enabled = VrManagerService.this.mComponentObserver.getEnabled(userId);
            if (enabled == null || enabled.size() == 0) {
                pw.println("None");
            } else {
                for (ComponentName n : enabled) {
                    pw.print(tab);
                    pw.println(n.flattenToString());
                }
            }
            pw.println("\n");
            pw.println("********* End of VrManagerService Dump *********");
        }
    };

    private static native void initializeNative();

    private static native void setVrModeNative(boolean var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEnabledComponentChanged() {
        Object object = this.mLock;
        synchronized (object) {
            int currentUser = ActivityManager.getCurrentUser();
            ArraySet<ComponentName> enabledListeners = this.mComponentObserver.getEnabled(currentUser);
            ArraySet<String> enabledPackages = new ArraySet<String>();
            for (ComponentName n : enabledListeners) {
                String pkg = n.getPackageName();
                if (!this.isDefaultAllowed(pkg)) continue;
                enabledPackages.add(n.getPackageName());
            }
            this.mNotifAccessManager.update(enabledPackages);
            if (this.mCurrentVrService == null) {
                return;
            }
            this.consumeAndApplyPendingStateLocked();
            if (this.mCurrentVrService == null) {
                return;
            }
            this.updateCurrentVrServiceLocked(this.mVrModeEnabled, this.mCurrentVrService.getComponent(), this.mCurrentVrService.getUserId(), null);
        }
    }

    private void enforceCallerPermission(String permission2) {
        if (this.mContext.checkCallingOrSelfPermission(permission2) != 0) {
            throw new SecurityException("Caller does not hold the permission " + permission2);
        }
    }

    public VrManagerService(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        Object object = this.mLock;
        synchronized (object) {
            VrManagerService.initializeNative();
            this.mContext = this.getContext();
        }
        this.publishLocalService(VrManagerInternal.class, new LocalService());
        this.publishBinderService(VR_MANAGER_BINDER_SERVICE, this.mVrManager.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            Object object = this.mLock;
            synchronized (object) {
                Looper looper = Looper.getMainLooper();
                Handler handler = new Handler(looper);
                ArrayList<EnabledComponentsObserver.EnabledComponentChangeListener> listeners = new ArrayList<EnabledComponentsObserver.EnabledComponentChangeListener>();
                listeners.add(this);
                this.mComponentObserver = EnabledComponentsObserver.build(this.mContext, handler, "enabled_vr_listeners", looper, "android.permission.BIND_VR_LISTENER_SERVICE", "android.service.vr.VrListenerService", this.mLock, listeners);
                this.mComponentObserver.rebuildAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComponentObserver.onUsersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComponentObserver.onUsersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStopUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComponentObserver.onUsersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCleanupUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComponentObserver.onUsersChanged();
        }
    }

    private void updateOverlayStateLocked(String exemptedPackage, int newUserId, int oldUserId) {
        String[] stringArray;
        AppOpsManager appOpsManager = this.getContext().getSystemService(AppOpsManager.class);
        if (oldUserId != newUserId) {
            appOpsManager.setUserRestrictionForUser(24, false, this.mOverlayToken, null, oldUserId);
        }
        if (exemptedPackage == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = exemptedPackage;
        }
        String[] exemptions = stringArray;
        appOpsManager.setUserRestrictionForUser(24, this.mVrModeEnabled, this.mOverlayToken, exemptions, newUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDependentAppOpsLocked(String newVrServicePackage, int newUserId, String oldVrServicePackage, int oldUserId) {
        if (Objects.equals(newVrServicePackage, oldVrServicePackage)) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.updateOverlayStateLocked(newVrServicePackage, newUserId, oldUserId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCurrentVrServiceLocked(boolean enabled, ComponentName component, int userId, ComponentName calling) {
        boolean sendUpdatedCaller = false;
        long identity = Binder.clearCallingIdentity();
        try {
            boolean validUserComponent;
            boolean bl = validUserComponent = this.mComponentObserver.isValid(component, userId) == 0;
            if (!this.mVrModeEnabled && !enabled) {
                boolean bl2 = validUserComponent;
                return bl2;
            }
            String oldVrServicePackage = this.mCurrentVrService != null ? this.mCurrentVrService.getComponent().getPackageName() : null;
            int oldUserId = this.mCurrentVrModeUser;
            this.changeVrModeLocked(enabled);
            if (!enabled || !validUserComponent) {
                if (this.mCurrentVrService != null) {
                    Slog.i(TAG, "Disconnecting " + this.mCurrentVrService.getComponent() + " for user " + this.mCurrentVrService.getUserId());
                    this.mCurrentVrService.disconnect();
                    this.mCurrentVrService = null;
                }
            } else if (this.mCurrentVrService != null) {
                if (this.mCurrentVrService.disconnectIfNotMatching(component, userId)) {
                    Slog.i(TAG, "Disconnecting " + this.mCurrentVrService.getComponent() + " for user " + this.mCurrentVrService.getUserId());
                    this.createAndConnectService(component, userId);
                    sendUpdatedCaller = true;
                }
            } else {
                this.createAndConnectService(component, userId);
                sendUpdatedCaller = true;
            }
            if (calling != null && !Objects.equals(calling, this.mCurrentVrModeComponent)) {
                this.mCurrentVrModeComponent = calling;
                sendUpdatedCaller = true;
            }
            if (this.mCurrentVrModeUser != userId) {
                this.mCurrentVrModeUser = userId;
                sendUpdatedCaller = true;
            }
            String newVrServicePackage = this.mCurrentVrService != null ? this.mCurrentVrService.getComponent().getPackageName() : null;
            int newUserId = this.mCurrentVrModeUser;
            this.updateDependentAppOpsLocked(newVrServicePackage, newUserId, oldVrServicePackage, oldUserId);
            if (this.mCurrentVrService != null && sendUpdatedCaller) {
                final ComponentName c = this.mCurrentVrModeComponent;
                this.mCurrentVrService.sendEvent(new ManagedApplicationService.PendingEvent(){

                    @Override
                    public void runEvent(IInterface service) throws RemoteException {
                        IVrListener l = (IVrListener)service;
                        l.focusedActivityChanged(c);
                    }
                });
            }
            this.logStateLocked();
            boolean bl3 = validUserComponent;
            return bl3;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private boolean isDefaultAllowed(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        ApplicationInfo info = null;
        try {
            info = pm.getApplicationInfo(packageName, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info != null && (info.isSystemApp() || info.isUpdatedSystemApp());
    }

    private void grantNotificationPolicyAccess(String pkg) {
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        nm.setNotificationPolicyAccessGranted(pkg, true);
    }

    private void revokeNotificationPolicyAccess(String pkg) {
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        nm.removeAutomaticZenRules(pkg);
        nm.setNotificationPolicyAccessGranted(pkg, false);
    }

    private void grantNotificationListenerAccess(String pkg, int userId) {
        PackageManager pm = this.mContext.getPackageManager();
        ArraySet<ComponentName> possibleServices = EnabledComponentsObserver.loadComponentNames(pm, userId, "android.service.notification.NotificationListenerService", "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE");
        ContentResolver resolver = this.mContext.getContentResolver();
        ArraySet<String> current = this.getNotificationListeners(resolver, userId);
        for (ComponentName c : possibleServices) {
            String flatName = c.flattenToString();
            if (!Objects.equals(c.getPackageName(), pkg) || current.contains(flatName)) continue;
            current.add(flatName);
        }
        if (current.size() > 0) {
            String flatSettings = VrManagerService.formatSettings(current);
            Settings.Secure.putStringForUser(resolver, "enabled_notification_listeners", flatSettings, userId);
        }
    }

    private void revokeNotificationListenerAccess(String pkg, int userId) {
        ContentResolver resolver = this.mContext.getContentResolver();
        ArraySet<String> current = this.getNotificationListeners(resolver, userId);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String c : current) {
            ComponentName component = ComponentName.unflattenFromString(c);
            if (component == null || !component.getPackageName().equals(pkg)) continue;
            toRemove.add(c);
        }
        current.removeAll(toRemove);
        String flatSettings = VrManagerService.formatSettings(current);
        Settings.Secure.putStringForUser(resolver, "enabled_notification_listeners", flatSettings, userId);
    }

    private void grantCoarseLocationPermissionIfNeeded(String pkg, int userId) {
        if (!this.isPermissionUserUpdated("android.permission.ACCESS_COARSE_LOCATION", pkg, userId)) {
            this.mContext.getPackageManager().grantRuntimePermission(pkg, "android.permission.ACCESS_COARSE_LOCATION", new UserHandle(userId));
        }
    }

    private void revokeCoarseLocationPermissionIfNeeded(String pkg, int userId) {
        if (!this.isPermissionUserUpdated("android.permission.ACCESS_COARSE_LOCATION", pkg, userId)) {
            this.mContext.getPackageManager().revokeRuntimePermission(pkg, "android.permission.ACCESS_COARSE_LOCATION", new UserHandle(userId));
        }
    }

    private boolean isPermissionUserUpdated(String permission2, String pkg, int userId) {
        int flags = this.mContext.getPackageManager().getPermissionFlags(permission2, pkg, new UserHandle(userId));
        return (flags & 3) != 0;
    }

    private ArraySet<String> getNotificationListeners(ContentResolver resolver, int userId) {
        String flat = Settings.Secure.getStringForUser(resolver, "enabled_notification_listeners", userId);
        ArraySet<String> current = new ArraySet<String>();
        if (flat != null) {
            String[] allowed;
            for (String s : allowed = flat.split(":")) {
                if (TextUtils.isEmpty(s)) continue;
                current.add(s);
            }
        }
        return current;
    }

    private static String formatSettings(Collection<String> c) {
        if (c == null || c.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        boolean start = true;
        for (String s : c) {
            if ("".equals(s)) continue;
            if (!start) {
                b.append(':');
            }
            b.append(s);
            start = false;
        }
        return b.toString();
    }

    private void createAndConnectService(ComponentName component, int userId) {
        this.mCurrentVrService = VrManagerService.create(this.mContext, component, userId);
        this.mCurrentVrService.connect();
        Slog.i(TAG, "Connecting " + component + " for user " + userId);
    }

    private void changeVrModeLocked(boolean enabled) {
        if (this.mVrModeEnabled != enabled) {
            this.mVrModeEnabled = enabled;
            Slog.i(TAG, "VR mode " + (this.mVrModeEnabled ? "enabled" : "disabled"));
            VrManagerService.setVrModeNative(this.mVrModeEnabled);
            this.onVrModeChangedLocked();
        }
    }

    private void onVrModeChangedLocked() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0, this.mVrModeEnabled ? 1 : 0, 0));
    }

    private static ManagedApplicationService create(Context context, ComponentName component, int userId) {
        return ManagedApplicationService.build(context, component, userId, 17040499, "android.settings.VR_LISTENER_SETTINGS", sBinderChecker);
    }

    private void consumeAndApplyPendingStateLocked() {
        if (this.mPendingState != null) {
            this.updateCurrentVrServiceLocked(this.mPendingState.enabled, this.mPendingState.targetPackageName, this.mPendingState.userId, this.mPendingState.callingPackage);
            this.mPendingState = null;
        }
    }

    private void logStateLocked() {
        ComponentName currentBoundService = this.mCurrentVrService == null ? null : this.mCurrentVrService.getComponent();
        VrState current = new VrState(this.mVrModeEnabled, currentBoundService, this.mCurrentVrModeUser, this.mCurrentVrModeComponent, this.mWasDefaultGranted);
        if (this.mLoggingDeque.size() == 32) {
            this.mLoggingDeque.removeFirst();
        }
        this.mLoggingDeque.add(current);
    }

    private void dumpStateTransitions(PrintWriter pw) {
        SimpleDateFormat d = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
        String tab = "  ";
        if (this.mLoggingDeque.size() == 0) {
            pw.print(tab);
            pw.println("None");
        }
        for (VrState state : this.mLoggingDeque) {
            pw.print(d.format(new Date(state.timestamp)));
            pw.print(tab);
            pw.print("State changed to:");
            pw.print(tab);
            pw.println(state.enabled ? "ENABLED" : "DISABLED");
            if (!state.enabled) continue;
            pw.print(tab);
            pw.print("User=");
            pw.println(state.userId);
            pw.print(tab);
            pw.print("Current VR Activity=");
            pw.println(state.callingPackage == null ? "None" : state.callingPackage.flattenToString());
            pw.print(tab);
            pw.print("Bound VrListenerService=");
            pw.println(state.targetPackageName == null ? "None" : state.targetPackageName.flattenToString());
            if (!state.defaultPermissionsGranted) continue;
            pw.print(tab);
            pw.println("Default permissions granted to the bound VrListenerService.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVrMode(boolean enabled, ComponentName targetPackageName, int userId, ComponentName callingPackage, boolean immediate) {
        Object object = this.mLock;
        synchronized (object) {
            if (!enabled && this.mCurrentVrService != null && !immediate) {
                if (this.mPendingState == null) {
                    this.mHandler.sendEmptyMessageDelayed(1, 300L);
                }
                this.mPendingState = new VrState(enabled, targetPackageName, userId, callingPackage);
                return;
            }
            this.mHandler.removeMessages(1);
            this.mPendingState = null;
            this.updateCurrentVrServiceLocked(enabled, targetPackageName, userId, callingPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int hasVrPackage(ComponentName targetPackageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mComponentObserver.isValid(targetPackageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentVrListener(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentVrService == null) {
                return false;
            }
            return this.mCurrentVrService.getComponent().getPackageName().equals(packageName) && userId == this.mCurrentVrService.getUserId();
        }
    }

    private void addStateCallback(IVrStateCallbacks cb) {
        this.mRemoteCallbacks.register(cb);
    }

    private void removeStateCallback(IVrStateCallbacks cb) {
        this.mRemoteCallbacks.unregister(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getVrMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mVrModeEnabled;
        }
    }

    private final class LocalService
    extends VrManagerInternal {
        private LocalService() {
        }

        @Override
        public void setVrMode(boolean enabled, ComponentName packageName, int userId, ComponentName callingPackage) {
            VrManagerService.this.setVrMode(enabled, packageName, userId, callingPackage, false);
        }

        @Override
        public void setVrModeImmediate(boolean enabled, ComponentName packageName, int userId, ComponentName callingPackage) {
            VrManagerService.this.setVrMode(enabled, packageName, userId, callingPackage, true);
        }

        @Override
        public boolean isCurrentVrListener(String packageName, int userId) {
            return VrManagerService.this.isCurrentVrListener(packageName, userId);
        }

        @Override
        public int hasVrPackage(ComponentName packageName, int userId) {
            return VrManagerService.this.hasVrPackage(packageName, userId);
        }
    }

    private final class NotificationAccessManager {
        private final SparseArray<ArraySet<String>> mAllowedPackages = new SparseArray();
        private final ArrayMap<String, Integer> mNotificationAccessPackageToUserId = new ArrayMap();

        private NotificationAccessManager() {
        }

        public void update(Collection<String> packageNames) {
            int currentUserId = ActivityManager.getCurrentUser();
            ArraySet<String> allowed = this.mAllowedPackages.get(currentUserId);
            if (allowed == null) {
                allowed = new ArraySet();
            }
            int listenerCount = this.mNotificationAccessPackageToUserId.size();
            for (int i = listenerCount - 1; i >= 0; --i) {
                int grantUserId = this.mNotificationAccessPackageToUserId.valueAt(i);
                if (grantUserId == currentUserId) continue;
                String packageName = this.mNotificationAccessPackageToUserId.keyAt(i);
                VrManagerService.this.revokeNotificationListenerAccess(packageName, grantUserId);
                VrManagerService.this.revokeNotificationPolicyAccess(packageName);
                VrManagerService.this.revokeCoarseLocationPermissionIfNeeded(packageName, grantUserId);
                this.mNotificationAccessPackageToUserId.removeAt(i);
            }
            for (String pkg : allowed) {
                if (packageNames.contains(pkg)) continue;
                VrManagerService.this.revokeNotificationListenerAccess(pkg, currentUserId);
                VrManagerService.this.revokeNotificationPolicyAccess(pkg);
                VrManagerService.this.revokeCoarseLocationPermissionIfNeeded(pkg, currentUserId);
                this.mNotificationAccessPackageToUserId.remove(pkg);
            }
            for (String pkg : packageNames) {
                if (allowed.contains(pkg)) continue;
                VrManagerService.this.grantNotificationPolicyAccess(pkg);
                VrManagerService.this.grantNotificationListenerAccess(pkg, currentUserId);
                VrManagerService.this.grantCoarseLocationPermissionIfNeeded(pkg, currentUserId);
                this.mNotificationAccessPackageToUserId.put(pkg, currentUserId);
            }
            allowed.clear();
            allowed.addAll(packageNames);
            this.mAllowedPackages.put(currentUserId, allowed);
        }
    }

    private static class VrState {
        final boolean enabled;
        final int userId;
        final ComponentName targetPackageName;
        final ComponentName callingPackage;
        final long timestamp;
        final boolean defaultPermissionsGranted;

        VrState(boolean enabled, ComponentName targetPackageName, int userId, ComponentName callingPackage) {
            this.enabled = enabled;
            this.userId = userId;
            this.targetPackageName = targetPackageName;
            this.callingPackage = callingPackage;
            this.defaultPermissionsGranted = false;
            this.timestamp = System.currentTimeMillis();
        }

        VrState(boolean enabled, ComponentName targetPackageName, int userId, ComponentName callingPackage, boolean defaultPermissionsGranted) {
            this.enabled = enabled;
            this.userId = userId;
            this.targetPackageName = targetPackageName;
            this.callingPackage = callingPackage;
            this.defaultPermissionsGranted = defaultPermissionsGranted;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

