/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.webkit;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Slog;
import android.webkit.WebViewFactory;
import android.webkit.WebViewProviderInfo;
import android.webkit.WebViewProviderResponse;
import com.android.server.webkit.SystemInterface;
import java.util.ArrayList;
import java.util.Arrays;

public class WebViewUpdateServiceImpl {
    private static final String TAG = WebViewUpdateServiceImpl.class.getSimpleName();
    private SystemInterface mSystemInterface;
    private WebViewUpdater mWebViewUpdater;
    private Context mContext;

    public WebViewUpdateServiceImpl(Context context, SystemInterface systemInterface) {
        this.mContext = context;
        this.mSystemInterface = systemInterface;
        this.mWebViewUpdater = new WebViewUpdater(this.mContext, this.mSystemInterface);
    }

    void packageStateChanged(String packageName, int changedState, int userId) {
        this.updateFallbackStateOnPackageChange(packageName, changedState);
        this.mWebViewUpdater.packageStateChanged(packageName, changedState);
    }

    void prepareWebViewInSystemServer() {
        this.updateFallbackStateOnBoot();
        this.mWebViewUpdater.prepareWebViewInSystemServer();
    }

    private boolean existsValidNonFallbackProvider(WebViewProviderInfo[] providers) {
        for (WebViewProviderInfo provider : providers) {
            if (!provider.availableByDefault || provider.isFallback) continue;
            try {
                PackageInfo packageInfo = this.mSystemInterface.getPackageInfoForProvider(provider);
                if (!WebViewUpdateServiceImpl.isInstalledPackage(packageInfo) || !WebViewUpdateServiceImpl.isEnabledPackage(packageInfo) || !this.mWebViewUpdater.isValidProvider(provider, packageInfo)) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    void handleNewUser(int userId) {
        if (!this.mSystemInterface.isFallbackLogicEnabled()) {
            return;
        }
        WebViewProviderInfo[] webviewProviders = this.mSystemInterface.getWebViewPackages();
        WebViewProviderInfo fallbackProvider = WebViewUpdateServiceImpl.getFallbackProvider(webviewProviders);
        if (fallbackProvider == null) {
            return;
        }
        this.mSystemInterface.enablePackageForUser(fallbackProvider.packageName, !this.existsValidNonFallbackProvider(webviewProviders), userId);
    }

    void notifyRelroCreationCompleted() {
        this.mWebViewUpdater.notifyRelroCreationCompleted();
    }

    WebViewProviderResponse waitForAndGetProvider() {
        return this.mWebViewUpdater.waitForAndGetProvider();
    }

    String changeProviderAndSetting(String newProvider) {
        return this.mWebViewUpdater.changeProviderAndSetting(newProvider);
    }

    WebViewProviderInfo[] getValidWebViewPackages() {
        return this.mWebViewUpdater.getValidAndInstalledWebViewPackages();
    }

    WebViewProviderInfo[] getWebViewPackages() {
        return this.mSystemInterface.getWebViewPackages();
    }

    String getCurrentWebViewPackageName() {
        return this.mWebViewUpdater.getCurrentWebViewPackageName();
    }

    void enableFallbackLogic(boolean enable) {
        this.mSystemInterface.enableFallbackLogic(enable);
    }

    private void updateFallbackStateOnBoot() {
        if (!this.mSystemInterface.isFallbackLogicEnabled()) {
            return;
        }
        WebViewProviderInfo[] webviewProviders = this.mSystemInterface.getWebViewPackages();
        this.updateFallbackState(webviewProviders, true);
    }

    private void updateFallbackStateOnPackageChange(String changedPackage, int changedState) {
        if (!this.mSystemInterface.isFallbackLogicEnabled()) {
            return;
        }
        WebViewProviderInfo[] webviewProviders = this.mSystemInterface.getWebViewPackages();
        boolean changedPackageAvailableByDefault = false;
        for (WebViewProviderInfo provider : webviewProviders) {
            if (!provider.packageName.equals(changedPackage)) continue;
            if (!provider.availableByDefault) break;
            changedPackageAvailableByDefault = true;
            break;
        }
        if (!changedPackageAvailableByDefault) {
            return;
        }
        this.updateFallbackState(webviewProviders, false);
    }

    private void updateFallbackState(WebViewProviderInfo[] webviewProviders, boolean isBoot) {
        WebViewProviderInfo fallbackProvider = WebViewUpdateServiceImpl.getFallbackProvider(webviewProviders);
        if (fallbackProvider == null) {
            return;
        }
        boolean existsValidNonFallbackProvider = this.existsValidNonFallbackProvider(webviewProviders);
        boolean isFallbackEnabled = false;
        try {
            isFallbackEnabled = WebViewUpdateServiceImpl.isEnabledPackage(this.mSystemInterface.getPackageInfoForProvider(fallbackProvider));
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (existsValidNonFallbackProvider && (isFallbackEnabled || isBoot)) {
            this.mSystemInterface.uninstallAndDisablePackageForAllUsers(this.mContext, fallbackProvider.packageName);
        } else if (!(existsValidNonFallbackProvider || isFallbackEnabled && !isBoot)) {
            this.mSystemInterface.enablePackageForAllUsers(this.mContext, fallbackProvider.packageName, true);
        }
    }

    private static WebViewProviderInfo getFallbackProvider(WebViewProviderInfo[] webviewPackages) {
        for (WebViewProviderInfo provider : webviewPackages) {
            if (!provider.isFallback) continue;
            return provider;
        }
        return null;
    }

    boolean isFallbackPackage(String packageName) {
        if (packageName == null || !this.mSystemInterface.isFallbackLogicEnabled()) {
            return false;
        }
        WebViewProviderInfo[] webviewPackages = this.mSystemInterface.getWebViewPackages();
        WebViewProviderInfo fallbackProvider = WebViewUpdateServiceImpl.getFallbackProvider(webviewPackages);
        return fallbackProvider != null && packageName.equals(fallbackProvider.packageName);
    }

    private static boolean providerHasValidSignature(WebViewProviderInfo provider, PackageInfo packageInfo, SystemInterface systemInterface) {
        if (systemInterface.systemIsDebuggable()) {
            return true;
        }
        if (provider.signatures == null || provider.signatures.length == 0) {
            return packageInfo.applicationInfo.isSystemApp();
        }
        Signature[] packageSignatures = packageInfo.signatures;
        if (packageSignatures.length != 1) {
            return false;
        }
        byte[] packageSignature = packageSignatures[0].toByteArray();
        for (String signature : provider.signatures) {
            byte[] validSignature = Base64.decode(signature, 0);
            if (!Arrays.equals(packageSignature, validSignature)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnabledPackage(PackageInfo packageInfo) {
        return packageInfo.applicationInfo.enabled;
    }

    private static boolean isInstalledPackage(PackageInfo packageInfo) {
        return (packageInfo.applicationInfo.flags & 0x800000) != 0 && (packageInfo.applicationInfo.privateFlags & 1) == 0;
    }

    private static class WebViewUpdater {
        private Context mContext;
        private SystemInterface mSystemInterface;
        private int mMinimumVersionCode = -1;
        private static final int WAIT_TIMEOUT_MS = 1000;
        private int mNumRelroCreationsStarted = 0;
        private int mNumRelroCreationsFinished = 0;
        private boolean mWebViewPackageDirty = false;
        private boolean mAnyWebViewInstalled = false;
        private int NUMBER_OF_RELROS_UNKNOWN = Integer.MAX_VALUE;
        private PackageInfo mCurrentWebViewPackage = null;
        private Object mLock = new Object();

        public WebViewUpdater(Context context, SystemInterface systemInterface) {
            this.mContext = context;
            this.mSystemInterface = systemInterface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void packageStateChanged(String packageName, int changedState) {
            for (WebViewProviderInfo provider : this.mSystemInterface.getWebViewPackages()) {
                String webviewPackage = provider.packageName;
                if (!webviewPackage.equals(packageName)) continue;
                boolean updateWebView = false;
                boolean removedOrChangedOldPackage = false;
                String oldProviderName = null;
                PackageInfo newPackage = null;
                Object object = this.mLock;
                synchronized (object) {
                    try {
                        newPackage = this.findPreferredWebViewPackage();
                        if (this.mCurrentWebViewPackage != null) {
                            oldProviderName = this.mCurrentWebViewPackage.packageName;
                            if (changedState == 0 && newPackage.packageName.equals(oldProviderName)) {
                                return;
                            }
                            if (newPackage.packageName.equals(oldProviderName) && newPackage.lastUpdateTime == this.mCurrentWebViewPackage.lastUpdateTime) {
                                return;
                            }
                        }
                        updateWebView = provider.packageName.equals(newPackage.packageName) || provider.packageName.equals(oldProviderName) || this.mCurrentWebViewPackage == null;
                        removedOrChangedOldPackage = provider.packageName.equals(oldProviderName);
                        if (updateWebView) {
                            this.onWebViewProviderChanged(newPackage);
                        }
                    }
                    catch (WebViewFactory.MissingWebViewPackageException e) {
                        Slog.e(TAG, "Could not find valid WebView package to create relro with " + e);
                    }
                }
                if (updateWebView && !removedOrChangedOldPackage && oldProviderName != null) {
                    this.mSystemInterface.killPackageDependents(oldProviderName);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepareWebViewInSystemServer() {
            try {
                Object object = this.mLock;
                synchronized (object) {
                    this.mCurrentWebViewPackage = this.findPreferredWebViewPackage();
                    this.mSystemInterface.updateUserSetting(this.mContext, this.mCurrentWebViewPackage.packageName);
                    this.onWebViewProviderChanged(this.mCurrentWebViewPackage);
                }
            }
            catch (Throwable t) {
                Slog.e(TAG, "error preparing webview provider from system server", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String changeProviderAndSetting(String newProviderName) {
            PackageInfo oldPackage = null;
            PackageInfo newPackage = null;
            boolean providerChanged = false;
            Object object = this.mLock;
            synchronized (object) {
                oldPackage = this.mCurrentWebViewPackage;
                this.mSystemInterface.updateUserSetting(this.mContext, newProviderName);
                try {
                    newPackage = this.findPreferredWebViewPackage();
                    providerChanged = oldPackage == null || !newPackage.packageName.equals(oldPackage.packageName);
                }
                catch (WebViewFactory.MissingWebViewPackageException e) {
                    Slog.e(TAG, "Tried to change WebView provider but failed to fetch WebView package " + e);
                    return "";
                }
                if (providerChanged) {
                    this.onWebViewProviderChanged(newPackage);
                }
            }
            if (providerChanged && oldPackage != null) {
                this.mSystemInterface.killPackageDependents(oldPackage.packageName);
            }
            return newPackage.packageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onWebViewProviderChanged(PackageInfo newPackage) {
            Object object = this.mLock;
            synchronized (object) {
                this.mAnyWebViewInstalled = true;
                if (this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished) {
                    this.mCurrentWebViewPackage = newPackage;
                    this.mNumRelroCreationsStarted = this.NUMBER_OF_RELROS_UNKNOWN;
                    this.mNumRelroCreationsFinished = 0;
                    this.mNumRelroCreationsStarted = this.mSystemInterface.onWebViewProviderChanged(newPackage);
                    this.checkIfRelrosDoneLocked();
                } else {
                    this.mWebViewPackageDirty = true;
                }
            }
        }

        private ProviderAndPackageInfo[] getValidWebViewPackagesAndInfos(boolean onlyInstalled) {
            WebViewProviderInfo[] allProviders = this.mSystemInterface.getWebViewPackages();
            ArrayList<ProviderAndPackageInfo> providers = new ArrayList<ProviderAndPackageInfo>();
            for (int n = 0; n < allProviders.length; ++n) {
                try {
                    PackageInfo packageInfo = this.mSystemInterface.getPackageInfoForProvider(allProviders[n]);
                    if (onlyInstalled && !WebViewUpdateServiceImpl.isInstalledPackage(packageInfo) || !this.isValidProvider(allProviders[n], packageInfo)) continue;
                    providers.add(new ProviderAndPackageInfo(allProviders[n], packageInfo));
                    continue;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            return providers.toArray(new ProviderAndPackageInfo[providers.size()]);
        }

        public WebViewProviderInfo[] getValidAndInstalledWebViewPackages() {
            ProviderAndPackageInfo[] providersAndPackageInfos = this.getValidWebViewPackagesAndInfos(true);
            WebViewProviderInfo[] providers = new WebViewProviderInfo[providersAndPackageInfos.length];
            for (int n = 0; n < providersAndPackageInfos.length; ++n) {
                providers[n] = providersAndPackageInfos[n].provider;
            }
            return providers;
        }

        private PackageInfo findPreferredWebViewPackage() {
            ProviderAndPackageInfo[] providers = this.getValidWebViewPackagesAndInfos(false);
            String userChosenProvider = this.mSystemInterface.getUserChosenWebViewProvider(this.mContext);
            for (ProviderAndPackageInfo providerAndPackage : providers) {
                if (!providerAndPackage.provider.packageName.equals(userChosenProvider) || !WebViewUpdateServiceImpl.isInstalledPackage(providerAndPackage.packageInfo) || !WebViewUpdateServiceImpl.isEnabledPackage(providerAndPackage.packageInfo)) continue;
                return providerAndPackage.packageInfo;
            }
            for (ProviderAndPackageInfo providerAndPackage : providers) {
                if (!providerAndPackage.provider.availableByDefault || !WebViewUpdateServiceImpl.isInstalledPackage(providerAndPackage.packageInfo) || !WebViewUpdateServiceImpl.isEnabledPackage(providerAndPackage.packageInfo)) continue;
                return providerAndPackage.packageInfo;
            }
            for (ProviderAndPackageInfo providerAndPackage : providers) {
                if (!providerAndPackage.provider.availableByDefault) continue;
                return providerAndPackage.packageInfo;
            }
            this.mAnyWebViewInstalled = false;
            throw new WebViewFactory.MissingWebViewPackageException("Could not find a loadable WebView package");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyRelroCreationCompleted() {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mNumRelroCreationsFinished;
                this.checkIfRelrosDoneLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WebViewProviderResponse waitForAndGetProvider() {
            PackageInfo webViewPackage = null;
            long NS_PER_MS = 1000000L;
            long timeoutTimeMs = System.nanoTime() / 1000000L + 1000L;
            boolean webViewReady = false;
            int webViewStatus = 0;
            Object object = this.mLock;
            synchronized (object) {
                long timeNowMs;
                webViewReady = this.webViewIsReadyLocked();
                while (!webViewReady && (timeNowMs = System.nanoTime() / 1000000L) < timeoutTimeMs) {
                    try {
                        this.mLock.wait(timeoutTimeMs - timeNowMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    webViewReady = this.webViewIsReadyLocked();
                }
                webViewPackage = this.mCurrentWebViewPackage;
                if (!webViewReady) {
                    if (!this.mAnyWebViewInstalled) {
                        webViewStatus = 4;
                    } else {
                        webViewStatus = 3;
                        Slog.e(TAG, "Timed out waiting for relro creation, relros started " + this.mNumRelroCreationsStarted + " relros finished " + this.mNumRelroCreationsFinished + " package dirty? " + this.mWebViewPackageDirty);
                    }
                }
            }
            if (!webViewReady) {
                Slog.w(TAG, "creating relro file timed out");
            }
            return new WebViewProviderResponse(webViewPackage, webViewStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getCurrentWebViewPackageName() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCurrentWebViewPackage == null) {
                    return null;
                }
                return this.mCurrentWebViewPackage.packageName;
            }
        }

        private boolean webViewIsReadyLocked() {
            return !this.mWebViewPackageDirty && this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished && this.mAnyWebViewInstalled;
        }

        private void checkIfRelrosDoneLocked() {
            if (this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished) {
                if (this.mWebViewPackageDirty) {
                    this.mWebViewPackageDirty = false;
                    try {
                        PackageInfo newPackage = this.findPreferredWebViewPackage();
                        this.onWebViewProviderChanged(newPackage);
                    }
                    catch (WebViewFactory.MissingWebViewPackageException missingWebViewPackageException) {}
                } else {
                    this.mLock.notifyAll();
                }
            }
        }

        private static boolean versionCodeGE(int versionCode1, int versionCode2) {
            int v1 = versionCode1 / 100000;
            int v2 = versionCode2 / 100000;
            return v1 >= v2;
        }

        public boolean isValidProvider(WebViewProviderInfo configInfo, PackageInfo packageInfo) {
            if (!WebViewUpdater.versionCodeGE(packageInfo.versionCode, this.getMinimumVersionCode()) && !this.mSystemInterface.systemIsDebuggable()) {
                return false;
            }
            return WebViewUpdateServiceImpl.providerHasValidSignature(configInfo, packageInfo, this.mSystemInterface) && WebViewFactory.getWebViewLibrary(packageInfo.applicationInfo) != null;
        }

        private int getMinimumVersionCode() {
            if (this.mMinimumVersionCode > 0) {
                return this.mMinimumVersionCode;
            }
            for (WebViewProviderInfo provider : this.mSystemInterface.getWebViewPackages()) {
                if (!provider.availableByDefault || provider.isFallback) continue;
                try {
                    int versionCode = this.mSystemInterface.getFactoryPackageVersion(provider.packageName);
                    if (this.mMinimumVersionCode >= 0 && versionCode >= this.mMinimumVersionCode) continue;
                    this.mMinimumVersionCode = versionCode;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            return this.mMinimumVersionCode;
        }

        private static class ProviderAndPackageInfo {
            public final WebViewProviderInfo provider;
            public final PackageInfo packageInfo;

            public ProviderAndPackageInfo(WebViewProviderInfo provider, PackageInfo packageInfo) {
                this.provider = provider;
                this.packageInfo = packageInfo;
            }
        }
    }
}

