/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.view.AppTransitionAnimationSpec;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.ClipRectAnimation;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import com.android.internal.R;
import com.android.internal.util.DumpUtils;
import com.android.server.AttributeCache;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.animation.ClipRectLRAnimation;
import com.android.server.wm.animation.ClipRectTBAnimation;
import com.android.server.wm.animation.CurvedTranslateAnimation;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AppTransition
implements DumpUtils.Dump {
    private static final String TAG = "WindowManager";
    private static final int CLIP_REVEAL_TRANSLATION_Y_DP = 8;
    public static final int TRANSIT_UNSET = -1;
    public static final int TRANSIT_NONE = 0;
    public static final int TRANSIT_ACTIVITY_OPEN = 6;
    public static final int TRANSIT_ACTIVITY_CLOSE = 7;
    public static final int TRANSIT_TASK_OPEN = 8;
    public static final int TRANSIT_TASK_CLOSE = 9;
    public static final int TRANSIT_TASK_TO_FRONT = 10;
    public static final int TRANSIT_TASK_TO_BACK = 11;
    public static final int TRANSIT_WALLPAPER_CLOSE = 12;
    public static final int TRANSIT_WALLPAPER_OPEN = 13;
    public static final int TRANSIT_WALLPAPER_INTRA_OPEN = 14;
    public static final int TRANSIT_WALLPAPER_INTRA_CLOSE = 15;
    public static final int TRANSIT_TASK_OPEN_BEHIND = 16;
    public static final int TRANSIT_TASK_IN_PLACE = 17;
    public static final int TRANSIT_ACTIVITY_RELAUNCH = 18;
    public static final int TRANSIT_DOCK_TASK_FROM_RECENTS = 19;
    private static final float RECENTS_THUMBNAIL_FADEIN_FRACTION = 0.5f;
    private static final float RECENTS_THUMBNAIL_FADEOUT_FRACTION = 0.5f;
    static final int DEFAULT_APP_TRANSITION_DURATION = 336;
    static final Interpolator TOUCH_RESPONSE_INTERPOLATOR = new PathInterpolator(0.3f, 0.0f, 0.1f, 1.0f);
    private static final Interpolator THUMBNAIL_DOCK_INTERPOLATOR = new PathInterpolator(0.85f, 0.0f, 1.0f, 1.0f);
    private static final int MAX_CLIP_REVEAL_TRANSITION_DURATION = 420;
    private static final int THUMBNAIL_APP_TRANSITION_DURATION = 336;
    private static final long APP_TRANSITION_TIMEOUT_MS = 5000L;
    private final Context mContext;
    private final WindowManagerService mService;
    private int mNextAppTransition = -1;
    private int mLastUsedAppTransition = -1;
    private String mLastOpeningApp;
    private String mLastClosingApp;
    private static final int NEXT_TRANSIT_TYPE_NONE = 0;
    private static final int NEXT_TRANSIT_TYPE_CUSTOM = 1;
    private static final int NEXT_TRANSIT_TYPE_SCALE_UP = 2;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_UP = 3;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_DOWN = 4;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_UP = 5;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_DOWN = 6;
    private static final int NEXT_TRANSIT_TYPE_CUSTOM_IN_PLACE = 7;
    private static final int NEXT_TRANSIT_TYPE_CLIP_REVEAL = 8;
    private int mNextAppTransitionType = 0;
    private static final int THUMBNAIL_TRANSITION_ENTER_SCALE_UP = 0;
    private static final int THUMBNAIL_TRANSITION_EXIT_SCALE_UP = 1;
    private static final int THUMBNAIL_TRANSITION_ENTER_SCALE_DOWN = 2;
    private static final int THUMBNAIL_TRANSITION_EXIT_SCALE_DOWN = 3;
    private String mNextAppTransitionPackage;
    private boolean mNextAppTransitionScaleUp;
    private IRemoteCallback mNextAppTransitionCallback;
    private IRemoteCallback mNextAppTransitionFutureCallback;
    private IRemoteCallback mAnimationFinishedCallback;
    private int mNextAppTransitionEnter;
    private int mNextAppTransitionExit;
    private int mNextAppTransitionInPlace;
    private final SparseArray<AppTransitionAnimationSpec> mNextAppTransitionAnimationsSpecs = new SparseArray();
    private IAppTransitionAnimationSpecsFuture mNextAppTransitionAnimationsSpecsFuture;
    private boolean mNextAppTransitionAnimationsSpecsPending;
    private AppTransitionAnimationSpec mDefaultNextAppTransitionAnimationSpec;
    private Rect mNextAppTransitionInsets = new Rect();
    private Rect mTmpFromClipRect = new Rect();
    private Rect mTmpToClipRect = new Rect();
    private final Rect mTmpRect = new Rect();
    private static final int APP_STATE_IDLE = 0;
    private static final int APP_STATE_READY = 1;
    private static final int APP_STATE_RUNNING = 2;
    private static final int APP_STATE_TIMEOUT = 3;
    private int mAppTransitionState = 0;
    private final int mConfigShortAnimTime;
    private final Interpolator mDecelerateInterpolator;
    private final Interpolator mThumbnailFadeInInterpolator;
    private final Interpolator mThumbnailFadeOutInterpolator;
    private final Interpolator mLinearOutSlowInInterpolator;
    private final Interpolator mFastOutLinearInInterpolator;
    private final Interpolator mFastOutSlowInInterpolator;
    private final Interpolator mClipHorizontalInterpolator = new PathInterpolator(0.0f, 0.0f, 0.4f, 1.0f);
    private final int mClipRevealTranslationY;
    private int mCurrentUserId = 0;
    private long mLastClipRevealTransitionDuration = 336L;
    private final ArrayList<WindowManagerInternal.AppTransitionListener> mListeners = new ArrayList();
    private final ExecutorService mDefaultExecutor = Executors.newSingleThreadExecutor();
    private int mLastClipRevealMaxTranslation;
    private boolean mLastHadClipReveal;
    private boolean mProlongedAnimationsEnded;

    AppTransition(Context context, WindowManagerService service) {
        this.mContext = context;
        this.mService = service;
        this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
        this.mFastOutLinearInInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mConfigShortAnimTime = context.getResources().getInteger(0x10E0000);
        this.mDecelerateInterpolator = AnimationUtils.loadInterpolator(context, 17563651);
        this.mThumbnailFadeInInterpolator = new Interpolator(){

            @Override
            public float getInterpolation(float input) {
                if (input < 0.5f) {
                    return 0.0f;
                }
                float t = (input - 0.5f) / 0.5f;
                return AppTransition.this.mFastOutLinearInInterpolator.getInterpolation(t);
            }
        };
        this.mThumbnailFadeOutInterpolator = new Interpolator(){

            @Override
            public float getInterpolation(float input) {
                if (input < 0.5f) {
                    float t = input / 0.5f;
                    return AppTransition.this.mLinearOutSlowInInterpolator.getInterpolation(t);
                }
                return 1.0f;
            }
        };
        this.mClipRevealTranslationY = (int)(8.0f * this.mContext.getResources().getDisplayMetrics().density);
    }

    boolean isTransitionSet() {
        return this.mNextAppTransition != -1;
    }

    boolean isTransitionEqual(int transit) {
        return this.mNextAppTransition == transit;
    }

    int getAppTransition() {
        return this.mNextAppTransition;
    }

    private void setAppTransition(int transit) {
        this.mNextAppTransition = transit;
        this.setLastAppTransition(-1, null, null);
    }

    void setLastAppTransition(int transit, AppWindowToken openingApp, AppWindowToken closingApp) {
        this.mLastUsedAppTransition = transit;
        this.mLastOpeningApp = "" + openingApp;
        this.mLastClosingApp = "" + closingApp;
    }

    boolean isReady() {
        return this.mAppTransitionState == 1 || this.mAppTransitionState == 3;
    }

    void setReady() {
        this.mAppTransitionState = 1;
        this.fetchAppTransitionSpecsFromFuture();
    }

    boolean isRunning() {
        return this.mAppTransitionState == 2;
    }

    void setIdle() {
        this.mAppTransitionState = 0;
    }

    boolean isTimeout() {
        return this.mAppTransitionState == 3;
    }

    void setTimeout() {
        this.mAppTransitionState = 3;
    }

    Bitmap getAppTransitionThumbnailHeader(int taskId) {
        AppTransitionAnimationSpec spec = this.mNextAppTransitionAnimationsSpecs.get(taskId);
        if (spec == null) {
            spec = this.mDefaultNextAppTransitionAnimationSpec;
        }
        return spec != null ? spec.bitmap : null;
    }

    boolean isNextThumbnailTransitionAspectScaled() {
        return this.mNextAppTransitionType == 5 || this.mNextAppTransitionType == 6;
    }

    boolean isNextThumbnailTransitionScaleUp() {
        return this.mNextAppTransitionScaleUp;
    }

    boolean isNextAppTransitionThumbnailUp() {
        return this.mNextAppTransitionType == 3 || this.mNextAppTransitionType == 5;
    }

    boolean isNextAppTransitionThumbnailDown() {
        return this.mNextAppTransitionType == 4 || this.mNextAppTransitionType == 6;
    }

    boolean isFetchingAppTransitionsSpecs() {
        return this.mNextAppTransitionAnimationsSpecsPending;
    }

    private boolean prepare() {
        if (!this.isRunning()) {
            this.mAppTransitionState = 0;
            this.notifyAppTransitionPendingLocked();
            this.mLastHadClipReveal = false;
            this.mLastClipRevealMaxTranslation = 0;
            this.mLastClipRevealTransitionDuration = 336L;
            return true;
        }
        return false;
    }

    void goodToGo(AppWindowAnimator topOpeningAppAnimator, AppWindowAnimator topClosingAppAnimator, ArraySet<AppWindowToken> openingApps, ArraySet<AppWindowToken> closingApps) {
        this.mNextAppTransition = -1;
        this.mAppTransitionState = 2;
        this.notifyAppTransitionStartingLocked(topOpeningAppAnimator != null ? topOpeningAppAnimator.mAppToken.token : null, topClosingAppAnimator != null ? topClosingAppAnimator.mAppToken.token : null, topOpeningAppAnimator != null ? topOpeningAppAnimator.animation : null, topClosingAppAnimator != null ? topClosingAppAnimator.animation : null);
        this.mService.getDefaultDisplayContentLocked().getDockedDividerController().notifyAppTransitionStarting();
        if (this.mNextAppTransition == 19 && !this.mProlongedAnimationsEnded) {
            for (int i = openingApps.size() - 1; i >= 0; --i) {
                AppWindowAnimator appAnimator = openingApps.valueAt((int)i).mAppAnimator;
                appAnimator.startProlongAnimation(2);
            }
        }
    }

    void notifyProlongedAnimationsEnded() {
        this.mProlongedAnimationsEnded = true;
    }

    void clear() {
        this.mNextAppTransitionType = 0;
        this.mNextAppTransitionPackage = null;
        this.mNextAppTransitionAnimationsSpecs.clear();
        this.mNextAppTransitionAnimationsSpecsFuture = null;
        this.mDefaultNextAppTransitionAnimationSpec = null;
        this.mAnimationFinishedCallback = null;
        this.mProlongedAnimationsEnded = false;
    }

    void freeze() {
        this.setAppTransition(-1);
        this.clear();
        this.setReady();
        this.notifyAppTransitionCancelledLocked();
    }

    void registerListenerLocked(WindowManagerInternal.AppTransitionListener listener) {
        this.mListeners.add(listener);
    }

    public void notifyAppTransitionFinishedLocked(IBinder token) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionFinishedLocked(token);
        }
    }

    private void notifyAppTransitionPendingLocked() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionPendingLocked();
        }
    }

    private void notifyAppTransitionCancelledLocked() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionCancelledLocked();
        }
    }

    private void notifyAppTransitionStartingLocked(IBinder openToken, IBinder closeToken, Animation openAnimation, Animation closeAnimation) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionStartingLocked(openToken, closeToken, openAnimation, closeAnimation);
        }
    }

    private AttributeCache.Entry getCachedAnimations(WindowManager.LayoutParams lp) {
        if (lp != null && lp.windowAnimations != 0) {
            String packageName = lp.packageName != null ? lp.packageName : "android";
            int resId = lp.windowAnimations;
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation, this.mCurrentUserId);
        }
        return null;
    }

    private AttributeCache.Entry getCachedAnimations(String packageName, int resId) {
        if (packageName != null) {
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation, this.mCurrentUserId);
        }
        return null;
    }

    Animation loadAnimationAttr(WindowManager.LayoutParams lp, int animAttr) {
        AttributeCache.Entry ent;
        int anim2 = 0;
        Context context = this.mContext;
        if (animAttr >= 0 && (ent = this.getCachedAnimations(lp)) != null) {
            context = ent.context;
            anim2 = ent.array.getResourceId(animAttr, 0);
        }
        if (anim2 != 0) {
            return AnimationUtils.loadAnimation(context, anim2);
        }
        return null;
    }

    Animation loadAnimationRes(WindowManager.LayoutParams lp, int resId) {
        Context context = this.mContext;
        if (resId >= 0) {
            AttributeCache.Entry ent = this.getCachedAnimations(lp);
            if (ent != null) {
                context = ent.context;
            }
            return AnimationUtils.loadAnimation(context, resId);
        }
        return null;
    }

    private Animation loadAnimationRes(String packageName, int resId) {
        AttributeCache.Entry ent;
        int anim2 = 0;
        Context context = this.mContext;
        if (resId >= 0 && (ent = this.getCachedAnimations(packageName, resId)) != null) {
            context = ent.context;
            anim2 = resId;
        }
        if (anim2 != 0) {
            return AnimationUtils.loadAnimation(context, anim2);
        }
        return null;
    }

    private static float computePivot(int startPos, float finalScale) {
        float denom = finalScale - 1.0f;
        if (Math.abs(denom) < 1.0E-4f) {
            return startPos;
        }
        return (float)(-startPos) / denom;
    }

    private Animation createScaleUpAnimationLocked(int transit, boolean enter, Rect containingFrame) {
        long duration;
        Animation a;
        this.getDefaultNextAppTransitionStartRect(this.mTmpRect);
        int appWidth = containingFrame.width();
        int appHeight = containingFrame.height();
        if (enter) {
            float scaleW = (float)this.mTmpRect.width() / (float)appWidth;
            float scaleH = (float)this.mTmpRect.height() / (float)appHeight;
            ScaleAnimation scale = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mTmpRect.left, scaleW), AppTransition.computePivot(this.mTmpRect.top, scaleH));
            scale.setInterpolator(this.mDecelerateInterpolator);
            AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
            alpha.setInterpolator(this.mThumbnailFadeOutInterpolator);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.setDetachWallpaper(true);
            a = set;
        } else if (transit == 14 || transit == 15) {
            a = new AlphaAnimation(1.0f, 0.0f);
            a.setDetachWallpaper(true);
        } else {
            a = new AlphaAnimation(1.0f, 1.0f);
        }
        switch (transit) {
            case 6: 
            case 7: {
                duration = this.mConfigShortAnimTime;
                break;
            }
            default: {
                duration = 336L;
            }
        }
        a.setDuration(duration);
        a.setFillAfter(true);
        a.setInterpolator(this.mDecelerateInterpolator);
        a.initialize(appWidth, appHeight, appWidth, appHeight);
        return a;
    }

    private void getDefaultNextAppTransitionStartRect(Rect rect) {
        if (this.mDefaultNextAppTransitionAnimationSpec == null || this.mDefaultNextAppTransitionAnimationSpec.rect == null) {
            Slog.wtf(TAG, "Starting rect for app requested, but none available", new Throwable());
            rect.setEmpty();
        } else {
            rect.set(this.mDefaultNextAppTransitionAnimationSpec.rect);
        }
    }

    void getNextAppTransitionStartRect(int taskId, Rect rect) {
        AppTransitionAnimationSpec spec = this.mNextAppTransitionAnimationsSpecs.get(taskId);
        if (spec == null) {
            spec = this.mDefaultNextAppTransitionAnimationSpec;
        }
        if (spec == null || spec.rect == null) {
            Slog.wtf(TAG, "Starting rect for task: " + taskId + " requested, but not available", new Throwable());
            rect.setEmpty();
        } else {
            rect.set(spec.rect);
        }
    }

    private void putDefaultNextAppTransitionCoordinates(int left, int top, int width, int height, Bitmap bitmap) {
        this.mDefaultNextAppTransitionAnimationSpec = new AppTransitionAnimationSpec(-1, bitmap, new Rect(left, top, left + width, top + height));
    }

    long getLastClipRevealTransitionDuration() {
        return this.mLastClipRevealTransitionDuration;
    }

    int getLastClipRevealMaxTranslation() {
        return this.mLastClipRevealMaxTranslation;
    }

    boolean hadClipRevealAnimation() {
        return this.mLastHadClipReveal;
    }

    private long calculateClipRevealTransitionDuration(boolean cutOff, float translationX, float translationY, Rect displayFrame) {
        if (!cutOff) {
            return 336L;
        }
        float fraction2 = Math.max(Math.abs(translationX) / (float)displayFrame.width(), Math.abs(translationY) / (float)displayFrame.height());
        return (long)(336.0f + fraction2 * 84.0f);
    }

    private Animation createClipRevealAnimationLocked(int transit, boolean enter, Rect appFrame, Rect displayFrame) {
        Animation anim2;
        if (enter) {
            int appWidth = appFrame.width();
            int appHeight = appFrame.height();
            this.getDefaultNextAppTransitionStartRect(this.mTmpRect);
            float t = 0.0f;
            if (appHeight > 0) {
                t = (float)this.mTmpRect.top / (float)displayFrame.height();
            }
            int translationY = this.mClipRevealTranslationY + (int)((float)displayFrame.height() / 7.0f * t);
            int translationX = 0;
            int translationYCorrection = translationY;
            int centerX = this.mTmpRect.centerX();
            int centerY = this.mTmpRect.centerY();
            int halfWidth = this.mTmpRect.width() / 2;
            int halfHeight = this.mTmpRect.height() / 2;
            int clipStartX = centerX - halfWidth - appFrame.left;
            int clipStartY = centerY - halfHeight - appFrame.top;
            boolean cutOff = false;
            if (appFrame.top > centerY - halfHeight) {
                translationY = centerY - halfHeight - appFrame.top;
                translationYCorrection = 0;
                clipStartY = 0;
                cutOff = true;
            }
            if (appFrame.left > centerX - halfWidth) {
                translationX = centerX - halfWidth - appFrame.left;
                clipStartX = 0;
                cutOff = true;
            }
            if (appFrame.right < centerX + halfWidth) {
                translationX = centerX + halfWidth - appFrame.right;
                clipStartX = appWidth - this.mTmpRect.width();
                cutOff = true;
            }
            long duration = this.calculateClipRevealTransitionDuration(cutOff, translationX, translationY, displayFrame);
            ClipRectLRAnimation clipAnimLR = new ClipRectLRAnimation(clipStartX, clipStartX + this.mTmpRect.width(), 0, appWidth);
            clipAnimLR.setInterpolator(this.mClipHorizontalInterpolator);
            clipAnimLR.setDuration((long)((float)duration / 2.5f));
            TranslateAnimation translate = new TranslateAnimation(translationX, 0.0f, translationY, 0.0f);
            translate.setInterpolator(cutOff ? TOUCH_RESPONSE_INTERPOLATOR : this.mLinearOutSlowInInterpolator);
            translate.setDuration(duration);
            ClipRectTBAnimation clipAnimTB = new ClipRectTBAnimation(clipStartY, clipStartY + this.mTmpRect.height(), 0, appHeight, translationYCorrection, 0, this.mLinearOutSlowInInterpolator);
            clipAnimTB.setInterpolator(TOUCH_RESPONSE_INTERPOLATOR);
            clipAnimTB.setDuration(duration);
            long alphaDuration = duration / 4L;
            AlphaAnimation alpha = new AlphaAnimation(0.5f, 1.0f);
            alpha.setDuration(alphaDuration);
            alpha.setInterpolator(this.mLinearOutSlowInInterpolator);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(clipAnimLR);
            set.addAnimation(clipAnimTB);
            set.addAnimation(translate);
            set.addAnimation(alpha);
            set.setZAdjustment(1);
            set.initialize(appWidth, appHeight, appWidth, appHeight);
            anim2 = set;
            this.mLastHadClipReveal = true;
            this.mLastClipRevealTransitionDuration = duration;
            this.mLastClipRevealMaxTranslation = cutOff ? Math.max(Math.abs(translationY), Math.abs(translationX)) : 0;
        } else {
            long duration;
            switch (transit) {
                case 6: 
                case 7: {
                    duration = this.mConfigShortAnimTime;
                    break;
                }
                default: {
                    duration = 336L;
                }
            }
            if (transit == 14 || transit == 15) {
                anim2 = new AlphaAnimation(1.0f, 0.0f);
                anim2.setDetachWallpaper(true);
            } else {
                anim2 = new AlphaAnimation(1.0f, 1.0f);
            }
            anim2.setInterpolator(this.mDecelerateInterpolator);
            anim2.setDuration(duration);
            anim2.setFillAfter(true);
        }
        return anim2;
    }

    Animation prepareThumbnailAnimationWithDuration(Animation a, int appWidth, int appHeight, long duration, Interpolator interpolator2) {
        if (duration > 0L) {
            a.setDuration(duration);
        }
        a.setFillAfter(true);
        if (interpolator2 != null) {
            a.setInterpolator(interpolator2);
        }
        a.initialize(appWidth, appHeight, appWidth, appHeight);
        return a;
    }

    Animation prepareThumbnailAnimation(Animation a, int appWidth, int appHeight, int transit) {
        int duration;
        switch (transit) {
            case 6: 
            case 7: {
                duration = this.mConfigShortAnimTime;
                break;
            }
            default: {
                duration = 336;
            }
        }
        return this.prepareThumbnailAnimationWithDuration(a, appWidth, appHeight, duration, this.mDecelerateInterpolator);
    }

    int getThumbnailTransitionState(boolean enter) {
        if (enter) {
            if (this.mNextAppTransitionScaleUp) {
                return 0;
            }
            return 2;
        }
        if (this.mNextAppTransitionScaleUp) {
            return 1;
        }
        return 3;
    }

    Animation createThumbnailAspectScaleAnimationLocked(Rect appRect, Rect contentInsets, Bitmap thumbnailHeader, int taskId, int uiMode, int orientation) {
        AnimationSet a;
        float pivotY;
        float pivotX;
        float toY;
        float toX;
        float fromY;
        float fromX;
        int thumbWidthI = thumbnailHeader.getWidth();
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = thumbnailHeader.getHeight();
        int appWidth = appRect.width();
        float scaleW = (float)appWidth / thumbWidth;
        this.getNextAppTransitionStartRect(taskId, this.mTmpRect);
        if (this.isTvUiMode(uiMode) || orientation == 1) {
            fromX = this.mTmpRect.left;
            fromY = this.mTmpRect.top;
            toX = (float)(this.mTmpRect.width() / 2) * (scaleW - 1.0f) + (float)appRect.left;
            toY = (float)(appRect.height() / 2) * (1.0f - 1.0f / scaleW) + (float)appRect.top;
            pivotX = this.mTmpRect.width() / 2;
            pivotY = (float)(appRect.height() / 2) / scaleW;
        } else {
            pivotX = 0.0f;
            pivotY = 0.0f;
            fromX = this.mTmpRect.left;
            fromY = this.mTmpRect.top;
            toX = appRect.left;
            toY = appRect.top;
        }
        long duration = this.getAspectScaleDuration();
        Interpolator interpolator2 = this.getAspectScaleInterpolator();
        if (this.mNextAppTransitionScaleUp) {
            ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleW, pivotX, pivotY);
            scale.setInterpolator(interpolator2);
            scale.setDuration(duration);
            AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
            alpha.setInterpolator(this.mNextAppTransition == 19 ? THUMBNAIL_DOCK_INTERPOLATOR : this.mThumbnailFadeOutInterpolator);
            alpha.setDuration(this.mNextAppTransition == 19 ? duration / 2L : duration);
            Animation translate = this.createCurvedMotion(fromX, toX, fromY, toY);
            translate.setInterpolator(interpolator2);
            translate.setDuration(duration);
            this.mTmpFromClipRect.set(0, 0, thumbWidthI, thumbHeightI);
            this.mTmpToClipRect.set(appRect);
            this.mTmpToClipRect.offsetTo(0, 0);
            this.mTmpToClipRect.right = (int)((float)this.mTmpToClipRect.right / scaleW);
            this.mTmpToClipRect.bottom = (int)((float)this.mTmpToClipRect.bottom / scaleW);
            if (contentInsets != null) {
                this.mTmpToClipRect.inset((int)((float)(-contentInsets.left) * scaleW), (int)((float)(-contentInsets.top) * scaleW), (int)((float)(-contentInsets.right) * scaleW), (int)((float)(-contentInsets.bottom) * scaleW));
            }
            ClipRectAnimation clipAnim = new ClipRectAnimation(this.mTmpFromClipRect, this.mTmpToClipRect);
            clipAnim.setInterpolator(interpolator2);
            clipAnim.setDuration(duration);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.addAnimation(translate);
            set.addAnimation(clipAnim);
            a = set;
        } else {
            ScaleAnimation scale = new ScaleAnimation(scaleW, 1.0f, scaleW, 1.0f, pivotX, pivotY);
            scale.setInterpolator(interpolator2);
            scale.setDuration(duration);
            AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
            alpha.setInterpolator(this.mThumbnailFadeInInterpolator);
            alpha.setDuration(duration);
            Animation translate = this.createCurvedMotion(toX, fromX, toY, fromY);
            translate.setInterpolator(interpolator2);
            translate.setDuration(duration);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.addAnimation(translate);
            a = set;
        }
        return this.prepareThumbnailAnimationWithDuration(a, appWidth, appRect.height(), 0L, null);
    }

    private Animation createCurvedMotion(float fromX, float toX, float fromY, float toY) {
        if (Math.abs(toX - fromX) < 1.0f || this.mNextAppTransition != 19) {
            return new TranslateAnimation(fromX, toX, fromY, toY);
        }
        Path path = this.createCurvedPath(fromX, toX, fromY, toY);
        return new CurvedTranslateAnimation(path);
    }

    private Path createCurvedPath(float fromX, float toX, float fromY, float toY) {
        Path path = new Path();
        path.moveTo(fromX, fromY);
        if (fromY > toY) {
            path.cubicTo(fromX, fromY, toX, 0.9f * fromY + 0.1f * toY, toX, toY);
        } else {
            path.cubicTo(fromX, fromY, fromX, 0.1f * fromY + 0.9f * toY, toX, toY);
        }
        return path;
    }

    private long getAspectScaleDuration() {
        if (this.mNextAppTransition == 19) {
            return 453L;
        }
        return 336L;
    }

    private Interpolator getAspectScaleInterpolator() {
        if (this.mNextAppTransition == 19) {
            return this.mFastOutSlowInInterpolator;
        }
        return TOUCH_RESPONSE_INTERPOLATOR;
    }

    Animation createAspectScaledThumbnailEnterExitAnimationLocked(int thumbTransitState, int uiMode, int orientation, int transit, Rect containingFrame, Rect contentInsets, Rect surfaceInsets, boolean freeform, int taskId) {
        Animation a;
        int appWidth = containingFrame.width();
        int appHeight = containingFrame.height();
        this.getDefaultNextAppTransitionStartRect(this.mTmpRect);
        int thumbWidthI = this.mTmpRect.width();
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = this.mTmpRect.height();
        float thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        int thumbStartX = this.mTmpRect.left - containingFrame.left - contentInsets.left;
        int thumbStartY = this.mTmpRect.top - containingFrame.top;
        switch (thumbTransitState) {
            case 0: 
            case 3: {
                boolean scaleUp;
                boolean bl = scaleUp = thumbTransitState == 0;
                if (freeform && scaleUp) {
                    a = this.createAspectScaledThumbnailEnterFreeformAnimationLocked(containingFrame, surfaceInsets, taskId);
                    break;
                }
                if (freeform) {
                    a = this.createAspectScaledThumbnailExitFreeformAnimationLocked(containingFrame, surfaceInsets, taskId);
                    break;
                }
                AnimationSet set = new AnimationSet(true);
                this.mTmpFromClipRect.set(containingFrame);
                this.mTmpToClipRect.set(containingFrame);
                this.mTmpFromClipRect.offsetTo(0, 0);
                this.mTmpToClipRect.offsetTo(0, 0);
                this.mTmpFromClipRect.inset(contentInsets);
                this.mNextAppTransitionInsets.set(contentInsets);
                if (this.isTvUiMode(uiMode) || orientation == 1) {
                    float scale = thumbWidth / (float)(appWidth - contentInsets.left - contentInsets.right);
                    int unscaledThumbHeight = (int)(thumbHeight / scale);
                    this.mTmpFromClipRect.bottom = this.mTmpFromClipRect.top + unscaledThumbHeight;
                    this.mNextAppTransitionInsets.set(contentInsets);
                    ScaleAnimation scaleAnim = new ScaleAnimation(scaleUp ? scale : 1.0f, scaleUp ? 1.0f : scale, scaleUp ? scale : 1.0f, scaleUp ? 1.0f : scale, (float)containingFrame.width() / 2.0f, (float)containingFrame.height() / 2.0f + (float)contentInsets.top);
                    float targetX = this.mTmpRect.left - containingFrame.left;
                    float x = (float)containingFrame.width() / 2.0f - (float)containingFrame.width() / 2.0f * scale;
                    float targetY = this.mTmpRect.top - containingFrame.top;
                    float y = (float)containingFrame.height() / 2.0f - (float)containingFrame.height() / 2.0f * scale;
                    float startX = targetX - x;
                    float startY = targetY - y;
                    ClipRectAnimation clipAnim = scaleUp ? new ClipRectAnimation(this.mTmpFromClipRect, this.mTmpToClipRect) : new ClipRectAnimation(this.mTmpToClipRect, this.mTmpFromClipRect);
                    Animation translateAnim = scaleUp ? this.createCurvedMotion(startX, 0.0f, startY - (float)contentInsets.top, 0.0f) : this.createCurvedMotion(0.0f, startX, 0.0f, startY - (float)contentInsets.top);
                    set.addAnimation(clipAnim);
                    set.addAnimation(scaleAnim);
                    set.addAnimation(translateAnim);
                } else {
                    this.mTmpFromClipRect.bottom = this.mTmpFromClipRect.top + thumbHeightI;
                    this.mTmpFromClipRect.right = this.mTmpFromClipRect.left + thumbWidthI;
                    ClipRectAnimation clipAnim = scaleUp ? new ClipRectAnimation(this.mTmpFromClipRect, this.mTmpToClipRect) : new ClipRectAnimation(this.mTmpToClipRect, this.mTmpFromClipRect);
                    Animation translateAnim = scaleUp ? this.createCurvedMotion(thumbStartX, 0.0f, thumbStartY - contentInsets.top, 0.0f) : this.createCurvedMotion(0.0f, thumbStartX, 0.0f, thumbStartY - contentInsets.top);
                    set.addAnimation(clipAnim);
                    set.addAnimation(translateAnim);
                }
                a = set;
                a.setZAdjustment(1);
                break;
            }
            case 1: {
                if (transit == 14) {
                    a = new AlphaAnimation(1.0f, 0.0f);
                    break;
                }
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            case 2: {
                if (transit == 14) {
                    a = new AlphaAnimation(0.0f, 1.0f);
                    break;
                }
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            default: {
                throw new RuntimeException("Invalid thumbnail transition state");
            }
        }
        return this.prepareThumbnailAnimationWithDuration(a, appWidth, appHeight, this.getAspectScaleDuration(), this.getAspectScaleInterpolator());
    }

    private Animation createAspectScaledThumbnailEnterFreeformAnimationLocked(Rect frame, Rect surfaceInsets, int taskId) {
        this.getNextAppTransitionStartRect(taskId, this.mTmpRect);
        return this.createAspectScaledThumbnailFreeformAnimationLocked(this.mTmpRect, frame, surfaceInsets, true);
    }

    private Animation createAspectScaledThumbnailExitFreeformAnimationLocked(Rect frame, Rect surfaceInsets, int taskId) {
        this.getNextAppTransitionStartRect(taskId, this.mTmpRect);
        return this.createAspectScaledThumbnailFreeformAnimationLocked(frame, this.mTmpRect, surfaceInsets, false);
    }

    private AnimationSet createAspectScaledThumbnailFreeformAnimationLocked(Rect sourceFrame, Rect destFrame, Rect surfaceInsets, boolean enter) {
        float sourceWidth = sourceFrame.width();
        float sourceHeight = sourceFrame.height();
        float destWidth = destFrame.width();
        float destHeight = destFrame.height();
        float scaleH = enter ? sourceWidth / destWidth : destWidth / sourceWidth;
        float scaleV = enter ? sourceHeight / destHeight : destHeight / sourceHeight;
        AnimationSet set = new AnimationSet(true);
        int surfaceInsetsH = surfaceInsets == null ? 0 : surfaceInsets.left + surfaceInsets.right;
        int surfaceInsetsV = surfaceInsets == null ? 0 : surfaceInsets.top + surfaceInsets.bottom;
        float scaleHCenter = ((enter ? destWidth : sourceWidth) + (float)surfaceInsetsH) / 2.0f;
        float scaleVCenter = ((enter ? destHeight : sourceHeight) + (float)surfaceInsetsV) / 2.0f;
        ScaleAnimation scale = enter ? new ScaleAnimation(scaleH, 1.0f, scaleV, 1.0f, scaleHCenter, scaleVCenter) : new ScaleAnimation(1.0f, scaleH, 1.0f, scaleV, scaleHCenter, scaleVCenter);
        int sourceHCenter = sourceFrame.left + sourceFrame.width() / 2;
        int sourceVCenter = sourceFrame.top + sourceFrame.height() / 2;
        int destHCenter = destFrame.left + destFrame.width() / 2;
        int destVCenter = destFrame.top + destFrame.height() / 2;
        int fromX = enter ? sourceHCenter - destHCenter : destHCenter - sourceHCenter;
        int fromY = enter ? sourceVCenter - destVCenter : destVCenter - sourceVCenter;
        TranslateAnimation translation = enter ? new TranslateAnimation(fromX, 0.0f, fromY, 0.0f) : new TranslateAnimation(0.0f, fromX, 0.0f, fromY);
        set.addAnimation(scale);
        set.addAnimation(translation);
        final IRemoteCallback callback = this.mAnimationFinishedCallback;
        if (callback != null) {
            set.setAnimationListener(new Animation.AnimationListener(){

                @Override
                public void onAnimationStart(Animation animation) {
                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    ((AppTransition)AppTransition.this).mService.mH.obtainMessage(26, callback).sendToTarget();
                }

                @Override
                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        return set;
    }

    Animation createThumbnailScaleAnimationLocked(int appWidth, int appHeight, int transit, Bitmap thumbnailHeader) {
        Animation a;
        float thumbHeight;
        this.getDefaultNextAppTransitionStartRect(this.mTmpRect);
        int thumbWidthI = thumbnailHeader.getWidth();
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = thumbnailHeader.getHeight();
        float f = thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        if (this.mNextAppTransitionScaleUp) {
            float scaleW = (float)appWidth / thumbWidth;
            float scaleH = (float)appHeight / thumbHeight;
            ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleH, AppTransition.computePivot(this.mTmpRect.left, 1.0f / scaleW), AppTransition.computePivot(this.mTmpRect.top, 1.0f / scaleH));
            scale.setInterpolator(this.mDecelerateInterpolator);
            AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
            alpha.setInterpolator(this.mThumbnailFadeOutInterpolator);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            a = set;
        } else {
            float scaleW = (float)appWidth / thumbWidth;
            float scaleH = (float)appHeight / thumbHeight;
            a = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mTmpRect.left, 1.0f / scaleW), AppTransition.computePivot(this.mTmpRect.top, 1.0f / scaleH));
        }
        return this.prepareThumbnailAnimation(a, appWidth, appHeight, transit);
    }

    Animation createThumbnailEnterExitAnimationLocked(int thumbTransitState, Rect containingFrame, int transit, int taskId) {
        Animation a;
        int appWidth = containingFrame.width();
        int appHeight = containingFrame.height();
        Bitmap thumbnailHeader = this.getAppTransitionThumbnailHeader(taskId);
        this.getDefaultNextAppTransitionStartRect(this.mTmpRect);
        int thumbWidthI = thumbnailHeader != null ? thumbnailHeader.getWidth() : appWidth;
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = thumbnailHeader != null ? thumbnailHeader.getHeight() : appHeight;
        float thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        switch (thumbTransitState) {
            case 0: {
                float scaleW = thumbWidth / (float)appWidth;
                float scaleH = thumbHeight / (float)appHeight;
                a = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mTmpRect.left, scaleW), AppTransition.computePivot(this.mTmpRect.top, scaleH));
                break;
            }
            case 1: {
                if (transit == 14) {
                    a = new AlphaAnimation(1.0f, 0.0f);
                    break;
                }
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            case 2: {
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            case 3: {
                float scaleW = thumbWidth / (float)appWidth;
                float scaleH = thumbHeight / (float)appHeight;
                ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleH, AppTransition.computePivot(this.mTmpRect.left, scaleW), AppTransition.computePivot(this.mTmpRect.top, scaleH));
                AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
                AnimationSet set = new AnimationSet(true);
                set.addAnimation(scale);
                set.addAnimation(alpha);
                set.setZAdjustment(1);
                a = set;
                break;
            }
            default: {
                throw new RuntimeException("Invalid thumbnail transition state");
            }
        }
        return this.prepareThumbnailAnimation(a, appWidth, appHeight, transit);
    }

    private Animation createRelaunchAnimation(Rect containingFrame, Rect contentInsets) {
        this.getDefaultNextAppTransitionStartRect(this.mTmpFromClipRect);
        int left = this.mTmpFromClipRect.left;
        int top = this.mTmpFromClipRect.top;
        this.mTmpFromClipRect.offset(-left, -top);
        this.mTmpToClipRect.set(0, 0, containingFrame.width(), containingFrame.height());
        AnimationSet set = new AnimationSet(true);
        float fromWidth = this.mTmpFromClipRect.width();
        float toWidth = this.mTmpToClipRect.width();
        float fromHeight = this.mTmpFromClipRect.height();
        float toHeight = this.mTmpToClipRect.height() - contentInsets.top - contentInsets.bottom;
        int translateAdjustment = 0;
        if (fromWidth <= toWidth && fromHeight <= toHeight) {
            set.addAnimation(new ClipRectAnimation(this.mTmpFromClipRect, this.mTmpToClipRect));
        } else {
            set.addAnimation(new ScaleAnimation(fromWidth / toWidth, 1.0f, fromHeight / toHeight, 1.0f));
            translateAdjustment = (int)((float)contentInsets.top * fromHeight / toHeight);
        }
        TranslateAnimation translate = new TranslateAnimation(left - containingFrame.left, 0.0f, top - containingFrame.top - translateAdjustment, 0.0f);
        set.addAnimation(translate);
        set.setDuration(336L);
        set.setZAdjustment(1);
        return set;
    }

    boolean canSkipFirstFrame() {
        return this.mNextAppTransitionType != 1 && this.mNextAppTransitionType != 7 && this.mNextAppTransitionType != 8;
    }

    Animation loadAnimation(WindowManager.LayoutParams lp, int transit, boolean enter, int uiMode, int orientation, Rect frame, Rect displayFrame, Rect insets, Rect surfaceInsets, boolean isVoiceInteraction, boolean freeform, int taskId) {
        Animation a;
        if (isVoiceInteraction && (transit == 6 || transit == 8 || transit == 10)) {
            a = this.loadAnimationRes(lp, enter ? 0x10A00A0 : 0x10A00A1);
        } else if (isVoiceInteraction && (transit == 7 || transit == 9 || transit == 11)) {
            a = this.loadAnimationRes(lp, enter ? 17432734 : 17432735);
        } else if (transit == 18) {
            a = this.createRelaunchAnimation(frame, insets);
        } else if (this.mNextAppTransitionType == 1) {
            a = this.loadAnimationRes(this.mNextAppTransitionPackage, enter ? this.mNextAppTransitionEnter : this.mNextAppTransitionExit);
        } else if (this.mNextAppTransitionType == 7) {
            a = this.loadAnimationRes(this.mNextAppTransitionPackage, this.mNextAppTransitionInPlace);
        } else if (this.mNextAppTransitionType == 8) {
            a = this.createClipRevealAnimationLocked(transit, enter, frame, displayFrame);
        } else if (this.mNextAppTransitionType == 2) {
            a = this.createScaleUpAnimationLocked(transit, enter, frame);
        } else if (this.mNextAppTransitionType == 3 || this.mNextAppTransitionType == 4) {
            this.mNextAppTransitionScaleUp = this.mNextAppTransitionType == 3;
            a = this.createThumbnailEnterExitAnimationLocked(this.getThumbnailTransitionState(enter), frame, transit, taskId);
        } else if (this.mNextAppTransitionType == 5 || this.mNextAppTransitionType == 6) {
            this.mNextAppTransitionScaleUp = this.mNextAppTransitionType == 5;
            a = this.createAspectScaledThumbnailEnterExitAnimationLocked(this.getThumbnailTransitionState(enter), uiMode, orientation, transit, frame, insets, surfaceInsets, freeform, taskId);
        } else {
            int animAttr = 0;
            switch (transit) {
                case 6: {
                    animAttr = enter ? 4 : 5;
                    break;
                }
                case 7: {
                    animAttr = enter ? 6 : 7;
                    break;
                }
                case 8: 
                case 19: {
                    animAttr = enter ? 8 : 9;
                    break;
                }
                case 9: {
                    animAttr = enter ? 10 : 11;
                    break;
                }
                case 10: {
                    animAttr = enter ? 12 : 13;
                    break;
                }
                case 11: {
                    animAttr = enter ? 14 : 15;
                    break;
                }
                case 13: {
                    animAttr = enter ? 16 : 17;
                    break;
                }
                case 12: {
                    animAttr = enter ? 18 : 19;
                    break;
                }
                case 14: {
                    animAttr = enter ? 20 : 21;
                    break;
                }
                case 15: {
                    animAttr = enter ? 22 : 23;
                    break;
                }
                case 16: {
                    animAttr = enter ? 25 : 24;
                }
            }
            a = animAttr != 0 ? this.loadAnimationAttr(lp, animAttr) : null;
        }
        return a;
    }

    int getAppStackClipMode() {
        return this.mNextAppTransition == 18 || this.mNextAppTransition == 19 || this.mNextAppTransitionType == 8 ? 2 : 0;
    }

    void postAnimationCallback() {
        if (this.mNextAppTransitionCallback != null) {
            this.mService.mH.sendMessage(this.mService.mH.obtainMessage(26, this.mNextAppTransitionCallback));
            this.mNextAppTransitionCallback = null;
        }
    }

    void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = 1;
            this.mNextAppTransitionPackage = packageName;
            this.mNextAppTransitionEnter = enterAnim;
            this.mNextAppTransitionExit = exitAnim;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = 2;
            this.putDefaultNextAppTransitionCoordinates(startX, startY, startWidth, startHeight, null);
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionClipReveal(int startX, int startY, int startWidth, int startHeight) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = 8;
            this.putDefaultNextAppTransitionCoordinates(startX, startY, startWidth, startHeight, null);
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionThumb(Bitmap srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = scaleUp ? 3 : 4;
            this.mNextAppTransitionScaleUp = scaleUp;
            this.putDefaultNextAppTransitionCoordinates(startX, startY, 0, 0, srcThumb);
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionAspectScaledThumb(Bitmap srcThumb, int startX, int startY, int targetWidth, int targetHeight, IRemoteCallback startedCallback, boolean scaleUp) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = scaleUp ? 5 : 6;
            this.mNextAppTransitionScaleUp = scaleUp;
            this.putDefaultNextAppTransitionCoordinates(startX, startY, targetWidth, targetHeight, srcThumb);
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    public void overridePendingAppTransitionMultiThumb(AppTransitionAnimationSpec[] specs, IRemoteCallback onAnimationStartedCallback, IRemoteCallback onAnimationFinishedCallback, boolean scaleUp) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = scaleUp ? 5 : 6;
            this.mNextAppTransitionScaleUp = scaleUp;
            if (specs != null) {
                for (int i = 0; i < specs.length; ++i) {
                    AppTransitionAnimationSpec spec = specs[i];
                    if (spec == null) continue;
                    this.mNextAppTransitionAnimationsSpecs.put(spec.taskId, spec);
                    if (i != 0) continue;
                    Rect rect = spec.rect;
                    this.putDefaultNextAppTransitionCoordinates(rect.left, rect.top, rect.width(), rect.height(), spec.bitmap);
                }
            }
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = onAnimationStartedCallback;
            this.mAnimationFinishedCallback = onAnimationFinishedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback callback, boolean scaleUp) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = scaleUp ? 5 : 6;
            this.mNextAppTransitionAnimationsSpecsFuture = specsFuture;
            this.mNextAppTransitionScaleUp = scaleUp;
            this.mNextAppTransitionFutureCallback = callback;
        }
    }

    void overrideInPlaceAppTransition(String packageName, int anim2) {
        if (this.isTransitionSet()) {
            this.clear();
            this.mNextAppTransitionType = 7;
            this.mNextAppTransitionPackage = packageName;
            this.mNextAppTransitionInPlace = anim2;
        } else {
            this.postAnimationCallback();
        }
    }

    private void fetchAppTransitionSpecsFromFuture() {
        if (this.mNextAppTransitionAnimationsSpecsFuture != null) {
            this.mNextAppTransitionAnimationsSpecsPending = true;
            final IAppTransitionAnimationSpecsFuture future = this.mNextAppTransitionAnimationsSpecsFuture;
            this.mNextAppTransitionAnimationsSpecsFuture = null;
            this.mDefaultExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AppTransitionAnimationSpec[] specs = null;
                    try {
                        specs = future.get();
                    }
                    catch (RemoteException e) {
                        Slog.w(AppTransition.TAG, "Failed to fetch app transition specs: " + e);
                    }
                    HashMap<IBinder, WindowState> hashMap = ((AppTransition)AppTransition.this).mService.mWindowMap;
                    synchronized (hashMap) {
                        AppTransition.this.mNextAppTransitionAnimationsSpecsPending = false;
                        AppTransition.this.overridePendingAppTransitionMultiThumb(specs, AppTransition.this.mNextAppTransitionFutureCallback, null, AppTransition.this.mNextAppTransitionScaleUp);
                        AppTransition.this.mNextAppTransitionFutureCallback = null;
                        if (specs != null) {
                            AppTransition.this.mService.prolongAnimationsFromSpecs(specs, AppTransition.this.mNextAppTransitionScaleUp);
                        }
                    }
                    AppTransition.this.mService.requestTraversal();
                }
            });
        }
    }

    public String toString() {
        return "mNextAppTransition=" + AppTransition.appTransitionToString(this.mNextAppTransition);
    }

    public static String appTransitionToString(int transition2) {
        switch (transition2) {
            case -1: {
                return "TRANSIT_UNSET";
            }
            case 0: {
                return "TRANSIT_NONE";
            }
            case 6: {
                return "TRANSIT_ACTIVITY_OPEN";
            }
            case 7: {
                return "TRANSIT_ACTIVITY_CLOSE";
            }
            case 8: {
                return "TRANSIT_TASK_OPEN";
            }
            case 9: {
                return "TRANSIT_TASK_CLOSE";
            }
            case 10: {
                return "TRANSIT_TASK_TO_FRONT";
            }
            case 11: {
                return "TRANSIT_TASK_TO_BACK";
            }
            case 12: {
                return "TRANSIT_WALLPAPER_CLOSE";
            }
            case 13: {
                return "TRANSIT_WALLPAPER_OPEN";
            }
            case 14: {
                return "TRANSIT_WALLPAPER_INTRA_OPEN";
            }
            case 15: {
                return "TRANSIT_WALLPAPER_INTRA_CLOSE";
            }
            case 16: {
                return "TRANSIT_TASK_OPEN_BEHIND";
            }
            case 18: {
                return "TRANSIT_ACTIVITY_RELAUNCH";
            }
            case 19: {
                return "TRANSIT_DOCK_TASK_FROM_RECENTS";
            }
        }
        return "<UNKNOWN>";
    }

    private String appStateToString() {
        switch (this.mAppTransitionState) {
            case 0: {
                return "APP_STATE_IDLE";
            }
            case 1: {
                return "APP_STATE_READY";
            }
            case 2: {
                return "APP_STATE_RUNNING";
            }
            case 3: {
                return "APP_STATE_TIMEOUT";
            }
        }
        return "unknown state=" + this.mAppTransitionState;
    }

    private String transitTypeToString() {
        switch (this.mNextAppTransitionType) {
            case 0: {
                return "NEXT_TRANSIT_TYPE_NONE";
            }
            case 1: {
                return "NEXT_TRANSIT_TYPE_CUSTOM";
            }
            case 7: {
                return "NEXT_TRANSIT_TYPE_CUSTOM_IN_PLACE";
            }
            case 2: {
                return "NEXT_TRANSIT_TYPE_SCALE_UP";
            }
            case 3: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_UP";
            }
            case 4: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_DOWN";
            }
            case 5: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_UP";
            }
            case 6: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_DOWN";
            }
        }
        return "unknown type=" + this.mNextAppTransitionType;
    }

    @Override
    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println(this);
        pw.print(prefix);
        pw.print("mAppTransitionState=");
        pw.println(this.appStateToString());
        if (this.mNextAppTransitionType != 0) {
            pw.print(prefix);
            pw.print("mNextAppTransitionType=");
            pw.println(this.transitTypeToString());
        }
        switch (this.mNextAppTransitionType) {
            case 1: {
                pw.print(prefix);
                pw.print("mNextAppTransitionPackage=");
                pw.println(this.mNextAppTransitionPackage);
                pw.print(prefix);
                pw.print("mNextAppTransitionEnter=0x");
                pw.print(Integer.toHexString(this.mNextAppTransitionEnter));
                pw.print(" mNextAppTransitionExit=0x");
                pw.println(Integer.toHexString(this.mNextAppTransitionExit));
                break;
            }
            case 7: {
                pw.print(prefix);
                pw.print("mNextAppTransitionPackage=");
                pw.println(this.mNextAppTransitionPackage);
                pw.print(prefix);
                pw.print("mNextAppTransitionInPlace=0x");
                pw.print(Integer.toHexString(this.mNextAppTransitionInPlace));
                break;
            }
            case 2: {
                this.getDefaultNextAppTransitionStartRect(this.mTmpRect);
                pw.print(prefix);
                pw.print("mNextAppTransitionStartX=");
                pw.print(this.mTmpRect.left);
                pw.print(" mNextAppTransitionStartY=");
                pw.println(this.mTmpRect.top);
                pw.print(prefix);
                pw.print("mNextAppTransitionStartWidth=");
                pw.print(this.mTmpRect.width());
                pw.print(" mNextAppTransitionStartHeight=");
                pw.println(this.mTmpRect.height());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                pw.print(prefix);
                pw.print("mDefaultNextAppTransitionAnimationSpec=");
                pw.println(this.mDefaultNextAppTransitionAnimationSpec);
                pw.print(prefix);
                pw.print("mNextAppTransitionAnimationsSpecs=");
                pw.println(this.mNextAppTransitionAnimationsSpecs);
                pw.print(prefix);
                pw.print("mNextAppTransitionScaleUp=");
                pw.println(this.mNextAppTransitionScaleUp);
            }
        }
        if (this.mNextAppTransitionCallback != null) {
            pw.print(prefix);
            pw.print("mNextAppTransitionCallback=");
            pw.println(this.mNextAppTransitionCallback);
        }
        if (this.mLastUsedAppTransition != 0) {
            pw.print(prefix);
            pw.print("mLastUsedAppTransition=");
            pw.println(AppTransition.appTransitionToString(this.mLastUsedAppTransition));
            pw.print(prefix);
            pw.print("mLastOpeningApp=");
            pw.println(this.mLastOpeningApp);
            pw.print(prefix);
            pw.print("mLastClosingApp=");
            pw.println(this.mLastClosingApp);
        }
    }

    public void setCurrentUser(int newUserId) {
        this.mCurrentUserId = newUserId;
    }

    boolean prepareAppTransitionLocked(int transit, boolean alwaysKeepCurrent) {
        if (!this.isTransitionSet() || this.mNextAppTransition == 0) {
            this.setAppTransition(transit);
        } else if (!alwaysKeepCurrent) {
            if (transit == 8 && this.isTransitionEqual(9)) {
                this.setAppTransition(transit);
            } else if (transit == 6 && this.isTransitionEqual(7)) {
                this.setAppTransition(transit);
            }
        }
        boolean prepared = this.prepare();
        if (this.isTransitionSet()) {
            this.mService.mH.removeMessages(13);
            this.mService.mH.sendEmptyMessageDelayed(13, 5000L);
        }
        return prepared;
    }

    private boolean isTvUiMode(int uiMode) {
        return (uiMode & 4) > 0;
    }
}

