/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Message;
import android.os.RemoteException;
import android.util.Slog;
import android.view.IApplicationToken;
import android.view.View;
import com.android.server.input.InputApplicationHandle;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayContentList;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfaceController;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;

class AppWindowToken
extends WindowToken {
    private static final String TAG = "WindowManager";
    final IApplicationToken appToken;
    final WindowList allAppWindows = new WindowList();
    final AppWindowAnimator mAppAnimator;
    final boolean voiceInteraction;
    Task mTask;
    boolean appFullscreen;
    int requestedOrientation = -1;
    boolean layoutConfigChanges;
    boolean showForAllUsers;
    int targetSdk;
    long inputDispatchingTimeoutNanos;
    long lastTransactionSequence = Long.MIN_VALUE;
    int numInterestingWindows;
    int numDrawnWindows;
    boolean inPendingTransaction;
    boolean allDrawn;
    boolean deferClearAllDrawn;
    boolean allDrawnExcludingSaved;
    int numInterestingWindowsExcludingSaved;
    int numDrawnWindowsExclusingSaved;
    boolean hiddenRequested;
    boolean clientHidden;
    boolean reportedVisible;
    boolean reportedDrawn;
    boolean removed;
    StartingData startingData;
    WindowState startingWindow;
    View startingView;
    boolean startingDisplayed;
    boolean startingMoved;
    boolean firstWindowDrawn;
    final InputApplicationHandle mInputApplicationHandle;
    boolean mIsExiting;
    boolean mLaunchTaskBehind;
    boolean mEnteringAnimation;
    boolean mAlwaysFocusable;
    boolean mAppStopped;
    int mRotationAnimationHint;
    int mPendingRelaunchCount;
    private ArrayList<WindowSurfaceController.SurfaceControlWithBackground> mSurfaceViewBackgrounds = new ArrayList();
    ArrayDeque<Rect> mFrozenBounds = new ArrayDeque();
    ArrayDeque<Configuration> mFrozenMergedConfig = new ArrayDeque();

    AppWindowToken(WindowManagerService _service, IApplicationToken _token, boolean _voiceInteraction) {
        super(_service, _token.asBinder(), 2, true);
        this.appWindowToken = this;
        this.appToken = _token;
        this.voiceInteraction = _voiceInteraction;
        this.mInputApplicationHandle = new InputApplicationHandle(this);
        this.mAppAnimator = new AppWindowAnimator(this);
    }

    void sendAppVisibilityToClients() {
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            if (win == this.startingWindow && this.clientHidden) continue;
            try {
                win.mClient.dispatchAppVisibility(!this.clientHidden);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void setVisibleBeforeClientHidden() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            w.setVisibleBeforeClientHidden();
        }
    }

    void onFirstWindowDrawn(WindowState win, WindowStateAnimator winAnimator) {
        this.firstWindowDrawn = true;
        this.removeAllDeadWindows();
        if (this.startingData != null) {
            winAnimator.clearAnimation();
            winAnimator.mService.mFinishedStarting.add(this);
            winAnimator.mService.mH.sendEmptyMessage(7);
        }
        this.updateReportedVisibilityLocked();
    }

    void updateReportedVisibilityLocked() {
        Message m;
        boolean nowVisible;
        if (this.appToken == null) {
            return;
        }
        int numInteresting = 0;
        int numVisible = 0;
        int numDrawn = 0;
        boolean nowGone = true;
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            if (win == this.startingWindow || win.mAppFreezing || win.mViewVisibility != 0 || win.mAttrs.type == 3 || win.mDestroying) continue;
            ++numInteresting;
            if (win.isDrawnLw()) {
                ++numDrawn;
                if (!win.mWinAnimator.isAnimationSet()) {
                    ++numVisible;
                }
                nowGone = false;
                continue;
            }
            if (!win.mWinAnimator.isAnimationSet()) continue;
            nowGone = false;
        }
        boolean nowDrawn = numInteresting > 0 && numDrawn >= numInteresting;
        boolean bl = nowVisible = numInteresting > 0 && numVisible >= numInteresting;
        if (!nowGone) {
            if (!nowDrawn) {
                nowDrawn = this.reportedDrawn;
            }
            if (!nowVisible) {
                nowVisible = this.reportedVisible;
            }
        }
        if (nowDrawn != this.reportedDrawn) {
            if (nowDrawn) {
                m = this.service.mH.obtainMessage(9, this);
                this.service.mH.sendMessage(m);
            }
            this.reportedDrawn = nowDrawn;
        }
        if (nowVisible != this.reportedVisible) {
            this.reportedVisible = nowVisible;
            m = this.service.mH.obtainMessage(8, nowVisible ? 1 : 0, nowGone ? 1 : 0, this);
            this.service.mH.sendMessage(m);
        }
    }

    WindowState findMainWindow() {
        WindowState candidate = null;
        int j = this.windows.size();
        while (j > 0) {
            WindowState win = (WindowState)this.windows.get(--j);
            if (win.mAttrs.type != 1 && win.mAttrs.type != 3) continue;
            if (win.mAnimatingExit) {
                candidate = win;
                continue;
            }
            return win;
        }
        return candidate;
    }

    boolean windowsAreFocusable() {
        return ActivityManager.StackId.canReceiveKeys(this.mTask.mStack.mStackId) || this.mAlwaysFocusable;
    }

    boolean isVisible() {
        int N = this.allAppWindows.size();
        for (int i = 0; i < N; ++i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            if (win.mAppFreezing || win.mViewVisibility != 0 && !win.isAnimatingWithSavedSurface() && (!win.mWinAnimator.isAnimationSet() || this.service.mAppTransition.isTransitionSet()) || win.mDestroying || !win.isDrawnLw()) continue;
            return true;
        }
        return false;
    }

    void removeAppFromTaskLocked() {
        this.mIsExiting = false;
        this.removeAllWindows();
        Task task = this.mTask;
        if (task != null) {
            if (!task.removeAppToken(this)) {
                Slog.e(TAG, "removeAppFromTaskLocked: token=" + this + " not found.");
            }
            task.mStack.mExitingAppTokens.remove(this);
        }
    }

    void clearAnimatingFlags() {
        boolean wallpaperMightChange = false;
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            if (win.mWillReplaceWindow || win.mRemoveOnExit) continue;
            if (win.mAnimatingExit) {
                win.mAnimatingExit = false;
                wallpaperMightChange = true;
            }
            if (win.mWinAnimator.mAnimating) {
                win.mWinAnimator.mAnimating = false;
                wallpaperMightChange = true;
            }
            if (!win.mDestroying) continue;
            win.mDestroying = false;
            this.service.mDestroySurface.remove(win);
            wallpaperMightChange = true;
        }
        if (wallpaperMightChange) {
            this.requestUpdateWallpaperIfNeeded();
        }
    }

    void destroySurfaces() {
        this.destroySurfaces(false);
    }

    private void destroySurfaces(boolean cleanupOnResume) {
        int i;
        ArrayList allWindows = (ArrayList)this.allAppWindows.clone();
        DisplayContentList displayList = new DisplayContentList();
        for (i = allWindows.size() - 1; i >= 0; --i) {
            DisplayContent displayContent;
            WindowState win = (WindowState)allWindows.get(i);
            if (!this.mAppStopped && !win.mWindowRemovalAllowed && !cleanupOnResume) continue;
            win.mWinAnimator.destroyPreservedSurfaceLocked();
            if (!win.mDestroying) continue;
            if (!cleanupOnResume || win.mRemoveOnExit) {
                win.destroyOrSaveSurface();
            }
            if (win.mRemoveOnExit) {
                this.service.removeWindowInnerLocked(win);
            }
            if ((displayContent = win.getDisplayContent()) != null && !displayList.contains(displayContent)) {
                displayList.add(displayContent);
            }
            if (cleanupOnResume) {
                win.requestUpdateWallpaperIfNeeded();
            }
            win.mDestroying = false;
        }
        for (i = 0; i < displayList.size(); ++i) {
            DisplayContent displayContent = (DisplayContent)displayList.get(i);
            this.service.mLayersController.assignLayersLocked(displayContent.getWindowList());
            displayContent.layoutNeeded = true;
        }
    }

    void notifyAppResumed(boolean wasStopped, boolean allowSavedSurface) {
        this.mAppStopped = false;
        if (!wasStopped) {
            this.destroySurfaces(true);
        }
        if (!allowSavedSurface) {
            this.destroySavedSurfaces();
        }
    }

    void notifyAppStopped() {
        this.mAppStopped = true;
        this.destroySurfaces();
        this.mTask.mService.scheduleRemoveStartingWindowLocked(this);
    }

    boolean shouldSaveSurface() {
        return this.allDrawn;
    }

    boolean canRestoreSurfaces() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            if (!w.canRestoreSurface()) continue;
            return true;
        }
        return false;
    }

    void clearVisibleBeforeClientHidden() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            w.clearVisibleBeforeClientHidden();
        }
    }

    boolean isAnimatingInvisibleWithSavedSurface() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            if (!w.isAnimatingInvisibleWithSavedSurface()) continue;
            return true;
        }
        return false;
    }

    void stopUsingSavedSurfaceLocked() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            if (!w.isAnimatingInvisibleWithSavedSurface()) continue;
            w.clearAnimatingWithSavedSurface();
            w.mDestroying = true;
            w.mWinAnimator.hide("stopUsingSavedSurfaceLocked");
            w.mWinAnimator.mWallpaperControllerLocked.hideWallpapers(w);
        }
        this.destroySurfaces();
    }

    void markSavedSurfaceExiting() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            if (!w.isAnimatingInvisibleWithSavedSurface()) continue;
            w.mAnimatingExit = true;
            w.mWinAnimator.mAnimating = true;
        }
    }

    void restoreSavedSurfaces() {
        if (!this.canRestoreSurfaces()) {
            this.clearVisibleBeforeClientHidden();
            return;
        }
        int numInteresting = 0;
        int numDrawn = 0;
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            if (w == this.startingWindow || w.mAppDied || !w.wasVisibleBeforeClientHidden() || this.mAppAnimator.freezingScreen && w.mAppFreezing) continue;
            ++numInteresting;
            if (w.hasSavedSurface()) {
                w.restoreSavedSurface();
            }
            if (!w.isDrawnLw()) continue;
            ++numDrawn;
        }
        if (!this.allDrawn) {
            boolean bl = this.allDrawn = numInteresting > 0 && numInteresting == numDrawn;
            if (this.allDrawn) {
                this.service.mH.obtainMessage(32, this.token).sendToTarget();
            }
        }
        this.clearVisibleBeforeClientHidden();
    }

    void destroySavedSurfaces() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.allAppWindows.get(i);
            win.destroySavedSurface();
        }
    }

    void clearAllDrawn() {
        this.allDrawn = false;
        this.deferClearAllDrawn = false;
        this.allDrawnExcludingSaved = false;
    }

    @Override
    void removeAllWindows() {
        int winNdx = this.allAppWindows.size() - 1;
        while (winNdx >= 0) {
            WindowState win = (WindowState)this.allAppWindows.get(winNdx);
            this.service.removeWindowLocked(win);
            winNdx = Math.min(winNdx - 1, this.allAppWindows.size() - 1);
        }
        this.allAppWindows.clear();
        this.windows.clear();
    }

    void removeAllDeadWindows() {
        int winNdx = this.allAppWindows.size() - 1;
        while (winNdx >= 0) {
            WindowState win = (WindowState)this.allAppWindows.get(winNdx);
            if (win.mAppDied) {
                win.mDestroying = true;
                this.service.removeWindowLocked(win);
            }
            winNdx = Math.min(winNdx - 1, this.allAppWindows.size() - 1);
        }
    }

    boolean hasWindowsAlive() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            if (((WindowState)this.allAppWindows.get((int)i)).mAppDied) continue;
            return true;
        }
        return false;
    }

    void setReplacingWindows(boolean animate) {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            w.setReplacing(animate);
        }
        if (animate) {
            this.mAppAnimator.setDummyAnimation();
        }
    }

    void setReplacingChildren() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            if (!w.shouldBeReplacedWithChildren()) continue;
            w.setReplacing(false);
        }
    }

    void resetReplacingWindows() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            w.resetReplacing();
        }
    }

    void requestUpdateWallpaperIfNeeded() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.allAppWindows.get(i);
            w.requestUpdateWallpaperIfNeeded();
        }
    }

    boolean isRelaunching() {
        return this.mPendingRelaunchCount > 0;
    }

    void startRelaunching() {
        if (this.canFreezeBounds()) {
            this.freezeBounds();
        }
        ++this.mPendingRelaunchCount;
    }

    void finishRelaunching() {
        if (this.canFreezeBounds()) {
            this.unfreezeBounds();
        }
        if (this.mPendingRelaunchCount > 0) {
            --this.mPendingRelaunchCount;
        }
    }

    void clearRelaunching() {
        if (this.mPendingRelaunchCount == 0) {
            return;
        }
        if (this.canFreezeBounds()) {
            this.unfreezeBounds();
        }
        this.mPendingRelaunchCount = 0;
    }

    void addWindow(WindowState w) {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.allAppWindows.get(i);
            if (!candidate.mWillReplaceWindow || candidate.mReplacingWindow != null || !candidate.getWindowTag().toString().equals(w.getWindowTag().toString())) continue;
            candidate.mReplacingWindow = w;
            w.mSkipEnterAnimationForSeamlessReplacement = !candidate.mAnimateReplacingWindow;
            this.service.scheduleReplacingWindowTimeouts(this);
        }
        this.allAppWindows.add(w);
    }

    boolean waitingForReplacement() {
        for (int i = this.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.allAppWindows.get(i);
            if (!candidate.mWillReplaceWindow) continue;
            return true;
        }
        return false;
    }

    void clearTimedoutReplacesLocked() {
        int i = this.allAppWindows.size() - 1;
        while (i >= 0) {
            WindowState candidate = (WindowState)this.allAppWindows.get(i);
            if (candidate.mWillReplaceWindow) {
                candidate.mWillReplaceWindow = false;
                if (candidate.mReplacingWindow != null) {
                    candidate.mReplacingWindow.mSkipEnterAnimationForSeamlessReplacement = false;
                }
                this.service.removeWindowInnerLocked(candidate);
            }
            i = Math.min(i - 1, this.allAppWindows.size() - 1);
        }
    }

    private boolean canFreezeBounds() {
        return this.mTask != null && !this.mTask.inFreeformWorkspace();
    }

    private void freezeBounds() {
        this.mFrozenBounds.offer(new Rect(this.mTask.mPreparedFrozenBounds));
        if (this.mTask.mPreparedFrozenMergedConfig.equals(Configuration.EMPTY)) {
            Configuration config = new Configuration(this.service.mCurConfiguration);
            config.updateFrom(this.mTask.mOverrideConfig);
            this.mFrozenMergedConfig.offer(config);
        } else {
            this.mFrozenMergedConfig.offer(new Configuration(this.mTask.mPreparedFrozenMergedConfig));
        }
        this.mTask.mPreparedFrozenMergedConfig.setToDefaults();
    }

    private void unfreezeBounds() {
        if (!this.mFrozenBounds.isEmpty()) {
            this.mFrozenBounds.remove();
        }
        if (!this.mFrozenMergedConfig.isEmpty()) {
            this.mFrozenMergedConfig.remove();
        }
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.windows.get(i);
            if (!win.mHasSurface) continue;
            win.mLayoutNeeded = true;
            win.setDisplayLayoutNeeded();
            if (this.service.mResizingWindows.contains(win)) continue;
            this.service.mResizingWindows.add(win);
        }
        this.service.mWindowPlacerLocked.performSurfacePlacement();
    }

    void addSurfaceViewBackground(WindowSurfaceController.SurfaceControlWithBackground background) {
        this.mSurfaceViewBackgrounds.add(background);
    }

    void removeSurfaceViewBackground(WindowSurfaceController.SurfaceControlWithBackground background) {
        this.mSurfaceViewBackgrounds.remove(background);
        this.updateSurfaceViewBackgroundVisibilities();
    }

    void updateSurfaceViewBackgroundVisibilities() {
        WindowSurfaceController.SurfaceControlWithBackground sc;
        int i;
        WindowSurfaceController.SurfaceControlWithBackground bottom = null;
        int bottomLayer = Integer.MAX_VALUE;
        for (i = 0; i < this.mSurfaceViewBackgrounds.size(); ++i) {
            sc = this.mSurfaceViewBackgrounds.get(i);
            if (!sc.mVisible || sc.mLayer >= bottomLayer) continue;
            bottomLayer = sc.mLayer;
            bottom = sc;
        }
        for (i = 0; i < this.mSurfaceViewBackgrounds.size(); ++i) {
            sc.updateBackgroundVisibility((sc = this.mSurfaceViewBackgrounds.get(i)) != bottom);
        }
    }

    @Override
    void dump(PrintWriter pw, String prefix) {
        super.dump(pw, prefix);
        if (this.appToken != null) {
            pw.print(prefix);
            pw.print("app=true voiceInteraction=");
            pw.println(this.voiceInteraction);
        }
        if (this.allAppWindows.size() > 0) {
            pw.print(prefix);
            pw.print("allAppWindows=");
            pw.println(this.allAppWindows);
        }
        pw.print(prefix);
        pw.print("task=");
        pw.println(this.mTask);
        pw.print(prefix);
        pw.print(" appFullscreen=");
        pw.print(this.appFullscreen);
        pw.print(" requestedOrientation=");
        pw.println(this.requestedOrientation);
        pw.print(prefix);
        pw.print("hiddenRequested=");
        pw.print(this.hiddenRequested);
        pw.print(" clientHidden=");
        pw.print(this.clientHidden);
        pw.print(" reportedDrawn=");
        pw.print(this.reportedDrawn);
        pw.print(" reportedVisible=");
        pw.println(this.reportedVisible);
        if (this.paused) {
            pw.print(prefix);
            pw.print("paused=");
            pw.println(this.paused);
        }
        if (this.mAppStopped) {
            pw.print(prefix);
            pw.print("mAppStopped=");
            pw.println(this.mAppStopped);
        }
        if (this.numInterestingWindows != 0 || this.numDrawnWindows != 0 || this.allDrawn || this.mAppAnimator.allDrawn) {
            pw.print(prefix);
            pw.print("numInterestingWindows=");
            pw.print(this.numInterestingWindows);
            pw.print(" numDrawnWindows=");
            pw.print(this.numDrawnWindows);
            pw.print(" inPendingTransaction=");
            pw.print(this.inPendingTransaction);
            pw.print(" allDrawn=");
            pw.print(this.allDrawn);
            pw.print(" (animator=");
            pw.print(this.mAppAnimator.allDrawn);
            pw.println(")");
        }
        if (this.inPendingTransaction) {
            pw.print(prefix);
            pw.print("inPendingTransaction=");
            pw.println(this.inPendingTransaction);
        }
        if (this.startingData != null || this.removed || this.firstWindowDrawn || this.mIsExiting) {
            pw.print(prefix);
            pw.print("startingData=");
            pw.print(this.startingData);
            pw.print(" removed=");
            pw.print(this.removed);
            pw.print(" firstWindowDrawn=");
            pw.print(this.firstWindowDrawn);
            pw.print(" mIsExiting=");
            pw.println(this.mIsExiting);
        }
        if (this.startingWindow != null || this.startingView != null || this.startingDisplayed || this.startingMoved) {
            pw.print(prefix);
            pw.print("startingWindow=");
            pw.print(this.startingWindow);
            pw.print(" startingView=");
            pw.print(this.startingView);
            pw.print(" startingDisplayed=");
            pw.print(this.startingDisplayed);
            pw.print(" startingMoved=");
            pw.println(this.startingMoved);
        }
        if (!this.mFrozenBounds.isEmpty()) {
            pw.print(prefix);
            pw.print("mFrozenBounds=");
            pw.println(this.mFrozenBounds);
            pw.print(prefix);
            pw.print("mFrozenMergedConfig=");
            pw.println(this.mFrozenMergedConfig);
        }
        if (this.mPendingRelaunchCount != 0) {
            pw.print(prefix);
            pw.print("mPendingRelaunchCount=");
            pw.println(this.mPendingRelaunchCount);
        }
    }

    @Override
    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("AppWindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" token=");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName;
    }
}

