/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.Rect;
import android.graphics.Region;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayInfo;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DimLayerController;
import com.android.server.wm.DockedStackDividerController;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskTapPointerEventListener;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;

class DisplayContent {
    private final int mDisplayId;
    private final WindowList mWindows = new WindowList();
    int mInitialDisplayWidth = 0;
    int mInitialDisplayHeight = 0;
    int mInitialDisplayDensity = 0;
    int mBaseDisplayWidth = 0;
    int mBaseDisplayHeight = 0;
    int mBaseDisplayDensity = 0;
    boolean mDisplayScalingDisabled;
    private final DisplayInfo mDisplayInfo = new DisplayInfo();
    private final Display mDisplay;
    private final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    Rect mBaseDisplayRect = new Rect();
    Rect mContentRect = new Rect();
    boolean layoutNeeded;
    int pendingLayoutChanges;
    final boolean isDefaultDisplay;
    final ArrayList<WindowToken> mExitingTokens = new ArrayList();
    private final ArrayList<TaskStack> mStacks = new ArrayList();
    private TaskStack mHomeStack = null;
    TaskTapPointerEventListener mTapDetector;
    Region mTouchExcludeRegion = new Region();
    Region mNonResizeableRegion = new Region();
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpRect2 = new Rect();
    private final Region mTmpRegion = new Region();
    final ArrayList<Task> mTmpTaskHistory = new ArrayList();
    final WindowManagerService mService;
    boolean mDeferredRemoval;
    final DockedStackDividerController mDividerControllerLocked;
    final DimLayerController mDimLayerController;
    final ArrayList<WindowState> mTapExcludedWindows = new ArrayList();

    DisplayContent(Display display, WindowManagerService service) {
        this.mDisplay = display;
        this.mDisplayId = display.getDisplayId();
        display.getDisplayInfo(this.mDisplayInfo);
        display.getMetrics(this.mDisplayMetrics);
        this.isDefaultDisplay = this.mDisplayId == 0;
        this.mService = service;
        this.initializeDisplayBaseInfo();
        this.mDividerControllerLocked = new DockedStackDividerController(service, this);
        this.mDimLayerController = new DimLayerController(this);
    }

    int getDisplayId() {
        return this.mDisplayId;
    }

    WindowList getWindowList() {
        return this.mWindows;
    }

    Display getDisplay() {
        return this.mDisplay;
    }

    DisplayInfo getDisplayInfo() {
        return this.mDisplayInfo;
    }

    DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }

    DockedStackDividerController getDockedDividerController() {
        return this.mDividerControllerLocked;
    }

    public boolean hasAccess(int uid) {
        return this.mDisplay.hasAccess(uid);
    }

    public boolean isPrivate() {
        return (this.mDisplay.getFlags() & 4) != 0;
    }

    ArrayList<TaskStack> getStacks() {
        return this.mStacks;
    }

    ArrayList<Task> getTasks() {
        this.mTmpTaskHistory.clear();
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            this.mTmpTaskHistory.addAll(this.mStacks.get(stackNdx).getTasks());
        }
        return this.mTmpTaskHistory;
    }

    TaskStack getHomeStack() {
        if (this.mHomeStack == null && this.mDisplayId == 0) {
            Slog.e("WindowManager", "getHomeStack: Returning null from this=" + this);
        }
        return this.mHomeStack;
    }

    TaskStack getStackById(int stackId) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            TaskStack stack = this.mStacks.get(i);
            if (stack.mStackId != stackId) continue;
            return stack;
        }
        return null;
    }

    void updateDisplayInfo() {
        this.mDisplay.getDisplayInfo(this.mDisplayInfo);
        this.mDisplay.getMetrics(this.mDisplayMetrics);
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            this.mStacks.get(i).updateDisplayInfo(null);
        }
    }

    void initializeDisplayBaseInfo() {
        DisplayInfo newDisplayInfo = this.mService.mDisplayManagerInternal.getDisplayInfo(this.mDisplayId);
        if (newDisplayInfo != null) {
            this.mDisplayInfo.copyFrom(newDisplayInfo);
        }
        this.mBaseDisplayWidth = this.mInitialDisplayWidth = this.mDisplayInfo.logicalWidth;
        this.mBaseDisplayHeight = this.mInitialDisplayHeight = this.mDisplayInfo.logicalHeight;
        this.mBaseDisplayDensity = this.mInitialDisplayDensity = this.mDisplayInfo.logicalDensityDpi;
        this.mBaseDisplayRect.set(0, 0, this.mBaseDisplayWidth, this.mBaseDisplayHeight);
    }

    void getLogicalDisplayRect(Rect out) {
        int orientation = this.mDisplayInfo.rotation;
        boolean rotated = orientation == 1 || orientation == 3;
        int physWidth = rotated ? this.mBaseDisplayHeight : this.mBaseDisplayWidth;
        int physHeight = rotated ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        int width = this.mDisplayInfo.logicalWidth;
        int left = (physWidth - width) / 2;
        int height = this.mDisplayInfo.logicalHeight;
        int top = (physHeight - height) / 2;
        out.set(left, top, left + width, top + height);
    }

    void getContentRect(Rect out) {
        out.set(this.mContentRect);
    }

    void attachStack(TaskStack stack, boolean onTop) {
        if (stack.mStackId == 0) {
            if (this.mHomeStack != null) {
                throw new IllegalArgumentException("attachStack: HOME_STACK_ID (0) not first.");
            }
            this.mHomeStack = stack;
        }
        if (onTop) {
            this.mStacks.add(stack);
        } else {
            this.mStacks.add(0, stack);
        }
        this.layoutNeeded = true;
    }

    void moveStack(TaskStack stack, boolean toTop) {
        int addIndex;
        if (ActivityManager.StackId.isAlwaysOnTop(stack.mStackId) && !toTop) {
            Slog.w("WindowManager", "Ignoring move of always-on-top stack=" + stack + " to bottom");
            return;
        }
        if (!this.mStacks.remove(stack)) {
            Slog.wtf("WindowManager", "moving stack that was not added: " + stack, new Throwable());
        }
        int n = addIndex = toTop ? this.mStacks.size() : 0;
        if (toTop && this.mService.isStackVisibleLocked(4) && stack.mStackId != 4) {
            TaskStack topStack = this.mStacks.get(--addIndex);
            if (topStack.mStackId != 4) {
                throw new IllegalStateException("Pinned stack isn't top stack??? " + this.mStacks);
            }
        }
        this.mStacks.add(addIndex, stack);
    }

    void detachStack(TaskStack stack) {
        this.mDimLayerController.removeDimLayerUser(stack);
        this.mStacks.remove(stack);
    }

    void resize(Rect contentRect) {
        this.mContentRect.set(contentRect);
    }

    int taskIdFromPoint(int x, int y) {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = this.mStacks.get(stackNdx);
            stack.getBounds(this.mTmpRect);
            if (!this.mTmpRect.contains(x, y) || stack.isAdjustedForMinimizedDockedStack()) continue;
            ArrayList<Task> tasks = stack.getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                Task task = tasks.get(taskNdx);
                WindowState win = task.getTopVisibleAppMainWindow();
                if (win == null) continue;
                task.getDimBounds(this.mTmpRect);
                if (!this.mTmpRect.contains(x, y)) continue;
                return task.mTaskId;
            }
        }
        return -1;
    }

    Task findTaskForControlPoint(int x, int y) {
        int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = this.mStacks.get(stackNdx);
            if (!ActivityManager.StackId.isTaskResizeAllowed(stack.mStackId)) break;
            ArrayList<Task> tasks = stack.getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                Task task = tasks.get(taskNdx);
                if (task.isFullscreen()) {
                    return null;
                }
                task.getDimBounds(this.mTmpRect);
                this.mTmpRect.inset(-delta, -delta);
                if (!this.mTmpRect.contains(x, y)) continue;
                this.mTmpRect.inset(delta, delta);
                if (!this.mTmpRect.contains(x, y)) {
                    return task;
                }
                return null;
            }
        }
        return null;
    }

    void setTouchExcludeRegion(Task focusedTask) {
        WindowState inputMethod;
        this.mTouchExcludeRegion.set(this.mBaseDisplayRect);
        int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
        boolean addBackFocusedTask = false;
        this.mNonResizeableRegion.setEmpty();
        block0: for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = this.mStacks.get(stackNdx);
            ArrayList<Task> tasks = stack.getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                Task task = tasks.get(taskNdx);
                AppWindowToken token = task.getTopVisibleAppToken();
                if (token == null || !token.isVisible()) continue;
                task.getDimBounds(this.mTmpRect);
                if (task == focusedTask) {
                    addBackFocusedTask = true;
                    this.mTmpRect2.set(this.mTmpRect);
                }
                boolean isFreeformed = task.inFreeformWorkspace();
                if (task != focusedTask || isFreeformed) {
                    if (isFreeformed) {
                        this.mTmpRect.inset(-delta, -delta);
                        this.mTmpRect.intersect(this.mContentRect);
                    }
                    this.mTouchExcludeRegion.op(this.mTmpRect, Region.Op.DIFFERENCE);
                }
                if (!task.isTwoFingerScrollMode()) continue;
                stack.getBounds(this.mTmpRect);
                this.mNonResizeableRegion.op(this.mTmpRect, Region.Op.UNION);
                continue block0;
            }
        }
        if (addBackFocusedTask) {
            this.mTouchExcludeRegion.op(this.mTmpRect2, Region.Op.UNION);
        }
        if ((inputMethod = this.mService.mInputMethodWindow) != null && inputMethod.isVisibleLw()) {
            inputMethod.getTouchableRegion(this.mTmpRegion);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        for (int i = this.mTapExcludedWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mTapExcludedWindows.get(i);
            win.getTouchableRegion(this.mTmpRegion);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        if (this.getDockedStackVisibleForUserLocked() != null) {
            this.mDividerControllerLocked.getTouchRegion(this.mTmpRect);
            this.mTmpRegion.set(this.mTmpRect);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        if (this.mTapDetector != null) {
            this.mTapDetector.setTouchExcludeRegion(this.mTouchExcludeRegion, this.mNonResizeableRegion);
        }
    }

    void switchUserStacks() {
        WindowList windows = this.getWindowList();
        for (int i = 0; i < windows.size(); ++i) {
            WindowState win = (WindowState)windows.get(i);
            if (!win.isHiddenFromUserLocked()) continue;
            win.hideLw(false);
        }
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            this.mStacks.get(stackNdx).switchUser();
        }
    }

    void resetAnimationBackgroundAnimator() {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            this.mStacks.get(stackNdx).resetAnimationBackgroundAnimator();
        }
    }

    boolean animateDimLayers() {
        return this.mDimLayerController.animateDimLayers();
    }

    void resetDimming() {
        this.mDimLayerController.resetDimming();
    }

    boolean isDimming() {
        return this.mDimLayerController.isDimming();
    }

    void stopDimmingIfNeeded() {
        this.mDimLayerController.stopDimmingIfNeeded();
    }

    void close() {
        this.mDimLayerController.close();
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            this.mStacks.get(stackNdx).close();
        }
    }

    boolean isAnimating() {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = this.mStacks.get(stackNdx);
            if (!stack.isAnimating()) continue;
            return true;
        }
        return false;
    }

    void checkForDeferredActions() {
        boolean animating = false;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = this.mStacks.get(stackNdx);
            if (stack.isAnimating()) {
                animating = true;
                continue;
            }
            if (stack.mDeferDetach) {
                this.mService.detachStackLocked(this, stack);
            }
            ArrayList<Task> tasks = stack.getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                Task task = tasks.get(taskNdx);
                AppTokenList tokens = task.mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                    if (!wtoken.mIsExiting) continue;
                    wtoken.removeAppFromTaskLocked();
                }
            }
        }
        if (!animating && this.mDeferredRemoval) {
            this.mService.onDisplayRemoved(this.mDisplayId);
        }
    }

    void rotateBounds(int oldRotation, int newRotation, Rect bounds) {
        int rotationDelta = DisplayContent.deltaRotation(oldRotation, newRotation);
        this.getLogicalDisplayRect(this.mTmpRect);
        switch (rotationDelta) {
            case 0: {
                this.mTmpRect2.set(bounds);
                break;
            }
            case 1: {
                this.mTmpRect2.top = this.mTmpRect.bottom - bounds.right;
                this.mTmpRect2.left = bounds.top;
                this.mTmpRect2.right = this.mTmpRect2.left + bounds.height();
                this.mTmpRect2.bottom = this.mTmpRect2.top + bounds.width();
                break;
            }
            case 2: {
                this.mTmpRect2.top = this.mTmpRect.bottom - bounds.bottom;
                this.mTmpRect2.left = this.mTmpRect.right - bounds.right;
                this.mTmpRect2.right = this.mTmpRect2.left + bounds.width();
                this.mTmpRect2.bottom = this.mTmpRect2.top + bounds.height();
                break;
            }
            case 3: {
                this.mTmpRect2.top = bounds.left;
                this.mTmpRect2.left = this.mTmpRect.right - bounds.bottom;
                this.mTmpRect2.right = this.mTmpRect2.left + bounds.height();
                this.mTmpRect2.bottom = this.mTmpRect2.top + bounds.width();
            }
        }
        bounds.set(this.mTmpRect2);
    }

    static int deltaRotation(int oldRotation, int newRotation) {
        int delta = newRotation - oldRotation;
        if (delta < 0) {
            delta += 4;
        }
        return delta;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("Display: mDisplayId=");
        pw.println(this.mDisplayId);
        String subPrefix = "  " + prefix;
        pw.print(subPrefix);
        pw.print("init=");
        pw.print(this.mInitialDisplayWidth);
        pw.print("x");
        pw.print(this.mInitialDisplayHeight);
        pw.print(" ");
        pw.print(this.mInitialDisplayDensity);
        pw.print("dpi");
        if (this.mInitialDisplayWidth != this.mBaseDisplayWidth || this.mInitialDisplayHeight != this.mBaseDisplayHeight || this.mInitialDisplayDensity != this.mBaseDisplayDensity) {
            pw.print(" base=");
            pw.print(this.mBaseDisplayWidth);
            pw.print("x");
            pw.print(this.mBaseDisplayHeight);
            pw.print(" ");
            pw.print(this.mBaseDisplayDensity);
            pw.print("dpi");
        }
        if (this.mDisplayScalingDisabled) {
            pw.println(" noscale");
        }
        pw.print(" cur=");
        pw.print(this.mDisplayInfo.logicalWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.logicalHeight);
        pw.print(" app=");
        pw.print(this.mDisplayInfo.appWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.appHeight);
        pw.print(" rng=");
        pw.print(this.mDisplayInfo.smallestNominalAppWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.smallestNominalAppHeight);
        pw.print("-");
        pw.print(this.mDisplayInfo.largestNominalAppWidth);
        pw.print("x");
        pw.println(this.mDisplayInfo.largestNominalAppHeight);
        pw.print(subPrefix);
        pw.print("deferred=");
        pw.print(this.mDeferredRemoval);
        pw.print(" layoutNeeded=");
        pw.println(this.layoutNeeded);
        pw.println();
        pw.println("  Application tokens in top down Z order:");
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = this.mStacks.get(stackNdx);
            stack.dump(prefix + "  ", pw);
        }
        pw.println();
        if (!this.mExitingTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting tokens:");
            for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
                WindowToken token = this.mExitingTokens.get(i);
                pw.print("  Exiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
        pw.println();
        this.mDimLayerController.dump(prefix + "  ", pw);
        pw.println();
        this.mDividerControllerLocked.dump(prefix + "  ", pw);
    }

    public String toString() {
        return "Display " + this.mDisplayId + " info=" + this.mDisplayInfo + " stacks=" + this.mStacks;
    }

    TaskStack getDockedStackLocked() {
        TaskStack stack = this.mService.mStackIdToStack.get(3);
        return stack != null && stack.isVisibleLocked() ? stack : null;
    }

    TaskStack getDockedStackVisibleForUserLocked() {
        TaskStack stack = this.mService.mStackIdToStack.get(3);
        return stack != null && stack.isVisibleForUserLocked() ? stack : null;
    }

    WindowState getTouchableWinAtPointLocked(float xf, float yf) {
        WindowState touchedWin = null;
        int x = (int)xf;
        int y = (int)yf;
        for (int i = this.mWindows.size() - 1; i >= 0; --i) {
            WindowState window = (WindowState)this.mWindows.get(i);
            int flags = window.mAttrs.flags;
            if (!window.isVisibleLw() || (flags & 0x10) != 0) continue;
            window.getVisibleBounds(this.mTmpRect);
            if (!this.mTmpRect.contains(x, y)) continue;
            window.getTouchableRegion(this.mTmpRegion);
            int touchFlags = flags & 0x28;
            if (!this.mTmpRegion.contains(x, y) && touchFlags != 0) continue;
            touchedWin = window;
            break;
        }
        return touchedWin;
    }
}

