/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Slog;
import android.view.DisplayInfo;
import android.view.IDockedStackListener;
import android.view.SurfaceControl;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.policy.DividerSnapAlgorithm;
import com.android.internal.policy.DockedDividerUtils;
import com.android.server.LocalServices;
import com.android.server.wm.AppTransition;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.ArrayList;

public class DockedStackDividerController
implements DimLayer.DimLayerUser {
    private static final String TAG = "WindowManager";
    private static final float CLIP_REVEAL_MEET_EARLIEST = 0.6f;
    private static final float CLIP_REVEAL_MEET_LAST = 1.0f;
    private static final float CLIP_REVEAL_MEET_FRACTION_MIN = 0.4f;
    private static final float CLIP_REVEAL_MEET_FRACTION_MAX = 0.8f;
    private static final Interpolator IME_ADJUST_ENTRY_INTERPOLATOR = new PathInterpolator(0.2f, 0.0f, 0.1f, 1.0f);
    private static final long IME_ADJUST_ANIM_DURATION = 280L;
    private static final long IME_ADJUST_DRAWN_TIMEOUT = 200L;
    private static final int DIVIDER_WIDTH_INACTIVE_DP = 4;
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private int mDividerWindowWidth;
    private int mDividerWindowWidthInactive;
    private int mDividerInsets;
    private boolean mResizing;
    private WindowState mWindow;
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpRect2 = new Rect();
    private final Rect mTmpRect3 = new Rect();
    private final Rect mLastRect = new Rect();
    private boolean mLastVisibility = false;
    private final RemoteCallbackList<IDockedStackListener> mDockedStackListeners = new RemoteCallbackList();
    private final DimLayer mDimLayer;
    private boolean mMinimizedDock;
    private boolean mAnimatingForMinimizedDockedStack;
    private boolean mAnimationStarted;
    private long mAnimationStartTime;
    private float mAnimationStart;
    private float mAnimationTarget;
    private long mAnimationDuration;
    private boolean mAnimationStartDelayed;
    private final Interpolator mMinimizedDockInterpolator;
    private float mMaximizeMeetFraction;
    private final Rect mTouchRegion = new Rect();
    private boolean mAnimatingForIme;
    private boolean mAdjustedForIme;
    private int mImeHeight;
    private WindowState mDelayedImeWin;
    private boolean mAdjustedForDivider;
    private float mDividerAnimationStart;
    private float mDividerAnimationTarget;
    private float mLastAnimationProgress;
    private float mLastDividerProgress;
    private final DividerSnapAlgorithm[] mSnapAlgorithmForRotation = new DividerSnapAlgorithm[4];
    private boolean mImeHideRequested;

    DockedStackDividerController(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        Context context = service.mContext;
        this.mDimLayer = new DimLayer(displayContent.mService, this, displayContent.getDisplayId(), "DockedStackDim");
        this.mMinimizedDockInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.loadDimens();
    }

    int getSmallestWidthDpForBounds(Rect bounds) {
        DisplayInfo di = this.mDisplayContent.getDisplayInfo();
        if (bounds == null || bounds.left == 0 && bounds.top == 0 && bounds.right == di.logicalWidth && bounds.bottom == di.logicalHeight) {
            return this.mService.mCurConfiguration.smallestScreenWidthDp;
        }
        int baseDisplayWidth = this.mDisplayContent.mBaseDisplayWidth;
        int baseDisplayHeight = this.mDisplayContent.mBaseDisplayHeight;
        int minWidth = Integer.MAX_VALUE;
        for (int rotation = 0; rotation < 4; ++rotation) {
            this.mTmpRect.set(bounds);
            this.mDisplayContent.rotateBounds(di.rotation, rotation, this.mTmpRect);
            boolean rotated = rotation == 1 || rotation == 3;
            this.mTmpRect2.set(0, 0, rotated ? baseDisplayHeight : baseDisplayWidth, rotated ? baseDisplayWidth : baseDisplayHeight);
            int orientation = this.mTmpRect2.width() <= this.mTmpRect2.height() ? 1 : 2;
            int dockSide = TaskStack.getDockSideUnchecked(this.mTmpRect, this.mTmpRect2, orientation);
            int position = DockedDividerUtils.calculatePositionForBounds(this.mTmpRect, dockSide, this.getContentWidth());
            int snappedPosition = this.mSnapAlgorithmForRotation[rotation].calculateNonDismissingSnapTarget((int)position).position;
            DockedDividerUtils.calculateBoundsForPosition(snappedPosition, dockSide, this.mTmpRect, this.mTmpRect2.width(), this.mTmpRect2.height(), this.getContentWidth());
            this.mService.mPolicy.getStableInsetsLw(rotation, this.mTmpRect2.width(), this.mTmpRect2.height(), this.mTmpRect3);
            this.mService.subtractInsets(this.mTmpRect2, this.mTmpRect3, this.mTmpRect);
            minWidth = Math.min(this.mTmpRect.width(), minWidth);
        }
        return (int)((float)minWidth / this.mDisplayContent.getDisplayMetrics().density);
    }

    private void initSnapAlgorithmForRotations() {
        Configuration baseConfig = this.mService.mCurConfiguration;
        Configuration config = new Configuration();
        for (int rotation = 0; rotation < 4; ++rotation) {
            boolean rotated = rotation == 1 || rotation == 3;
            int dw = rotated ? this.mDisplayContent.mBaseDisplayHeight : this.mDisplayContent.mBaseDisplayWidth;
            int dh = rotated ? this.mDisplayContent.mBaseDisplayWidth : this.mDisplayContent.mBaseDisplayHeight;
            this.mService.mPolicy.getStableInsetsLw(rotation, dw, dh, this.mTmpRect);
            config.setToDefaults();
            config.orientation = dw <= dh ? 1 : 2;
            config.screenWidthDp = (int)((float)this.mService.mPolicy.getConfigDisplayWidth(dw, dh, rotation, baseConfig.uiMode) / this.mDisplayContent.getDisplayMetrics().density);
            config.screenHeightDp = (int)((float)this.mService.mPolicy.getConfigDisplayHeight(dw, dh, rotation, baseConfig.uiMode) / this.mDisplayContent.getDisplayMetrics().density);
            Context rotationContext = this.mService.mContext.createConfigurationContext(config);
            this.mSnapAlgorithmForRotation[rotation] = new DividerSnapAlgorithm(rotationContext.getResources(), dw, dh, this.getContentWidth(), config.orientation == 1, this.mTmpRect);
        }
    }

    private void loadDimens() {
        Context context = this.mService.mContext;
        this.mDividerWindowWidth = context.getResources().getDimensionPixelSize(17104929);
        this.mDividerInsets = context.getResources().getDimensionPixelSize(17104930);
        this.mDividerWindowWidthInactive = WindowManagerService.dipToPixel(4, this.mDisplayContent.getDisplayMetrics());
        this.initSnapAlgorithmForRotations();
    }

    void onConfigurationChanged() {
        this.loadDimens();
    }

    boolean isResizing() {
        return this.mResizing;
    }

    int getContentWidth() {
        return this.mDividerWindowWidth - 2 * this.mDividerInsets;
    }

    int getContentInsets() {
        return this.mDividerInsets;
    }

    int getContentWidthInactive() {
        return this.mDividerWindowWidthInactive;
    }

    void setResizing(boolean resizing) {
        if (this.mResizing != resizing) {
            this.mResizing = resizing;
            this.resetDragResizingChangeReported();
        }
    }

    void setTouchRegion(Rect touchRegion) {
        this.mTouchRegion.set(touchRegion);
    }

    void getTouchRegion(Rect outRegion) {
        outRegion.set(this.mTouchRegion);
        outRegion.offset(this.mWindow.getFrameLw().left, this.mWindow.getFrameLw().top);
    }

    private void resetDragResizingChangeReported() {
        WindowList windowList = this.mDisplayContent.getWindowList();
        for (int i = windowList.size() - 1; i >= 0; --i) {
            ((WindowState)windowList.get(i)).resetDragResizingChangeReported();
        }
    }

    void setWindow(WindowState window) {
        this.mWindow = window;
        this.reevaluateVisibility(false);
    }

    void reevaluateVisibility(boolean force) {
        boolean visible;
        if (this.mWindow == null) {
            return;
        }
        TaskStack stack = this.mDisplayContent.mService.mStackIdToStack.get(3);
        boolean bl = visible = stack != null;
        if (this.mLastVisibility == visible && !force) {
            return;
        }
        this.mLastVisibility = visible;
        this.notifyDockedDividerVisibilityChanged(visible);
        if (!visible) {
            this.setResizeDimLayer(false, -1, 0.0f);
        }
    }

    boolean wasVisible() {
        return this.mLastVisibility;
    }

    void setAdjustedForIme(boolean adjustedForIme, boolean adjustedForDivider, boolean animate, WindowState imeWin, int imeHeight) {
        if (this.mAdjustedForIme != adjustedForIme || adjustedForIme && this.mImeHeight != imeHeight || this.mAdjustedForDivider != adjustedForDivider) {
            if (animate && !this.mAnimatingForMinimizedDockedStack) {
                this.startImeAdjustAnimation(adjustedForIme, adjustedForDivider, imeWin);
            } else {
                this.notifyAdjustedForImeChanged(adjustedForIme || adjustedForDivider, 0L);
            }
            this.mAdjustedForIme = adjustedForIme;
            this.mImeHeight = imeHeight;
            this.mAdjustedForDivider = adjustedForDivider;
        }
    }

    int getImeHeightAdjustedFor() {
        return this.mImeHeight;
    }

    void positionDockedStackedDivider(Rect frame) {
        TaskStack stack = this.mDisplayContent.getDockedStackLocked();
        if (stack == null) {
            frame.set(this.mLastRect);
            return;
        }
        stack.getDimBounds(this.mTmpRect);
        int side = stack.getDockSide();
        switch (side) {
            case 1: {
                frame.set(this.mTmpRect.right - this.mDividerInsets, frame.top, this.mTmpRect.right + frame.width() - this.mDividerInsets, frame.bottom);
                break;
            }
            case 2: {
                frame.set(frame.left, this.mTmpRect.bottom - this.mDividerInsets, this.mTmpRect.right, this.mTmpRect.bottom + frame.height() - this.mDividerInsets);
                break;
            }
            case 3: {
                frame.set(this.mTmpRect.left - frame.width() + this.mDividerInsets, frame.top, this.mTmpRect.left + this.mDividerInsets, frame.bottom);
                break;
            }
            case 4: {
                frame.set(frame.left, this.mTmpRect.top - frame.height() + this.mDividerInsets, frame.right, this.mTmpRect.top + this.mDividerInsets);
            }
        }
        this.mLastRect.set(frame);
    }

    void notifyDockedDividerVisibilityChanged(boolean visible) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDividerVisibilityChanged(visible);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering divider visibility changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    void notifyDockedStackExistsChanged(boolean exists) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDockedStackExistsChanged(exists);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering docked stack exists changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
        if (exists) {
            InputMethodManagerInternal inputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
            if (inputMethodManagerInternal != null) {
                inputMethodManagerInternal.hideCurrentInputMethod();
                this.mImeHideRequested = true;
            }
        } else if (this.setMinimizedDockedStack(false)) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    void resetImeHideRequested() {
        this.mImeHideRequested = false;
    }

    boolean isImeHideRequested() {
        return this.mImeHideRequested;
    }

    void notifyDockedStackMinimizedChanged(boolean minimizedDock, long animDuration) {
        this.mService.mH.removeMessages(53);
        this.mService.mH.obtainMessage(53, minimizedDock ? 1 : 0, 0).sendToTarget();
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDockedStackMinimizedChanged(minimizedDock, animDuration);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering minimized dock changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    void notifyDockSideChanged(int newDockSide) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDockSideChanged(newDockSide);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering dock side changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    void notifyAdjustedForImeChanged(boolean adjustedForIme, long animDuration) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onAdjustedForImeChanged(adjustedForIme, animDuration);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering adjusted for ime changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    void registerDockedStackListener(IDockedStackListener listener) {
        this.mDockedStackListeners.register(listener);
        this.notifyDockedDividerVisibilityChanged(this.wasVisible());
        this.notifyDockedStackExistsChanged(this.mDisplayContent.mService.mStackIdToStack.get(3) != null);
        this.notifyDockedStackMinimizedChanged(this.mMinimizedDock, 0L);
        this.notifyAdjustedForImeChanged(this.mAdjustedForIme, 0L);
    }

    void setResizeDimLayer(boolean visible, int targetStackId, float alpha) {
        boolean visibleAndValid;
        SurfaceControl.openTransaction();
        TaskStack stack = this.mDisplayContent.mService.mStackIdToStack.get(targetStackId);
        TaskStack dockedStack = this.mDisplayContent.getDockedStackLocked();
        boolean bl = visibleAndValid = visible && stack != null && dockedStack != null;
        if (visibleAndValid) {
            stack.getDimBounds(this.mTmpRect);
            if (this.mTmpRect.height() > 0 && this.mTmpRect.width() > 0) {
                this.mDimLayer.setBounds(this.mTmpRect);
                this.mDimLayer.show(this.mService.mLayersController.getResizeDimLayer(), alpha, 0L);
            } else {
                visibleAndValid = false;
            }
        }
        if (!visibleAndValid) {
            this.mDimLayer.hide();
        }
        SurfaceControl.closeTransaction();
    }

    void notifyAppVisibilityChanged() {
        this.checkMinimizeChanged(false);
    }

    void notifyAppTransitionStarting() {
        this.checkMinimizeChanged(true);
    }

    boolean isMinimizedDock() {
        return this.mMinimizedDock;
    }

    private void checkMinimizeChanged(boolean animate) {
        if (this.mDisplayContent.getDockedStackVisibleForUserLocked() == null) {
            return;
        }
        TaskStack homeStack = this.mDisplayContent.getHomeStack();
        if (homeStack == null) {
            return;
        }
        Task homeTask = homeStack.findHomeTask();
        if (homeTask == null || !this.isWithinDisplay(homeTask)) {
            return;
        }
        TaskStack fullscreenStack = this.mService.mStackIdToStack.get(1);
        ArrayList<Task> homeStackTasks = homeStack.getTasks();
        Task topHomeStackTask = homeStackTasks.get(homeStackTasks.size() - 1);
        boolean homeVisible = homeTask.getTopVisibleAppToken() != null;
        boolean homeBehind = fullscreenStack != null && fullscreenStack.isVisibleLocked() || homeStackTasks.size() > 1 && topHomeStackTask != homeTask;
        this.setMinimizedDockedStack(homeVisible && !homeBehind, animate);
    }

    private boolean isWithinDisplay(Task task) {
        task.mStack.getBounds(this.mTmpRect);
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect2);
        return this.mTmpRect.intersect(this.mTmpRect2);
    }

    private void setMinimizedDockedStack(boolean minimizedDock, boolean animate) {
        boolean wasMinimized = this.mMinimizedDock;
        this.mMinimizedDock = minimizedDock;
        if (minimizedDock == wasMinimized) {
            return;
        }
        boolean imeChanged = this.clearImeAdjustAnimation();
        boolean minimizedChange = false;
        if (minimizedDock) {
            if (animate) {
                this.startAdjustAnimation(0.0f, 1.0f);
            } else {
                minimizedChange |= this.setMinimizedDockedStack(true);
            }
        } else if (animate) {
            this.startAdjustAnimation(1.0f, 0.0f);
        } else {
            minimizedChange |= this.setMinimizedDockedStack(false);
        }
        if (imeChanged || minimizedChange) {
            if (imeChanged && !minimizedChange) {
                Slog.d(TAG, "setMinimizedDockedStack: IME adjust changed due to minimizing, minimizedDock=" + minimizedDock + " minimizedChange=" + minimizedChange);
            }
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    private boolean clearImeAdjustAnimation() {
        boolean changed = false;
        ArrayList<TaskStack> stacks = this.mDisplayContent.getStacks();
        for (int i = stacks.size() - 1; i >= 0; --i) {
            TaskStack stack = stacks.get(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            stack.resetAdjustedForIme(true);
            changed = true;
        }
        this.mAnimatingForIme = false;
        return changed;
    }

    private void startAdjustAnimation(float from, float to) {
        this.mAnimatingForMinimizedDockedStack = true;
        this.mAnimationStarted = false;
        this.mAnimationStart = from;
        this.mAnimationTarget = to;
    }

    private void startImeAdjustAnimation(boolean adjustedForIme, boolean adjustedForDivider, WindowState imeWin) {
        if (!this.mAnimatingForIme) {
            this.mAnimationStart = this.mAdjustedForIme ? 1.0f : 0.0f;
            this.mDividerAnimationStart = this.mAdjustedForDivider ? 1.0f : 0.0f;
            this.mLastAnimationProgress = this.mAnimationStart;
            this.mLastDividerProgress = this.mDividerAnimationStart;
        } else {
            this.mAnimationStart = this.mLastAnimationProgress;
            this.mDividerAnimationStart = this.mLastDividerProgress;
        }
        this.mAnimatingForIme = true;
        this.mAnimationStarted = false;
        this.mAnimationTarget = adjustedForIme ? 1.0f : 0.0f;
        this.mDividerAnimationTarget = adjustedForDivider ? 1.0f : 0.0f;
        ArrayList<TaskStack> stacks = this.mDisplayContent.getStacks();
        for (int i = stacks.size() - 1; i >= 0; --i) {
            TaskStack stack = stacks.get(i);
            if (!stack.isVisibleLocked() || !stack.isAdjustedForIme()) continue;
            stack.beginImeAdjustAnimation();
        }
        if (!this.mService.mWaitingForDrawn.isEmpty()) {
            this.mService.mH.removeMessages(24);
            this.mService.mH.sendEmptyMessageDelayed(24, 200L);
            this.mAnimationStartDelayed = true;
            if (imeWin != null) {
                if (this.mDelayedImeWin != null) {
                    this.mDelayedImeWin.mWinAnimator.endDelayingAnimationStart();
                }
                this.mDelayedImeWin = imeWin;
                imeWin.mWinAnimator.startDelayingAnimationStart();
            }
            this.mService.mWaitingForDrawnCallback = () -> {
                this.mAnimationStartDelayed = false;
                if (this.mDelayedImeWin != null) {
                    this.mDelayedImeWin.mWinAnimator.endDelayingAnimationStart();
                }
                long duration = 0L;
                if (this.mAdjustedForIme == adjustedForIme && this.mAdjustedForDivider == adjustedForDivider) {
                    duration = 280L;
                } else {
                    Slog.w(TAG, "IME adjust changed while waiting for drawn: adjustedForIme=" + adjustedForIme + " adjustedForDivider=" + adjustedForDivider + " mAdjustedForIme=" + this.mAdjustedForIme + " mAdjustedForDivider=" + this.mAdjustedForDivider);
                }
                this.notifyAdjustedForImeChanged(this.mAdjustedForIme || this.mAdjustedForDivider, duration);
            };
        } else {
            this.notifyAdjustedForImeChanged(adjustedForIme || adjustedForDivider, 280L);
        }
    }

    private boolean setMinimizedDockedStack(boolean minimized) {
        TaskStack stack = this.mDisplayContent.getDockedStackVisibleForUserLocked();
        this.notifyDockedStackMinimizedChanged(minimized, 0L);
        return stack != null && stack.setAdjustedForMinimizedDock(minimized ? 1.0f : 0.0f);
    }

    private boolean isAnimationMaximizing() {
        return this.mAnimationTarget == 0.0f;
    }

    public boolean animate(long now) {
        if (this.mWindow == null) {
            return false;
        }
        if (this.mAnimatingForMinimizedDockedStack) {
            return this.animateForMinimizedDockedStack(now);
        }
        if (this.mAnimatingForIme) {
            return this.animateForIme(now);
        }
        if (this.mDimLayer != null && this.mDimLayer.isDimming()) {
            this.mDimLayer.setLayer(this.mService.mLayersController.getResizeDimLayer());
        }
        return false;
    }

    private boolean animateForIme(long now) {
        if (!this.mAnimationStarted || this.mAnimationStartDelayed) {
            this.mAnimationStarted = true;
            this.mAnimationStartTime = now;
            this.mAnimationDuration = (long)(280.0f * this.mService.getWindowAnimationScaleLocked());
        }
        float t = Math.min(1.0f, (float)(now - this.mAnimationStartTime) / (float)this.mAnimationDuration);
        t = (this.mAnimationTarget == 1.0f ? IME_ADJUST_ENTRY_INTERPOLATOR : AppTransition.TOUCH_RESPONSE_INTERPOLATOR).getInterpolation(t);
        ArrayList<TaskStack> stacks = this.mDisplayContent.getStacks();
        boolean updated = false;
        for (int i = stacks.size() - 1; i >= 0; --i) {
            TaskStack stack = stacks.get(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            if (t >= 1.0f && this.mAnimationTarget == 0.0f && this.mDividerAnimationTarget == 0.0f) {
                stack.resetAdjustedForIme(true);
                updated = true;
            } else {
                this.mLastAnimationProgress = this.getInterpolatedAnimationValue(t);
                this.mLastDividerProgress = this.getInterpolatedDividerValue(t);
                updated |= stack.updateAdjustForIme(this.mLastAnimationProgress, this.mLastDividerProgress, false);
            }
            if (!(t >= 1.0f)) continue;
            stack.endImeAdjustAnimation();
        }
        if (updated) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
        if (t >= 1.0f) {
            this.mLastAnimationProgress = this.mAnimationTarget;
            this.mLastDividerProgress = this.mDividerAnimationTarget;
            this.mAnimatingForIme = false;
            return false;
        }
        return true;
    }

    private boolean animateForMinimizedDockedStack(long now) {
        TaskStack stack = this.mService.mStackIdToStack.get(3);
        if (!this.mAnimationStarted) {
            this.mAnimationStarted = true;
            this.mAnimationStartTime = now;
            long transitionDuration = this.isAnimationMaximizing() ? this.mService.mAppTransition.getLastClipRevealTransitionDuration() : 336L;
            this.mAnimationDuration = (long)((float)transitionDuration * this.mService.getTransitionAnimationScaleLocked());
            this.mMaximizeMeetFraction = this.getClipRevealMeetFraction(stack);
            this.notifyDockedStackMinimizedChanged(this.mMinimizedDock, (long)((float)this.mAnimationDuration * this.mMaximizeMeetFraction));
        }
        float t = Math.min(1.0f, (float)(now - this.mAnimationStartTime) / (float)this.mAnimationDuration);
        t = (this.isAnimationMaximizing() ? AppTransition.TOUCH_RESPONSE_INTERPOLATOR : this.mMinimizedDockInterpolator).getInterpolation(t);
        if (stack != null && stack.setAdjustedForMinimizedDock(this.getMinimizeAmount(stack, t))) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
        if (t >= 1.0f) {
            this.mAnimatingForMinimizedDockedStack = false;
            return false;
        }
        return true;
    }

    private float getInterpolatedAnimationValue(float t) {
        return t * this.mAnimationTarget + (1.0f - t) * this.mAnimationStart;
    }

    private float getInterpolatedDividerValue(float t) {
        return t * this.mDividerAnimationTarget + (1.0f - t) * this.mDividerAnimationStart;
    }

    private float getMinimizeAmount(TaskStack stack, float t) {
        float naturalAmount = this.getInterpolatedAnimationValue(t);
        if (this.isAnimationMaximizing()) {
            return this.adjustMaximizeAmount(stack, t, naturalAmount);
        }
        return naturalAmount;
    }

    private float adjustMaximizeAmount(TaskStack stack, float t, float naturalAmount) {
        if (this.mMaximizeMeetFraction == 1.0f) {
            return naturalAmount;
        }
        int minimizeDistance = stack.getMinimizeDistance();
        float startPrime = (float)this.mService.mAppTransition.getLastClipRevealMaxTranslation() / (float)minimizeDistance;
        float amountPrime = t * this.mAnimationTarget + (1.0f - t) * startPrime;
        float t2 = Math.min(t / this.mMaximizeMeetFraction, 1.0f);
        return amountPrime * t2 + naturalAmount * (1.0f - t2);
    }

    private float getClipRevealMeetFraction(TaskStack stack) {
        if (!this.isAnimationMaximizing() || stack == null || !this.mService.mAppTransition.hadClipRevealAnimation()) {
            return 1.0f;
        }
        int minimizeDistance = stack.getMinimizeDistance();
        float fraction2 = (float)Math.abs(this.mService.mAppTransition.getLastClipRevealMaxTranslation()) / (float)minimizeDistance;
        float t = Math.max(0.0f, Math.min(1.0f, (fraction2 - 0.4f) / 0.4f));
        return 0.6f + (1.0f - t) * 0.39999998f;
    }

    @Override
    public boolean dimFullscreen() {
        return false;
    }

    @Override
    public DisplayInfo getDisplayInfo() {
        return this.mDisplayContent.getDisplayInfo();
    }

    @Override
    public void getDimBounds(Rect outBounds) {
    }

    @Override
    public String toShortString() {
        return TAG;
    }

    WindowState getWindow() {
        return this.mWindow;
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "DockedStackDividerController");
        pw.println(prefix + "  mLastVisibility=" + this.mLastVisibility);
        pw.println(prefix + "  mMinimizedDock=" + this.mMinimizedDock);
        pw.println(prefix + "  mAdjustedForIme=" + this.mAdjustedForIme);
        pw.println(prefix + "  mAdjustedForDivider=" + this.mAdjustedForDivider);
        if (this.mDimLayer.isDimming()) {
            pw.println(prefix + "  Dim layer is dimming: ");
            this.mDimLayer.printTo(prefix + "    ", pw);
        }
    }
}

