/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.os.IBinder;
import android.os.Trace;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.Choreographer;
import android.view.SurfaceControl;
import android.view.WindowManagerPolicy;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfacePlacer;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class WindowAnimator {
    private static final String TAG = "WindowManager";
    private static final long KEYGUARD_ANIM_TIMEOUT_MS = 1000L;
    final WindowManagerService mService;
    final Context mContext;
    final WindowManagerPolicy mPolicy;
    private final WindowSurfacePlacer mWindowPlacerLocked;
    private boolean mAnimating;
    boolean mAppWindowAnimating;
    final Choreographer.FrameCallback mAnimationFrameCallback;
    long mCurrentTime;
    private int mAnimTransactionSequence;
    WindowState mWindowDetachedWallpaper = null;
    int mBulkUpdateParams = 0;
    Object mLastWindowFreezeSource;
    SparseArray<DisplayContentsAnimator> mDisplayContentsAnimators = new SparseArray(2);
    boolean mInitialized = false;
    boolean mKeyguardGoingAway;
    int mKeyguardGoingAwayFlags;
    Animation mPostKeyguardExitAnimation;
    static final int KEYGUARD_NOT_SHOWN = 0;
    static final int KEYGUARD_SHOWN = 1;
    static final int KEYGUARD_ANIMATING_OUT = 2;
    int mForceHiding = 0;
    private boolean mRemoveReplacedWindows = false;
    private final AppTokenList mTmpExitingAppTokens = new AppTokenList();

    private String forceHidingToString() {
        switch (this.mForceHiding) {
            case 0: {
                return "KEYGUARD_NOT_SHOWN";
            }
            case 1: {
                return "KEYGUARD_SHOWN";
            }
            case 2: {
                return "KEYGUARD_ANIMATING_OUT";
            }
        }
        return "KEYGUARD STATE UNKNOWN " + this.mForceHiding;
    }

    WindowAnimator(WindowManagerService service) {
        this.mService = service;
        this.mContext = service.mContext;
        this.mPolicy = service.mPolicy;
        this.mWindowPlacerLocked = service.mWindowPlacerLocked;
        this.mAnimationFrameCallback = new Choreographer.FrameCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doFrame(long frameTimeNs) {
                HashMap<IBinder, WindowState> hashMap = WindowAnimator.this.mService.mWindowMap;
                synchronized (hashMap) {
                    WindowAnimator.this.mService.mAnimationScheduled = false;
                    WindowAnimator.this.animateLocked(frameTimeNs);
                }
            }
        };
    }

    void addDisplayLocked(int displayId) {
        this.getDisplayContentsAnimatorLocked(displayId);
        if (displayId == 0) {
            this.mInitialized = true;
        }
    }

    void removeDisplayLocked(int displayId) {
        DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.get(displayId);
        if (displayAnimator != null && displayAnimator.mScreenRotationAnimation != null) {
            displayAnimator.mScreenRotationAnimation.kill();
            displayAnimator.mScreenRotationAnimation = null;
        }
        this.mDisplayContentsAnimators.delete(displayId);
    }

    private void updateAppWindowsLocked(int displayId) {
        ArrayList<TaskStack> stacks = this.mService.getDisplayContentLocked(displayId).getStacks();
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = stacks.get(stackNdx);
            ArrayList<Task> tasks = stack.getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    AppWindowAnimator appAnimator = ((AppWindowToken)tokens.get((int)tokenNdx)).mAppAnimator;
                    appAnimator.wasAnimating = appAnimator.animating;
                    if (appAnimator.stepAnimationLocked(this.mCurrentTime, displayId)) {
                        appAnimator.animating = true;
                        this.setAnimating(true);
                        this.mAppWindowAnimating = true;
                        continue;
                    }
                    if (!appAnimator.wasAnimating) continue;
                    this.setAppLayoutChanges(appAnimator, 4, "appToken " + appAnimator.mAppToken + " done", displayId);
                }
            }
            this.mTmpExitingAppTokens.clear();
            this.mTmpExitingAppTokens.addAll(stack.mExitingAppTokens);
            int exitingCount = this.mTmpExitingAppTokens.size();
            for (int i = 0; i < exitingCount; ++i) {
                AppWindowAnimator appAnimator = ((AppWindowToken)this.mTmpExitingAppTokens.get((int)i)).mAppAnimator;
                if (!stack.mExitingAppTokens.contains(appAnimator)) continue;
                appAnimator.wasAnimating = appAnimator.animating;
                if (appAnimator.stepAnimationLocked(this.mCurrentTime, displayId)) {
                    this.setAnimating(true);
                    this.mAppWindowAnimating = true;
                    continue;
                }
                if (!appAnimator.wasAnimating) continue;
                this.setAppLayoutChanges(appAnimator, 4, "exiting appToken " + appAnimator.mAppToken + " done", displayId);
            }
        }
    }

    private boolean shouldForceHide(WindowState win) {
        WindowState imeTarget = this.mService.mInputMethodTarget;
        boolean showImeOverKeyguard = imeTarget != null && imeTarget.isVisibleNow() && ((imeTarget.getAttrs().flags & 0x80000) != 0 || !this.mPolicy.canBeForceHidden(imeTarget, imeTarget.mAttrs));
        WindowState winShowWhenLocked = (WindowState)this.mPolicy.getWinShowWhenLockedLw();
        AppWindowToken appShowWhenLocked = winShowWhenLocked == null ? null : winShowWhenLocked.mAppToken;
        boolean allowWhenLocked = false;
        allowWhenLocked |= (win.mIsImWindow || imeTarget == win) && showImeOverKeyguard;
        allowWhenLocked |= (win.mAttrs.flags & 0x80000) != 0 && win.mTurnOnScreen;
        if (appShowWhenLocked != null) {
            allowWhenLocked |= appShowWhenLocked == win.mAppToken || (win.mAttrs.flags & 0x80000) != 0 || (win.mAttrs.privateFlags & 0x100) != 0;
        }
        boolean keyguardOn = this.mPolicy.isKeyguardShowingOrOccluded() && this.mForceHiding != 2;
        boolean hideDockDivider = win.mAttrs.type == 2034 && win.getDisplayContent().getDockedStackLocked() == null;
        return keyguardOn && !(allowWhenLocked |= (win.mAttrs.flags & 0x400000) != 0 && this.mPolicy.canShowDismissingWindowWhileLockedLw()) && win.getDisplayId() == 0 || hideDockDivider;
    }

    private void updateWindowsLocked(int displayId) {
        WindowStateAnimator winAnimator;
        boolean keyguardGoingAwayWithWallpaper;
        ++this.mAnimTransactionSequence;
        WindowList windows = this.mService.getWindowListLocked(displayId);
        boolean keyguardGoingAwayToShade = (this.mKeyguardGoingAwayFlags & 1) != 0;
        boolean keyguardGoingAwayNoAnimation = (this.mKeyguardGoingAwayFlags & 2) != 0;
        boolean bl = keyguardGoingAwayWithWallpaper = (this.mKeyguardGoingAwayFlags & 4) != 0;
        if (this.mKeyguardGoingAway) {
            for (int i = windows.size() - 1; i >= 0; --i) {
                WindowState win = (WindowState)windows.get(i);
                if (!this.mPolicy.isKeyguardHostWindow(win.mAttrs)) continue;
                WindowStateAnimator winAnimator2 = win.mWinAnimator;
                if ((win.mAttrs.privateFlags & 0x400) != 0) {
                    if (winAnimator2.mAnimating) break;
                    winAnimator2.mAnimation = new AlphaAnimation(1.0f, 1.0f);
                    winAnimator2.mAnimation.setDuration(1000L);
                    winAnimator2.mAnimationIsEntrance = false;
                    winAnimator2.mAnimationStartTime = -1L;
                    winAnimator2.mKeyguardGoingAwayAnimation = true;
                    winAnimator2.mKeyguardGoingAwayWithWallpaper = keyguardGoingAwayWithWallpaper;
                    break;
                }
                this.mKeyguardGoingAway = false;
                winAnimator2.clearAnimation();
                break;
            }
        }
        this.mForceHiding = 0;
        boolean wallpaperInUnForceHiding = false;
        boolean startingInUnForceHiding = false;
        ArrayList<WindowStateAnimator> unForceHiding = null;
        WindowState wallpaper = null;
        WallpaperController wallpaperController = this.mService.mWallpaperControllerLocked;
        for (int i = windows.size() - 1; i >= 0; --i) {
            AppWindowAnimator appAnimator;
            WindowState win = (WindowState)windows.get(i);
            winAnimator = win.mWinAnimator;
            int flags = win.mAttrs.flags;
            boolean canBeForceHidden = this.mPolicy.canBeForceHidden(win, win.mAttrs);
            boolean shouldBeForceHidden = this.shouldForceHide(win);
            if (winAnimator.hasSurface()) {
                boolean nowAnimating;
                boolean wasAnimating = winAnimator.mWasAnimating;
                winAnimator.mWasAnimating = nowAnimating = winAnimator.stepAnimationLocked(this.mCurrentTime);
                this.orAnimating(nowAnimating);
                if (wasAnimating && !winAnimator.mAnimating && wallpaperController.isWallpaperTarget(win)) {
                    this.mBulkUpdateParams |= 2;
                    this.setPendingLayoutChanges(0, 4);
                }
                if (this.mPolicy.isForceHiding(win.mAttrs)) {
                    if (!wasAnimating && nowAnimating) {
                        this.mBulkUpdateParams |= 4;
                        this.setPendingLayoutChanges(displayId, 4);
                        this.mService.mFocusMayChange = true;
                    } else if (this.mKeyguardGoingAway && !nowAnimating) {
                        Slog.e(TAG, "Timeout waiting for animation to startup");
                        this.mPolicy.startKeyguardExitAnimation(0L, 0L);
                        this.mKeyguardGoingAway = false;
                    }
                    if (win.isReadyForDisplay()) {
                        this.mForceHiding = nowAnimating && win.mWinAnimator.mKeyguardGoingAwayAnimation ? 2 : (win.isDrawnLw() ? 1 : 0);
                    }
                } else if (canBeForceHidden) {
                    if (shouldBeForceHidden) {
                        if (!win.hideLw(false, false)) {
                            continue;
                        }
                    } else {
                        WindowState currentFocus;
                        boolean applyExistingExitAnimation;
                        boolean bl2 = applyExistingExitAnimation = this.mPostKeyguardExitAnimation != null && !this.mPostKeyguardExitAnimation.hasEnded() && !winAnimator.mKeyguardGoingAwayAnimation && win.hasDrawnLw() && win.mAttachedWindow == null && !win.mIsImWindow && displayId == 0;
                        if (!win.showLw(false, false) && !applyExistingExitAnimation) continue;
                        boolean visibleNow = win.isVisibleNow();
                        if (!visibleNow) {
                            win.hideLw(false, false);
                            continue;
                        }
                        if ((this.mBulkUpdateParams & 4) != 0 && win.mAttachedWindow == null) {
                            if (unForceHiding == null) {
                                unForceHiding = new ArrayList<WindowStateAnimator>();
                            }
                            unForceHiding.add(winAnimator);
                            if ((flags & 0x100000) != 0) {
                                wallpaperInUnForceHiding = true;
                            }
                            if (win.mAttrs.type == 3) {
                                startingInUnForceHiding = true;
                            }
                        } else if (applyExistingExitAnimation) {
                            Animation a = this.mPolicy.createForceHideEnterAnimation(false, keyguardGoingAwayToShade);
                            winAnimator.setAnimation(a, this.mPostKeyguardExitAnimation.getStartTime(), 1);
                            winAnimator.mKeyguardGoingAwayAnimation = true;
                            winAnimator.mKeyguardGoingAwayWithWallpaper = keyguardGoingAwayWithWallpaper;
                        }
                        if ((currentFocus = this.mService.mCurrentFocus) == null || currentFocus.mLayer < win.mLayer) {
                            this.mService.mFocusMayChange = true;
                        }
                    }
                    if ((flags & 0x100000) != 0) {
                        this.mBulkUpdateParams |= 2;
                        this.setPendingLayoutChanges(0, 4);
                    }
                }
            } else if (canBeForceHidden) {
                if (shouldBeForceHidden) {
                    win.hideLw(false, false);
                } else {
                    win.showLw(false, false);
                }
            }
            AppWindowToken atoken = win.mAppToken;
            if (winAnimator.mDrawState == 3 && (atoken == null || atoken.allDrawn) && winAnimator.performShowLocked()) {
                this.setPendingLayoutChanges(displayId, 8);
            }
            if ((appAnimator = winAnimator.mAppAnimator) != null && appAnimator.thumbnail != null) {
                if (appAnimator.thumbnailTransactionSeq != this.mAnimTransactionSequence) {
                    appAnimator.thumbnailTransactionSeq = this.mAnimTransactionSequence;
                    appAnimator.thumbnailLayer = 0;
                }
                if (appAnimator.thumbnailLayer < winAnimator.mAnimLayer) {
                    appAnimator.thumbnailLayer = winAnimator.mAnimLayer;
                }
            }
            if (!win.mIsWallpaper) continue;
            wallpaper = win;
        }
        if (unForceHiding != null) {
            Animation a;
            if (!keyguardGoingAwayNoAnimation) {
                boolean first = true;
                for (int i = unForceHiding.size() - 1; i >= 0; --i) {
                    winAnimator = (WindowStateAnimator)unForceHiding.get(i);
                    Animation a2 = this.mPolicy.createForceHideEnterAnimation(wallpaperInUnForceHiding && !startingInUnForceHiding, keyguardGoingAwayToShade);
                    if (a2 == null) continue;
                    winAnimator.setAnimation(a2, 1);
                    winAnimator.mKeyguardGoingAwayAnimation = true;
                    winAnimator.mKeyguardGoingAwayWithWallpaper = keyguardGoingAwayWithWallpaper;
                    if (!first) continue;
                    this.mPostKeyguardExitAnimation = a2;
                    this.mPostKeyguardExitAnimation.setStartTime(this.mCurrentTime);
                    first = false;
                }
            } else if (this.mKeyguardGoingAway) {
                this.mPolicy.startKeyguardExitAnimation(this.mCurrentTime, 0L);
                this.mKeyguardGoingAway = false;
            }
            if (!wallpaperInUnForceHiding && wallpaper != null && !keyguardGoingAwayNoAnimation && (a = this.mPolicy.createForceHideWallpaperExitAnimation(keyguardGoingAwayToShade)) != null) {
                wallpaper.mWinAnimator.setAnimation(a);
            }
        }
        if (this.mPostKeyguardExitAnimation != null) {
            if (this.mKeyguardGoingAway) {
                this.mPolicy.startKeyguardExitAnimation(this.mCurrentTime + this.mPostKeyguardExitAnimation.getStartOffset(), this.mPostKeyguardExitAnimation.getDuration());
                this.mKeyguardGoingAway = false;
            } else if (this.mPostKeyguardExitAnimation.hasEnded() || this.mCurrentTime - this.mPostKeyguardExitAnimation.getStartTime() > this.mPostKeyguardExitAnimation.getDuration()) {
                this.mPostKeyguardExitAnimation = null;
            }
        }
    }

    private void updateWallpaperLocked(int displayId) {
        this.mService.getDisplayContentLocked(displayId).resetAnimationBackgroundAnimator();
        WindowList windows = this.mService.getWindowListLocked(displayId);
        WindowState detachedWallpaper = null;
        for (int i = windows.size() - 1; i >= 0; --i) {
            TaskStack stack;
            int color2;
            AppWindowAnimator appAnimator;
            WindowState win = (WindowState)windows.get(i);
            WindowStateAnimator winAnimator = win.mWinAnimator;
            if (winAnimator.mSurfaceController == null || !winAnimator.hasSurface()) continue;
            int flags = win.mAttrs.flags;
            if (winAnimator.mAnimating) {
                if (winAnimator.mAnimation != null) {
                    TaskStack stack2;
                    int color3;
                    if ((flags & 0x100000) != 0 && winAnimator.mAnimation.getDetachWallpaper()) {
                        detachedWallpaper = win;
                    }
                    if ((color3 = winAnimator.mAnimation.getBackgroundColor()) != 0 && (stack2 = win.getStack()) != null) {
                        stack2.setAnimationBackground(winAnimator, color3);
                    }
                }
                this.setAnimating(true);
            }
            if ((appAnimator = winAnimator.mAppAnimator) == null || appAnimator.animation == null || !appAnimator.animating) continue;
            if ((flags & 0x100000) != 0 && appAnimator.animation.getDetachWallpaper()) {
                detachedWallpaper = win;
            }
            if ((color2 = appAnimator.animation.getBackgroundColor()) == 0 || (stack = win.getStack()) == null) continue;
            stack.setAnimationBackground(winAnimator, color2);
        }
        if (this.mWindowDetachedWallpaper != detachedWallpaper) {
            this.mWindowDetachedWallpaper = detachedWallpaper;
            this.mBulkUpdateParams |= 2;
        }
    }

    private void testTokenMayBeDrawnLocked(int displayId) {
        ArrayList<Task> tasks = this.mService.getDisplayContentLocked(displayId).getTasks();
        int numTasks = tasks.size();
        for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            int numTokens = tokens.size();
            for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                AppWindowAnimator appAnimator = wtoken.mAppAnimator;
                boolean allDrawn = wtoken.allDrawn;
                if (allDrawn == appAnimator.allDrawn) continue;
                appAnimator.allDrawn = allDrawn;
                if (!allDrawn) continue;
                if (appAnimator.freezingScreen) {
                    appAnimator.showAllWindowsLocked();
                    this.mService.unsetAppFreezingScreenLocked(wtoken, false, true);
                    this.setAppLayoutChanges(appAnimator, 4, "testTokenMayBeDrawnLocked: freezingScreen", displayId);
                    continue;
                }
                this.setAppLayoutChanges(appAnimator, 8, "testTokenMayBeDrawnLocked", displayId);
                if (this.mService.mOpeningApps.contains(wtoken)) continue;
                this.orAnimating(appAnimator.showAllWindowsLocked());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void animateLocked(long frameTimeNs) {
        if (!this.mInitialized) {
            return;
        }
        this.mCurrentTime = frameTimeNs / 1000000L;
        this.mBulkUpdateParams = 8;
        boolean wasAnimating = this.mAnimating;
        this.setAnimating(false);
        this.mAppWindowAnimating = false;
        SurfaceControl.openTransaction();
        SurfaceControl.setAnimationTransaction();
        try {
            int displayId;
            int i;
            int numDisplays = this.mDisplayContentsAnimators.size();
            for (i = 0; i < numDisplays; ++i) {
                displayId = this.mDisplayContentsAnimators.keyAt(i);
                this.updateAppWindowsLocked(displayId);
                DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.valueAt(i);
                ScreenRotationAnimation screenRotationAnimation = displayAnimator.mScreenRotationAnimation;
                if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
                    if (screenRotationAnimation.stepAnimationLocked(this.mCurrentTime)) {
                        this.setAnimating(true);
                    } else {
                        this.mBulkUpdateParams |= 1;
                        screenRotationAnimation.kill();
                        displayAnimator.mScreenRotationAnimation = null;
                        if (this.mService.mAccessibilityController != null && displayId == 0) {
                            this.mService.mAccessibilityController.onRotationChangedLocked(this.mService.getDefaultDisplayContentLocked(), this.mService.mRotation);
                        }
                    }
                }
                this.updateWindowsLocked(displayId);
                this.updateWallpaperLocked(displayId);
                WindowList windows = this.mService.getWindowListLocked(displayId);
                int N = windows.size();
                for (int j = 0; j < N; ++j) {
                    ((WindowState)windows.get((int)j)).mWinAnimator.prepareSurfaceLocked(true);
                }
            }
            for (i = 0; i < numDisplays; ++i) {
                displayId = this.mDisplayContentsAnimators.keyAt(i);
                this.testTokenMayBeDrawnLocked(displayId);
                ScreenRotationAnimation screenRotationAnimation = this.mDisplayContentsAnimators.valueAt((int)i).mScreenRotationAnimation;
                if (screenRotationAnimation != null) {
                    screenRotationAnimation.updateSurfacesInTransaction();
                }
                this.orAnimating(this.mService.getDisplayContentLocked(displayId).animateDimLayers());
                this.orAnimating(this.mService.getDisplayContentLocked(displayId).getDockedDividerController().animate(this.mCurrentTime));
                if (this.mService.mAccessibilityController == null || displayId != 0) continue;
                this.mService.mAccessibilityController.drawMagnifiedRegionBorderIfNeededLocked();
            }
            if (this.mService.mDragState != null) {
                this.mAnimating |= this.mService.mDragState.stepAnimationLocked(this.mCurrentTime);
            }
            if (this.mAnimating) {
                this.mService.scheduleAnimationLocked();
            }
            if (this.mService.mWatermark != null) {
                this.mService.mWatermark.drawIfNeeded();
            }
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        boolean hasPendingLayoutChanges = false;
        int numDisplays = this.mService.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mService.mDisplayContents.valueAt(displayNdx);
            int pendingChanges = this.getPendingLayoutChanges(displayContent.getDisplayId());
            if ((pendingChanges & 4) != 0) {
                this.mBulkUpdateParams |= 0x20;
            }
            if (pendingChanges == 0) continue;
            hasPendingLayoutChanges = true;
        }
        boolean doRequest = false;
        if (this.mBulkUpdateParams != 0) {
            doRequest = this.mWindowPlacerLocked.copyAnimToLayoutParamsLocked();
        }
        if (hasPendingLayoutChanges || doRequest) {
            this.mWindowPlacerLocked.requestTraversal();
        }
        if (this.mAnimating && !wasAnimating && Trace.isTagEnabled(32L)) {
            Trace.asyncTraceBegin(32L, "animating", 0);
        }
        if (!this.mAnimating && wasAnimating) {
            this.mWindowPlacerLocked.requestTraversal();
            if (Trace.isTagEnabled(32L)) {
                Trace.asyncTraceEnd(32L, "animating", 0);
            }
        }
        if (this.mRemoveReplacedWindows) {
            this.removeReplacedWindowsLocked();
        }
        this.mService.stopUsingSavedSurfaceLocked();
        this.mService.destroyPreservedSurfaceLocked();
        this.mService.mWindowPlacerLocked.destroyPendingSurfaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReplacedWindowsLocked() {
        SurfaceControl.openTransaction();
        try {
            for (int i = this.mService.mDisplayContents.size() - 1; i >= 0; --i) {
                DisplayContent display = this.mService.mDisplayContents.valueAt(i);
                WindowList windows = this.mService.getWindowListLocked(display.getDisplayId());
                for (int j = windows.size() - 1; j >= 0; --j) {
                    ((WindowState)windows.get(j)).maybeRemoveReplacedWindow();
                }
            }
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        this.mRemoveReplacedWindows = false;
    }

    private static String bulkUpdateParamsToString(int bulkUpdateParams) {
        StringBuilder builder = new StringBuilder(128);
        if ((bulkUpdateParams & 1) != 0) {
            builder.append(" UPDATE_ROTATION");
        }
        if ((bulkUpdateParams & 2) != 0) {
            builder.append(" WALLPAPER_MAY_CHANGE");
        }
        if ((bulkUpdateParams & 4) != 0) {
            builder.append(" FORCE_HIDING_CHANGED");
        }
        if ((bulkUpdateParams & 8) != 0) {
            builder.append(" ORIENTATION_CHANGE_COMPLETE");
        }
        if ((bulkUpdateParams & 0x10) != 0) {
            builder.append(" TURN_ON_SCREEN");
        }
        return builder.toString();
    }

    public void dumpLocked(PrintWriter pw, String prefix, boolean dumpAll) {
        String subPrefix = "  " + prefix;
        String subSubPrefix = "  " + subPrefix;
        for (int i = 0; i < this.mDisplayContentsAnimators.size(); ++i) {
            pw.print(prefix);
            pw.print("DisplayContentsAnimator #");
            pw.print(this.mDisplayContentsAnimators.keyAt(i));
            pw.println(":");
            DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.valueAt(i);
            WindowList windows = this.mService.getWindowListLocked(this.mDisplayContentsAnimators.keyAt(i));
            int N = windows.size();
            for (int j = 0; j < N; ++j) {
                WindowStateAnimator wanim = ((WindowState)windows.get((int)j)).mWinAnimator;
                pw.print(subPrefix);
                pw.print("Window #");
                pw.print(j);
                pw.print(": ");
                pw.println(wanim);
            }
            if (displayAnimator.mScreenRotationAnimation != null) {
                pw.print(subPrefix);
                pw.println("mScreenRotationAnimation:");
                displayAnimator.mScreenRotationAnimation.printTo(subSubPrefix, pw);
            } else if (dumpAll) {
                pw.print(subPrefix);
                pw.println("no ScreenRotationAnimation ");
            }
            pw.println();
        }
        pw.println();
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mAnimTransactionSequence=");
            pw.print(this.mAnimTransactionSequence);
            pw.print(" mForceHiding=");
            pw.println(this.forceHidingToString());
            pw.print(prefix);
            pw.print("mCurrentTime=");
            pw.println(TimeUtils.formatUptime(this.mCurrentTime));
        }
        if (this.mBulkUpdateParams != 0) {
            pw.print(prefix);
            pw.print("mBulkUpdateParams=0x");
            pw.print(Integer.toHexString(this.mBulkUpdateParams));
            pw.println(WindowAnimator.bulkUpdateParamsToString(this.mBulkUpdateParams));
        }
        if (this.mWindowDetachedWallpaper != null) {
            pw.print(prefix);
            pw.print("mWindowDetachedWallpaper=");
            pw.println(this.mWindowDetachedWallpaper);
        }
    }

    int getPendingLayoutChanges(int displayId) {
        if (displayId < 0) {
            return 0;
        }
        DisplayContent displayContent = this.mService.getDisplayContentLocked(displayId);
        return displayContent != null ? displayContent.pendingLayoutChanges : 0;
    }

    void setPendingLayoutChanges(int displayId, int changes) {
        if (displayId < 0) {
            return;
        }
        DisplayContent displayContent = this.mService.getDisplayContentLocked(displayId);
        if (displayContent != null) {
            displayContent.pendingLayoutChanges |= changes;
        }
    }

    void setAppLayoutChanges(AppWindowAnimator appAnimator, int changes, String reason, int displayId) {
        WindowList windows = appAnimator.mAppToken.allAppWindows;
        for (int i = windows.size() - 1; i >= 0; --i) {
            if (displayId != ((WindowState)windows.get(i)).getDisplayId()) continue;
            this.setPendingLayoutChanges(displayId, changes);
            break;
        }
    }

    private DisplayContentsAnimator getDisplayContentsAnimatorLocked(int displayId) {
        DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.get(displayId);
        if (displayAnimator == null) {
            displayAnimator = new DisplayContentsAnimator();
            this.mDisplayContentsAnimators.put(displayId, displayAnimator);
        }
        return displayAnimator;
    }

    void setScreenRotationAnimationLocked(int displayId, ScreenRotationAnimation animation) {
        if (displayId >= 0) {
            this.getDisplayContentsAnimatorLocked((int)displayId).mScreenRotationAnimation = animation;
        }
    }

    ScreenRotationAnimation getScreenRotationAnimationLocked(int displayId) {
        if (displayId < 0) {
            return null;
        }
        return this.getDisplayContentsAnimatorLocked((int)displayId).mScreenRotationAnimation;
    }

    void requestRemovalOfReplacedWindows(WindowState win) {
        this.mRemoveReplacedWindows = true;
    }

    boolean isAnimating() {
        return this.mAnimating;
    }

    void setAnimating(boolean animating) {
        this.mAnimating = animating;
    }

    void orAnimating(boolean animating) {
        this.mAnimating |= animating;
    }

    private class DisplayContentsAnimator {
        ScreenRotationAnimation mScreenRotationAnimation = null;

        private DisplayContentsAnimator() {
        }
    }
}

