/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.ValueAnimator;
import android.annotation.IntDef;
import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerInternal;
import android.hardware.input.InputManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemService;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.TypedValue;
import android.view.AppTransitionAnimationSpec;
import android.view.Choreographer;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.IApplicationToken;
import android.view.IDockedStackListener;
import android.view.IInputFilter;
import android.view.IOnKeyguardExitResult;
import android.view.IRotationWatcher;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.View;
import android.view.WindowContentFrameStats;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.WindowManagerPolicy;
import android.view.animation.Animation;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.R;
import com.android.internal.app.IAssistScreenshotReceiver;
import com.android.internal.os.IResultReceiver;
import com.android.internal.policy.IShortcutService;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.WindowManagerPolicyThread;
import com.android.server.AttributeCache;
import com.android.server.DisplayThread;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.input.InputManagerService;
import com.android.server.policy.PhoneWindowManager;
import com.android.server.power.ShutdownThread;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationController;
import com.android.server.wm.CircularDisplayMask;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayContentList;
import com.android.server.wm.DisplaySettings;
import com.android.server.wm.DragState;
import com.android.server.wm.EmulatorDisplayOverlay;
import com.android.server.wm.InputConsumerImpl;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.KeyguardDisableHandler;
import com.android.server.wm.PointerEventDispatcher;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.StartingData;
import com.android.server.wm.StrictModeFlash;
import com.android.server.wm.Task;
import com.android.server.wm.TaskGroup;
import com.android.server.wm.TaskPositioner;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskTapPointerEventListener;
import com.android.server.wm.ViewServer;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.Watermark;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowLayersController;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfaceController;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class WindowManagerService
extends IWindowManager.Stub
implements Watchdog.Monitor,
WindowManagerPolicy.WindowManagerFuncs {
    private static final String TAG = "WindowManager";
    static final int LAYOUT_REPEAT_THRESHOLD = 4;
    static final boolean PROFILE_ORIENTATION = false;
    static final boolean localLOGV = false;
    static final int TYPE_LAYER_MULTIPLIER = 10000;
    static final int TYPE_LAYER_OFFSET = 1000;
    static final int WINDOW_LAYER_MULTIPLIER = 5;
    static final int LAYER_OFFSET_DIM = 1;
    static final int LAYER_OFFSET_THUMBNAIL = 4;
    static final int MAX_ANIMATION_DURATION = 10000;
    static final int WINDOW_FREEZE_TIMEOUT_DURATION = 2000;
    static final int SEAMLESS_ROTATION_TIMEOUT_DURATION = 2000;
    static final int WINDOW_REPLACEMENT_TIMEOUT_DURATION = 2000;
    static final int LAST_ANR_LIFETIME_DURATION_MSECS = 0x6DDD00;
    static final boolean CUSTOM_SCREEN_ROTATION = true;
    private static final int INPUT_DEVICES_READY_FOR_SAFE_MODE_DETECTION_TIMEOUT_MILLIS = 1000;
    static final long DEFAULT_INPUT_DISPATCHING_TIMEOUT_NANOS = 5000000000L;
    private static final int BOOT_ANIMATION_POLL_INTERVAL = 200;
    private static final String BOOT_ANIMATION_SERVICE = "bootanim";
    static final int UPDATE_FOCUS_NORMAL = 0;
    static final int UPDATE_FOCUS_WILL_ASSIGN_LAYERS = 1;
    static final int UPDATE_FOCUS_PLACING_SURFACES = 2;
    static final int UPDATE_FOCUS_WILL_PLACE_SURFACES = 3;
    private static final String SYSTEM_SECURE = "ro.secure";
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    private static final String DENSITY_OVERRIDE = "ro.config.density_override";
    private static final String SIZE_OVERRIDE = "ro.config.size_override";
    private static final int MAX_SCREENSHOT_RETRIES = 3;
    private static final String PROPERTY_EMULATOR_CIRCULAR = "ro.emulator.circular";
    private static final boolean ALWAYS_KEEP_CURRENT = true;
    private static final float DRAG_SHADOW_ALPHA_TRANSPARENT = 0.7071f;
    private static final String PROPERTY_BUILD_DATE_UTC = "ro.build.date.utc";
    private static final int WINDOW_ANIMATION_SCALE = 0;
    private static final int TRANSITION_ANIMATION_SCALE = 1;
    private static final int ANIMATION_DURATION_SCALE = 2;
    private final KeyguardDisableHandler mKeyguardDisableHandler;
    final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED".equals(action)) {
                WindowManagerService.this.mKeyguardDisableHandler.sendEmptyMessage(3);
            }
        }
    };
    final WindowSurfacePlacer mWindowPlacerLocked;
    int mCurrentUserId;
    int[] mCurrentProfileIds = new int[0];
    final Context mContext;
    final boolean mHaveInputMethods;
    final boolean mHasPermanentDpad;
    final long mDrawLockTimeoutMillis;
    final boolean mAllowAnimationsInLowPowerMode;
    final boolean mAllowBootMessages;
    final boolean mLimitedAlphaCompositing;
    final WindowManagerPolicy mPolicy = new PhoneWindowManager();
    final IActivityManager mActivityManager;
    final ActivityManagerInternal mAmInternal;
    final AppOpsManager mAppOps;
    final DisplaySettings mDisplaySettings;
    final ArraySet<Session> mSessions = new ArraySet();
    final HashMap<IBinder, WindowState> mWindowMap = new HashMap();
    final HashMap<IBinder, WindowToken> mTokenMap = new HashMap();
    final ArrayList<AppWindowToken> mFinishedStarting = new ArrayList();
    final ArrayList<AppWindowToken> mFinishedEarlyAnim = new ArrayList();
    final ArrayList<AppWindowToken> mReplacingWindowTimeouts = new ArrayList();
    InputConsumerImpl mInputConsumer;
    InputConsumerImpl mWallpaperInputConsumer;
    final ArrayList<WindowState> mResizingWindows = new ArrayList();
    final ArrayList<WindowState> mPendingRemove = new ArrayList();
    WindowState[] mPendingRemoveTmp = new WindowState[20];
    final ArrayList<WindowState> mDestroySurface = new ArrayList();
    final ArrayList<WindowState> mDestroyPreservedSurface = new ArrayList();
    ArrayList<WindowState> mLosingFocus = new ArrayList();
    final ArrayList<WindowState> mForceRemoves = new ArrayList();
    ArrayList<WindowState> mWaitingForDrawn = new ArrayList();
    Runnable mWaitingForDrawnCallback;
    WindowState[] mRebuildTmp = new WindowState[20];
    SparseArray<Boolean> mScreenCaptureDisabled = new SparseArray();
    IInputMethodManager mInputMethodManager;
    AccessibilityController mAccessibilityController;
    final SurfaceSession mFxSession;
    Watermark mWatermark;
    StrictModeFlash mStrictModeFlash;
    CircularDisplayMask mCircularDisplayMask;
    EmulatorDisplayOverlay mEmulatorDisplayOverlay;
    final float[] mTmpFloats = new float[9];
    final Rect mTmpRect = new Rect();
    final Rect mTmpRect2 = new Rect();
    final Rect mTmpRect3 = new Rect();
    final RectF mTmpRectF = new RectF();
    final Matrix mTmpTransform = new Matrix();
    boolean mDisplayReady;
    boolean mSafeMode;
    boolean mDisplayEnabled = false;
    boolean mSystemBooted = false;
    boolean mForceDisplayEnabled = false;
    boolean mShowingBootMessages = false;
    boolean mBootAnimationStopped = false;
    WindowState mLastWakeLockHoldingWindow = null;
    WindowState mLastWakeLockObscuringWindow = null;
    String mLastANRState;
    SparseArray<DisplayContent> mDisplayContents = new SparseArray(2);
    int mRotation = 0;
    int mLastOrientation = -1;
    boolean mAltOrientation = false;
    private boolean mKeyguardWaitingForActivityDrawn;
    int mDockedStackCreateMode = 0;
    Rect mDockedStackCreateBounds;
    private final SparseIntArray mTmpTaskIds = new SparseIntArray();
    private final ArrayList<Integer> mChangedStackList = new ArrayList();
    boolean mForceResizableTasks = false;
    ArrayList<RotationWatcher> mRotationWatchers = new ArrayList();
    int mDeferredRotationPauseCount;
    int mSystemDecorLayer = 0;
    final Rect mScreenRect = new Rect();
    boolean mDisplayFrozen = false;
    long mDisplayFreezeTime = 0L;
    int mLastDisplayFreezeDuration = 0;
    Object mLastFinishedFreezeSource = null;
    boolean mWaitingForConfig = false;
    static final int WINDOWS_FREEZING_SCREENS_NONE = 0;
    static final int WINDOWS_FREEZING_SCREENS_ACTIVE = 1;
    static final int WINDOWS_FREEZING_SCREENS_TIMEOUT = 2;
    int mWindowsFreezingScreen = 0;
    boolean mClientFreezingScreen = false;
    int mAppsFreezingScreen = 0;
    int mLastWindowForcedOrientation = -1;
    int mLastKeyguardForcedOrientation = -1;
    int mLayoutSeq = 0;
    int mLastStatusBarVisibility = 0;
    int mLastDispatchedSystemUiVisibility = 0;
    boolean mFocusMayChange;
    Configuration mCurConfiguration = new Configuration();
    private final PowerManager.WakeLock mScreenFrozenLock;
    final AppTransition mAppTransition;
    boolean mSkipAppTransitionAnimation = false;
    final ArraySet<AppWindowToken> mOpeningApps = new ArraySet();
    final ArraySet<AppWindowToken> mClosingApps = new ArraySet();
    boolean mIsTouchDevice;
    final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mRealDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mTmpDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mCompatDisplayMetrics = new DisplayMetrics();
    final H mH = new H();
    final Choreographer mChoreographer = Choreographer.getInstance();
    WindowState mCurrentFocus = null;
    WindowState mLastFocus = null;
    WindowState mInputMethodTarget = null;
    boolean mInputMethodTargetWaitingAnim;
    WindowState mInputMethodWindow = null;
    final ArrayList<WindowState> mInputMethodDialogs = new ArrayList();
    final ArrayList<WindowState> mTmpWindows = new ArrayList();
    boolean mHardKeyboardAvailable;
    WindowManagerInternal.OnHardKeyboardStatusChangeListener mHardKeyboardStatusChangeListener;
    SettingsObserver mSettingsObserver;
    WallpaperController mWallpaperControllerLocked;
    final WindowLayersController mLayersController;
    boolean mAnimateWallpaperWithTarget;
    AppWindowToken mFocusedApp = null;
    PowerManager mPowerManager;
    PowerManagerInternal mPowerManagerInternal;
    float mWindowAnimationScaleSetting = 1.0f;
    float mTransitionAnimationScaleSetting = 1.0f;
    float mAnimatorDurationScaleSetting = 1.0f;
    boolean mAnimationsDisabled = false;
    final InputManagerService mInputManager;
    final DisplayManagerInternal mDisplayManagerInternal;
    final DisplayManager mDisplayManager;
    final Display[] mDisplays;
    Session mHoldingScreenOn;
    PowerManager.WakeLock mHoldingScreenWakeLock;
    boolean mTurnOnScreen;
    boolean mAllowTheaterModeWakeFromLayout;
    TaskPositioner mTaskPositioner;
    DragState mDragState = null;
    int mExitAnimId;
    int mEnterAnimId;
    boolean mAnimationScheduled;
    int mTransactionSequence;
    final WindowAnimator mAnimator;
    private final BoundsAnimationController mBoundsAnimationController;
    SparseArray<Task> mTaskIdToTask = new SparseArray();
    SparseArray<TaskStack> mStackIdToStack = new SparseArray();
    private final PointerEventDispatcher mPointerEventDispatcher;
    private WindowContentFrameStats mTempWindowRenderStats;
    boolean mInTouchMode;
    private ViewServer mViewServer;
    final ArrayList<WindowChangeListener> mWindowChangeListeners = new ArrayList();
    boolean mWindowsChanged = false;
    final Configuration mTempConfiguration = new Configuration();
    float mCompatibleScreenScale;
    final boolean mOnlyCore;
    final List<IBinder> mNoAnimationNotifyOnTransitionFinished = new ArrayList<IBinder>();
    private final DisplayContentList mReconfigureOnConfigurationChanged = new DisplayContentList();
    private final WindowManagerInternal.AppTransitionListener mActivityManagerAppTransitionNotifier = new WindowManagerInternal.AppTransitionListener(){

        @Override
        public void onAppTransitionCancelledLocked() {
            WindowManagerService.this.mH.sendEmptyMessage(48);
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            WindowManagerService.this.mH.sendEmptyMessage(49);
            AppWindowToken atoken = WindowManagerService.this.findAppWindowToken(token);
            if (atoken == null) {
                return;
            }
            if (atoken.mLaunchTaskBehind) {
                try {
                    WindowManagerService.this.mActivityManager.notifyLaunchTaskBehindComplete(atoken.token);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                atoken.mLaunchTaskBehind = false;
            } else {
                atoken.updateReportedVisibilityLocked();
                if (atoken.mEnteringAnimation) {
                    atoken.mEnteringAnimation = false;
                    try {
                        WindowManagerService.this.mActivityManager.notifyEnterAnimationComplete(atoken.token);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    final InputMonitor mInputMonitor = new InputMonitor(this);
    private boolean mEventDispatchingEnabled;
    private MousePositionTracker mMousePositionTracker = new MousePositionTracker();

    int getDragLayerLocked() {
        return this.mPolicy.windowTypeToLayerLw(2016) * 10000 + 1000;
    }

    public static WindowManagerService main(final Context context, final InputManagerService im, final boolean haveInputMethods, final boolean showBootMsgs, final boolean onlyCore) {
        final WindowManagerService[] holder = new WindowManagerService[1];
        DisplayThread.getHandler().runWithScissors(new Runnable(){

            @Override
            public void run() {
                holder[0] = new WindowManagerService(context, im, haveInputMethods, showBootMsgs, onlyCore);
            }
        }, 0L);
        return holder[0];
    }

    private void initPolicy() {
        UiThread.getHandler().runWithScissors(new Runnable(){

            @Override
            public void run() {
                WindowManagerPolicyThread.set(Thread.currentThread(), Looper.myLooper());
                WindowManagerService.this.mPolicy.init(WindowManagerService.this.mContext, WindowManagerService.this, WindowManagerService.this);
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowManagerService(Context context, InputManagerService inputManager, boolean haveInputMethods, boolean showBootMsgs, boolean onlyCore) {
        this.mContext = context;
        this.mHaveInputMethods = haveInputMethods;
        this.mAllowBootMessages = showBootMsgs;
        this.mOnlyCore = onlyCore;
        this.mLimitedAlphaCompositing = context.getResources().getBoolean(17956875);
        this.mHasPermanentDpad = context.getResources().getBoolean(17956996);
        this.mInTouchMode = context.getResources().getBoolean(17957023);
        this.mDrawLockTimeoutMillis = context.getResources().getInteger(17694869);
        this.mAllowAnimationsInLowPowerMode = context.getResources().getBoolean(17957025);
        this.mInputManager = inputManager;
        this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
        this.mDisplaySettings = new DisplaySettings();
        this.mDisplaySettings.readSettingsLocked();
        this.mWallpaperControllerLocked = new WallpaperController(this);
        this.mWindowPlacerLocked = new WindowSurfacePlacer(this);
        this.mLayersController = new WindowLayersController(this);
        LocalServices.addService(WindowManagerPolicy.class, this.mPolicy);
        this.mPointerEventDispatcher = new PointerEventDispatcher(this.mInputManager.monitorInput(TAG));
        this.mFxSession = new SurfaceSession();
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        for (Display display : this.mDisplays = this.mDisplayManager.getDisplays()) {
            this.createDisplayContentLocked(display);
        }
        this.mKeyguardDisableHandler = new KeyguardDisableHandler(this.mContext, this.mPolicy);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLowPowerModeChanged(boolean enabled) {
                HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                synchronized (hashMap) {
                    if (WindowManagerService.this.mAnimationsDisabled != enabled && !WindowManagerService.this.mAllowAnimationsInLowPowerMode) {
                        WindowManagerService.this.mAnimationsDisabled = enabled;
                        WindowManagerService.this.dispatchNewAnimatorScaleLocked(null);
                    }
                }
            }
        });
        this.mAnimationsDisabled = this.mPowerManagerInternal.getLowPowerModeEnabled();
        this.mScreenFrozenLock = this.mPowerManager.newWakeLock(1, "SCREEN_FROZEN");
        this.mScreenFrozenLock.setReferenceCounted(false);
        this.mAppTransition = new AppTransition(context, this);
        this.mAppTransition.registerListenerLocked(this.mActivityManagerAppTransitionNotifier);
        this.mBoundsAnimationController = new BoundsAnimationController(this.mAppTransition, UiThread.getHandler());
        this.mActivityManager = ActivityManagerNative.getDefault();
        this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        AppOpsManager.OnOpChangedInternalListener opListener = new AppOpsManager.OnOpChangedInternalListener(){

            @Override
            public void onOpChanged(int op, String packageName) {
                WindowManagerService.this.updateAppOpsState();
            }
        };
        this.mAppOps.startWatchingMode(24, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mAppOps.startWatchingMode(45, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mWindowAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "window_animation_scale", this.mWindowAnimationScaleSetting);
        this.mTransitionAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "transition_animation_scale", this.mTransitionAnimationScaleSetting);
        this.setAnimatorDurationScale(Settings.Global.getFloat(context.getContentResolver(), "animator_duration_scale", this.mAnimatorDurationScaleSetting));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mSettingsObserver = new SettingsObserver();
        this.mHoldingScreenWakeLock = this.mPowerManager.newWakeLock(0x2000000A, TAG);
        this.mHoldingScreenWakeLock.setReferenceCounted(false);
        this.mAnimator = new WindowAnimator(this);
        this.mAllowTheaterModeWakeFromLayout = context.getResources().getBoolean(17956913);
        LocalServices.addService(WindowManagerInternal.class, new LocalService());
        this.initPolicy();
        Watchdog.getInstance().addMonitor(this);
        SurfaceControl.openTransaction();
        try {
            this.createWatermarkInTransaction();
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        this.showEmulatorDisplayOverlayIfNeeded();
    }

    public InputMonitor getInputMonitor() {
        return this.mInputMonitor;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Window Manager Crash", e);
            }
            throw e;
        }
    }

    private void placeWindowAfter(WindowState pos, WindowState window) {
        WindowList windows = pos.getWindowList();
        int i = windows.indexOf(pos);
        windows.add(i + 1, window);
        this.mWindowsChanged = true;
    }

    private void placeWindowBefore(WindowState pos, WindowState window) {
        WindowList windows = pos.getWindowList();
        int i = windows.indexOf(pos);
        if (i < 0) {
            Slog.w(TAG, "placeWindowBefore: Unable to find " + pos + " in " + windows);
            i = 0;
        }
        windows.add(i, window);
        this.mWindowsChanged = true;
    }

    private int findIdxBasedOnAppTokens(WindowState win) {
        WindowList windows = win.getWindowList();
        for (int j = windows.size() - 1; j >= 0; --j) {
            WindowState wentry = (WindowState)windows.get(j);
            if (wentry.mAppToken != win.mAppToken) continue;
            return j;
        }
        return -1;
    }

    private WindowList getTokenWindowsOnDisplay(WindowToken token, DisplayContent displayContent) {
        WindowList windowList = new WindowList();
        int count = token.windows.size();
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)token.windows.get(i);
            if (win.getDisplayContent() != displayContent) continue;
            windowList.add(win);
        }
        return windowList;
    }

    private int indexOfWinInWindowList(WindowState targetWin, WindowList windows) {
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)windows.get(i);
            if (w == targetWin) {
                return i;
            }
            if (w.mChildWindows.isEmpty() || this.indexOfWinInWindowList(targetWin, w.mChildWindows) < 0) continue;
            return i;
        }
        return -1;
    }

    private int addAppWindowToListLocked(WindowState win) {
        int i;
        WindowToken atoken;
        AppWindowToken t;
        AppTokenList tokens;
        int taskNdx;
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            return 0;
        }
        IWindow client = win.mClient;
        WindowToken token = win.mToken;
        WindowList windows = displayContent.getWindowList();
        WindowList tokenWindowList = this.getTokenWindowsOnDisplay(token, displayContent);
        int tokenWindowsPos = 0;
        if (!tokenWindowList.isEmpty()) {
            return this.addAppWindowToTokenListLocked(win, token, windows, tokenWindowList);
        }
        WindowState pos = null;
        ArrayList<Task> tasks = displayContent.getTasks();
        int tokenNdx = -1;
        for (taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            for (tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                t = (AppWindowToken)tokens.get(tokenNdx);
                if (t == token) {
                    if (--tokenNdx >= 0 || --taskNdx < 0) break;
                    tokenNdx = tasks.get((int)taskNdx).mAppTokens.size() - 1;
                    break;
                }
                tokenWindowList = this.getTokenWindowsOnDisplay(t, displayContent);
                if (t.sendingToBottom || tokenWindowList.size() <= 0) continue;
                pos = (WindowState)tokenWindowList.get(0);
            }
            if (tokenNdx >= 0) break;
        }
        if (pos != null) {
            int NC;
            atoken = this.mTokenMap.get(pos.mClient.asBinder());
            if (atoken != null && (NC = (tokenWindowList = this.getTokenWindowsOnDisplay(atoken, displayContent)).size()) > 0) {
                WindowState bottom = (WindowState)tokenWindowList.get(0);
                if (bottom.mSubLayer < 0) {
                    pos = bottom;
                }
            }
            this.placeWindowBefore(pos, win);
            return tokenWindowsPos;
        }
        while (taskNdx >= 0) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            while (tokenNdx >= 0) {
                t = (AppWindowToken)tokens.get(tokenNdx);
                tokenWindowList = this.getTokenWindowsOnDisplay(t, displayContent);
                int NW = tokenWindowList.size();
                if (NW > 0) {
                    pos = (WindowState)tokenWindowList.get(NW - 1);
                    break;
                }
                --tokenNdx;
            }
            if (tokenNdx >= 0) break;
            --taskNdx;
        }
        if (pos != null) {
            int NC;
            atoken = this.mTokenMap.get(pos.mClient.asBinder());
            if (atoken != null && (NC = atoken.windows.size()) > 0) {
                WindowState top = (WindowState)atoken.windows.get(NC - 1);
                if (top.mSubLayer >= 0) {
                    pos = top;
                }
            }
            this.placeWindowAfter(pos, win);
            return tokenWindowsPos;
        }
        int myLayer = win.mBaseLayer;
        for (i = windows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mBaseLayer <= myLayer && w.mAttrs.type != 2034) break;
        }
        windows.add(i + 1, win);
        this.mWindowsChanged = true;
        return tokenWindowsPos;
    }

    private int addAppWindowToTokenListLocked(WindowState win, WindowToken token, WindowList windows, WindowList tokenWindowList) {
        int tokenWindowsPos;
        if (win.mAttrs.type == 1) {
            WindowState lowestWindow = (WindowState)tokenWindowList.get(0);
            this.placeWindowBefore(lowestWindow, win);
            tokenWindowsPos = this.indexOfWinInWindowList(lowestWindow, token.windows);
        } else {
            AppWindowToken atoken = win.mAppToken;
            int windowListPos = tokenWindowList.size();
            WindowState lastWindow = (WindowState)tokenWindowList.get(windowListPos - 1);
            if (atoken != null && lastWindow == atoken.startingWindow) {
                this.placeWindowBefore(lastWindow, win);
                tokenWindowsPos = this.indexOfWinInWindowList(lastWindow, token.windows);
            } else {
                int newIdx = this.findIdxBasedOnAppTokens(win);
                windows.add(newIdx + 1, win);
                tokenWindowsPos = newIdx < 0 ? 0 : this.indexOfWinInWindowList((WindowState)windows.get(newIdx), token.windows) + 1;
                this.mWindowsChanged = true;
            }
        }
        return tokenWindowsPos;
    }

    private void addFreeWindowToListLocked(WindowState win) {
        WindowState otherWin;
        int i;
        WindowList windows = win.getWindowList();
        int myLayer = win.mBaseLayer;
        for (i = windows.size() - 1; i >= 0 && ((otherWin = (WindowState)windows.get(i)).getBaseType() == 2013 || otherWin.mBaseLayer > myLayer); --i) {
        }
        windows.add(++i, win);
        this.mWindowsChanged = true;
    }

    private void addAttachedWindowToListLocked(WindowState win, boolean addToToken) {
        int i;
        WindowToken token = win.mToken;
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            return;
        }
        WindowState attached = win.mAttachedWindow;
        WindowList tokenWindowList = this.getTokenWindowsOnDisplay(token, displayContent);
        int NA = tokenWindowList.size();
        int sublayer = win.mSubLayer;
        int largestSublayer = Integer.MIN_VALUE;
        WindowState windowWithLargestSublayer = null;
        for (i = 0; i < NA; ++i) {
            WindowState w = (WindowState)tokenWindowList.get(i);
            int wSublayer = w.mSubLayer;
            if (wSublayer >= largestSublayer) {
                largestSublayer = wSublayer;
                windowWithLargestSublayer = w;
            }
            if (sublayer < 0) {
                if (wSublayer < sublayer) continue;
                if (addToToken) {
                    token.windows.add(i, win);
                }
                this.placeWindowBefore(wSublayer >= 0 ? attached : w, win);
                break;
            }
            if (wSublayer <= sublayer) continue;
            if (addToToken) {
                token.windows.add(i, win);
            }
            this.placeWindowBefore(w, win);
            break;
        }
        if (i >= NA) {
            if (addToToken) {
                token.windows.add(win);
            }
            if (sublayer < 0) {
                this.placeWindowBefore(attached, win);
            } else {
                this.placeWindowAfter(largestSublayer >= 0 ? windowWithLargestSublayer : attached, win);
            }
        }
    }

    private void addWindowToListInOrderLocked(WindowState win, boolean addToToken) {
        if (win.mAttachedWindow == null) {
            WindowToken token = win.mToken;
            int tokenWindowsPos = 0;
            if (token.appWindowToken != null) {
                tokenWindowsPos = this.addAppWindowToListLocked(win);
            } else {
                this.addFreeWindowToListLocked(win);
            }
            if (addToToken) {
                token.windows.add(tokenWindowsPos, win);
            }
        } else {
            this.addAttachedWindowToListLocked(win, addToToken);
        }
        AppWindowToken appToken = win.mAppToken;
        if (appToken != null && addToToken) {
            appToken.addWindow(win);
        }
    }

    static boolean canBeImeTarget(WindowState w) {
        int fl = w.mAttrs.flags & 0x20008;
        int type = w.mAttrs.type;
        if (fl == 0 || fl == 131080 || type == 3) {
            return w.isVisibleOrAdding();
        }
        return false;
    }

    int findDesiredInputMethodWindowIndexLocked(boolean willMove) {
        WindowState curTarget;
        int i;
        WindowList windows = this.getDefaultWindowListLocked();
        WindowState w = null;
        for (i = windows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            if (!WindowManagerService.canBeImeTarget(win)) continue;
            w = win;
            if (willMove || w.mAttrs.type != 3 || i <= 0) break;
            WindowState wb = (WindowState)windows.get(i - 1);
            if (wb.mAppToken != w.mAppToken || !WindowManagerService.canBeImeTarget(wb)) break;
            --i;
            w = wb;
            break;
        }
        if ((curTarget = this.mInputMethodTarget) != null && curTarget.isDisplayedLw() && curTarget.isClosing() && (w == null || curTarget.mWinAnimator.mAnimLayer > w.mWinAnimator.mAnimLayer)) {
            return windows.indexOf(curTarget) + 1;
        }
        if (willMove && w != null) {
            AppWindowToken token;
            AppWindowToken appWindowToken = token = curTarget == null ? null : curTarget.mAppToken;
            if (token != null) {
                WindowState highestTarget = null;
                int highestPos = 0;
                if (token.mAppAnimator.animating || token.mAppAnimator.animation != null) {
                    WindowList curWindows = curTarget.getWindowList();
                    for (int pos = curWindows.indexOf(curTarget); pos >= 0; --pos) {
                        WindowState win = (WindowState)curWindows.get(pos);
                        if (win.mAppToken != token) break;
                        if (win.mRemoved || highestTarget != null && win.mWinAnimator.mAnimLayer <= highestTarget.mWinAnimator.mAnimLayer) continue;
                        highestTarget = win;
                        highestPos = pos;
                    }
                }
                if (highestTarget != null) {
                    if (this.mAppTransition.isTransitionSet()) {
                        this.mInputMethodTargetWaitingAnim = true;
                        this.mInputMethodTarget = highestTarget;
                        return highestPos + 1;
                    }
                    if (highestTarget.mWinAnimator.isAnimationSet() && highestTarget.mWinAnimator.mAnimLayer > w.mWinAnimator.mAnimLayer) {
                        this.mInputMethodTargetWaitingAnim = true;
                        this.mInputMethodTarget = highestTarget;
                        return highestPos + 1;
                    }
                }
            }
        }
        if (w != null) {
            int dividerIndex;
            WindowState dockedDivider;
            if (willMove) {
                this.mInputMethodTarget = w;
                this.mInputMethodTargetWaitingAnim = false;
                if (w.mAppToken != null) {
                    this.mLayersController.setInputMethodAnimLayerAdjustment(w.mAppToken.mAppAnimator.animLayerAdjustment);
                } else {
                    this.mLayersController.setInputMethodAnimLayerAdjustment(0);
                }
            }
            if ((dockedDivider = w.mDisplayContent.mDividerControllerLocked.getWindow()) != null && dockedDivider.isVisibleLw() && (dividerIndex = windows.indexOf(dockedDivider)) > 0 && dividerIndex > i) {
                return dividerIndex + 1;
            }
            return i + 1;
        }
        if (willMove) {
            this.mInputMethodTarget = null;
            this.mLayersController.setInputMethodAnimLayerAdjustment(0);
        }
        return -1;
    }

    void addInputMethodWindowToListLocked(WindowState win) {
        int pos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (pos >= 0) {
            win.mTargetAppToken = this.mInputMethodTarget.mAppToken;
            this.getDefaultWindowListLocked().add(pos, win);
            this.mWindowsChanged = true;
            this.moveInputMethodDialogsLocked(pos + 1);
            return;
        }
        win.mTargetAppToken = null;
        this.addWindowToListInOrderLocked(win, true);
        this.moveInputMethodDialogsLocked(pos);
    }

    private int tmpRemoveWindowLocked(int interestingPos, WindowState win) {
        WindowList windows = win.getWindowList();
        int wpos = windows.indexOf(win);
        if (wpos >= 0) {
            if (wpos < interestingPos) {
                --interestingPos;
            }
            windows.remove(wpos);
            this.mWindowsChanged = true;
            int NC = win.mChildWindows.size();
            while (NC > 0) {
                WindowState cw;
                int cpos;
                if ((cpos = windows.indexOf(cw = (WindowState)win.mChildWindows.get(--NC))) < 0) continue;
                if (cpos < interestingPos) {
                    --interestingPos;
                }
                windows.remove(cpos);
            }
        }
        return interestingPos;
    }

    private void reAddWindowToListInOrderLocked(WindowState win) {
        this.addWindowToListInOrderLocked(win, false);
        WindowList windows = win.getWindowList();
        int wpos = windows.indexOf(win);
        if (wpos >= 0) {
            windows.remove(wpos);
            this.mWindowsChanged = true;
            this.reAddWindowLocked(wpos, win);
        }
    }

    void logWindowList(WindowList windows, String prefix) {
        int N = windows.size();
        while (N > 0) {
            Slog.v(TAG, prefix + "#" + --N + ": " + windows.get(N));
        }
    }

    void moveInputMethodDialogsLocked(int pos) {
        int i;
        ArrayList<WindowState> dialogs = this.mInputMethodDialogs;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = dialogs.size();
        for (i = 0; i < N; ++i) {
            pos = this.tmpRemoveWindowLocked(pos, dialogs.get(i));
        }
        if (pos >= 0) {
            AppWindowToken targetAppToken = this.mInputMethodTarget.mAppToken;
            if (this.mInputMethodWindow != null) {
                WindowState wp;
                while (pos < windows.size() && ((wp = (WindowState)windows.get(pos)) == this.mInputMethodWindow || wp.mAttachedWindow == this.mInputMethodWindow)) {
                    ++pos;
                }
            }
            for (int i2 = 0; i2 < N; ++i2) {
                WindowState win = dialogs.get(i2);
                win.mTargetAppToken = targetAppToken;
                pos = this.reAddWindowLocked(pos, win);
            }
            return;
        }
        for (i = 0; i < N; ++i) {
            WindowState win = dialogs.get(i);
            win.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(win);
        }
    }

    boolean moveInputMethodWindowsIfNeededLocked(boolean needAssignLayers) {
        WindowState imWin = this.mInputMethodWindow;
        int DN = this.mInputMethodDialogs.size();
        if (imWin == null && DN == 0) {
            return false;
        }
        WindowList windows = this.getDefaultWindowListLocked();
        int imPos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (imPos >= 0) {
            WindowState baseImWin;
            int N = windows.size();
            WindowState firstImWin = imPos < N ? (WindowState)windows.get(imPos) : null;
            WindowState windowState = baseImWin = imWin != null ? imWin : this.mInputMethodDialogs.get(0);
            if (baseImWin.mChildWindows.size() > 0) {
                WindowState cw = (WindowState)baseImWin.mChildWindows.get(0);
                if (cw.mSubLayer < 0) {
                    baseImWin = cw;
                }
            }
            if (firstImWin == baseImWin) {
                int pos;
                for (pos = imPos + 1; pos < N && ((WindowState)windows.get((int)pos)).mIsImWindow; ++pos) {
                }
                ++pos;
                while (pos < N && !((WindowState)windows.get((int)pos)).mIsImWindow) {
                    ++pos;
                }
                if (pos >= N) {
                    if (imWin != null) {
                        imWin.mTargetAppToken = this.mInputMethodTarget.mAppToken;
                    }
                    return false;
                }
            }
            if (imWin != null) {
                imPos = this.tmpRemoveWindowLocked(imPos, imWin);
                imWin.mTargetAppToken = this.mInputMethodTarget.mAppToken;
                this.reAddWindowLocked(imPos, imWin);
                if (DN > 0) {
                    this.moveInputMethodDialogsLocked(imPos + 1);
                }
            } else {
                this.moveInputMethodDialogsLocked(imPos);
            }
        } else if (imWin != null) {
            this.tmpRemoveWindowLocked(0, imWin);
            imWin.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(imWin);
            if (DN > 0) {
                this.moveInputMethodDialogsLocked(-1);
            }
        } else {
            this.moveInputMethodDialogsLocked(-1);
        }
        if (needAssignLayers) {
            this.mLayersController.assignLayersLocked(windows);
        }
        return true;
    }

    private static boolean excludeWindowTypeFromTapOutTask(int windowType) {
        switch (windowType) {
            case 2000: 
            case 2012: 
            case 2019: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, InputChannel outInputChannel) {
        long origId;
        int[] appOp = new int[1];
        int res = this.mPolicy.checkAddPermission(attrs, appOp);
        if (res != 0) {
            return res;
        }
        boolean reportNewConfig = false;
        WindowState attachedWindow = null;
        int type = attrs.type;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int startOpResult;
            boolean openInputChannels;
            if (!this.mDisplayReady) {
                throw new IllegalStateException("Display has not been initialialized");
            }
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent == null) {
                Slog.w(TAG, "Attempted to add window to a display that does not exist: " + displayId + ".  Aborting.");
                return -9;
            }
            if (!displayContent.hasAccess(session.mUid)) {
                Slog.w(TAG, "Attempted to add window to a display for which the application does not have access: " + displayId + ".  Aborting.");
                return -9;
            }
            if (this.mWindowMap.containsKey(client.asBinder())) {
                Slog.w(TAG, "Window " + client + " is already added");
                return -5;
            }
            if (type >= 1000 && type <= 1999) {
                attachedWindow = this.windowForClientLocked(null, attrs.token, false);
                if (attachedWindow == null) {
                    Slog.w(TAG, "Attempted to add window with token that is not a window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
                if (attachedWindow.mAttrs.type >= 1000 && attachedWindow.mAttrs.type <= 1999) {
                    Slog.w(TAG, "Attempted to add window with token that is a sub-window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
            }
            if (type == 2030 && !displayContent.isPrivate()) {
                Slog.w(TAG, "Attempted to add private presentation window to a non-private display.  Aborting.");
                return -8;
            }
            boolean addToken = false;
            WindowToken token = this.mTokenMap.get(attrs.token);
            AppWindowToken atoken = null;
            if (token == null) {
                if (type >= 1 && type <= 99) {
                    Slog.w(TAG, "Attempted to add application window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2011) {
                    Slog.w(TAG, "Attempted to add input method window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2031) {
                    Slog.w(TAG, "Attempted to add voice interaction window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2023) {
                    Slog.w(TAG, "Attempted to add Dream window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2035) {
                    Slog.w(TAG, "Attempted to add QS dialog window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2032) {
                    Slog.w(TAG, "Attempted to add Accessibility overlay window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                token = new WindowToken(this, attrs.token, -1, false);
                addToken = true;
            } else if (type >= 1 && type <= 99) {
                atoken = token.appWindowToken;
                if (atoken == null) {
                    Slog.w(TAG, "Attempted to add window with non-application token " + token + ".  Aborting.");
                    return -3;
                }
                if (atoken.removed) {
                    Slog.w(TAG, "Attempted to add window with exiting application token " + token + ".  Aborting.");
                    return -4;
                }
                if (type == 3 && atoken.firstWindowDrawn) {
                    return -6;
                }
            } else if (type == 2011) {
                if (token.windowType != 2011) {
                    Slog.w(TAG, "Attempted to add input method window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2031) {
                if (token.windowType != 2031) {
                    Slog.w(TAG, "Attempted to add voice interaction window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2013) {
                if (token.windowType != 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2023) {
                if (token.windowType != 2023) {
                    Slog.w(TAG, "Attempted to add Dream window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2032) {
                if (token.windowType != 2032) {
                    Slog.w(TAG, "Attempted to add Accessibility overlay window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2035) {
                if (token.windowType != 2035) {
                    Slog.w(TAG, "Attempted to add QS dialog window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (token.appWindowToken != null) {
                Slog.w(TAG, "Non-null appWindowToken for system window of type=" + type);
                attrs.token = null;
                token = new WindowToken(this, null, -1, false);
                addToken = true;
            }
            WindowState win = new WindowState(this, session, client, token, attachedWindow, appOp[0], seq, attrs, viewVisibility, displayContent);
            if (win.mDeathRecipient == null) {
                Slog.w(TAG, "Adding window client " + client.asBinder() + " that is dead, aborting.");
                return -4;
            }
            if (win.getDisplayContent() == null) {
                Slog.w(TAG, "Adding window to Display that has been removed.");
                return -9;
            }
            this.mPolicy.adjustWindowParamsLw(win.mAttrs);
            win.setShowToOwnerOnlyLocked(this.mPolicy.checkShowToOwnerOnly(attrs));
            res = this.mPolicy.prepareAddWindowLw(win, attrs);
            if (res != 0) {
                return res;
            }
            boolean bl = openInputChannels = outInputChannel != null && (attrs.inputFeatures & 2) == 0;
            if (openInputChannels) {
                win.openInputChannel(outInputChannel);
            }
            res = 0;
            if (WindowManagerService.excludeWindowTypeFromTapOutTask(type)) {
                displayContent.mTapExcludedWindows.add(win);
            }
            origId = Binder.clearCallingIdentity();
            if (addToken) {
                this.mTokenMap.put(attrs.token, token);
            }
            win.attach();
            this.mWindowMap.put(client.asBinder(), win);
            if (win.mAppOp != -1 && (startOpResult = this.mAppOps.startOpNoThrow(win.mAppOp, win.getOwningUid(), win.getOwningPackage())) != 0 && startOpResult != 3) {
                win.setAppOpVisibilityLw(false);
            }
            if (type == 3 && token.appWindowToken != null) {
                token.appWindowToken.startingWindow = win;
            }
            boolean imMayMove = true;
            if (type == 2011) {
                win.mGivenInsetsPending = true;
                this.mInputMethodWindow = win;
                this.addInputMethodWindowToListLocked(win);
                imMayMove = false;
            } else if (type == 2012) {
                this.mInputMethodDialogs.add(win);
                this.addWindowToListInOrderLocked(win, true);
                this.moveInputMethodDialogsLocked(this.findDesiredInputMethodWindowIndexLocked(true));
                imMayMove = false;
            } else {
                this.addWindowToListInOrderLocked(win, true);
                if (type == 2013) {
                    this.mWallpaperControllerLocked.clearLastWallpaperTimeoutTime();
                    displayContent.pendingLayoutChanges |= 4;
                } else if ((attrs.flags & 0x100000) != 0) {
                    displayContent.pendingLayoutChanges |= 4;
                } else if (this.mWallpaperControllerLocked.isBelowWallpaperTarget(win)) {
                    displayContent.pendingLayoutChanges |= 4;
                }
            }
            win.applyScrollIfNeeded();
            win.applyAdjustForImeIfNeeded();
            if (type == 2034) {
                this.getDefaultDisplayContentLocked().getDockedDividerController().setWindow(win);
            }
            WindowStateAnimator winAnimator = win.mWinAnimator;
            winAnimator.mEnterAnimationPending = true;
            winAnimator.mEnteringAnimation = true;
            if (atoken != null && !this.prepareWindowReplacementTransition(atoken)) {
                this.prepareNoneTransitionForRelaunching(atoken);
            }
            if (displayContent.isDefaultDisplay) {
                Rect taskBounds;
                DisplayInfo displayInfo = displayContent.getDisplayInfo();
                if (atoken != null && atoken.mTask != null) {
                    taskBounds = this.mTmpRect;
                    atoken.mTask.getBounds(this.mTmpRect);
                } else {
                    taskBounds = null;
                }
                if (this.mPolicy.getInsetHintLw(win.mAttrs, taskBounds, this.mRotation, displayInfo.logicalWidth, displayInfo.logicalHeight, outContentInsets, outStableInsets, outOutsets)) {
                    res |= 4;
                }
            } else {
                outContentInsets.setEmpty();
                outStableInsets.setEmpty();
            }
            if (this.mInTouchMode) {
                res |= 1;
            }
            if (win.mAppToken == null || !win.mAppToken.clientHidden) {
                res |= 2;
            }
            this.mInputMonitor.setUpdateInputWindowsNeededLw();
            boolean focusChanged = false;
            if (win.canReceiveKeys() && (focusChanged = this.updateFocusedWindowLocked(1, false))) {
                imMayMove = false;
            }
            if (imMayMove) {
                this.moveInputMethodWindowsIfNeededLocked(false);
            }
            this.mLayersController.assignLayersLocked(displayContent.getWindowList());
            if (focusChanged) {
                this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, false);
            }
            this.mInputMonitor.updateInputWindowsLw(false);
            if (win.isVisibleOrAdding() && this.updateOrientationFromAppTokensLocked(false)) {
                reportNewConfig = true;
            }
            if (attrs.removeTimeoutMilliseconds > 0L) {
                this.mH.sendMessageDelayed(this.mH.obtainMessage(52, win), attrs.removeTimeoutMilliseconds);
            }
        }
        if (reportNewConfig) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
        return res;
    }

    private boolean prepareWindowReplacementTransition(AppWindowToken atoken) {
        atoken.clearAllDrawn();
        WindowState replacedWindow = null;
        for (int i = atoken.windows.size() - 1; i >= 0 && replacedWindow == null; --i) {
            WindowState candidate = (WindowState)atoken.windows.get(i);
            if (!candidate.mAnimatingExit || !candidate.mWillReplaceWindow || !candidate.mAnimateReplacingWindow) continue;
            replacedWindow = candidate;
        }
        if (replacedWindow == null) {
            return false;
        }
        Rect frame = replacedWindow.mVisibleFrame;
        this.mOpeningApps.add(atoken);
        this.prepareAppTransition(18, true);
        this.mAppTransition.overridePendingAppTransitionClipReveal(frame.left, frame.top, frame.width(), frame.height());
        this.executeAppTransition();
        return true;
    }

    private void prepareNoneTransitionForRelaunching(AppWindowToken atoken) {
        if (this.mDisplayFrozen && !this.mOpeningApps.contains(atoken) && atoken.isRelaunching()) {
            this.mOpeningApps.add(atoken);
            this.prepareAppTransition(0, false);
            this.executeAppTransition();
        }
    }

    boolean isScreenCaptureDisabledLocked(int userId) {
        Boolean disabled = this.mScreenCaptureDisabled.get(userId);
        if (disabled == null) {
            return false;
        }
        return disabled;
    }

    boolean isSecureLocked(WindowState w) {
        if ((w.mAttrs.flags & 0x2000) != 0) {
            return true;
        }
        return this.isScreenCaptureDisabledLocked(UserHandle.getUserId(w.mOwnerUid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenCaptureDisabled(int userId, boolean disabled) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("Only system can call setScreenCaptureDisabled.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mScreenCaptureDisabled.put(userId, disabled);
            for (int displayNdx = this.mDisplayContents.size() - 1; displayNdx >= 0; --displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (!win.mHasSurface || userId != UserHandle.getUserId(win.mOwnerUid)) continue;
                    win.mWinAnimator.setSecureLocked(disabled);
                }
            }
        }
    }

    private void setupWindowForRemoveOnExit(WindowState win) {
        win.mRemoveOnExit = true;
        win.setDisplayLayoutNeeded();
        boolean focusChanged = this.updateFocusedWindowLocked(3, false);
        this.mWindowPlacerLocked.performSurfacePlacement();
        if (focusChanged) {
            this.mInputMonitor.updateInputWindowsLw(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(Session session, IWindow client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return;
            }
            this.removeWindowLocked(win);
        }
    }

    void removeWindowLocked(WindowState win) {
        this.removeWindowLocked(win, false);
    }

    void removeWindowLocked(WindowState win, boolean keepVisibleDeadWindow) {
        boolean startingWindow;
        win.mWindowRemovalAllowed = true;
        boolean bl = startingWindow = win.mAttrs.type == 3;
        if (startingWindow) {
            // empty if block
        }
        long origId = Binder.clearCallingIdentity();
        win.disposeInputChannel();
        boolean wasVisible = false;
        if (win.mHasSurface && this.okToDisplay()) {
            boolean lastWindowIsStartingWindow;
            AppWindowToken appToken = win.mAppToken;
            if (win.mWillReplaceWindow) {
                win.mAnimatingExit = true;
                win.mReplacingRemoveRequested = true;
                Binder.restoreCallingIdentity(origId);
                return;
            }
            if (win.isAnimatingWithSavedSurface() && !appToken.allDrawnExcludingSaved) {
                this.setupWindowForRemoveOnExit(win);
                Binder.restoreCallingIdentity(origId);
                return;
            }
            wasVisible = win.isWinVisibleLw();
            if (keepVisibleDeadWindow) {
                win.mAppDied = true;
                win.setDisplayLayoutNeeded();
                this.mWindowPlacerLocked.performSurfacePlacement();
                win.openInputChannel(null);
                this.mInputMonitor.updateInputWindowsLw(true);
                Binder.restoreCallingIdentity(origId);
                return;
            }
            WindowStateAnimator winAnimator = win.mWinAnimator;
            if (wasVisible) {
                int transit;
                int n = transit = !startingWindow ? 2 : 5;
                if (winAnimator.applyAnimationLocked(transit, false)) {
                    win.mAnimatingExit = true;
                }
                if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
                    this.mAccessibilityController.onWindowTransitionLocked(win, transit);
                }
            }
            boolean isAnimating = winAnimator.isAnimationSet() && !winAnimator.isDummyAnimation();
            boolean bl2 = lastWindowIsStartingWindow = startingWindow && appToken != null && appToken.allAppWindows.size() == 1;
            if (winAnimator.getShown() && win.mAnimatingExit && (!lastWindowIsStartingWindow || isAnimating)) {
                this.setupWindowForRemoveOnExit(win);
                if (appToken != null) {
                    appToken.updateReportedVisibilityLocked();
                }
                Binder.restoreCallingIdentity(origId);
                return;
            }
        }
        this.removeWindowInnerLocked(win);
        if (wasVisible && this.updateOrientationFromAppTokensLocked(false)) {
            this.mH.sendEmptyMessage(18);
        }
        this.updateFocusedWindowLocked(0, true);
        Binder.restoreCallingIdentity(origId);
    }

    void removeWindowInnerLocked(WindowState win) {
        int type;
        if (win.mRemoved) {
            return;
        }
        for (int i = win.mChildWindows.size() - 1; i >= 0; --i) {
            WindowState cwin = (WindowState)win.mChildWindows.get(i);
            Slog.w(TAG, "Force-removing child win " + cwin + " from container " + win);
            this.removeWindowInnerLocked(cwin);
        }
        win.mRemoved = true;
        if (this.mInputMethodTarget == win) {
            this.moveInputMethodWindowsIfNeededLocked(false);
        }
        if (WindowManagerService.excludeWindowTypeFromTapOutTask(type = win.mAttrs.type)) {
            DisplayContent displaycontent = win.getDisplayContent();
            displaycontent.mTapExcludedWindows.remove(win);
        }
        this.mPolicy.removeWindowLw(win);
        win.removeLocked();
        this.mWindowMap.remove(win.mClient.asBinder());
        if (win.mAppOp != -1) {
            this.mAppOps.finishOp(win.mAppOp, win.getOwningUid(), win.getOwningPackage());
        }
        this.mPendingRemove.remove(win);
        this.mResizingWindows.remove(win);
        this.mWindowsChanged = true;
        if (this.mInputMethodWindow == win) {
            this.mInputMethodWindow = null;
        } else if (win.mAttrs.type == 2012) {
            this.mInputMethodDialogs.remove(win);
        }
        WindowToken token = win.mToken;
        AppWindowToken atoken = win.mAppToken;
        token.windows.remove(win);
        if (atoken != null) {
            atoken.allAppWindows.remove(win);
        }
        if (token.windows.size() == 0) {
            if (!token.explicit) {
                this.mTokenMap.remove(token.token);
            } else if (atoken != null) {
                atoken.firstWindowDrawn = false;
                atoken.clearAllDrawn();
            }
        }
        if (atoken != null) {
            if (atoken.startingWindow == win) {
                this.scheduleRemoveStartingWindowLocked(atoken);
            } else if (atoken.allAppWindows.size() == 0 && atoken.startingData != null) {
                atoken.startingData = null;
            } else if (atoken.allAppWindows.size() == 1 && atoken.startingView != null) {
                this.scheduleRemoveStartingWindowLocked(atoken);
            }
        }
        if (type == 2013) {
            this.mWallpaperControllerLocked.clearLastWallpaperTimeoutTime();
            this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
        } else if ((win.mAttrs.flags & 0x100000) != 0) {
            this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
        }
        WindowList windows = win.getWindowList();
        if (windows != null) {
            windows.remove(win);
            if (!this.mWindowPlacerLocked.isInLayout()) {
                this.mLayersController.assignLayersLocked(windows);
                win.setDisplayLayoutNeeded();
                this.mWindowPlacerLocked.performSurfacePlacement();
                if (win.mAppToken != null) {
                    win.mAppToken.updateReportedVisibilityLocked();
                }
            }
        }
        this.mInputMonitor.updateInputWindowsLw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppOpsState() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (win.mAppOp == -1) continue;
                    int mode = this.mAppOps.checkOpNoThrow(win.mAppOp, win.getOwningUid(), win.getOwningPackage());
                    win.setAppOpVisibilityLw(mode == 0 || mode == 3);
                }
            }
        }
    }

    static void logSurface(WindowState w, String msg, boolean withStackTrace) {
        String str = "  SURFACE " + msg + ": " + w;
        if (withStackTrace) {
            WindowManagerService.logWithStack(TAG, str);
        } else {
            Slog.i(TAG, str);
        }
    }

    static void logSurface(SurfaceControl s, String title, String msg) {
        String str = "  SURFACE " + s + ": " + msg + " / " + title;
        Slog.i(TAG, str);
    }

    static void logWithStack(String tag, String s) {
        Throwable e = null;
        Slog.i(tag, s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransparentRegionWindow(Session session, IWindow client, Region region) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null && w.mHasSurface) {
                    w.mWinAnimator.setTransparentRegionHintLocked(region);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInsetsWindow(Session session, IWindow client, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null) {
                    w.mGivenInsetsPending = false;
                    w.mGivenContentInsets.set(contentInsets);
                    w.mGivenVisibleInsets.set(visibleInsets);
                    w.mGivenTouchableRegion.set(touchableRegion);
                    w.mTouchableInsets = touchableInsets;
                    if (w.mGlobalScale != 1.0f) {
                        w.mGivenContentInsets.scale(w.mGlobalScale);
                        w.mGivenVisibleInsets.scale(w.mGlobalScale);
                        w.mGivenTouchableRegion.scale(w.mGlobalScale);
                    }
                    w.setDisplayLayoutNeeded();
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWindowDisplayFrame(Session session, IWindow client, Rect outDisplayFrame) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                outDisplayFrame.setEmpty();
                return;
            }
            outDisplayFrame.set(win.mDisplayFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window;
            if (this.mAccessibilityController != null && (window = this.mWindowMap.get(token)) != null && window.getDisplayId() == 0) {
                this.mAccessibilityController.onRectangleOnScreenRequestedLocked(rectangle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWindowId getWindowId(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window = this.mWindowMap.get(token);
            return window != null ? window.mWindowId : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pokeDrawLock(Session session, IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window = this.windowForClientLocked(session, token, false);
            if (window != null) {
                window.pokeDrawLockLw(this.mDrawLockTimeoutMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repositionChild(Session session, IWindow client, int left, int top, int right, int bottom, long frameNumber, Rect outFrame) {
        Trace.traceBegin(32L, "repositionChild");
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win;
                block14: {
                    win = this.windowForClientLocked(session, client, false);
                    if (win != null) break block14;
                    return;
                }
                if (win.mAttachedWindow == null) {
                    throw new IllegalArgumentException("repositionChild called but window is notattached to a parent win=" + win);
                }
                win.mAttrs.x = left;
                win.mAttrs.y = top;
                win.mAttrs.width = right - left;
                win.mAttrs.height = bottom - top;
                win.setWindowScale(win.mRequestedWidth, win.mRequestedHeight);
                if (win.mHasSurface) {
                    SurfaceControl.openTransaction();
                    try {
                        win.applyGravityAndUpdateFrame(win.mContainingFrame, win.mDisplayFrame);
                        win.mWinAnimator.computeShownFrameLocked();
                        win.mWinAnimator.setSurfaceBoundariesLocked(false);
                        if (frameNumber > 0L) {
                            win.mWinAnimator.deferTransactionUntilParentFrame(frameNumber);
                        }
                    }
                    finally {
                        SurfaceControl.closeTransaction();
                    }
                }
                outFrame = win.mCompatFrame;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
            Trace.traceEnd(32L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int relayoutWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, Rect outFrame, Rect outOverscanInsets, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, Rect outOutsets, Rect outBackdropFrame, Configuration outConfig, Surface outSurface) {
        boolean configChanged;
        int result = 0;
        boolean hasStatusBarPermission = this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") == 0;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean toBeDisplayed;
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return 0;
            }
            WindowStateAnimator winAnimator = win.mWinAnimator;
            if (viewVisibility != 8) {
                win.setRequestedSize(requestedWidth, requestedHeight);
            }
            int attrChanges = 0;
            int flagChanges = 0;
            if (attrs != null) {
                this.mPolicy.adjustWindowParamsLw(attrs);
                if (seq == win.mSeq) {
                    int systemUiVisibility = attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility;
                    if ((systemUiVisibility & 0x3FF0000) != 0 && !hasStatusBarPermission) {
                        systemUiVisibility &= 0xFC00FFFF;
                    }
                    win.mSystemUiVisibility = systemUiVisibility;
                }
                if (win.mAttrs.type != attrs.type) {
                    throw new IllegalArgumentException("Window type can not be changed after the window is added.");
                }
                if ((attrs.privateFlags & 0x2000) != 0) {
                    attrs.x = win.mAttrs.x;
                    attrs.y = win.mAttrs.y;
                    attrs.width = win.mAttrs.width;
                    attrs.height = win.mAttrs.height;
                }
                flagChanges = win.mAttrs.flags ^= attrs.flags;
                attrChanges = win.mAttrs.copyFrom(attrs);
                if ((attrChanges & 0x4001) != 0) {
                    win.mLayoutNeeded = true;
                }
            }
            winAnimator.mSurfaceDestroyDeferred = (flags & 2) != 0;
            boolean bl = win.mEnforceSizeCompat = (win.mAttrs.privateFlags & 0x80) != 0;
            if ((attrChanges & 0x80) != 0) {
                winAnimator.mAlpha = attrs.alpha;
            }
            win.setWindowScale(win.mRequestedWidth, win.mRequestedHeight);
            if (win.mAttrs.surfaceInsets.left != 0 || win.mAttrs.surfaceInsets.top != 0 || win.mAttrs.surfaceInsets.right != 0 || win.mAttrs.surfaceInsets.bottom != 0) {
                winAnimator.setOpaqueLocked(false);
            }
            boolean imMayMove = (flagChanges & 0x20008) != 0;
            boolean isDefaultDisplay = win.isDefaultDisplay();
            boolean focusMayChange = isDefaultDisplay && (win.mViewVisibility != viewVisibility || (flagChanges & 8) != 0 || !win.mRelayoutCalled);
            boolean wallpaperMayMove = win.mViewVisibility != viewVisibility && (win.mAttrs.flags & 0x100000) != 0;
            wallpaperMayMove |= (flagChanges & 0x100000) != 0;
            if ((flagChanges & 0x2000) != 0 && winAnimator.mSurfaceController != null) {
                winAnimator.mSurfaceController.setSecure(this.isSecureLocked(win));
            }
            win.mRelayoutCalled = true;
            win.mInRelayout = true;
            int oldVisibility = win.mViewVisibility;
            win.mViewVisibility = viewVisibility;
            if (!(viewVisibility != 0 || win.mAppToken != null && win.mAppToken.clientHidden)) {
                result = this.relayoutVisibleWindow(outConfig, result, win, winAnimator, attrChanges, oldVisibility);
                try {
                    result = this.createSurfaceControl(outSurface, result, win, winAnimator);
                }
                catch (Exception e) {
                    this.mInputMonitor.updateInputWindowsLw(true);
                    Slog.w(TAG, "Exception thrown when creating surface for client " + client + " (" + win.mAttrs.getTitle() + ")", e);
                    Binder.restoreCallingIdentity(origId);
                    return 0;
                }
                if ((result & 2) != 0) {
                    focusMayChange = isDefaultDisplay;
                }
                if (win.mAttrs.type == 2011 && this.mInputMethodWindow == null) {
                    this.mInputMethodWindow = win;
                    imMayMove = true;
                }
                win.adjustStartingWindowFlags();
            } else {
                boolean usingSavedSurfaceBeforeVisible;
                winAnimator.mEnterAnimationPending = false;
                winAnimator.mEnteringAnimation = false;
                boolean bl2 = usingSavedSurfaceBeforeVisible = oldVisibility != 0 && win.isAnimatingWithSavedSurface();
                if (winAnimator.hasSurface() && !win.mAnimatingExit && !usingSavedSurfaceBeforeVisible) {
                    if (!win.mWillReplaceWindow) {
                        focusMayChange = this.tryStartExitingAnimation(win, winAnimator, isDefaultDisplay, focusMayChange);
                    }
                    result |= 4;
                }
                WindowSurfaceController surfaceController = winAnimator.mSurfaceController;
                if (viewVisibility == 0 && surfaceController != null) {
                    surfaceController.getSurface(outSurface);
                } else {
                    try {
                        Trace.traceBegin(32L, "wmReleaseOutSurface_" + win.mAttrs.getTitle());
                        outSurface.release();
                    }
                    finally {
                        Trace.traceEnd(32L);
                    }
                }
            }
            if (focusMayChange && this.updateFocusedWindowLocked(3, false)) {
                imMayMove = false;
            }
            boolean bl3 = toBeDisplayed = (result & 2) != 0;
            if (imMayMove && (this.moveInputMethodWindowsIfNeededLocked(false) || toBeDisplayed)) {
                this.mLayersController.assignLayersLocked(win.getWindowList());
            }
            if (wallpaperMayMove) {
                this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
            }
            win.setDisplayLayoutNeeded();
            win.mGivenInsetsPending = (flags & 1) != 0;
            configChanged = this.updateOrientationFromAppTokensLocked(false);
            this.mWindowPlacerLocked.performSurfacePlacement();
            if (toBeDisplayed && win.mIsWallpaper) {
                DisplayInfo displayInfo = this.getDefaultDisplayInfoLocked();
                this.mWallpaperControllerLocked.updateWallpaperOffset(win, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
            }
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
            if (winAnimator.mReportSurfaceResized) {
                winAnimator.mReportSurfaceResized = false;
                result |= 0x20;
            }
            if (this.mPolicy.isNavBarForcedShownLw(win)) {
                result |= 0x40;
            }
            if (!win.isGoneForLayoutLw()) {
                win.mResizedWhileGone = false;
            }
            outFrame.set(win.mCompatFrame);
            outOverscanInsets.set(win.mOverscanInsets);
            outContentInsets.set(win.mContentInsets);
            outVisibleInsets.set(win.mVisibleInsets);
            outStableInsets.set(win.mStableInsets);
            outOutsets.set(win.mOutsets);
            outBackdropFrame.set(win.getBackdropFrame(win.mFrame));
            result |= this.mInTouchMode ? 1 : 0;
            this.mInputMonitor.updateInputWindowsLw(true);
            win.mInRelayout = false;
        }
        if (configChanged) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
        return result;
    }

    private boolean tryStartExitingAnimation(WindowState win, WindowStateAnimator winAnimator, boolean isDefaultDisplay, boolean focusMayChange) {
        int transit = 2;
        if (win.mAttrs.type == 3) {
            transit = 5;
        }
        if (win.isWinVisibleLw() && winAnimator.applyAnimationLocked(transit, false)) {
            focusMayChange = isDefaultDisplay;
            win.mAnimatingExit = true;
            win.mWinAnimator.mAnimating = true;
        } else if (win.mWinAnimator.isAnimationSet()) {
            win.mAnimatingExit = true;
            win.mWinAnimator.mAnimating = true;
        } else if (this.mWallpaperControllerLocked.isWallpaperTarget(win)) {
            win.mAnimatingExit = true;
            win.mWinAnimator.mAnimating = true;
        } else {
            if (this.mInputMethodWindow == win) {
                this.mInputMethodWindow = null;
            }
            win.destroyOrSaveSurface();
        }
        if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
            this.mAccessibilityController.onWindowTransitionLocked(win, transit);
        }
        return focusMayChange;
    }

    private int createSurfaceControl(Surface outSurface, int result, WindowState win, WindowStateAnimator winAnimator) {
        WindowSurfaceController surfaceController;
        if (!win.mHasSurface) {
            result |= 4;
        }
        if ((surfaceController = winAnimator.createSurfaceLocked()) != null) {
            surfaceController.getSurface(outSurface);
        } else {
            Slog.w(TAG, "Failed to create surface control for " + win);
            outSurface.release();
        }
        return result;
    }

    private int relayoutVisibleWindow(Configuration outConfig, int result, WindowState win, WindowStateAnimator winAnimator, int attrChanges, int oldVisibility) {
        result |= !win.isVisibleLw() ? 2 : 0;
        if (win.mAnimatingExit) {
            Slog.d(TAG, "relayoutVisibleWindow: " + win + " mAnimatingExit=true, mRemoveOnExit=" + win.mRemoveOnExit + ", mDestroying=" + win.mDestroying);
            winAnimator.cancelExitAnimationForNextAnimationLocked();
            win.mAnimatingExit = false;
        }
        if (win.mDestroying) {
            win.mDestroying = false;
            this.mDestroySurface.remove(win);
        }
        if (oldVisibility == 8) {
            winAnimator.mEnterAnimationPending = true;
        }
        win.mLastVisibleLayoutRotation = this.mRotation;
        winAnimator.mEnteringAnimation = true;
        if ((result & 2) != 0) {
            win.prepareWindowToDisplayDuringRelayout(outConfig);
        }
        if ((attrChanges & 8) != 0 && !winAnimator.tryChangeFormatInPlaceLocked()) {
            winAnimator.preserveSurfaceLocked();
            result |= 6;
        }
        if (win.isDragResizeChanged() || win.isResizedWhileNotDragResizing()) {
            win.setDragResizing();
            win.setResizedWhileNotDragResizing(false);
            if (win.mHasSurface && win.mAttachedWindow == null) {
                winAnimator.preserveSurfaceLocked();
                result |= 2;
            }
        }
        boolean freeformResizing = win.isDragResizing() && win.getResizeMode() == 0;
        boolean dockedResizing = win.isDragResizing() && win.getResizeMode() == 1;
        result |= freeformResizing ? 16 : 0;
        result |= dockedResizing ? 8 : 0;
        if (win.isAnimatingWithSavedSurface()) {
            result |= 2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDeferredDestroyWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win;
                block8: {
                    win = this.windowForClientLocked(session, client, false);
                    if (win != null && !win.mWillReplaceWindow) break block8;
                    return;
                }
                win.mWinAnimator.destroyDeferredSurfaceLocked();
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean outOfMemoryWindow(Session session, IWindow client) {
        WindowState win;
        long origId;
        block6: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                // MONITORENTER : hashMap
                win = this.windowForClientLocked(session, client, false);
                if (win != null) break block6;
                bl = false;
                // MONITOREXIT : hashMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        boolean bl = this.reclaimSomeSurfaceMemoryLocked(win.mWinAnimator, "from-client", false);
        // MONITOREXIT : hashMap
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDrawingWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win = this.windowForClientLocked(session, client, false);
                if (win != null && win.mWinAnimator.finishDrawingLocked()) {
                    if ((win.mAttrs.flags & 0x100000) != 0) {
                        this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
                    }
                    win.setDisplayLayoutNeeded();
                    this.mWindowPlacerLocked.requestTraversal();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private boolean applyAnimationLocked(AppWindowToken atoken, WindowManager.LayoutParams lp, int transit, boolean enter, boolean isVoiceInteraction) {
        Trace.traceBegin(32L, "WM#applyAnimationLocked");
        if (this.okToDisplay()) {
            Animation a;
            boolean freeform;
            DisplayInfo displayInfo = this.getDefaultDisplayInfoLocked();
            int width = displayInfo.appWidth;
            int height = displayInfo.appHeight;
            WindowState win = atoken.findMainWindow();
            Rect frame = new Rect(0, 0, width, height);
            Rect displayFrame = new Rect(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
            Rect insets = new Rect();
            Rect surfaceInsets = null;
            boolean bl = freeform = win != null && win.inFreeformWorkspace();
            if (win != null) {
                if (freeform) {
                    frame.set(win.mFrame);
                } else {
                    frame.set(win.mContainingFrame);
                }
                surfaceInsets = win.getAttrs().surfaceInsets;
                insets.set(win.mContentInsets);
            }
            if (atoken.mLaunchTaskBehind) {
                enter = false;
            }
            if ((a = this.mAppTransition.loadAnimation(lp, transit, enter, this.mCurConfiguration.uiMode, this.mCurConfiguration.orientation, frame, displayFrame, insets, surfaceInsets, isVoiceInteraction, freeform, atoken.mTask.mTaskId)) != null) {
                int containingWidth = frame.width();
                int containingHeight = frame.height();
                atoken.mAppAnimator.setAnimation(a, containingWidth, containingHeight, this.mAppTransition.canSkipFirstFrame(), this.mAppTransition.getAppStackClipMode());
            }
        } else {
            atoken.mAppAnimator.clearAnimation();
        }
        Trace.traceEnd(32L);
        return atoken.mAppAnimator.animation != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAppTokens(int stackId, List<TaskGroup> tasks) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int taskNdx;
            int t = tasks.size() - 1;
            if (t < 0) {
                Slog.w(TAG, "validateAppTokens: empty task list");
                return;
            }
            TaskGroup task = tasks.get(0);
            int taskId = task.taskId;
            Task targetTask = this.mTaskIdToTask.get(taskId);
            DisplayContent displayContent = targetTask.getDisplayContent();
            if (displayContent == null) {
                Slog.w(TAG, "validateAppTokens: no Display for taskId=" + taskId);
                return;
            }
            ArrayList<Task> localTasks = this.mStackIdToStack.get(stackId).getTasks();
            for (taskNdx = localTasks.size() - 1; taskNdx >= 0 && t >= 0; --taskNdx, --t) {
                AppTokenList localTokens = localTasks.get((int)taskNdx).mAppTokens;
                task = tasks.get(t);
                ArrayList<IApplicationToken> tokens = task.tokens;
                DisplayContent lastDisplayContent = displayContent;
                displayContent = this.mTaskIdToTask.get(taskId).getDisplayContent();
                if (displayContent != lastDisplayContent) {
                    Slog.w(TAG, "validateAppTokens: displayContent changed in TaskGroup list!");
                    return;
                }
                int tokenNdx = localTokens.size() - 1;
                int v = task.tokens.size() - 1;
                while (tokenNdx >= 0 && v >= 0) {
                    AppWindowToken atoken = (AppWindowToken)localTokens.get(tokenNdx);
                    if (atoken.removed) {
                        --tokenNdx;
                        continue;
                    }
                    if (tokens.get(v) != atoken.token) break;
                    --tokenNdx;
                    --v;
                }
                if (tokenNdx >= 0 || v >= 0) break;
            }
            if (taskNdx >= 0 || t >= 0) {
                Slog.w(TAG, "validateAppTokens: Mismatch! ActivityManager=" + tasks);
                Slog.w(TAG, "validateAppTokens: Mismatch! WindowManager=" + localTasks);
                Slog.w(TAG, "validateAppTokens: Mismatch! Callers=" + Debug.getCallers(4));
            }
        }
    }

    public void validateStackOrder(Integer[] remoteStackIds) {
    }

    private boolean checkCallingPermission(String permission2, String func) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        if (this.mContext.checkCallingPermission(permission2) == 0) {
            return true;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w(TAG, msg);
        return false;
    }

    boolean okToDisplay() {
        return !this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOn();
    }

    AppWindowToken findAppWindowToken(IBinder token) {
        WindowToken wtoken = this.mTokenMap.get(token);
        if (wtoken == null) {
            return null;
        }
        return wtoken.appWindowToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWindowToken(IBinder token, int type) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken wtoken = this.mTokenMap.get(token);
            if (wtoken != null) {
                Slog.w(TAG, "Attempted to add existing input method token: " + token);
                return;
            }
            wtoken = new WindowToken(this, token, type, true);
            this.mTokenMap.put(token, wtoken);
            if (type == 2013) {
                this.mWallpaperControllerLocked.addWallpaperToken(wtoken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWindowToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = null;
            WindowToken wtoken = this.mTokenMap.remove(token);
            if (wtoken != null) {
                boolean delayed = false;
                if (!wtoken.hidden) {
                    int N = wtoken.windows.size();
                    boolean changed = false;
                    for (int i = 0; i < N; ++i) {
                        WindowState win = (WindowState)wtoken.windows.get(i);
                        displayContent = win.getDisplayContent();
                        if (win.mWinAnimator.isAnimationSet()) {
                            delayed = true;
                        }
                        if (!win.isVisibleNow()) continue;
                        win.mWinAnimator.applyAnimationLocked(2, false);
                        if (this.mAccessibilityController != null && win.isDefaultDisplay()) {
                            this.mAccessibilityController.onWindowTransitionLocked(win, 2);
                        }
                        changed = true;
                        if (displayContent == null) continue;
                        displayContent.layoutNeeded = true;
                    }
                    wtoken.hidden = true;
                    if (changed) {
                        this.mWindowPlacerLocked.performSurfacePlacement();
                        this.updateFocusedWindowLocked(0, false);
                    }
                    if (delayed && displayContent != null) {
                        displayContent.mExitingTokens.add(wtoken);
                    } else if (wtoken.windowType == 2013) {
                        this.mWallpaperControllerLocked.removeWallpaperToken(wtoken);
                    }
                } else if (wtoken.windowType == 2013) {
                    this.mWallpaperControllerLocked.removeWallpaperToken(wtoken);
                }
                this.mInputMonitor.updateInputWindowsLw(true);
            } else {
                Slog.w(TAG, "Attempted to remove non-existing token: " + token);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    private Task createTaskLocked(int taskId, int stackId, int userId, AppWindowToken atoken, Rect bounds, Configuration config) {
        TaskStack stack = this.mStackIdToStack.get(stackId);
        if (stack == null) {
            throw new IllegalArgumentException("addAppToken: invalid stackId=" + stackId);
        }
        EventLog.writeEvent(31001, taskId, stackId);
        Task task = new Task(taskId, stack, userId, this, bounds, config);
        this.mTaskIdToTask.put(taskId, task);
        stack.addTask(task, !atoken.mLaunchTaskBehind, atoken.showForAllUsers);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppToken(int addPos, IApplicationToken token, int taskId, int stackId, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int userId, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, Rect taskBounds, Configuration config, int taskResizeMode, boolean alwaysFocusable, boolean homeTask, int targetSdkVersion, int rotationAnimationHint) {
        long inputDispatchingTimeoutNanos;
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        try {
            inputDispatchingTimeoutNanos = token.getKeyDispatchingTimeout() * 1000000L;
        }
        catch (RemoteException ex) {
            Slog.w(TAG, "Could not get dispatching timeout.", ex);
            inputDispatchingTimeoutNanos = 5000000000L;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token.asBinder());
            if (atoken != null) {
                Slog.w(TAG, "Attempted to add existing app token: " + token);
                return;
            }
            atoken = new AppWindowToken(this, token, voiceInteraction);
            atoken.inputDispatchingTimeoutNanos = inputDispatchingTimeoutNanos;
            atoken.appFullscreen = fullscreen;
            atoken.showForAllUsers = showForAllUsers;
            atoken.targetSdk = targetSdkVersion;
            atoken.requestedOrientation = requestedOrientation;
            atoken.layoutConfigChanges = (configChanges & 0x480) != 0;
            atoken.mLaunchTaskBehind = launchTaskBehind;
            atoken.mAlwaysFocusable = alwaysFocusable;
            atoken.mRotationAnimationHint = rotationAnimationHint;
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                task = this.createTaskLocked(taskId, stackId, userId, atoken, taskBounds, config);
            }
            task.addAppToken(addPos, atoken, taskResizeMode, homeTask);
            this.mTokenMap.put(token.asBinder(), atoken);
            atoken.hidden = true;
            atoken.hiddenRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppTask(IBinder token, int taskId, int stackId, Rect taskBounds, Configuration config, int taskResizeMode, boolean homeTask) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppTask()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token);
            if (atoken == null) {
                Slog.w(TAG, "Attempted to set task id of non-existing app token: " + token);
                return;
            }
            Task oldTask = atoken.mTask;
            oldTask.removeAppToken(atoken);
            Task newTask = this.mTaskIdToTask.get(taskId);
            if (newTask == null) {
                newTask = this.createTaskLocked(taskId, stackId, oldTask.mUserId, atoken, taskBounds, config);
            }
            newTask.addAppToken(Integer.MAX_VALUE, atoken, taskResizeMode, homeTask);
        }
    }

    public int getOrientationLocked() {
        if (this.mDisplayFrozen) {
            if (this.mLastWindowForcedOrientation != -1) {
                return this.mLastWindowForcedOrientation;
            }
            if (this.mPolicy.isKeyguardLocked()) {
                return this.mLastOrientation;
            }
        } else {
            int req;
            WindowList windows = this.getDefaultWindowListLocked();
            for (int pos = windows.size() - 1; pos >= 0; --pos) {
                WindowState win = (WindowState)windows.get(pos);
                if (win.mAppToken != null) break;
                if (!win.isVisibleLw() || !win.mPolicyVisibilityAfterAnim || (req = win.mAttrs.screenOrientation) == -1 || req == 3) continue;
                if (this.mPolicy.isKeyguardHostWindow(win.mAttrs)) {
                    this.mLastKeyguardForcedOrientation = req;
                }
                this.mLastWindowForcedOrientation = req;
                return this.mLastWindowForcedOrientation;
            }
            this.mLastWindowForcedOrientation = -1;
            if (this.mPolicy.isKeyguardLocked()) {
                AppWindowToken appShowWhenLocked;
                WindowState winShowWhenLocked = (WindowState)this.mPolicy.getWinShowWhenLockedLw();
                AppWindowToken appWindowToken = appShowWhenLocked = winShowWhenLocked == null ? null : winShowWhenLocked.mAppToken;
                if (appShowWhenLocked != null) {
                    req = appShowWhenLocked.requestedOrientation;
                    if (req == 3) {
                        req = this.mLastKeyguardForcedOrientation;
                    }
                    return req;
                }
                return this.mLastKeyguardForcedOrientation;
            }
        }
        return this.getAppSpecifiedOrientation();
    }

    private int getAppSpecifiedOrientation() {
        int lastOrientation = -1;
        boolean findingBehind = false;
        boolean lastFullscreen = false;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        ArrayList<Task> tasks = displayContent.getTasks();
        boolean inMultiWindow = this.isStackVisibleLocked(3) || this.isStackVisibleLocked(2);
        boolean dockMinimized = this.getDefaultDisplayContentLocked().mDividerControllerLocked.isMinimizedDock();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            int firstToken;
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            for (int tokenNdx = firstToken = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                AppWindowToken atoken = (AppWindowToken)tokens.get(tokenNdx);
                if (!findingBehind && !atoken.hidden && atoken.hiddenRequested) continue;
                if (tokenNdx == firstToken && lastOrientation != 3 && lastFullscreen) {
                    return lastOrientation;
                }
                if (atoken.hiddenRequested || inMultiWindow && (!atoken.mTask.isHomeTask() || !dockMinimized)) continue;
                if (tokenNdx == 0) {
                    lastOrientation = atoken.requestedOrientation;
                }
                int or = atoken.requestedOrientation;
                lastFullscreen = atoken.appFullscreen;
                if (lastFullscreen && or != 3) {
                    return or;
                }
                if (or != -1 && or != 3) {
                    return or;
                }
                findingBehind |= or == 3;
            }
        }
        return inMultiWindow ? -1 : this.mLastOrientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "updateOrientationFromAppTokens()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        Configuration config = null;
        long ident = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            config = this.updateOrientationFromAppTokensLocked(currentConfig, freezeThisOneIfNeeded);
        }
        Binder.restoreCallingIdentity(ident);
        return config;
    }

    private Configuration updateOrientationFromAppTokensLocked(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = null;
        if (this.updateOrientationFromAppTokensLocked(false)) {
            AppWindowToken atoken;
            if (freezeThisOneIfNeeded != null && (atoken = this.findAppWindowToken(freezeThisOneIfNeeded)) != null) {
                this.startAppFreezingScreenLocked(atoken);
            }
            config = this.computeNewConfigurationLocked();
        } else if (currentConfig != null) {
            this.mTempConfiguration.setToDefaults();
            this.mTempConfiguration.updateFrom(currentConfig);
            this.computeScreenConfigurationLocked(this.mTempConfiguration);
            if (currentConfig.diff(this.mTempConfiguration) != 0) {
                this.mWaitingForConfig = true;
                DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                displayContent.layoutNeeded = true;
                int[] anim2 = new int[2];
                if (displayContent.isDimming()) {
                    anim2[1] = 0;
                    anim2[0] = 0;
                } else {
                    this.mPolicy.selectRotationAnimationLw(anim2);
                }
                this.startFreezingDisplayLocked(false, anim2[0], anim2[1]);
                config = new Configuration(this.mTempConfiguration);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOrientationFromAppTokensLocked(boolean inTransaction) {
        long ident = Binder.clearCallingIdentity();
        try {
            int req = this.getOrientationLocked();
            if (req != this.mLastOrientation) {
                this.mLastOrientation = req;
                this.mPolicy.setCurrentOrientationLw(req);
                if (this.updateRotationUncheckedLocked(inTransaction)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] setNewConfiguration(Configuration config) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setNewConfiguration()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean configChanged;
            if (this.mWaitingForConfig) {
                this.mWaitingForConfig = false;
                this.mLastFinishedFreezeSource = "new-config";
            }
            boolean bl = configChanged = this.mCurConfiguration.diff(config) != 0;
            if (!configChanged) {
                return null;
            }
            this.prepareFreezingAllTaskBounds();
            this.mCurConfiguration = new Configuration(config);
            return this.onConfigurationChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rect getBoundsForNewConfiguration(int stackId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            Rect outBounds = new Rect();
            stack.getBoundsForNewConfiguration(outBounds);
            return outBounds;
        }
    }

    private void prepareFreezingAllTaskBounds() {
        for (int i = this.mDisplayContents.size() - 1; i >= 0; --i) {
            ArrayList<TaskStack> stacks = this.mDisplayContents.valueAt(i).getStacks();
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                TaskStack stack = stacks.get(stackNdx);
                stack.prepareFreezingTaskBounds();
            }
        }
    }

    private int[] onConfigurationChanged() {
        this.mPolicy.onConfigurationChanged();
        DisplayContent defaultDisplayContent = this.getDefaultDisplayContentLocked();
        if (!this.mReconfigureOnConfigurationChanged.contains(defaultDisplayContent)) {
            this.mReconfigureOnConfigurationChanged.add(defaultDisplayContent);
        }
        for (int i = this.mReconfigureOnConfigurationChanged.size() - 1; i >= 0; --i) {
            this.reconfigureDisplayLocked((DisplayContent)this.mReconfigureOnConfigurationChanged.remove(i));
        }
        defaultDisplayContent.getDockedDividerController().onConfigurationChanged();
        this.mChangedStackList.clear();
        for (int stackNdx = this.mStackIdToStack.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = this.mStackIdToStack.valueAt(stackNdx);
            if (!stack.onConfigurationChanged()) continue;
            this.mChangedStackList.add(stack.mStackId);
        }
        return this.mChangedStackList.isEmpty() ? null : ArrayUtils.convertToIntArray(this.mChangedStackList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppOrientation(IApplicationToken token, int requestedOrientation) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppOrientation()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token.asBinder());
            if (atoken == null) {
                Slog.w(TAG, "Attempted to set orientation of non-existing app token: " + token);
                return;
            }
            atoken.requestedOrientation = requestedOrientation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAppOrientation(IApplicationToken token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token.asBinder());
            if (wtoken == null) {
                return -1;
            }
            return wtoken.requestedOrientation;
        }
    }

    void setFocusTaskRegionLocked() {
        Task task;
        DisplayContent displayContent;
        if (this.mFocusedApp != null && (displayContent = (task = this.mFocusedApp.mTask).getDisplayContent()) != null) {
            displayContent.setTouchExcludeRegion(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedApp(IBinder token, boolean moveFocusNow) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setFocusedApp()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean changed;
            AppWindowToken newFocus;
            if (token == null) {
                newFocus = null;
            } else {
                newFocus = this.findAppWindowToken(token);
                if (newFocus == null) {
                    Slog.w(TAG, "Attempted to set focus to non-existing app token: " + token);
                }
            }
            boolean bl = changed = this.mFocusedApp != newFocus;
            if (changed) {
                this.mFocusedApp = newFocus;
                this.mInputMonitor.setFocusedAppLw(newFocus);
                this.setFocusTaskRegionLocked();
            }
            if (moveFocusNow && changed) {
                long origId = Binder.clearCallingIdentity();
                this.updateFocusedWindowLocked(0, true);
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "prepareAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean prepared = this.mAppTransition.prepareAppTransitionLocked(transit, alwaysKeepCurrent);
            if (prepared && this.okToDisplay()) {
                this.mSkipAppTransitionAnimation = false;
            }
        }
    }

    @Override
    public int getPendingAppTransition() {
        return this.mAppTransition.getAppTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransition(packageName, enterAnim, exitAnim, startedCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionScaleUp(startX, startY, startWidth, startHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionClipReveal(int startX, int startY, int startWidth, int startHeight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionClipReveal(startX, startY, startWidth, startHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionThumb(Bitmap srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionThumb(srcThumb, startX, startY, startedCallback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionAspectScaledThumb(Bitmap srcThumb, int startX, int startY, int targetWidth, int targetHeight, IRemoteCallback startedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionAspectScaledThumb(srcThumb, startX, startY, targetWidth, targetHeight, startedCallback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionMultiThumb(AppTransitionAnimationSpec[] specs, IRemoteCallback onAnimationStartedCallback, IRemoteCallback onAnimationFinishedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionMultiThumb(specs, onAnimationStartedCallback, onAnimationFinishedCallback, scaleUp);
            this.prolongAnimationsFromSpecs(specs, scaleUp);
        }
    }

    void prolongAnimationsFromSpecs(AppTransitionAnimationSpec[] specs, boolean scaleUp) {
        this.mTmpTaskIds.clear();
        for (int i = specs.length - 1; i >= 0; --i) {
            this.mTmpTaskIds.put(specs[i].taskId, 0);
        }
        for (WindowState win : this.mWindowMap.values()) {
            AppWindowToken appToken;
            Task task = win.getTask();
            if (task == null || this.mTmpTaskIds.get(task.mTaskId, -1) == -1 || !task.inFreeformWorkspace() || (appToken = win.mAppToken) == null || appToken.mAppAnimator == null) continue;
            appToken.mAppAnimator.startProlongAnimation(scaleUp ? 2 : 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionInPlace(String packageName, int anim2) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overrideInPlaceAppTransition(packageName, anim2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback callback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionMultiThumbFuture(specsFuture, callback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endProlongedAnimations() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (WindowState win : this.mWindowMap.values()) {
                AppWindowToken appToken = win.mAppToken;
                if (appToken == null || appToken.mAppAnimator == null) continue;
                appToken.mAppAnimator.endProlongedAnimation();
            }
            this.mAppTransition.notifyProlongedAnimationsEnded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAppTransition() {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "executeAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mAppTransition.isTransitionSet()) {
                this.mAppTransition.setReady();
                long origId = Binder.clearCallingIdentity();
                try {
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAppStartingWindow(IBinder token, String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean createIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppStartingWindow()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set icon of non-existing app token: " + token);
                return false;
            }
            if (!this.okToDisplay()) {
                return false;
            }
            if (wtoken.startingData != null) {
                return false;
            }
            if (theme != 0) {
                AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mCurrentUserId);
                if (ent == null) {
                    return false;
                }
                boolean windowIsTranslucent = ent.array.getBoolean(5, false);
                boolean windowIsFloating = ent.array.getBoolean(4, false);
                boolean windowShowWallpaper = ent.array.getBoolean(14, false);
                boolean windowDisableStarting = ent.array.getBoolean(12, false);
                if (windowIsTranslucent) {
                    return false;
                }
                if (windowIsFloating || windowDisableStarting) {
                    return false;
                }
                if (windowShowWallpaper) {
                    if (this.mWallpaperControllerLocked.getWallpaperTarget() == null) {
                        windowFlags |= 0x100000;
                    } else {
                        return false;
                    }
                }
            }
            if (this.transferStartingWindow(transferFrom, wtoken)) {
                return true;
            }
            if (!createIfNeeded) {
                return false;
            }
            wtoken.startingData = new StartingData(pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags);
            Message m = this.mH.obtainMessage(5, wtoken);
            this.mH.sendMessageAtFrontOfQueue(m);
        }
        return true;
    }

    private boolean transferStartingWindow(IBinder transferFrom, AppWindowToken wtoken) {
        if (transferFrom == null) {
            return false;
        }
        AppWindowToken ttoken = this.findAppWindowToken(transferFrom);
        if (ttoken == null) {
            return false;
        }
        WindowState startingWindow = ttoken.startingWindow;
        if (startingWindow != null && ttoken.startingView != null) {
            this.mSkipAppTransitionAnimation = true;
            long origId = Binder.clearCallingIdentity();
            wtoken.startingData = ttoken.startingData;
            wtoken.startingView = ttoken.startingView;
            wtoken.startingDisplayed = ttoken.startingDisplayed;
            ttoken.startingDisplayed = false;
            wtoken.startingWindow = startingWindow;
            wtoken.reportedVisible = ttoken.reportedVisible;
            ttoken.startingData = null;
            ttoken.startingView = null;
            ttoken.startingWindow = null;
            ttoken.startingMoved = true;
            startingWindow.mToken = wtoken;
            startingWindow.mRootToken = wtoken;
            startingWindow.mAppToken = wtoken;
            startingWindow.getWindowList().remove(startingWindow);
            this.mWindowsChanged = true;
            ttoken.windows.remove(startingWindow);
            ttoken.allAppWindows.remove(startingWindow);
            this.addWindowToListInOrderLocked(startingWindow, true);
            if (ttoken.allDrawn) {
                wtoken.allDrawn = true;
                wtoken.deferClearAllDrawn = ttoken.deferClearAllDrawn;
            }
            if (ttoken.firstWindowDrawn) {
                wtoken.firstWindowDrawn = true;
            }
            if (!ttoken.hidden) {
                wtoken.hidden = false;
                wtoken.hiddenRequested = false;
            }
            if (wtoken.clientHidden != ttoken.clientHidden) {
                wtoken.clientHidden = ttoken.clientHidden;
                wtoken.sendAppVisibilityToClients();
            }
            ttoken.mAppAnimator.transferCurrentAnimation(wtoken.mAppAnimator, startingWindow.mWinAnimator);
            this.updateFocusedWindowLocked(3, true);
            this.getDefaultDisplayContentLocked().layoutNeeded = true;
            this.mWindowPlacerLocked.performSurfacePlacement();
            Binder.restoreCallingIdentity(origId);
            return true;
        }
        if (ttoken.startingData != null) {
            wtoken.startingData = ttoken.startingData;
            ttoken.startingData = null;
            ttoken.startingMoved = true;
            Message m = this.mH.obtainMessage(5, wtoken);
            this.mH.sendMessageAtFrontOfQueue(m);
            return true;
        }
        AppWindowAnimator tAppAnimator = ttoken.mAppAnimator;
        AppWindowAnimator wAppAnimator = wtoken.mAppAnimator;
        if (tAppAnimator.thumbnail != null) {
            if (wAppAnimator.thumbnail != null) {
                wAppAnimator.thumbnail.destroy();
            }
            wAppAnimator.thumbnail = tAppAnimator.thumbnail;
            wAppAnimator.thumbnailLayer = tAppAnimator.thumbnailLayer;
            wAppAnimator.thumbnailAnimation = tAppAnimator.thumbnailAnimation;
            tAppAnimator.thumbnail = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppStartingWindow(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.mTokenMap.get((Object)token).appWindowToken;
            this.scheduleRemoveStartingWindowLocked(wtoken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppFullscreen(IBinder token, boolean toOpaque) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token);
            if (atoken != null) {
                atoken.appFullscreen = toOpaque;
                this.setWindowOpaqueLocked(token, toOpaque);
                this.mWindowPlacerLocked.requestTraversal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowOpaque(IBinder token, boolean isOpaque) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.setWindowOpaqueLocked(token, isOpaque);
        }
    }

    public void setWindowOpaqueLocked(IBinder token, boolean isOpaque) {
        WindowState win;
        AppWindowToken wtoken = this.findAppWindowToken(token);
        if (wtoken != null && (win = wtoken.findMainWindow()) != null) {
            win.mWinAnimator.setOpaqueLocked(isOpaque);
        }
    }

    boolean setTokenVisibilityLocked(AppWindowToken wtoken, WindowManager.LayoutParams lp, boolean visible, int transit, boolean performLayout, boolean isVoiceInteraction) {
        boolean delayed = false;
        if (wtoken.clientHidden == visible) {
            wtoken.clientHidden = !visible;
            wtoken.sendAppVisibilityToClients();
        }
        boolean visibilityChanged = false;
        if (wtoken.hidden == visible || wtoken.hidden && wtoken.mIsExiting || visible && wtoken.waitingForReplacement()) {
            boolean changed = false;
            boolean runningAppAnimation = false;
            if (transit != -1) {
                WindowState window;
                if (wtoken.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation) {
                    wtoken.mAppAnimator.setNullAnimation();
                }
                if (this.applyAnimationLocked(wtoken, lp, transit, visible, isVoiceInteraction)) {
                    runningAppAnimation = true;
                    delayed = true;
                }
                if ((window = wtoken.findMainWindow()) != null && this.mAccessibilityController != null && window.getDisplayId() == 0) {
                    this.mAccessibilityController.onAppWindowTransitionLocked(window, transit);
                }
                changed = true;
            }
            int windowsCount = wtoken.allAppWindows.size();
            for (int i = 0; i < windowsCount; ++i) {
                WindowState win = (WindowState)wtoken.allAppWindows.get(i);
                if (win == wtoken.startingWindow) {
                    if (visible || !win.isVisibleNow() || !wtoken.mAppAnimator.isAnimating()) continue;
                    win.mAnimatingExit = true;
                    win.mRemoveOnExit = true;
                    win.mWindowRemovalAllowed = true;
                    continue;
                }
                if (visible) {
                    if (win.isVisibleNow()) continue;
                    if (!runningAppAnimation) {
                        win.mWinAnimator.applyAnimationLocked(1, true);
                        if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
                            this.mAccessibilityController.onWindowTransitionLocked(win, 1);
                        }
                    }
                    changed = true;
                    win.setDisplayLayoutNeeded();
                    continue;
                }
                if (!win.isVisibleNow()) continue;
                if (!runningAppAnimation) {
                    win.mWinAnimator.applyAnimationLocked(2, false);
                    if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
                        this.mAccessibilityController.onWindowTransitionLocked(win, 2);
                    }
                }
                changed = true;
                win.setDisplayLayoutNeeded();
            }
            wtoken.hiddenRequested = !visible;
            wtoken.hidden = wtoken.hiddenRequested;
            visibilityChanged = true;
            if (!visible) {
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
            } else {
                WindowState swin = wtoken.startingWindow;
                if (swin != null && !swin.isDrawnLw()) {
                    swin.mPolicyVisibility = false;
                    swin.mPolicyVisibilityAfterAnim = false;
                }
            }
            if (changed) {
                this.mInputMonitor.setUpdateInputWindowsNeededLw();
                if (performLayout) {
                    this.updateFocusedWindowLocked(3, false);
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
                this.mInputMonitor.updateInputWindowsLw(false);
            }
        }
        if (wtoken.mAppAnimator.animation != null) {
            delayed = true;
        }
        for (int i = wtoken.allAppWindows.size() - 1; i >= 0 && !delayed; --i) {
            if (!((WindowState)wtoken.allAppWindows.get((int)i)).mWinAnimator.isWindowAnimationSet()) continue;
            delayed = true;
        }
        if (visibilityChanged) {
            if (visible && !delayed) {
                wtoken.mEnteringAnimation = true;
                this.mActivityManagerAppTransitionNotifier.onAppTransitionFinishedLocked(wtoken.token);
            }
            if (!this.mClosingApps.contains(wtoken) && !this.mOpeningApps.contains(wtoken)) {
                this.getDefaultDisplayContentLocked().getDockedDividerController().notifyAppVisibilityChanged();
            }
        }
        return delayed;
    }

    void updateTokenInPlaceLocked(AppWindowToken wtoken, int transit) {
        if (transit != -1) {
            if (wtoken.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation) {
                wtoken.mAppAnimator.setNullAnimation();
            }
            this.applyAnimationLocked(wtoken, null, transit, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAppResumed(IBinder token, boolean wasStopped, boolean allowSavedSurface) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "notifyAppResumed()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to notify resumed of non-existing app token: " + token);
                return;
            }
            wtoken.notifyAppResumed(wasStopped, allowSavedSurface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAppStopped(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "notifyAppStopped()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to notify stopped of non-existing app token: " + token);
                return;
            }
            wtoken.notifyAppStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppVisibility(IBinder token, boolean visible) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppVisibility()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set visibility of non-existing app token: " + token);
                return;
            }
            this.mOpeningApps.remove(wtoken);
            this.mClosingApps.remove(wtoken);
            wtoken.waitingToShow = false;
            boolean bl = wtoken.hiddenRequested = !visible;
            if (!visible) {
                wtoken.removeAllDeadWindows();
                wtoken.setVisibleBeforeClientHidden();
            } else if (visible) {
                if (!this.mAppTransition.isTransitionSet() && this.mAppTransition.isReady()) {
                    this.mOpeningApps.add(wtoken);
                }
                wtoken.startingMoved = false;
                if (wtoken.hidden || wtoken.mAppStopped) {
                    wtoken.clearAllDrawn();
                    if (wtoken.hidden) {
                        wtoken.waitingToShow = true;
                    }
                    if (wtoken.clientHidden) {
                        wtoken.clientHidden = false;
                        wtoken.sendAppVisibilityToClients();
                    }
                }
                wtoken.requestUpdateWallpaperIfNeeded();
                wtoken.mAppStopped = false;
            }
            if (this.okToDisplay() && this.mAppTransition.isTransitionSet()) {
                AppWindowToken focusedToken;
                WindowState win;
                if (wtoken.mAppAnimator.usingTransferredAnimation && wtoken.mAppAnimator.animation == null) {
                    Slog.wtf(TAG, "Will NOT set dummy animation on: " + wtoken + ", using null transfered animation!");
                }
                if (!(wtoken.mAppAnimator.usingTransferredAnimation || wtoken.startingDisplayed && !this.mSkipAppTransitionAnimation)) {
                    wtoken.mAppAnimator.setDummyAnimation();
                }
                wtoken.inPendingTransaction = true;
                if (visible) {
                    this.mOpeningApps.add(wtoken);
                    wtoken.mEnteringAnimation = true;
                } else {
                    this.mClosingApps.add(wtoken);
                    wtoken.mEnteringAnimation = false;
                }
                if (this.mAppTransition.getAppTransition() == 16 && (win = this.findFocusedWindowLocked(this.getDefaultDisplayContentLocked())) != null && (focusedToken = win.mAppToken) != null) {
                    focusedToken.hidden = true;
                    this.mOpeningApps.add(focusedToken);
                }
                return;
            }
            long origId = Binder.clearCallingIdentity();
            wtoken.inPendingTransaction = false;
            this.setTokenVisibilityLocked(wtoken, null, visible, -1, true, wtoken.voiceInteraction);
            wtoken.updateReportedVisibilityLocked();
            Binder.restoreCallingIdentity(origId);
        }
    }

    void unsetAppFreezingScreenLocked(AppWindowToken wtoken, boolean unfreezeSurfaceNow, boolean force) {
        if (wtoken.mAppAnimator.freezingScreen) {
            int N = wtoken.allAppWindows.size();
            boolean unfrozeWindows = false;
            for (int i = 0; i < N; ++i) {
                WindowState w = (WindowState)wtoken.allAppWindows.get(i);
                if (!w.mAppFreezing) continue;
                w.mAppFreezing = false;
                if (w.mHasSurface && !w.mOrientationChanging && this.mWindowsFreezingScreen != 2) {
                    w.mOrientationChanging = true;
                    this.mWindowPlacerLocked.mOrientationChangeComplete = false;
                }
                w.mLastFreezeDuration = 0;
                unfrozeWindows = true;
                w.setDisplayLayoutNeeded();
            }
            if (force || unfrozeWindows) {
                wtoken.mAppAnimator.freezingScreen = false;
                wtoken.mAppAnimator.lastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
                --this.mAppsFreezingScreen;
                this.mLastFinishedFreezeSource = wtoken;
            }
            if (unfreezeSurfaceNow) {
                if (unfrozeWindows) {
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
                this.stopFreezingDisplayLocked();
            }
        }
    }

    private void startAppFreezingScreenLocked(AppWindowToken wtoken) {
        if (!wtoken.hiddenRequested) {
            if (!wtoken.mAppAnimator.freezingScreen) {
                wtoken.mAppAnimator.freezingScreen = true;
                wtoken.mAppAnimator.lastFreezeDuration = 0;
                ++this.mAppsFreezingScreen;
                if (this.mAppsFreezingScreen == 1) {
                    this.startFreezingDisplayLocked(false, 0, 0);
                    this.mH.removeMessages(17);
                    this.mH.sendEmptyMessageDelayed(17, 2000L);
                }
            }
            int N = wtoken.allAppWindows.size();
            for (int i = 0; i < N; ++i) {
                WindowState w = (WindowState)wtoken.allAppWindows.get(i);
                w.mAppFreezing = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAppFreezingScreen(IBinder token, int configChanges) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (configChanges == 0 && this.okToDisplay()) {
                return;
            }
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                Slog.w(TAG, "Attempted to freeze screen with non-existing app token: " + wtoken);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.startAppFreezingScreenLocked(wtoken);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAppFreezingScreen(IBinder token, boolean force) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.unsetAppFreezingScreenLocked(wtoken, true, force);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAppToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        AppWindowToken wtoken = null;
        AppWindowToken startingToken = null;
        boolean delayed = false;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken basewtoken = this.mTokenMap.remove(token);
            if (basewtoken != null && (wtoken = basewtoken.appWindowToken) != null) {
                delayed = this.setTokenVisibilityLocked(wtoken, null, false, -1, true, wtoken.voiceInteraction);
                wtoken.inPendingTransaction = false;
                this.mOpeningApps.remove(wtoken);
                wtoken.waitingToShow = false;
                if (this.mClosingApps.contains(wtoken)) {
                    delayed = true;
                } else if (this.mAppTransition.isTransitionSet()) {
                    this.mClosingApps.add(wtoken);
                    delayed = true;
                }
                TaskStack stack = wtoken.mTask.mStack;
                if (delayed && !wtoken.allAppWindows.isEmpty()) {
                    stack.mExitingAppTokens.add(wtoken);
                    wtoken.mIsExiting = true;
                } else {
                    wtoken.mAppAnimator.clearAnimation();
                    wtoken.mAppAnimator.animating = false;
                    wtoken.removeAppFromTaskLocked();
                }
                wtoken.removed = true;
                if (wtoken.startingData != null) {
                    startingToken = wtoken;
                }
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
                if (this.mFocusedApp == wtoken) {
                    this.mFocusedApp = null;
                    this.updateFocusedWindowLocked(0, true);
                    this.mInputMonitor.setFocusedAppLw(null);
                }
            } else {
                Slog.w(TAG, "Attempted to remove non-existing app token: " + token);
            }
            if (!delayed && wtoken != null) {
                wtoken.updateReportedVisibilityLocked();
            }
            this.scheduleRemoveStartingWindowLocked(startingToken);
        }
        Binder.restoreCallingIdentity(origId);
    }

    void scheduleRemoveStartingWindowLocked(AppWindowToken wtoken) {
        if (wtoken == null) {
            return;
        }
        if (this.mH.hasMessages(6, wtoken)) {
            return;
        }
        if (wtoken.startingWindow == null) {
            if (wtoken.startingData != null) {
                wtoken.startingData = null;
            }
            return;
        }
        Message m = this.mH.obtainMessage(6, wtoken);
        this.mH.sendMessage(m);
    }

    void dumpAppTokensLocked() {
        int numStacks = this.mStackIdToStack.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            TaskStack stack = this.mStackIdToStack.valueAt(stackNdx);
            Slog.v(TAG, "  Stack #" + stack.mStackId + " tasks from bottom to top:");
            ArrayList<Task> tasks = stack.getTasks();
            int numTasks = tasks.size();
            for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
                Task task = tasks.get(taskNdx);
                Slog.v(TAG, "    Task #" + task.mTaskId + " activities from bottom to top:");
                AppTokenList tokens = task.mAppTokens;
                int numTokens = tokens.size();
                for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                    Slog.v(TAG, "      activity #" + tokenNdx + ": " + ((AppWindowToken)tokens.get((int)tokenNdx)).token);
                }
            }
        }
    }

    void dumpWindowsLocked() {
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            Slog.v(TAG, " Display #" + displayContent.getDisplayId());
            WindowList windows = displayContent.getWindowList();
            for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                Slog.v(TAG, "  #" + winNdx + ": " + windows.get(winNdx));
            }
        }
    }

    private final int reAddWindowLocked(int index, WindowState win) {
        WindowList windows = win.getWindowList();
        int NCW = win.mChildWindows.size();
        boolean winAdded = false;
        for (int j = 0; j < NCW; ++j) {
            WindowState cwin = (WindowState)win.mChildWindows.get(j);
            if (!winAdded && cwin.mSubLayer >= 0) {
                win.mRebuilding = false;
                windows.add(index, win);
                ++index;
                winAdded = true;
            }
            cwin.mRebuilding = false;
            windows.add(index, cwin);
            ++index;
        }
        if (!winAdded) {
            win.mRebuilding = false;
            windows.add(index, win);
            ++index;
        }
        this.mWindowsChanged = true;
        return index;
    }

    private final int reAddAppWindowsLocked(DisplayContent displayContent, int index, WindowToken token) {
        int NW = token.windows.size();
        for (int i = 0; i < NW; ++i) {
            WindowState win = (WindowState)token.windows.get(i);
            DisplayContent winDisplayContent = win.getDisplayContent();
            if (winDisplayContent != displayContent && winDisplayContent != null) continue;
            win.mDisplayContent = displayContent;
            index = this.reAddWindowLocked(index, win);
        }
        return index;
    }

    void moveStackWindowsLocked(DisplayContent displayContent) {
        WindowList windows = displayContent.getWindowList();
        this.mTmpWindows.addAll(windows);
        this.rebuildAppWindowListLocked(displayContent);
        int tmpSize = this.mTmpWindows.size();
        int winSize = windows.size();
        int tmpNdx = 0;
        int winNdx = 0;
        while (tmpNdx < tmpSize && winNdx < winSize) {
            WindowState win;
            WindowState tmp;
            do {
                tmp = this.mTmpWindows.get(tmpNdx++);
            } while (tmpNdx < tmpSize && tmp.mAppToken != null && tmp.mAppToken.mIsExiting);
            do {
                win = (WindowState)windows.get(winNdx++);
            } while (winNdx < winSize && win.mAppToken != null && win.mAppToken.mIsExiting);
            if (tmp == win) continue;
            displayContent.layoutNeeded = true;
            break;
        }
        if (tmpNdx != winNdx) {
            displayContent.layoutNeeded = true;
        }
        this.mTmpWindows.clear();
        if (!this.updateFocusedWindowLocked(3, false)) {
            this.mLayersController.assignLayersLocked(displayContent.getWindowList());
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        this.mWindowPlacerLocked.performSurfacePlacement();
        this.mInputMonitor.updateInputWindowsLw(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToTop(int taskId) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                TaskStack homeStack;
                Task task;
                block10: {
                    task = this.mTaskIdToTask.get(taskId);
                    if (task != null) break block10;
                    return;
                }
                TaskStack stack = task.mStack;
                DisplayContent displayContent = task.getDisplayContent();
                displayContent.moveStack(stack, true);
                if (displayContent.isDefaultDisplay && (homeStack = displayContent.getHomeStack()) != stack) {
                    displayContent.moveStack(homeStack, false);
                }
                stack.moveTaskToTop(task);
                if (this.mAppTransition.isTransitionSet()) {
                    task.setSendingToBottom(false);
                }
                this.moveStackWindowsLocked(displayContent);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToBottom(int taskId) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                Task task;
                block9: {
                    task = this.mTaskIdToTask.get(taskId);
                    if (task != null) break block9;
                    Slog.e(TAG, "moveTaskToBottom: taskId=" + taskId + " not found in mTaskIdToTask");
                    return;
                }
                TaskStack stack = task.mStack;
                stack.moveTaskToBottom(task);
                if (this.mAppTransition.isTransitionSet()) {
                    task.setSendingToBottom(true);
                }
                this.moveStackWindowsLocked(stack.getDisplayContent());
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    boolean isStackVisibleLocked(int stackId) {
        TaskStack stack = this.mStackIdToStack.get(stackId);
        return stack != null && stack.isVisibleLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDockedStackCreateState(int mode, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.setDockedStackCreateStateLocked(mode, bounds);
        }
    }

    void setDockedStackCreateStateLocked(int mode, Rect bounds) {
        this.mDockedStackCreateMode = mode;
        this.mDockedStackCreateBounds = bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Rect attachStack(int stackId, int displayId, boolean onTop) {
        long origId;
        block12: {
            TaskStack stack;
            block13: {
                Rect rect;
                origId = Binder.clearCallingIdentity();
                try {
                    HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                    // MONITORENTER : hashMap
                    DisplayContent displayContent = this.mDisplayContents.get(displayId);
                    boolean attachedToDisplay = false;
                    if (displayContent == null) break block12;
                    stack = this.mStackIdToStack.get(stackId);
                    if (stack == null) {
                        stack = displayContent.getStackById(stackId);
                        if (stack != null) {
                            displayContent.detachStack(stack);
                            stack.mDeferDetach = false;
                            attachedToDisplay = true;
                        } else {
                            stack = new TaskStack(this, stackId);
                        }
                        this.mStackIdToStack.put(stackId, stack);
                        if (stackId == 3) {
                            this.getDefaultDisplayContentLocked().mDividerControllerLocked.notifyDockedStackExistsChanged(true);
                        }
                    }
                    if (!attachedToDisplay) {
                        stack.attachDisplayContent(displayContent);
                    }
                    displayContent.attachStack(stack, onTop);
                    if (!stack.getRawFullscreen()) break block13;
                    rect = null;
                    // MONITOREXIT : hashMap
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(origId);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(origId);
                return rect;
            }
            Rect bounds = new Rect();
            stack.getRawBounds(bounds);
            Rect rect = bounds;
            // MONITOREXIT : hashMap
            Binder.restoreCallingIdentity(origId);
            return rect;
        }
        Binder.restoreCallingIdentity(origId);
        return null;
    }

    void detachStackLocked(DisplayContent displayContent, TaskStack stack) {
        displayContent.detachStack(stack);
        stack.detachDisplay();
        if (stack.mStackId == 3) {
            this.getDefaultDisplayContentLocked().mDividerControllerLocked.notifyDockedStackExistsChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachStack(int stackId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent;
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack != null && (displayContent = stack.getDisplayContent()) != null) {
                if (stack.isAnimating()) {
                    stack.mDeferDetach = true;
                    return;
                }
                this.detachStackLocked(displayContent, stack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStack(int stackId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mStackIdToStack.remove(stackId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(int taskId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            task.removeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTaskWindowTransition(int taskId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task != null) {
                task.cancelTaskWindowTransition();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTaskThumbnailTransition(int taskId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task != null) {
                task.cancelTaskThumbnailTransition();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(int taskId, int stackId, boolean toTop) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            TaskStack stack = this.mStackIdToStack.get(stackId);
            stack.addTask(task, toTop);
            DisplayContent displayContent = stack.getDisplayContent();
            displayContent.layoutNeeded = true;
            this.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack == null) {
                return;
            }
            task.moveTaskToStack(stack, toTop);
            DisplayContent displayContent = stack.getDisplayContent();
            displayContent.layoutNeeded = true;
            this.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStackDockedModeBounds(int stackId, Rect bounds, boolean ignoreVisibility) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack != null) {
                stack.getStackDockedModeBoundsLocked(bounds, ignoreVisibility);
                return;
            }
            bounds.setEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStackBounds(int stackId, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack != null) {
                stack.getBounds(bounds);
                return;
            }
            bounds.setEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resizeStack(int stackId, Rect bounds, SparseArray<Configuration> configs, SparseArray<Rect> taskBounds, SparseArray<Rect> taskTempInsetBounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack == null) {
                throw new IllegalArgumentException("resizeStack: stackId " + stackId + " not found.");
            }
            if (stack.setBounds(bounds, configs, taskBounds, taskTempInsetBounds) && stack.isVisibleLocked()) {
                stack.getDisplayContent().layoutNeeded = true;
                this.mWindowPlacerLocked.performSurfacePlacement();
            }
            return stack.getRawFullscreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareFreezingTaskBounds(int stackId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack == null) {
                throw new IllegalArgumentException("prepareFreezingTaskBounds: stackId " + stackId + " not found.");
            }
            stack.prepareFreezingTaskBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionTaskInStack(int taskId, int stackId, int position, Rect bounds, Configuration config) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack == null) {
                return;
            }
            task.positionTaskInStack(stack, position, bounds, config);
            DisplayContent displayContent = stack.getDisplayContent();
            displayContent.layoutNeeded = true;
            this.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeTask(int taskId, Rect bounds, Configuration configuration, boolean relayout, boolean forced) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                throw new IllegalArgumentException("resizeTask: taskId " + taskId + " not found.");
            }
            if (task.resizeLocked(bounds, configuration, forced) && relayout) {
                task.getDisplayContent().layoutNeeded = true;
                this.mWindowPlacerLocked.performSurfacePlacement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskDockedResizing(int taskId, boolean resizing) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                Slog.w(TAG, "setTaskDockedResizing: taskId " + taskId + " not found.");
                return;
            }
            task.setDragResizing(resizing, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollTask(int taskId, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                throw new IllegalArgumentException("scrollTask: taskId " + taskId + " not found.");
            }
            if (task.scrollLocked(bounds)) {
                task.getDisplayContent().layoutNeeded = true;
                this.mInputMonitor.setUpdateInputWindowsNeededLw();
                this.mWindowPlacerLocked.performSurfacePlacement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferSurfaceLayout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowPlacerLocked.deferLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueSurfaceLayout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowPlacerLocked.continueLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTaskBounds(int taskId, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task != null) {
                task.getBounds(bounds);
                return;
            }
            bounds.setEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidTaskId(int taskId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mTaskIdToTask.get(taskId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFreezingScreen(int exitAnim, int enterAnim) {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "startFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mClientFreezingScreen) {
                this.mClientFreezingScreen = true;
                long origId = Binder.clearCallingIdentity();
                try {
                    this.startFreezingDisplayLocked(false, exitAnim, enterAnim);
                    this.mH.removeMessages(30);
                    this.mH.sendEmptyMessageDelayed(30, 5000L);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFreezingScreen() {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "stopFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mClientFreezingScreen) {
                this.mClientFreezingScreen = false;
                this.mLastFinishedFreezeSource = "client";
                long origId = Binder.clearCallingIdentity();
                try {
                    this.stopFreezingDisplayLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    @Override
    public void disableKeyguard(IBinder token, String tag) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (Binder.getCallingUid() != 1000 && this.isKeyguardSecure()) {
            Log.d(TAG, "current mode is SecurityMode, ignore disableKeyguard");
            return;
        }
        if (Binder.getCallingUserHandle().getIdentifier() != this.mCurrentUserId) {
            Log.d(TAG, "non-current user, ignore disableKeyguard");
            return;
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(1, new Pair<IBinder, String>(token, tag)));
    }

    @Override
    public void reenableKeyguard(IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(2, token));
    }

    @Override
    public void exitKeyguardSecurely(final IOnKeyguardExitResult callback) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback == null");
        }
        this.mPolicy.exitKeyguardSecurely(new WindowManagerPolicy.OnKeyguardExitResult(){

            @Override
            public void onKeyguardExitResult(boolean success) {
                try {
                    callback.onKeyguardExitResult(success);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean inKeyguardRestrictedInputMode() {
        return this.mPolicy.inKeyguardRestrictedKeyInputMode();
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.mPolicy.isKeyguardLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyguardSecure() {
        int userId = UserHandle.getCallingUserId();
        long origId = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mPolicy.isKeyguardSecure(userId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissKeyguard() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.dismissKeyguardLw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyguardGoingAway(int flags) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAnimator.mKeyguardGoingAway = true;
            this.mAnimator.mKeyguardGoingAwayFlags = flags;
            this.mWindowPlacerLocked.requestTraversal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyguardWaitingForActivityDrawn() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mKeyguardWaitingForActivityDrawn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyActivityDrawnForKeyguard() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mKeyguardWaitingForActivityDrawn) {
                this.mPolicy.notifyActivityDrawnForKeyguardLw();
                this.mKeyguardWaitingForActivityDrawn = false;
            }
        }
    }

    void showGlobalActions() {
        this.mPolicy.showGlobalActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSystemDialogs(String reason) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState w = (WindowState)windows.get(winNdx);
                    if (!w.mHasSurface) continue;
                    try {
                        w.mClient.closeSystemDialogs(reason);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static float fixScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 20.0f) {
            scale = 20.0f;
        }
        return Math.abs(scale);
    }

    @Override
    public void setAnimationScale(int which, float scale) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        scale = WindowManagerService.fixScale(scale);
        switch (which) {
            case 0: {
                this.mWindowAnimationScaleSetting = scale;
                break;
            }
            case 1: {
                this.mTransitionAnimationScaleSetting = scale;
                break;
            }
            case 2: {
                this.mAnimatorDurationScaleSetting = scale;
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    @Override
    public void setAnimationScales(float[] scales) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        if (scales != null) {
            if (scales.length >= 1) {
                this.mWindowAnimationScaleSetting = WindowManagerService.fixScale(scales[0]);
            }
            if (scales.length >= 2) {
                this.mTransitionAnimationScaleSetting = WindowManagerService.fixScale(scales[1]);
            }
            if (scales.length >= 3) {
                this.mAnimatorDurationScaleSetting = WindowManagerService.fixScale(scales[2]);
                this.dispatchNewAnimatorScaleLocked(null);
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    private void setAnimatorDurationScale(float scale) {
        this.mAnimatorDurationScaleSetting = scale;
        ValueAnimator.setDurationScale(scale);
    }

    public float getWindowAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mWindowAnimationScaleSetting;
    }

    public float getTransitionAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mTransitionAnimationScaleSetting;
    }

    @Override
    public float getAnimationScale(int which) {
        switch (which) {
            case 0: {
                return this.mWindowAnimationScaleSetting;
            }
            case 1: {
                return this.mTransitionAnimationScaleSetting;
            }
            case 2: {
                return this.mAnimatorDurationScaleSetting;
            }
        }
        return 0.0f;
    }

    @Override
    public float[] getAnimationScales() {
        return new float[]{this.mWindowAnimationScaleSetting, this.mTransitionAnimationScaleSetting, this.mAnimatorDurationScaleSetting};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getCurrentAnimatorScale() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mAnimationsDisabled ? 0.0f : this.mAnimatorDurationScaleSetting;
        }
    }

    void dispatchNewAnimatorScaleLocked(Session session) {
        this.mH.obtainMessage(34, session).sendToTarget();
    }

    @Override
    public void registerPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.registerInputEventListener(listener);
    }

    @Override
    public void unregisterPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.unregisterInputEventListener(listener);
    }

    @Override
    public int getLidState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 0);
        if (sw > 0) {
            return 0;
        }
        if (sw == 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public void lockDeviceNow() {
        this.lockNow(null);
    }

    @Override
    public int getCameraLensCoverState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 9);
        if (sw > 0) {
            return 1;
        }
        if (sw == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public void switchInputMethod(boolean forwardDirection) {
        InputMethodManagerInternal inputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
        if (inputMethodManagerInternal != null) {
            inputMethodManagerInternal.switchInputMethod(forwardDirection);
        }
    }

    @Override
    public void shutdown(boolean confirm) {
        ShutdownThread.shutdown(this.mContext, "userrequested", confirm);
    }

    @Override
    public void reboot(boolean confirm) {
        ShutdownThread.reboot(this.mContext, "userrequested", confirm);
    }

    @Override
    public void rebootSafeMode(boolean confirm) {
        ShutdownThread.rebootSafeMode(this.mContext, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentProfileIds(int[] currentProfileIds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurrentProfileIds = currentProfileIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int newUserId, int[] currentProfileIds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurrentUserId = newUserId;
            this.mCurrentProfileIds = currentProfileIds;
            this.mAppTransition.setCurrentUser(newUserId);
            this.mPolicy.setCurrentUserLw(newUserId);
            this.mPolicy.enableKeyguard(true);
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                displayContent.switchUserStacks();
                this.rebuildAppWindowListLocked(displayContent);
            }
            this.mWindowPlacerLocked.performSurfacePlacement();
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            displayContent.mDividerControllerLocked.notifyDockedStackExistsChanged(this.hasDockedTasksForUser(newUserId));
            if (this.mDisplayReady) {
                int forcedDensity = this.getForcedDisplayDensityForUserLocked(newUserId);
                int targetDensity = forcedDensity != 0 ? forcedDensity : displayContent.mInitialDisplayDensity;
                this.setForcedDisplayDensityLocked(displayContent, targetDensity);
            }
        }
    }

    boolean hasDockedTasksForUser(int userId) {
        TaskStack stack = this.mStackIdToStack.get(3);
        if (stack == null) {
            return false;
        }
        ArrayList<Task> tasks = stack.getTasks();
        boolean hasUserTask = false;
        for (int i = tasks.size() - 1; i >= 0 && !hasUserTask; --i) {
            Task task = tasks.get(i);
            hasUserTask = task.mUserId == userId;
        }
        return hasUserTask;
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUserId) {
            return true;
        }
        for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
            if (this.mCurrentProfileIds[i] != userId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableScreenAfterBoot() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mSystemBooted) {
                return;
            }
            this.mSystemBooted = true;
            this.hideBootMessagesLocked();
            this.mH.sendEmptyMessageDelayed(23, 30000L);
        }
        this.mPolicy.systemBooted();
        this.performEnableScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableScreenIfNeeded() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.enableScreenIfNeededLocked();
        }
    }

    void enableScreenIfNeededLocked() {
        if (this.mDisplayEnabled) {
            return;
        }
        if (!this.mSystemBooted && !this.mShowingBootMessages) {
            return;
        }
        this.mH.sendEmptyMessage(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBootTimeout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            Slog.w(TAG, "***** BOOT TIMEOUT: forcing display enabled");
            this.mForceDisplayEnabled = true;
        }
        this.performEnableScreen();
    }

    private boolean checkWaitingForWindowsLocked() {
        boolean haveBootMsg = false;
        boolean haveApp = false;
        boolean haveWallpaper = false;
        boolean wallpaperEnabled = this.mContext.getResources().getBoolean(17956942) && !this.mOnlyCore;
        boolean haveKeyguard = true;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        for (int i = 0; i < N; ++i) {
            WindowState w = (WindowState)windows.get(i);
            if (w.isVisibleLw() && !w.mObscured && !w.isDrawnLw()) {
                return true;
            }
            if (!w.isDrawnLw()) continue;
            if (w.mAttrs.type == 2021) {
                haveBootMsg = true;
                continue;
            }
            if (w.mAttrs.type == 2 || w.mAttrs.type == 4) {
                haveApp = true;
                continue;
            }
            if (w.mAttrs.type == 2013) {
                haveWallpaper = true;
                continue;
            }
            if (w.mAttrs.type != 2000) continue;
            haveKeyguard = this.mPolicy.isKeyguardDrawnLw();
        }
        if (!this.mSystemBooted && !haveBootMsg) {
            return true;
        }
        return this.mSystemBooted && (!haveApp && !haveKeyguard || wallpaperEnabled && !haveWallpaper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performEnableScreen() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            if (!this.mSystemBooted && !this.mShowingBootMessages) {
                return;
            }
            if (!this.mForceDisplayEnabled && this.checkWaitingForWindowsLocked()) {
                return;
            }
            if (!this.mBootAnimationStopped) {
                Trace.asyncTraceBegin(32L, "Stop bootanim", 0);
                try {
                    IBinder surfaceFlinger = ServiceManager.getService("SurfaceFlinger");
                    if (surfaceFlinger != null) {
                        Parcel data = Parcel.obtain();
                        data.writeInterfaceToken("android.ui.ISurfaceComposer");
                        surfaceFlinger.transact(1, data, null, 0);
                        data.recycle();
                    }
                }
                catch (RemoteException ex) {
                    Slog.e(TAG, "Boot completed: SurfaceFlinger is dead!");
                }
                this.mBootAnimationStopped = true;
            }
            if (!this.mForceDisplayEnabled && !this.checkBootAnimationCompleteLocked()) {
                return;
            }
            EventLog.writeEvent(31007, SystemClock.uptimeMillis());
            Trace.asyncTraceEnd(32L, "Stop bootanim", 0);
            this.mDisplayEnabled = true;
            this.mInputMonitor.setEventDispatchingLw(this.mEventDispatchingEnabled);
        }
        try {
            this.mActivityManager.bootAnimationComplete();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mPolicy.enableScreenAfterBoot();
        this.updateRotationUnchecked(false, false);
    }

    private boolean checkBootAnimationCompleteLocked() {
        if (SystemService.isRunning(BOOT_ANIMATION_SERVICE)) {
            this.mH.removeMessages(37);
            this.mH.sendEmptyMessageDelayed(37, 200L);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBootMessage(CharSequence msg, boolean always) {
        boolean first = false;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mAllowBootMessages) {
                return;
            }
            if (!this.mShowingBootMessages) {
                if (!always) {
                    return;
                }
                first = true;
            }
            if (this.mSystemBooted) {
                return;
            }
            this.mShowingBootMessages = true;
            this.mPolicy.showBootMessage(msg, always);
        }
        if (first) {
            this.performEnableScreen();
        }
    }

    public void hideBootMessagesLocked() {
        if (this.mShowingBootMessages) {
            this.mShowingBootMessages = false;
            this.mPolicy.hideBootMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInTouchMode(boolean mode) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInTouchMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCircularDisplayMaskIfNeeded() {
        if (this.mContext.getResources().getConfiguration().isScreenRound() && this.mContext.getResources().getBoolean(17956999)) {
            int currentUserId;
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                currentUserId = this.mCurrentUserId;
            }
            int inversionState = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_inversion_enabled", 0, currentUserId);
            int showMask = inversionState == 1 ? 0 : 1;
            Message m = this.mH.obtainMessage(35);
            m.arg1 = showMask;
            this.mH.sendMessage(m);
        }
    }

    public void showEmulatorDisplayOverlayIfNeeded() {
        if (this.mContext.getResources().getBoolean(17957000) && SystemProperties.getBoolean(PROPERTY_EMULATOR_CIRCULAR, false) && Build.IS_EMULATOR) {
            this.mH.sendMessage(this.mH.obtainMessage(36));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCircularMask(boolean visible) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            SurfaceControl.openTransaction();
            try {
                if (visible) {
                    if (this.mCircularDisplayMask == null) {
                        int screenOffset = this.mContext.getResources().getInteger(17694868);
                        int maskThickness = this.mContext.getResources().getDimensionPixelSize(17105057);
                        this.mCircularDisplayMask = new CircularDisplayMask(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession, this.mPolicy.windowTypeToLayerLw(2018) * 10000 + 10, screenOffset, maskThickness);
                    }
                    this.mCircularDisplayMask.setVisibility(true);
                } else if (this.mCircularDisplayMask != null) {
                    this.mCircularDisplayMask.setVisibility(false);
                    this.mCircularDisplayMask = null;
                }
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEmulatorDisplayOverlay() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            SurfaceControl.openTransaction();
            try {
                if (this.mEmulatorDisplayOverlay == null) {
                    this.mEmulatorDisplayOverlay = new EmulatorDisplayOverlay(this.mContext, this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession, this.mPolicy.windowTypeToLayerLw(2018) * 10000 + 10);
                }
                this.mEmulatorDisplayOverlay.setVisibility(true);
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    @Override
    public void showStrictModeViolation(boolean on) {
        int pid = Binder.getCallingPid();
        this.mH.sendMessage(this.mH.obtainMessage(25, on ? 1 : 0, pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStrictModeViolation(int arg, int pid) {
        boolean on = arg != 0;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (on) {
                boolean isVisible = false;
                int numDisplays = this.mDisplayContents.size();
                block6: for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    int numWindows = windows.size();
                    for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                        WindowState ws = (WindowState)windows.get(winNdx);
                        if (ws.mSession.mPid != pid || !ws.isVisibleLw()) continue;
                        isVisible = true;
                        continue block6;
                    }
                }
                if (!isVisible) {
                    return;
                }
            }
            SurfaceControl.openTransaction();
            try {
                if (this.mStrictModeFlash == null) {
                    this.mStrictModeFlash = new StrictModeFlash(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession);
                }
                this.mStrictModeFlash.setVisibility(on);
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    @Override
    public void setStrictModeVisualIndicatorPreference(String value) {
        SystemProperties.set("persist.sys.strictmode.visual", value);
    }

    private static void convertCropForSurfaceFlinger(Rect crop, int rot, int dw, int dh) {
        if (rot == 1) {
            int tmp = crop.top;
            crop.top = dw - crop.right;
            crop.right = crop.bottom;
            crop.bottom = dw - crop.left;
            crop.left = tmp;
        } else if (rot == 2) {
            int tmp = crop.top;
            crop.top = dh - crop.bottom;
            crop.bottom = dh - tmp;
            tmp = crop.right;
            crop.right = dw - crop.left;
            crop.left = dw - tmp;
        } else if (rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = dh - crop.bottom;
            crop.bottom = crop.right;
            crop.right = dh - tmp;
        }
    }

    @Override
    public Bitmap screenshotWallpaper() {
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "screenshotWallpaper()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        try {
            Trace.traceBegin(32L, "screenshotWallpaper");
            Bitmap bitmap = this.screenshotApplicationsInner(null, 0, -1, -1, true, 1.0f, Bitmap.Config.ARGB_8888, true);
            return bitmap;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    @Override
    public boolean requestAssistScreenshot(final IAssistScreenshotReceiver receiver) {
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "requestAssistScreenshot()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        FgThread.getHandler().post(new Runnable(){

            @Override
            public void run() {
                Bitmap bm = WindowManagerService.this.screenshotApplicationsInner(null, 0, -1, -1, true, 1.0f, Bitmap.Config.ARGB_8888, false);
                try {
                    receiver.send(bm);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap screenshotApplications(IBinder appToken, int displayId, int width, int height, float frameScale) {
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "screenshotApplications()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        try {
            Trace.traceBegin(32L, "screenshotApplications");
            Bitmap bitmap = this.screenshotApplicationsInner(appToken, displayId, width, height, false, frameScale, Bitmap.Config.RGB_565, false);
            return bitmap;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap screenshotApplicationsInner(IBinder appToken, int displayId, int width, int height, boolean includeFullDisplay, float frameScale, Bitmap.Config config, boolean wallpaperOnly) {
        boolean includeImeInScreenshot;
        Object imeTargetAppToken;
        int minLayer;
        boolean screenshotReady;
        DisplayContent displayContent;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent == null) {
                return null;
            }
        }
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        if (dw == 0 || dh == 0) {
            return null;
        }
        Bitmap bm = null;
        int maxLayer = 0;
        Rect frame = new Rect();
        Rect stackBounds = new Rect();
        if (appToken == null && !wallpaperOnly) {
            screenshotReady = true;
            minLayer = 0;
        } else {
            screenshotReady = false;
            minLayer = Integer.MAX_VALUE;
        }
        WindowState appWin = null;
        HashMap<IBinder, WindowState> hashMap2 = this.mWindowMap;
        synchronized (hashMap2) {
            imeTargetAppToken = this.mInputMethodTarget != null ? this.mInputMethodTarget.mAppToken : null;
            includeImeInScreenshot = imeTargetAppToken != null && ((AppWindowToken)imeTargetAppToken).appToken != null && ((AppWindowToken)imeTargetAppToken).appToken.asBinder() == appToken && !this.mInputMethodTarget.isInMultiWindowMode();
        }
        int aboveAppLayer = (this.mPolicy.windowTypeToLayerLw(2) + 1) * 10000 + 1000;
        imeTargetAppToken = this.mWindowMap;
        synchronized (imeTargetAppToken) {
            appWin = null;
            WindowList windows = displayContent.getWindowList();
            for (int i = windows.size() - 1; i >= 0; --i) {
                boolean foundTargetWs;
                WindowState ws = (WindowState)windows.get(i);
                if (!ws.mHasSurface || ws.mLayer >= aboveAppLayer || wallpaperOnly && !ws.mIsWallpaper) continue;
                if (ws.mIsImWindow) {
                    if (!includeImeInScreenshot) {
                        continue;
                    }
                } else if (ws.mIsWallpaper) {
                    if (wallpaperOnly) {
                        appWin = ws;
                    }
                    if (appWin == null) {
                        continue;
                    }
                } else if (appToken != null) {
                    if (ws.mAppToken == null || ws.mAppToken.token != appToken) continue;
                    appWin = ws;
                }
                WindowStateAnimator winAnim = ws.mWinAnimator;
                int layer = winAnim.mSurfaceController.getLayer();
                if (maxLayer < layer) {
                    maxLayer = layer;
                }
                if (minLayer > layer) {
                    minLayer = layer;
                }
                if (!includeFullDisplay && !ws.mIsWallpaper) {
                    Rect wf = ws.mFrame;
                    Rect cr = ws.mContentInsets;
                    int left = wf.left + cr.left;
                    int top = wf.top + cr.top;
                    int right = wf.right - cr.right;
                    int bottom = wf.bottom - cr.bottom;
                    frame.union(left, top, right, bottom);
                    ws.getVisibleBounds(stackBounds);
                    if (!Rect.intersects(frame, stackBounds)) {
                        frame.setEmpty();
                    }
                }
                boolean bl = foundTargetWs = ws.mAppToken != null && ws.mAppToken.token == appToken || appWin != null && wallpaperOnly;
                if (foundTargetWs && ws.isDisplayedLw() && winAnim.getShown()) {
                    screenshotReady = true;
                }
                if (ws.isObscuringFullscreen(displayInfo)) break;
            }
            if (appToken != null && appWin == null) {
                return null;
            }
            if (!screenshotReady) {
                Slog.i(TAG, "Failed to capture screenshot of " + appToken + " appWin=" + (appWin == null ? "null" : appWin + " drawState=" + appWin.mWinAnimator.mDrawState));
                return null;
            }
            if (maxLayer == 0) {
                return null;
            }
            if (!includeFullDisplay) {
                if (!frame.intersect(0, 0, dw, dh)) {
                    frame.setEmpty();
                }
            } else {
                frame.set(0, 0, dw, dh);
            }
            if (frame.isEmpty()) {
                return null;
            }
            if (width < 0) {
                width = (int)((float)frame.width() * frameScale);
            }
            if (height < 0) {
                height = (int)((float)frame.height() * frameScale);
            }
            Rect crop = new Rect(frame);
            if ((float)width / (float)frame.width() < (float)height / (float)frame.height()) {
                int cropWidth = (int)((float)width / (float)height * (float)frame.height());
                crop.right = crop.left + cropWidth;
            } else {
                int cropHeight = (int)((float)height / (float)width * (float)frame.width());
                crop.bottom = crop.top + cropHeight;
            }
            int rot = this.getDefaultDisplayContentLocked().getDisplay().getRotation();
            if (rot == 1 || rot == 3) {
                rot = rot == 1 ? 3 : 1;
            }
            WindowManagerService.convertCropForSurfaceFlinger(crop, rot, dw, dh);
            ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
            boolean inRotation = screenRotationAnimation != null && screenRotationAnimation.isAnimating();
            SurfaceControl.openTransaction();
            SurfaceControl.closeTransactionSync();
            bm = SurfaceControl.screenshot(crop, width, height, minLayer, maxLayer, inRotation, rot);
            if (bm == null) {
                Slog.w(TAG, "Screenshot failure taking screenshot for (" + dw + "x" + dh + ") to layer " + maxLayer);
                return null;
            }
        }
        Bitmap ret = bm.createAshmemBitmap(config);
        bm.recycle();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeRotation(int rotation) {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "freezeRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        if (rotation < -1 || rotation > 3) {
            throw new IllegalArgumentException("Rotation argument must be -1 or a valid rotation constant.");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(1, rotation == -1 ? this.mRotation : rotation);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void thawRotation() {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "thawRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(0, 777);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) {
        this.updateRotationUnchecked(alwaysSendConfiguration, forceRelayout);
    }

    void pauseRotationLocked() {
        ++this.mDeferredRotationPauseCount;
    }

    void resumeRotationLocked() {
        if (this.mDeferredRotationPauseCount > 0) {
            boolean changed;
            --this.mDeferredRotationPauseCount;
            if (this.mDeferredRotationPauseCount == 0 && (changed = this.updateRotationUncheckedLocked(false))) {
                this.mH.sendEmptyMessage(18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRotationUnchecked(boolean alwaysSendConfiguration, boolean forceRelayout) {
        boolean changed;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            changed = this.updateRotationUncheckedLocked(false);
            if (!changed || forceRelayout) {
                this.getDefaultDisplayContentLocked().layoutNeeded = true;
                this.mWindowPlacerLocked.performSurfacePlacement();
            }
        }
        if (changed || alwaysSendConfiguration) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRotationUncheckedLocked(boolean inTransaction) {
        int i;
        WindowState w;
        boolean altOrientation;
        if (this.mDeferredRotationPauseCount > 0) {
            return false;
        }
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
        if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
            return false;
        }
        if (!this.mDisplayEnabled) {
            return false;
        }
        int rotation = this.mPolicy.rotationForOrientationLw(this.mLastOrientation, this.mRotation);
        boolean bl = altOrientation = !this.mPolicy.rotationHasCompatibleMetricsLw(this.mLastOrientation, rotation);
        if (this.mRotation == rotation && this.mAltOrientation == altOrientation) {
            return false;
        }
        int oldRotation = this.mRotation;
        this.mRotation = rotation;
        this.mAltOrientation = altOrientation;
        this.mPolicy.setRotationLw(this.mRotation);
        this.mWindowsFreezingScreen = 1;
        this.mH.removeMessages(11);
        this.mH.sendEmptyMessageDelayed(11, 2000L);
        this.mWaitingForConfig = true;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        displayContent.layoutNeeded = true;
        int[] anim2 = new int[2];
        if (displayContent.isDimming()) {
            anim2[1] = 0;
            anim2[0] = 0;
        } else {
            this.mPolicy.selectRotationAnimationLw(anim2);
        }
        boolean rotateSeamlessly = this.mPolicy.shouldRotateSeamlessly(oldRotation, this.mRotation);
        WindowList windows = displayContent.getWindowList();
        if (rotateSeamlessly) {
            for (int i2 = windows.size() - 1; i2 >= 0; --i2) {
                WindowState w2 = (WindowState)windows.get(i2);
                if (w2.mSeamlesslyRotated) {
                    rotateSeamlessly = false;
                    break;
                }
                if (!(w2.isChildWindow() & w2.isVisibleNow()) || w2.mWinAnimator.mSurfaceController.getTransformToDisplayInverse()) continue;
                rotateSeamlessly = false;
            }
        }
        if (!rotateSeamlessly) {
            this.startFreezingDisplayLocked(inTransaction, anim2[0], anim2[1]);
            screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
        } else {
            screenRotationAnimation = null;
        }
        this.updateDisplayAndOrientationLocked(this.mCurConfiguration.uiMode);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        if (!inTransaction) {
            SurfaceControl.openTransaction();
        }
        try {
            if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot() && screenRotationAnimation.setRotationInTransaction(rotation, this.mFxSession, 10000L, this.getTransitionAnimationScaleLocked(), displayInfo.logicalWidth, displayInfo.logicalHeight)) {
                this.scheduleAnimationLocked();
            }
            if (rotateSeamlessly) {
                for (int i3 = windows.size() - 1; i3 >= 0; --i3) {
                    w = (WindowState)windows.get(i3);
                    w.mWinAnimator.seamlesslyRotateWindow(oldRotation, this.mRotation);
                }
            }
            this.mDisplayManagerInternal.performTraversalInTransactionFromWindowManager();
        }
        finally {
            if (!inTransaction) {
                SurfaceControl.closeTransaction();
            }
        }
        for (i = windows.size() - 1; i >= 0; --i) {
            w = (WindowState)windows.get(i);
            if (w.mAppToken != null) {
                w.mAppToken.destroySavedSurfaces();
            }
            if (!w.mHasSurface || rotateSeamlessly) continue;
            w.mOrientationChanging = true;
            this.mWindowPlacerLocked.mOrientationChangeComplete = false;
            w.mLastFreezeDuration = 0;
        }
        if (rotateSeamlessly) {
            this.mH.removeMessages(54);
            this.mH.sendEmptyMessageDelayed(54, 2000L);
        }
        for (i = this.mRotationWatchers.size() - 1; i >= 0; --i) {
            try {
                this.mRotationWatchers.get((int)i).watcher.onRotationChanged(rotation);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (screenRotationAnimation == null && this.mAccessibilityController != null && displayContent.getDisplayId() == 0) {
            this.mAccessibilityController.onRotationChangedLocked(this.getDefaultDisplayContentLocked(), rotation);
        }
        return true;
    }

    @Override
    public int getRotation() {
        return this.mRotation;
    }

    @Override
    public boolean isRotationFrozen() {
        return this.mPolicy.getUserRotationMode() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int watchRotation(IRotationWatcher watcher) {
        final IBinder watcherBinder = watcher.asBinder();
        IBinder.DeathRecipient dr = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                synchronized (hashMap) {
                    for (int i = 0; i < WindowManagerService.this.mRotationWatchers.size(); ++i) {
                        if (watcherBinder != WindowManagerService.this.mRotationWatchers.get((int)i).watcher.asBinder()) continue;
                        RotationWatcher removed = WindowManagerService.this.mRotationWatchers.remove(i);
                        IBinder binder = removed.watcher.asBinder();
                        if (binder != null) {
                            binder.unlinkToDeath(this, 0);
                        }
                        --i;
                    }
                }
            }
        };
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            try {
                watcher.asBinder().linkToDeath(dr, 0);
                this.mRotationWatchers.add(new RotationWatcher(watcher, dr));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return this.mRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRotationWatcher(IRotationWatcher watcher) {
        IBinder watcherBinder = watcher.asBinder();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (int i = 0; i < this.mRotationWatchers.size(); ++i) {
                RotationWatcher rotationWatcher = this.mRotationWatchers.get(i);
                if (watcherBinder != rotationWatcher.watcher.asBinder()) continue;
                RotationWatcher removed = this.mRotationWatchers.remove(i);
                IBinder binder = removed.watcher.asBinder();
                if (binder != null) {
                    binder.unlinkToDeath(removed.deathRecipient, 0);
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredOptionsPanelGravity() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int rotation = this.getRotation();
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            if (displayContent.mInitialDisplayWidth < displayContent.mInitialDisplayHeight) {
                switch (rotation) {
                    default: {
                        return 81;
                    }
                    case 1: {
                        return 85;
                    }
                    case 2: {
                        return 81;
                    }
                    case 3: 
                }
                return 8388691;
            }
            switch (rotation) {
                default: {
                    return 85;
                }
                case 1: {
                    return 81;
                }
                case 2: {
                    return 8388691;
                }
                case 3: 
            }
            return 81;
        }
    }

    @Override
    public boolean startViewServer(int port) {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "startViewServer")) {
            return false;
        }
        if (port < 1024) {
            return false;
        }
        if (this.mViewServer != null) {
            if (!this.mViewServer.isRunning()) {
                try {
                    return this.mViewServer.start();
                }
                catch (IOException e) {
                    Slog.w(TAG, "View server did not start");
                }
            }
            return false;
        }
        try {
            this.mViewServer = new ViewServer(this, port);
            return this.mViewServer.start();
        }
        catch (IOException e) {
            Slog.w(TAG, "View server did not start");
            return false;
        }
    }

    private boolean isSystemSecure() {
        return "1".equals(SystemProperties.get(SYSTEM_SECURE, "1")) && "0".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
    }

    @Override
    public boolean stopViewServer() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "stopViewServer")) {
            return false;
        }
        if (this.mViewServer != null) {
            return this.mViewServer.stop();
        }
        return false;
    }

    @Override
    public boolean isViewServerRunning() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "isViewServerRunning")) {
            return false;
        }
        return this.mViewServer != null && this.mViewServer.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerListWindows(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowList windows = new WindowList();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                windows.addAll(displayContent.getWindowList());
            }
        }
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            int count = windows.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = (WindowState)windows.get(i);
                out.write(Integer.toHexString(System.identityHashCode(w)));
                out.write(32);
                out.append(w.mAttrs.getTitle());
                out.write(10);
            }
            out.write("DONE.\n");
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerGetFocusedWindow(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowState focusedWindow = this.getFocusedWindow();
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            if (focusedWindow != null) {
                out.write(Integer.toHexString(System.identityHashCode(focusedWindow)));
                out.write(32);
                out.append(focusedWindow.mAttrs.getTitle());
            }
            out.write(10);
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerWindowCommand(Socket client, String command, String parameters) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean success = true;
        Parcel data = null;
        Parcel reply = null;
        BufferedWriter out = null;
        try {
            int index = parameters.indexOf(32);
            if (index == -1) {
                index = parameters.length();
            }
            String code = parameters.substring(0, index);
            int hashCode = (int)Long.parseLong(code, 16);
            parameters = index < parameters.length() ? parameters.substring(index + 1) : "";
            WindowState window = this.findWindow(hashCode);
            if (window == null) {
                boolean bl = false;
                return bl;
            }
            data = Parcel.obtain();
            data.writeInterfaceToken("android.view.IWindow");
            data.writeString(command);
            data.writeString(parameters);
            data.writeInt(1);
            ParcelFileDescriptor.fromSocket(client).writeToParcel(data, 0);
            reply = Parcel.obtain();
            IBinder binder = window.mClient.asBinder();
            binder.transact(1, data, reply, 0);
            reply.readException();
            if (!client.isOutputShutdown()) {
                out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                out.write("DONE\n");
                out.flush();
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Could not send command " + command + " with parameters " + parameters, e);
            success = false;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWindowsChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].windowsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFocusChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].focusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState findWindow(int hashCode) {
        if (hashCode == -1) {
            return this.getFocusedWindow();
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState w = (WindowState)windows.get(winNdx);
                    if (System.identityHashCode(w) != hashCode) continue;
                    return w;
                }
            }
        }
        return null;
    }

    void sendNewConfiguration() {
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration computeNewConfiguration() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.computeNewConfigurationLocked();
        }
    }

    private Configuration computeNewConfigurationLocked() {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = new Configuration();
        config.fontScale = 0.0f;
        this.computeScreenConfigurationLocked(config);
        return config;
    }

    private void adjustDisplaySizeRanges(DisplayInfo displayInfo, int rotation, int uiMode, int dw, int dh) {
        int height;
        int width = this.mPolicy.getConfigDisplayWidth(dw, dh, rotation, uiMode);
        if (width < displayInfo.smallestNominalAppWidth) {
            displayInfo.smallestNominalAppWidth = width;
        }
        if (width > displayInfo.largestNominalAppWidth) {
            displayInfo.largestNominalAppWidth = width;
        }
        if ((height = this.mPolicy.getConfigDisplayHeight(dw, dh, rotation, uiMode)) < displayInfo.smallestNominalAppHeight) {
            displayInfo.smallestNominalAppHeight = height;
        }
        if (height > displayInfo.largestNominalAppHeight) {
            displayInfo.largestNominalAppHeight = height;
        }
    }

    private int reduceConfigLayout(int curLayout, int rotation, float density, int dw, int dh, int uiMode) {
        int h;
        int shortSize;
        int w = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode);
        int longSize = w;
        if (longSize < (shortSize = (h = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode)))) {
            int tmp = longSize;
            longSize = shortSize;
            shortSize = tmp;
        }
        longSize = (int)((float)longSize / density);
        shortSize = (int)((float)shortSize / density);
        return Configuration.reduceScreenLayout(curLayout, longSize, shortSize);
    }

    private void computeSizeRangesAndScreenLayout(DisplayInfo displayInfo, boolean rotated, int uiMode, int dw, int dh, float density, Configuration outConfig) {
        int unrotDh;
        int unrotDw;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        displayInfo.smallestNominalAppWidth = 0x40000000;
        displayInfo.smallestNominalAppHeight = 0x40000000;
        displayInfo.largestNominalAppWidth = 0;
        displayInfo.largestNominalAppHeight = 0;
        this.adjustDisplaySizeRanges(displayInfo, 0, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 1, uiMode, unrotDh, unrotDw);
        this.adjustDisplaySizeRanges(displayInfo, 2, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 3, uiMode, unrotDh, unrotDw);
        int sl = Configuration.resetScreenLayout(outConfig.screenLayout);
        sl = this.reduceConfigLayout(sl, 0, density, unrotDw, unrotDh, uiMode);
        sl = this.reduceConfigLayout(sl, 1, density, unrotDh, unrotDw, uiMode);
        sl = this.reduceConfigLayout(sl, 2, density, unrotDw, unrotDh, uiMode);
        sl = this.reduceConfigLayout(sl, 3, density, unrotDh, unrotDw, uiMode);
        outConfig.smallestScreenWidthDp = (int)((float)displayInfo.smallestNominalAppWidth / density);
        outConfig.screenLayout = sl;
    }

    private int reduceCompatConfigWidthSize(int curSize, int rotation, int uiMode, DisplayMetrics dm, int dw, int dh) {
        dm.noncompatWidthPixels = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode);
        dm.noncompatHeightPixels = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode);
        float scale = CompatibilityInfo.computeCompatibleScaling(dm, null);
        int size = (int)((float)dm.noncompatWidthPixels / scale / dm.density + 0.5f);
        if (curSize == 0 || size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private int computeCompatSmallestWidth(boolean rotated, int uiMode, DisplayMetrics dm, int dw, int dh) {
        int unrotDh;
        int unrotDw;
        this.mTmpDisplayMetrics.setTo(dm);
        DisplayMetrics tmpDm = this.mTmpDisplayMetrics;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceCompatConfigWidthSize(0, 0, uiMode, tmpDm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 1, uiMode, tmpDm, unrotDh, unrotDw);
        sw = this.reduceCompatConfigWidthSize(sw, 2, uiMode, tmpDm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 3, uiMode, tmpDm, unrotDh, unrotDw);
        return sw;
    }

    DisplayInfo updateDisplayAndOrientationLocked(int uiMode) {
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        int realdw = rotated ? displayContent.mBaseDisplayHeight : displayContent.mBaseDisplayWidth;
        int realdh = rotated ? displayContent.mBaseDisplayWidth : displayContent.mBaseDisplayHeight;
        int dw = realdw;
        int dh = realdh;
        if (this.mAltOrientation) {
            if (realdw > realdh) {
                int maxw = (int)((float)realdh / 1.3f);
                if (maxw < realdw) {
                    dw = maxw;
                }
            } else {
                int maxh = (int)((float)realdw / 1.3f);
                if (maxh < realdh) {
                    dh = maxh;
                }
            }
        }
        int appWidth = this.mPolicy.getNonDecorDisplayWidth(dw, dh, this.mRotation, uiMode);
        int appHeight = this.mPolicy.getNonDecorDisplayHeight(dw, dh, this.mRotation, uiMode);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        displayInfo.rotation = this.mRotation;
        displayInfo.logicalWidth = dw;
        displayInfo.logicalHeight = dh;
        displayInfo.logicalDensityDpi = displayContent.mBaseDisplayDensity;
        displayInfo.appWidth = appWidth;
        displayInfo.appHeight = appHeight;
        displayInfo.getLogicalMetrics(this.mRealDisplayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
        displayInfo.getAppMetrics(this.mDisplayMetrics);
        displayInfo.flags = displayContent.mDisplayScalingDisabled ? (displayInfo.flags |= 0x40000000) : (displayInfo.flags &= 0xBFFFFFFF);
        this.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayContent.getDisplayId(), displayInfo);
        displayContent.mBaseDisplayRect.set(0, 0, dw, dh);
        this.mCompatibleScreenScale = CompatibilityInfo.computeCompatibleScaling(this.mDisplayMetrics, this.mCompatDisplayMetrics);
        return displayInfo;
    }

    void computeScreenConfigurationLocked(Configuration config) {
        boolean hardKeyboardAvailable;
        DisplayInfo displayInfo = this.updateDisplayAndOrientationLocked(config.uiMode);
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        config.orientation = dw <= dh ? 1 : 2;
        config.screenWidthDp = (int)((float)this.mPolicy.getConfigDisplayWidth(dw, dh, this.mRotation, config.uiMode) / this.mDisplayMetrics.density);
        config.screenHeightDp = (int)((float)this.mPolicy.getConfigDisplayHeight(dw, dh, this.mRotation, config.uiMode) / this.mDisplayMetrics.density);
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        this.computeSizeRangesAndScreenLayout(displayInfo, rotated, config.uiMode, dw, dh, this.mDisplayMetrics.density, config);
        config.screenLayout = config.screenLayout & 0xFFFFFCFF | ((displayInfo.flags & 0x10) != 0 ? 512 : 256);
        config.compatScreenWidthDp = (int)((float)config.screenWidthDp / this.mCompatibleScreenScale);
        config.compatScreenHeightDp = (int)((float)config.screenHeightDp / this.mCompatibleScreenScale);
        config.compatSmallestScreenWidthDp = this.computeCompatSmallestWidth(rotated, config.uiMode, this.mDisplayMetrics, dw, dh);
        config.densityDpi = displayInfo.logicalDensityDpi;
        config.touchscreen = 1;
        config.keyboard = 1;
        config.navigation = 1;
        int keyboardPresence = 0;
        int navigationPresence = 0;
        for (InputDevice device : this.mInputManager.getInputDevices()) {
            int presenceFlag;
            if (device.isVirtual()) continue;
            int sources = device.getSources();
            int n = presenceFlag = device.isExternal() ? 2 : 1;
            if (this.mIsTouchDevice) {
                if ((sources & 0x1002) == 4098) {
                    config.touchscreen = 3;
                }
            } else {
                config.touchscreen = 1;
            }
            if ((sources & 0x10004) == 65540) {
                config.navigation = 3;
                navigationPresence |= presenceFlag;
            } else if ((sources & 0x201) == 513 && config.navigation == 1) {
                config.navigation = 2;
                navigationPresence |= presenceFlag;
            }
            if (device.getKeyboardType() != 2) continue;
            config.keyboard = 2;
            keyboardPresence |= presenceFlag;
        }
        if (config.navigation == 1 && this.mHasPermanentDpad) {
            config.navigation = 2;
            navigationPresence |= 1;
        }
        boolean bl = hardKeyboardAvailable = config.keyboard != 1;
        if (hardKeyboardAvailable != this.mHardKeyboardAvailable) {
            this.mHardKeyboardAvailable = hardKeyboardAvailable;
            this.mH.removeMessages(22);
            this.mH.sendEmptyMessage(22);
        }
        config.keyboardHidden = 1;
        config.hardKeyboardHidden = 1;
        config.navigationHidden = 1;
        this.mPolicy.adjustConfigurationLw(config, keyboardPresence, navigationPresence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyHardKeyboardStatusChange() {
        boolean available;
        WindowManagerInternal.OnHardKeyboardStatusChangeListener listener;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            listener = this.mHardKeyboardStatusChangeListener;
            available = this.mHardKeyboardAvailable;
        }
        if (listener != null) {
            listener.onHardKeyboardStatusChange(available);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startMovingTask(IWindow window, float startX, float startY) {
        WindowState win = null;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            win = this.windowForClientLocked(null, window, false);
            if (!this.startPositioningLocked(win, false, startX, startY)) {
                return false;
            }
        }
        try {
            this.mActivityManager.setFocusedTask(win.getTask().mTaskId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScrollingTask(DisplayContent displayContent, int startX, int startY) {
        Task task = null;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int taskId = displayContent.taskIdFromPoint(startX, startY);
            if (taskId >= 0) {
                task = this.mTaskIdToTask.get(taskId);
            }
            if (task == null || !task.isDockedInEffect() || !this.startPositioningLocked(task.getTopVisibleAppMainWindow(), false, startX, startY)) {
                return;
            }
        }
        try {
            this.mActivityManager.setFocusedTask(task.mTaskId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTapOutsideTask(DisplayContent displayContent, int x, int y) {
        int taskId = -1;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = displayContent.findTaskForControlPoint(x, y);
            if (task != null) {
                if (!this.startPositioningLocked(task.getTopVisibleAppMainWindow(), true, x, y)) {
                    return;
                }
                taskId = task.mTaskId;
            } else {
                taskId = displayContent.taskIdFromPoint(x, y);
            }
        }
        if (taskId >= 0) {
            try {
                this.mActivityManager.setFocusedTask(taskId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private boolean startPositioningLocked(WindowState win, boolean resize, float startX, float startY) {
        if (win == null || win.getAppToken() == null) {
            Slog.w(TAG, "startPositioningLocked: Bad window " + win);
            return false;
        }
        if (win.mInputChannel == null) {
            Slog.wtf(TAG, "startPositioningLocked: " + win + " has no input channel, " + " probably being removed");
            return false;
        }
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            Slog.w(TAG, "startPositioningLocked: Invalid display content " + win);
            return false;
        }
        Display display = displayContent.getDisplay();
        this.mTaskPositioner = new TaskPositioner(this);
        this.mTaskPositioner.register(display);
        this.mInputMonitor.updateInputWindowsLw(true);
        WindowState transferFocusFromWin = win;
        if (this.mCurrentFocus != null && this.mCurrentFocus != win && this.mCurrentFocus.mAppToken == win.mAppToken) {
            transferFocusFromWin = this.mCurrentFocus;
        }
        if (!this.mInputManager.transferTouchFocus(transferFocusFromWin.mInputChannel, this.mTaskPositioner.mServerChannel)) {
            Slog.e(TAG, "startPositioningLocked: Unable to transfer touch focus");
            this.mTaskPositioner.unregister();
            this.mTaskPositioner = null;
            this.mInputMonitor.updateInputWindowsLw(true);
            return false;
        }
        this.mTaskPositioner.startDragLocked(win, resize, startX, startY);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPositioning() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mTaskPositioner != null) {
                this.mTaskPositioner.unregister();
                this.mTaskPositioner = null;
                this.mInputMonitor.updateInputWindowsLw(true);
            }
        }
    }

    void adjustForImeIfNeeded(DisplayContent displayContent) {
        boolean imeHeightChanged;
        WindowState imeWin = this.mInputMethodWindow;
        boolean imeVisible = imeWin != null && imeWin.isVisibleLw() && imeWin.isDisplayedLw() && !displayContent.mDividerControllerLocked.isImeHideRequested();
        boolean dockVisible = this.isStackVisibleLocked(3);
        TaskStack imeTargetStack = this.getImeFocusStackLocked();
        int imeDockSide = dockVisible && imeTargetStack != null ? imeTargetStack.getDockSide() : -1;
        boolean imeOnTop = imeDockSide == 2;
        boolean imeOnBottom = imeDockSide == 4;
        boolean dockMinimized = displayContent.mDividerControllerLocked.isMinimizedDock();
        int imeHeight = this.mPolicy.getInputMethodWindowVisibleHeightLw();
        boolean bl = imeHeightChanged = imeVisible && imeHeight != displayContent.mDividerControllerLocked.getImeHeightAdjustedFor();
        if (imeVisible && dockVisible && (imeOnTop || imeOnBottom) && !dockMinimized) {
            ArrayList<TaskStack> stacks = displayContent.getStacks();
            for (int i = stacks.size() - 1; i >= 0; --i) {
                boolean isDockedOnBottom;
                TaskStack stack = stacks.get(i);
                boolean bl2 = isDockedOnBottom = stack.getDockSide() == 4;
                if (stack.isVisibleLocked() && (imeOnBottom || isDockedOnBottom)) {
                    stack.setAdjustedForIme(imeWin, imeOnBottom && imeHeightChanged);
                    continue;
                }
                stack.resetAdjustedForIme(false);
            }
            displayContent.mDividerControllerLocked.setAdjustedForIme(imeOnBottom, true, true, imeWin, imeHeight);
        } else {
            ArrayList<TaskStack> stacks = displayContent.getStacks();
            for (int i = stacks.size() - 1; i >= 0; --i) {
                TaskStack stack = stacks.get(i);
                stack.resetAdjustedForIme(!dockVisible);
            }
            displayContent.mDividerControllerLocked.setAdjustedForIme(false, false, dockVisible, imeWin, imeHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBinder prepareDragSurface(IWindow window, SurfaceSession session, int flags, int width, int height, Surface outSurface) {
        int callerPid = Binder.getCallingPid();
        int callerUid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        Binder token = null;
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                block11: {
                    try {
                        if (this.mDragState == null) {
                            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                            Display display = displayContent.getDisplay();
                            SurfaceControl surface = new SurfaceControl(session, "drag surface", width, height, -3, 4);
                            surface.setLayerStack(display.getLayerStack());
                            float alpha = 1.0f;
                            if ((flags & 0x200) == 0) {
                                alpha = 0.7071f;
                            }
                            surface.setAlpha(alpha);
                            outSurface.copyFrom(surface);
                            IBinder winBinder = window.asBinder();
                            token = new Binder();
                            this.mDragState = new DragState(this, token, surface, flags, winBinder);
                            this.mDragState.mPid = callerPid;
                            this.mDragState.mUid = callerUid;
                            this.mDragState.mOriginalAlpha = alpha;
                            this.mDragState.mToken = new Binder();
                            token = this.mDragState.mToken;
                            this.mH.removeMessages(20, winBinder);
                            Message msg = this.mH.obtainMessage(20, winBinder);
                            this.mH.sendMessageDelayed(msg, 5000L);
                        } else {
                            Slog.w(TAG, "Drag already in progress");
                        }
                    }
                    catch (Surface.OutOfResourcesException e) {
                        Slog.e(TAG, "Can't allocate drag surface w=" + width + " h=" + height, e);
                        if (this.mDragState == null) break block11;
                        this.mDragState.reset();
                        this.mDragState = null;
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "pauseKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.pauseDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "resumeKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.resumeDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventDispatching(boolean enabled) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setEventDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mEventDispatchingEnabled = enabled;
            if (this.mDisplayEnabled) {
                this.mInputMonitor.setEventDispatchingLw(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState getFocusedWindow() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.getFocusedWindowLocked();
        }
    }

    private WindowState getFocusedWindowLocked() {
        return this.mCurrentFocus;
    }

    TaskStack getImeFocusStackLocked() {
        return this.mFocusedApp != null && this.mFocusedApp.mTask != null ? this.mFocusedApp.mTask.mStack : null;
    }

    private void showAuditSafeModeNotification() {
        PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, new Intent("android.intent.action.VIEW", Uri.parse("https://support.google.com/nexus/answer/2852139")), 0);
        String title = this.mContext.getString(17040892);
        Notification notification = new Notification.Builder(this.mContext).setSmallIcon(17301642).setWhen(0L).setOngoing(true).setTicker(title).setLocalOnly(true).setPriority(1).setVisibility(1).setColor(this.mContext.getColor(17170523)).setContentTitle(title).setContentText(this.mContext.getString(17040893)).setContentIntent(pendingIntent).build();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        notificationManager.notifyAsUser(null, 17040892, notification, UserHandle.ALL);
    }

    public boolean detectSafeMode() {
        if (!this.mInputMonitor.waitForInputDevicesReady(1000L)) {
            Slog.w(TAG, "Devices still not ready after waiting 1000 milliseconds before attempting to detect safe mode.");
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "safe_boot_disallowed", 0) != 0) {
            return false;
        }
        int menuState = this.mInputManager.getKeyCodeState(-1, -256, 82);
        int sState = this.mInputManager.getKeyCodeState(-1, -256, 47);
        int dpadState = this.mInputManager.getKeyCodeState(-1, 513, 23);
        int trackballState = this.mInputManager.getScanCodeState(-1, 65540, 272);
        int volumeDownState = this.mInputManager.getKeyCodeState(-1, -256, 25);
        this.mSafeMode = menuState > 0 || sState > 0 || dpadState > 0 || trackballState > 0 || volumeDownState > 0;
        try {
            if (SystemProperties.getInt("persist.sys.safemode", 0) != 0 || SystemProperties.getInt("ro.sys.safemode", 0) != 0) {
                int auditSafeMode = SystemProperties.getInt("persist.sys.audit_safemode", 0);
                if (auditSafeMode == 0) {
                    this.mSafeMode = true;
                    SystemProperties.set("persist.sys.safemode", "");
                } else {
                    int buildDate = SystemProperties.getInt(PROPERTY_BUILD_DATE_UTC, 0);
                    if (auditSafeMode >= buildDate) {
                        this.mSafeMode = true;
                        this.showAuditSafeModeNotification();
                    } else {
                        SystemProperties.set("persist.sys.safemode", "");
                        SystemProperties.set("persist.sys.audit_safemode", "");
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.mSafeMode) {
            Log.i(TAG, "SAFE MODE ENABLED (menu=" + menuState + " s=" + sState + " dpad=" + dpadState + " trackball=" + trackballState + ")");
            SystemProperties.set("ro.sys.safemode", "1");
        } else {
            Log.i(TAG, "SAFE MODE not enabled");
        }
        this.mPolicy.setSafeMode(this.mSafeMode);
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReady() {
        for (Display display : this.mDisplays) {
            this.displayReady(display.getDisplayId());
        }
        HashMap<IBinder, WindowState> remoteException = this.mWindowMap;
        synchronized (remoteException) {
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            this.readForcedDisplayPropertiesLocked(displayContent);
            this.mDisplayReady = true;
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException2) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mIsTouchDevice = this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
            this.configureDisplayPolicyLocked(this.getDefaultDisplayContentLocked());
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException2) {
            // empty catch block
        }
        this.updateCircularDisplayMaskIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayReady(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                this.mAnimator.addDisplayLocked(displayId);
                displayContent.initializeDisplayBaseInfo();
                if (displayContent.mTapDetector != null) {
                    displayContent.mTapDetector.init();
                }
            }
        }
    }

    public void systemReady() {
        this.mPolicy.systemReady();
    }

    void destroyPreservedSurfaceLocked() {
        for (int i = this.mDestroyPreservedSurface.size() - 1; i >= 0; --i) {
            WindowState w = this.mDestroyPreservedSurface.get(i);
            w.mWinAnimator.destroyPreservedSurfaceLocked();
        }
        this.mDestroyPreservedSurface.clear();
    }

    void stopUsingSavedSurfaceLocked() {
        for (int i = this.mFinishedEarlyAnim.size() - 1; i >= 0; --i) {
            AppWindowToken wtoken = this.mFinishedEarlyAnim.get(i);
            wtoken.stopUsingSavedSurfaceLocked();
        }
        this.mFinishedEarlyAnim.clear();
    }

    @Override
    public IWindowSession openSession(IWindowSessionCallback callback, IInputMethodClient client, IInputContext inputContext) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (inputContext == null) {
            throw new IllegalArgumentException("null inputContext");
        }
        Session session = new Session(this, callback, client, inputContext);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inputMethodClientHasFocus(IInputMethodClient client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState imFocus;
            int idx = this.findDesiredInputMethodWindowIndexLocked(false);
            if (idx > 0 && (imFocus = (WindowState)this.getDefaultWindowListLocked().get(idx - 1)) != null) {
                if (imFocus.mAttrs.type == 3 && imFocus.mAppToken != null) {
                    for (int i = 0; i < imFocus.mAppToken.windows.size(); ++i) {
                        WindowState w = (WindowState)imFocus.mAppToken.windows.get(i);
                        if (w == imFocus) continue;
                        Log.i(TAG, "Switching to real app window: " + w);
                        imFocus = w;
                        break;
                    }
                }
                if (imFocus.mSession.mClient != null && imFocus.mSession.mClient.asBinder() == client.asBinder()) {
                    return true;
                }
            }
            if (this.mCurrentFocus != null && this.mCurrentFocus.mSession.mClient != null && this.mCurrentFocus.mSession.mClient.asBinder() == client.asBinder()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getInitialDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                size.x = displayContent.mInitialDisplayWidth;
                size.y = displayContent.mInitialDisplayHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBaseDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                size.x = displayContent.mBaseDisplayWidth;
                size.y = displayContent.mBaseDisplayHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplaySize(int displayId, int width, int height) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                int MIN_WIDTH = 200;
                int MIN_HEIGHT = 200;
                int MAX_SCALE = 2;
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    width = Math.min(Math.max(width, 200), displayContent.mInitialDisplayWidth * 2);
                    height = Math.min(Math.max(height, 200), displayContent.mInitialDisplayHeight * 2);
                    this.setForcedDisplaySizeLocked(displayContent, width, height);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", width + "," + height);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplayScalingMode(int displayId, int mode) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    if (mode < 0 || mode > 1) {
                        mode = 0;
                    }
                    this.setForcedDisplayScalingModeLocked(displayContent, mode);
                    Settings.Global.putInt(this.mContext.getContentResolver(), "display_scaling_force", mode);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void setForcedDisplayScalingModeLocked(DisplayContent displayContent, int mode) {
        Slog.i(TAG, "Using display scaling mode: " + (mode == 0 ? "auto" : "off"));
        displayContent.mDisplayScalingDisabled = mode != 0;
        this.reconfigureDisplayLocked(displayContent);
    }

    private void readForcedDisplayPropertiesLocked(DisplayContent displayContent) {
        int mode;
        int density;
        int pos;
        String sizeStr = Settings.Global.getString(this.mContext.getContentResolver(), "display_size_forced");
        if (sizeStr == null || sizeStr.length() == 0) {
            sizeStr = SystemProperties.get(SIZE_OVERRIDE, null);
        }
        if (sizeStr != null && sizeStr.length() > 0 && (pos = sizeStr.indexOf(44)) > 0 && sizeStr.lastIndexOf(44) == pos) {
            try {
                int width = Integer.parseInt(sizeStr.substring(0, pos));
                int height = Integer.parseInt(sizeStr.substring(pos + 1));
                if (displayContent.mBaseDisplayWidth != width || displayContent.mBaseDisplayHeight != height) {
                    Slog.i(TAG, "FORCED DISPLAY SIZE: " + width + "x" + height);
                    displayContent.mBaseDisplayWidth = width;
                    displayContent.mBaseDisplayHeight = height;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((density = this.getForcedDisplayDensityForUserLocked(this.mCurrentUserId)) != 0) {
            displayContent.mBaseDisplayDensity = density;
        }
        if ((mode = Settings.Global.getInt(this.mContext.getContentResolver(), "display_scaling_force", 0)) != 0) {
            Slog.i(TAG, "FORCED DISPLAY SCALING DISABLED");
            displayContent.mDisplayScalingDisabled = true;
        }
    }

    private void setForcedDisplaySizeLocked(DisplayContent displayContent, int width, int height) {
        Slog.i(TAG, "Using new display size: " + width + "x" + height);
        displayContent.mBaseDisplayWidth = width;
        displayContent.mBaseDisplayHeight = height;
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplaySize(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setForcedDisplaySizeLocked(displayContent, displayContent.mInitialDisplayWidth, displayContent.mInitialDisplayHeight);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", "");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInitialDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                return displayContent.mInitialDisplayDensity;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                return displayContent.mBaseDisplayDensity;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplayDensity(int displayId, int density) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setForcedDisplayDensityLocked(displayContent, density);
                    Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "display_density_forced", Integer.toString(density), this.mCurrentUserId);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplayDensity(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setForcedDisplayDensityLocked(displayContent, displayContent.mInitialDisplayDensity);
                    Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "display_density_forced", "", this.mCurrentUserId);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private int getForcedDisplayDensityForUserLocked(int userId) {
        String densityStr = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "display_density_forced", userId);
        if (densityStr == null || densityStr.length() == 0) {
            densityStr = SystemProperties.get(DENSITY_OVERRIDE, null);
        }
        if (densityStr != null && densityStr.length() > 0) {
            try {
                return Integer.parseInt(densityStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void setForcedDisplayDensityLocked(DisplayContent displayContent, int density) {
        displayContent.mBaseDisplayDensity = density;
        this.reconfigureDisplayLocked(displayContent);
    }

    private void reconfigureDisplayLocked(DisplayContent displayContent) {
        if (!this.mDisplayReady) {
            return;
        }
        this.configureDisplayPolicyLocked(displayContent);
        displayContent.layoutNeeded = true;
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mTempConfiguration.setToDefaults();
        this.mTempConfiguration.updateFrom(this.mCurConfiguration);
        this.computeScreenConfigurationLocked(this.mTempConfiguration);
        if (configChanged |= this.mCurConfiguration.diff(this.mTempConfiguration) != 0) {
            this.mWaitingForConfig = true;
            this.startFreezingDisplayLocked(false, 0, 0);
            this.mH.sendEmptyMessage(18);
            if (!this.mReconfigureOnConfigurationChanged.contains(displayContent)) {
                this.mReconfigureOnConfigurationChanged.add(displayContent);
            }
        }
        this.mWindowPlacerLocked.performSurfacePlacement();
    }

    private void configureDisplayPolicyLocked(DisplayContent displayContent) {
        this.mPolicy.setInitialDisplaySize(displayContent.getDisplay(), displayContent.mBaseDisplayWidth, displayContent.mBaseDisplayHeight, displayContent.mBaseDisplayDensity);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        this.mPolicy.setDisplayOverscan(displayContent.getDisplay(), displayInfo.overscanLeft, displayInfo.overscanTop, displayInfo.overscanRight, displayInfo.overscanBottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOverscan(int displayId, int left, int top, int right, int bottom) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setOverscanLocked(displayContent, left, top, right, bottom);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void setOverscanLocked(DisplayContent displayContent, int left, int top, int right, int bottom) {
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        displayInfo.overscanLeft = left;
        displayInfo.overscanTop = top;
        displayInfo.overscanRight = right;
        displayInfo.overscanBottom = bottom;
        this.mDisplaySettings.setOverscanLocked(displayInfo.uniqueId, displayInfo.name, left, top, right, bottom);
        this.mDisplaySettings.writeSettingsLocked();
        this.reconfigureDisplayLocked(displayContent);
    }

    final WindowState windowForClientLocked(Session session, IWindow client, boolean throwOnError) {
        return this.windowForClientLocked(session, client.asBinder(), throwOnError);
    }

    final WindowState windowForClientLocked(Session session, IBinder client, boolean throwOnError) {
        WindowState win = this.mWindowMap.get(client);
        if (win == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " does not exist");
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        if (session != null && win.mSession != session) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " is in session " + win.mSession + ", not " + session);
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        return win;
    }

    final void rebuildAppWindowListLocked() {
        this.rebuildAppWindowListLocked(this.getDefaultDisplayContentLocked());
    }

    private void rebuildAppWindowListLocked(DisplayContent displayContent) {
        int stackNdx;
        WindowList windows = displayContent.getWindowList();
        int NW = windows.size();
        int lastBelow = -1;
        int numRemoved = 0;
        if (this.mRebuildTmp.length < NW) {
            this.mRebuildTmp = new WindowState[NW + 10];
        }
        int i = 0;
        while (i < NW) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mAppToken != null) {
                WindowState win = (WindowState)windows.remove(i);
                win.mRebuilding = true;
                this.mRebuildTmp[numRemoved] = win;
                this.mWindowsChanged = true;
                --NW;
                ++numRemoved;
                continue;
            }
            if (lastBelow == i - 1 && w.mAttrs.type == 2013) {
                lastBelow = i;
            }
            ++i;
        }
        i = ++lastBelow;
        ArrayList<TaskStack> stacks = displayContent.getStacks();
        int numStacks = stacks.size();
        for (stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            AppTokenList exitingAppTokens = stacks.get((int)stackNdx).mExitingAppTokens;
            int NT = exitingAppTokens.size();
            for (int j = 0; j < NT; ++j) {
                i = this.reAddAppWindowsLocked(displayContent, i, (WindowToken)exitingAppTokens.get(j));
            }
        }
        for (stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ArrayList<Task> tasks = stacks.get(stackNdx).getTasks();
            int numTasks = tasks.size();
            for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                int numTokens = tokens.size();
                for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                    AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                    if (wtoken.mIsExiting && !wtoken.waitingForReplacement()) continue;
                    i = this.reAddAppWindowsLocked(displayContent, i, wtoken);
                }
            }
        }
        if ((i -= lastBelow) != numRemoved) {
            displayContent.layoutNeeded = true;
            Slog.w(TAG, "On display=" + displayContent.getDisplayId() + " Rebuild removed " + numRemoved + " windows but added " + i + " rebuildAppWindowListLocked() " + " callers=" + Debug.getCallers(10));
            for (i = 0; i < numRemoved; ++i) {
                WindowState ws = this.mRebuildTmp[i];
                if (!ws.mRebuilding) continue;
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
                ws.dump(pw, "", true);
                ((PrintWriter)pw).flush();
                Slog.w(TAG, "This window was lost: " + ws);
                Slog.w(TAG, sw.toString());
                ws.mWinAnimator.destroySurfaceLocked();
            }
            Slog.w(TAG, "Current app token list:");
            this.dumpAppTokensLocked();
            Slog.w(TAG, "Final window list:");
            this.dumpWindowsLocked();
        }
        Arrays.fill(this.mRebuildTmp, null);
    }

    void makeWindowFreezingScreenIfNeededLocked(WindowState w) {
        if (!this.okToDisplay() && this.mWindowsFreezingScreen != 2) {
            w.mOrientationChanging = true;
            w.mLastFreezeDuration = 0;
            this.mWindowPlacerLocked.mOrientationChangeComplete = false;
            if (this.mWindowsFreezingScreen == 0) {
                this.mWindowsFreezingScreen = 1;
                this.mH.removeMessages(11);
                this.mH.sendEmptyMessageDelayed(11, 2000L);
            }
        }
    }

    int handleAnimatingStoppedAndTransitionLocked() {
        int changes = 0;
        this.mAppTransition.setIdle();
        for (int i = this.mNoAnimationNotifyOnTransitionFinished.size() - 1; i >= 0; --i) {
            IBinder token = this.mNoAnimationNotifyOnTransitionFinished.get(i);
            this.mAppTransition.notifyAppTransitionFinishedLocked(token);
        }
        this.mNoAnimationNotifyOnTransitionFinished.clear();
        this.mWallpaperControllerLocked.hideDeferredWallpapersIfNeeded();
        ArrayList<TaskStack> stacks = this.getDefaultDisplayContentLocked().getStacks();
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ArrayList<Task> tasks = stacks.get(stackNdx).getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    ((AppWindowToken)tokens.get((int)tokenNdx)).sendingToBottom = false;
                }
            }
        }
        this.rebuildAppWindowListLocked();
        this.moveInputMethodWindowsIfNeededLocked(true);
        this.mWindowPlacerLocked.mWallpaperMayChange = true;
        this.mFocusMayChange = true;
        return changes |= 1;
    }

    void updateResizingWindows(WindowState w) {
        WindowStateAnimator winAnimator = w.mWinAnimator;
        if (w.mHasSurface && w.mLayoutSeq == this.mLayoutSeq && !w.isGoneForLayoutLw()) {
            Task task = w.getTask();
            if (task != null && task.mStack.getBoundsAnimating()) {
                return;
            }
            w.setReportResizeHints();
            boolean configChanged = w.isConfigChanged();
            boolean dragResizingChanged = w.isDragResizeChanged() && !w.isDragResizingChangeReported();
            w.mLastFrame.set(w.mFrame);
            if (w.mContentInsetsChanged || w.mVisibleInsetsChanged || winAnimator.mSurfaceResized || w.mOutsetsChanged || w.mFrameSizeChanged || configChanged || dragResizingChanged || !w.isResizedWhileNotDragResizingReported()) {
                if (w.mAppToken != null && w.mAppDied) {
                    w.mAppToken.removeAllDeadWindows();
                    return;
                }
                w.mLastOverscanInsets.set(w.mOverscanInsets);
                w.mLastContentInsets.set(w.mContentInsets);
                w.mLastVisibleInsets.set(w.mVisibleInsets);
                w.mLastStableInsets.set(w.mStableInsets);
                w.mLastOutsets.set(w.mOutsets);
                this.makeWindowFreezingScreenIfNeededLocked(w);
                if (w.mOrientationChanging || dragResizingChanged || w.isResizedWhileNotDragResizing()) {
                    winAnimator.mDrawState = 1;
                    if (w.mAppToken != null) {
                        w.mAppToken.clearAllDrawn();
                    }
                }
                if (!this.mResizingWindows.contains(w)) {
                    this.mResizingWindows.add(w);
                }
            } else if (w.mOrientationChanging && w.isDrawnLw()) {
                w.mOrientationChanging = false;
                w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
            }
        }
    }

    void checkDrawnWindowsLocked() {
        if (this.mWaitingForDrawn.isEmpty() || this.mWaitingForDrawnCallback == null) {
            return;
        }
        for (int j = this.mWaitingForDrawn.size() - 1; j >= 0; --j) {
            WindowState win = this.mWaitingForDrawn.get(j);
            if (win.mRemoved || !win.mHasSurface || !win.mPolicyVisibility) {
                this.mWaitingForDrawn.remove(win);
                continue;
            }
            if (!win.hasDrawnLw()) continue;
            this.mWaitingForDrawn.remove(win);
        }
        if (this.mWaitingForDrawn.isEmpty()) {
            this.mH.removeMessages(24);
            this.mH.sendEmptyMessage(33);
        }
    }

    void setHoldScreenLocked(Session newHoldScreen) {
        boolean hold;
        boolean bl = hold = newHoldScreen != null;
        if (hold && this.mHoldingScreenOn != newHoldScreen) {
            this.mHoldingScreenWakeLock.setWorkSource(new WorkSource(newHoldScreen.mUid));
        }
        this.mHoldingScreenOn = newHoldScreen;
        boolean state = this.mHoldingScreenWakeLock.isHeld();
        if (hold != state) {
            if (hold) {
                this.mLastWakeLockHoldingWindow = this.mWindowPlacerLocked.mHoldScreenWindow;
                this.mLastWakeLockObscuringWindow = null;
                this.mHoldingScreenWakeLock.acquire();
                this.mPolicy.keepScreenOnStartedLw();
            } else {
                this.mLastWakeLockHoldingWindow = null;
                this.mLastWakeLockObscuringWindow = this.mWindowPlacerLocked.mObsuringWindow;
                this.mPolicy.keepScreenOnStoppedLw();
                this.mHoldingScreenWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestTraversal() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowPlacerLocked.requestTraversal();
        }
    }

    void scheduleAnimationLocked() {
        if (!this.mAnimationScheduled) {
            this.mAnimationScheduled = true;
            this.mChoreographer.postFrameCallback(this.mAnimator.mAnimationFrameCallback);
        }
    }

    boolean needsLayout() {
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            if (!displayContent.layoutNeeded) continue;
            return true;
        }
        return false;
    }

    int adjustAnimationBackground(WindowStateAnimator winAnimator) {
        WindowList windows = winAnimator.mWin.getWindowList();
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState testWin = (WindowState)windows.get(i);
            if (!testWin.mIsWallpaper || !testWin.isVisibleNow()) continue;
            return testWin.mWinAnimator.mAnimLayer;
        }
        return winAnimator.mAnimLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimSomeSurfaceMemoryLocked(WindowStateAnimator winAnimator, String operation, boolean secure) {
        WindowSurfaceController surfaceController = winAnimator.mSurfaceController;
        boolean leakedSurface = false;
        boolean killedApps = false;
        EventLog.writeEvent(31000, winAnimator.mWin.toString(), winAnimator.mSession.mPid, operation);
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            Slog.i(TAG, "Out of memory for surface!  Looking for leaks...");
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState ws = (WindowState)windows.get(winNdx);
                    WindowStateAnimator wsa = ws.mWinAnimator;
                    if (wsa.mSurfaceController == null) continue;
                    if (!this.mSessions.contains(wsa.mSession)) {
                        Slog.w(TAG, "LEAKED SURFACE (session doesn't exist): " + ws + " surface=" + wsa.mSurfaceController + " token=" + ws.mToken + " pid=" + ws.mSession.mPid + " uid=" + ws.mSession.mUid);
                        wsa.destroySurface();
                        this.mForceRemoves.add(ws);
                        leakedSurface = true;
                        continue;
                    }
                    if (ws.mAppToken == null || !ws.mAppToken.clientHidden) continue;
                    Slog.w(TAG, "LEAKED SURFACE (app token hidden): " + ws + " surface=" + wsa.mSurfaceController + " token=" + ws.mAppToken + " saved=" + ws.hasSavedSurface());
                    wsa.destroySurface();
                    leakedSurface = true;
                }
            }
            if (!leakedSurface) {
                Slog.w(TAG, "No leaked surfaces; killing applicatons!");
                SparseIntArray pidCandidates = new SparseIntArray();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    int numWindows = windows.size();
                    for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                        WindowState ws = (WindowState)windows.get(winNdx);
                        if (this.mForceRemoves.contains(ws)) continue;
                        WindowStateAnimator wsa = ws.mWinAnimator;
                        if (wsa.mSurfaceController == null) continue;
                        pidCandidates.append(wsa.mSession.mPid, wsa.mSession.mPid);
                    }
                    if (pidCandidates.size() <= 0) continue;
                    int[] pids = new int[pidCandidates.size()];
                    for (int i = 0; i < pids.length; ++i) {
                        pids[i] = pidCandidates.keyAt(i);
                    }
                    try {
                        if (!this.mActivityManager.killPids(pids, "Free memory", secure)) continue;
                        killedApps = true;
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            if (leakedSurface || killedApps) {
                Slog.w(TAG, "Looks like we have reclaimed some memory, clearing surface for retry.");
                if (surfaceController != null) {
                    winAnimator.destroySurface();
                    this.scheduleRemoveStartingWindowLocked(winAnimator.mWin.mAppToken);
                }
                try {
                    winAnimator.mWin.mClient.dispatchGetNewSurface();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return leakedSurface || killedApps;
    }

    boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows) {
        WindowState newFocus = this.computeFocusedWindowLocked();
        if (this.mCurrentFocus != newFocus) {
            Trace.traceBegin(32L, "wmUpdateFocus");
            this.mH.removeMessages(2);
            this.mH.sendEmptyMessage(2);
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            boolean imWindowChanged = this.moveInputMethodWindowsIfNeededLocked(mode != 1 && mode != 3);
            if (imWindowChanged) {
                displayContent.layoutNeeded = true;
                newFocus = this.computeFocusedWindowLocked();
            }
            WindowState oldFocus = this.mCurrentFocus;
            this.mCurrentFocus = newFocus;
            this.mLosingFocus.remove(newFocus);
            int focusChanged = this.mPolicy.focusChangedLw(oldFocus, newFocus);
            if (imWindowChanged && oldFocus != this.mInputMethodWindow) {
                if (mode == 2) {
                    this.mWindowPlacerLocked.performLayoutLockedInner(displayContent, true, updateInputWindows);
                    focusChanged &= 0xFFFFFFFE;
                } else if (mode == 3) {
                    this.mLayersController.assignLayersLocked(displayContent.getWindowList());
                }
            }
            if ((focusChanged & 1) != 0) {
                displayContent.layoutNeeded = true;
                if (mode == 2) {
                    this.mWindowPlacerLocked.performLayoutLockedInner(displayContent, true, updateInputWindows);
                }
            }
            if (mode != 1) {
                this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, updateInputWindows);
            }
            this.adjustForImeIfNeeded(displayContent);
            Trace.traceEnd(32L);
            return true;
        }
        return false;
    }

    private WindowState computeFocusedWindowLocked() {
        int displayCount = this.mDisplayContents.size();
        for (int i = 0; i < displayCount; ++i) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(i);
            WindowState win = this.findFocusedWindowLocked(displayContent);
            if (win == null) continue;
            return win;
        }
        return null;
    }

    WindowState findFocusedWindowLocked(DisplayContent displayContent) {
        WindowList windows = displayContent.getWindowList();
        for (int i = windows.size() - 1; i >= 0; --i) {
            AppWindowToken wtoken;
            WindowState win = (WindowState)windows.get(i);
            if (!win.canReceiveKeys() || (wtoken = win.mAppToken) != null && (wtoken.removed || wtoken.sendingToBottom)) continue;
            if (wtoken != null && win.mAttrs.type != 3 && this.mFocusedApp != null) {
                ArrayList<Task> tasks = displayContent.getTasks();
                for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                    AppWindowToken token;
                    int tokenNdx;
                    AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                    for (tokenNdx = tokens.size() - 1; tokenNdx >= 0 && wtoken != (token = (AppWindowToken)tokens.get(tokenNdx)); --tokenNdx) {
                        if (this.mFocusedApp != token || !token.windowsAreFocusable()) continue;
                        return null;
                    }
                    if (tokenNdx >= 0) break;
                }
            }
            return win;
        }
        return null;
    }

    private void startFreezingDisplayLocked(boolean inTransaction, int exitAnim, int enterAnim) {
        if (this.mDisplayFrozen) {
            return;
        }
        if (!this.mDisplayReady || !this.mPolicy.isScreenOn()) {
            return;
        }
        this.mScreenFrozenLock.acquire();
        this.mDisplayFrozen = true;
        this.mDisplayFreezeTime = SystemClock.elapsedRealtime();
        this.mLastFinishedFreezeSource = null;
        this.mInputMonitor.freezeInputDispatchingLw();
        this.mPolicy.setLastInputMethodWindowLw(null, null);
        if (this.mAppTransition.isTransitionSet()) {
            this.mAppTransition.freeze();
        }
        this.mExitAnimId = exitAnim;
        this.mEnterAnimId = enterAnim;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null) {
            screenRotationAnimation.kill();
        }
        boolean isSecure = false;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        for (int i = 0; i < N; ++i) {
            WindowState ws = (WindowState)windows.get(i);
            if (!ws.isOnScreen() || (ws.mAttrs.flags & 0x2000) == 0) continue;
            isSecure = true;
            break;
        }
        displayContent.updateDisplayInfo();
        screenRotationAnimation = new ScreenRotationAnimation(this.mContext, displayContent, this.mFxSession, inTransaction, this.mPolicy.isDefaultOrientationForced(), isSecure);
        this.mAnimator.setScreenRotationAnimationLocked(displayId, screenRotationAnimation);
    }

    void stopFreezingDisplayLocked() {
        if (!this.mDisplayFrozen) {
            return;
        }
        if (this.mWaitingForConfig || this.mAppsFreezingScreen > 0 || this.mWindowsFreezingScreen == 1 || this.mClientFreezingScreen || !this.mOpeningApps.isEmpty()) {
            return;
        }
        this.mDisplayFrozen = false;
        this.mLastDisplayFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
        StringBuilder sb = new StringBuilder(128);
        sb.append("Screen frozen for ");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, sb);
        if (this.mLastFinishedFreezeSource != null) {
            sb.append(" due to ");
            sb.append(this.mLastFinishedFreezeSource);
        }
        Slog.i(TAG, sb.toString());
        this.mH.removeMessages(17);
        this.mH.removeMessages(30);
        boolean updateRotation = false;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot()) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            boolean isDimming = displayContent.isDimming();
            if (!this.mPolicy.validateRotationAnimationLw(this.mExitAnimId, this.mEnterAnimId, isDimming)) {
                this.mEnterAnimId = 0;
                this.mExitAnimId = 0;
            }
            if (screenRotationAnimation.dismiss(this.mFxSession, 10000L, this.getTransitionAnimationScaleLocked(), displayInfo.logicalWidth, displayInfo.logicalHeight, this.mExitAnimId, this.mEnterAnimId)) {
                this.scheduleAnimationLocked();
            } else {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
                updateRotation = true;
            }
        } else {
            if (screenRotationAnimation != null) {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
            }
            updateRotation = true;
        }
        this.mInputMonitor.thawInputDispatchingLw();
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mH.removeMessages(15);
        this.mH.sendEmptyMessageDelayed(15, 2000L);
        this.mScreenFrozenLock.release();
        if (updateRotation) {
            configChanged |= this.updateRotationUncheckedLocked(false);
        }
        if (configChanged) {
            this.mH.sendEmptyMessage(18);
        }
    }

    static int getPropertyInt(String[] tokens, int index, int defUnits, int defDps, DisplayMetrics dm) {
        String str;
        if (index < tokens.length && (str = tokens[index]) != null && str.length() > 0) {
            try {
                int val = Integer.parseInt(str);
                return val;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defUnits == 0) {
            return defDps;
        }
        int val = (int)TypedValue.applyDimension(defUnits, defDps, dm);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWatermarkInTransaction() {
        if (this.mWatermark != null) {
            return;
        }
        File file = new File("/system/etc/setup.conf");
        FileInputStream in = null;
        FilterInputStream ind = null;
        try {
            String[] toks;
            in = new FileInputStream(file);
            ind = new DataInputStream(in);
            String line = ((DataInputStream)ind).readLine();
            if (line != null && (toks = line.split("%")) != null && toks.length > 0) {
                this.mWatermark = new Watermark(this.getDefaultDisplayContentLocked().getDisplay(), this.mRealDisplayMetrics, this.mFxSession, toks);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (ind != null) {
                try {
                    ind.close();
                }
                catch (IOException iOException) {}
            } else if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusBarVisibilityChanged(int visibility) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mLastStatusBarVisibility = visibility;
            visibility = this.mPolicy.adjustSystemUiVisibilityLw(visibility);
            this.updateStatusBarVisibilityLocked(visibility);
        }
    }

    boolean updateStatusBarVisibilityLocked(int visibility) {
        if (this.mLastDispatchedSystemUiVisibility == visibility) {
            return false;
        }
        int globalDiff = (visibility ^ this.mLastDispatchedSystemUiVisibility) & 7 & ~visibility;
        this.mLastDispatchedSystemUiVisibility = visibility;
        this.mInputManager.setSystemUiVisibility(visibility);
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        for (int i = 0; i < N; ++i) {
            WindowState ws = (WindowState)windows.get(i);
            try {
                int curValue = ws.mSystemUiVisibility;
                int diff = (curValue ^ visibility) & globalDiff;
                int newValue = curValue & ~diff | visibility & diff;
                if (newValue != curValue) {
                    ++ws.mSeq;
                    ws.mSystemUiVisibility = newValue;
                }
                if (newValue == curValue && !ws.mAttrs.hasSystemUiListeners) continue;
                ws.mClient.dispatchSystemUiVisibilityChanged(ws.mSeq, visibility, newValue, diff);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reevaluateStatusBarVisibility() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int visibility = this.mPolicy.adjustSystemUiVisibilityLw(this.mLastStatusBarVisibility);
            if (this.updateStatusBarVisibilityLocked(visibility)) {
                this.mWindowPlacerLocked.requestTraversal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowManagerPolicy.InputConsumer addInputConsumer(Looper looper, InputEventReceiver.Factory inputEventReceiverFactory) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            HideNavInputConsumer inputConsumerImpl = new HideNavInputConsumer(this, looper, inputEventReceiverFactory);
            this.mInputConsumer = inputConsumerImpl;
            this.mInputMonitor.updateInputWindowsLw(true);
            return inputConsumerImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeInputConsumer() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mInputConsumer != null) {
                this.mInputConsumer = null;
                this.mInputMonitor.updateInputWindowsLw(true);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createWallpaperInputConsumer(InputChannel inputChannel) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWallpaperInputConsumer = new InputConsumerImpl(this, "wallpaper input", inputChannel);
            this.mWallpaperInputConsumer.mWindowHandle.hasWallpaper = true;
            this.mInputMonitor.updateInputWindowsLw(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWallpaperInputConsumer() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWallpaperInputConsumer != null) {
                this.mWallpaperInputConsumer.disposeChannelsLw();
                this.mWallpaperInputConsumer = null;
                this.mInputMonitor.updateInputWindowsLw(true);
            }
        }
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mPolicy.hasNavigationBar();
    }

    @Override
    public void lockNow(Bundle options) {
        this.mPolicy.lockNow(options);
    }

    public void showRecentApps(boolean fromHome) {
        this.mPolicy.showRecentApps(fromHome);
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearWindowContentFrameStats(IBinder token) {
        if (!this.checkCallingPermission("android.permission.FRAME_STATS", "clearWindowContentFrameStats()")) {
            throw new SecurityException("Requires FRAME_STATS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = this.mWindowMap.get(token);
            if (windowState == null) {
                return false;
            }
            WindowSurfaceController surfaceController = windowState.mWinAnimator.mSurfaceController;
            if (surfaceController == null) {
                return false;
            }
            return surfaceController.clearWindowContentFrameStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowContentFrameStats getWindowContentFrameStats(IBinder token) {
        if (!this.checkCallingPermission("android.permission.FRAME_STATS", "getWindowContentFrameStats()")) {
            throw new SecurityException("Requires FRAME_STATS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowContentFrameStats stats;
            WindowState windowState = this.mWindowMap.get(token);
            if (windowState == null) {
                return null;
            }
            WindowSurfaceController surfaceController = windowState.mWinAnimator.mSurfaceController;
            if (surfaceController == null) {
                return null;
            }
            if (this.mTempWindowRenderStats == null) {
                this.mTempWindowRenderStats = new WindowContentFrameStats();
            }
            if (!surfaceController.getWindowContentFrameStats(stats = this.mTempWindowRenderStats)) {
                return null;
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunching(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindow = this.findAppWindowToken(token);
            if (appWindow != null) {
                appWindow.startRelaunching();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunchingFinished(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindow = this.findAppWindowToken(token);
            if (appWindow != null) {
                appWindow.finishRelaunching();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunchesCleared(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindow = this.findAppWindowToken(token);
            if (appWindow != null) {
                appWindow.clearRelaunching();
            }
        }
    }

    @Override
    public int getDockedDividerInsetsLw() {
        return this.getDefaultDisplayContentLocked().getDockedDividerController().getContentInsets();
    }

    void dumpPolicyLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER POLICY STATE (dumpsys window policy)");
        this.mPolicy.dump("    ", pw, args);
    }

    void dumpAnimatorLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER ANIMATOR STATE (dumpsys window animator)");
        this.mAnimator.dumpLocked(pw, "    ", dumpAll);
    }

    void dumpTokensLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER TOKENS (dumpsys window tokens)");
        if (!this.mTokenMap.isEmpty()) {
            pw.println("  All tokens:");
            for (WindowToken token : this.mTokenMap.values()) {
                pw.print("  ");
                pw.print(token);
                if (dumpAll) {
                    pw.println(':');
                    token.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        this.mWallpaperControllerLocked.dumpTokens(pw, "  ", dumpAll);
        if (!this.mFinishedStarting.isEmpty()) {
            pw.println();
            pw.println("  Finishing start of application tokens:");
            for (int i = this.mFinishedStarting.size() - 1; i >= 0; --i) {
                WindowToken token;
                token = this.mFinishedStarting.get(i);
                pw.print("  Finished Starting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                if (dumpAll) {
                    pw.println(':');
                    token.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (!this.mOpeningApps.isEmpty() || !this.mClosingApps.isEmpty()) {
            pw.println();
            if (this.mOpeningApps.size() > 0) {
                pw.print("  mOpeningApps=");
                pw.println(this.mOpeningApps);
            }
            if (this.mClosingApps.size() > 0) {
                pw.print("  mClosingApps=");
                pw.println(this.mClosingApps);
            }
        }
    }

    void dumpSessionsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER SESSIONS (dumpsys window sessions)");
        for (int i = 0; i < this.mSessions.size(); ++i) {
            Session s = this.mSessions.valueAt(i);
            pw.print("  Session ");
            pw.print(s);
            pw.println(':');
            s.dump(pw, "    ");
        }
    }

    void dumpDisplayContentsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER DISPLAY CONTENTS (dumpsys window displays)");
        if (this.mDisplayReady) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                displayContent.dump("  ", pw);
            }
        } else {
            pw.println("  NO DISPLAY");
        }
    }

    void dumpWindowsLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        pw.println("WINDOW MANAGER WINDOWS (dumpsys window windows)");
        this.dumpWindowsNoHeaderLocked(pw, dumpAll, windows);
    }

    void dumpWindowsNoHeaderLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        WindowState w;
        int i;
        int displayNdx;
        int numDisplays = this.mDisplayContents.size();
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
            for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                WindowState w2 = (WindowState)windowList.get(winNdx);
                if (windows != null && !windows.contains(w2)) continue;
                pw.print("  Window #");
                pw.print(winNdx);
                pw.print(' ');
                pw.print(w2);
                pw.println(":");
                w2.dump(pw, "    ", dumpAll || windows != null);
            }
        }
        if (this.mInputMethodDialogs.size() > 0) {
            pw.println();
            pw.println("  Input method dialogs:");
            for (i = this.mInputMethodDialogs.size() - 1; i >= 0; --i) {
                w = this.mInputMethodDialogs.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  IM Dialog #");
                pw.print(i);
                pw.print(": ");
                pw.println(w);
            }
        }
        if (this.mPendingRemove.size() > 0) {
            pw.println();
            pw.println("  Remove pending for:");
            for (i = this.mPendingRemove.size() - 1; i >= 0; --i) {
                w = this.mPendingRemove.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Remove #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mForceRemoves != null && this.mForceRemoves.size() > 0) {
            pw.println();
            pw.println("  Windows force removing:");
            for (i = this.mForceRemoves.size() - 1; i >= 0; --i) {
                w = this.mForceRemoves.get(i);
                pw.print("  Removing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mDestroySurface.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to destroy their surface:");
            for (i = this.mDestroySurface.size() - 1; i >= 0; --i) {
                w = this.mDestroySurface.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Destroy #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mLosingFocus.size() > 0) {
            pw.println();
            pw.println("  Windows losing focus:");
            for (i = this.mLosingFocus.size() - 1; i >= 0; --i) {
                w = this.mLosingFocus.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Losing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mResizingWindows.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to resize:");
            for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
                w = this.mResizingWindows.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Resizing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWaitingForDrawn.size() > 0) {
            pw.println();
            pw.println("  Clients waiting for these windows to be drawn:");
            for (i = this.mWaitingForDrawn.size() - 1; i >= 0; --i) {
                WindowState win = this.mWaitingForDrawn.get(i);
                pw.print("  Waiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(win);
            }
        }
        pw.println();
        pw.print("  mCurConfiguration=");
        pw.println(this.mCurConfiguration);
        pw.print("  mHasPermanentDpad=");
        pw.println(this.mHasPermanentDpad);
        pw.print("  mCurrentFocus=");
        pw.println(this.mCurrentFocus);
        if (this.mLastFocus != this.mCurrentFocus) {
            pw.print("  mLastFocus=");
            pw.println(this.mLastFocus);
        }
        pw.print("  mFocusedApp=");
        pw.println(this.mFocusedApp);
        if (this.mInputMethodTarget != null) {
            pw.print("  mInputMethodTarget=");
            pw.println(this.mInputMethodTarget);
        }
        pw.print("  mInTouchMode=");
        pw.print(this.mInTouchMode);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        pw.print("  mLastDisplayFreezeDuration=");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, pw);
        if (this.mLastFinishedFreezeSource != null) {
            pw.print(" due to ");
            pw.print(this.mLastFinishedFreezeSource);
        }
        pw.println();
        pw.print("  mLastWakeLockHoldingWindow=");
        pw.print(this.mLastWakeLockHoldingWindow);
        pw.print(" mLastWakeLockObscuringWindow=");
        pw.print(this.mLastWakeLockObscuringWindow);
        pw.println();
        this.mInputMonitor.dump(pw, "  ");
        if (dumpAll) {
            pw.print("  mSystemDecorLayer=");
            pw.print(this.mSystemDecorLayer);
            pw.print(" mScreenRect=");
            pw.println(this.mScreenRect.toShortString());
            if (this.mLastStatusBarVisibility != 0) {
                pw.print("  mLastStatusBarVisibility=0x");
                pw.println(Integer.toHexString(this.mLastStatusBarVisibility));
            }
            if (this.mInputMethodWindow != null) {
                pw.print("  mInputMethodWindow=");
                pw.println(this.mInputMethodWindow);
            }
            this.mWindowPlacerLocked.dump(pw, "  ");
            this.mWallpaperControllerLocked.dump(pw, "  ");
            this.mLayersController.dump(pw, "  ");
            pw.print("  mSystemBooted=");
            pw.print(this.mSystemBooted);
            pw.print(" mDisplayEnabled=");
            pw.println(this.mDisplayEnabled);
            if (this.needsLayout()) {
                pw.print("  layoutNeeded on displays=");
                for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                    if (!displayContent.layoutNeeded) continue;
                    pw.print(displayContent.getDisplayId());
                }
                pw.println();
            }
            pw.print("  mTransactionSequence=");
            pw.println(this.mTransactionSequence);
            pw.print("  mDisplayFrozen=");
            pw.print(this.mDisplayFrozen);
            pw.print(" windows=");
            pw.print(this.mWindowsFreezingScreen);
            pw.print(" client=");
            pw.print(this.mClientFreezingScreen);
            pw.print(" apps=");
            pw.print(this.mAppsFreezingScreen);
            pw.print(" waitingForConfig=");
            pw.println(this.mWaitingForConfig);
            pw.print("  mRotation=");
            pw.print(this.mRotation);
            pw.print(" mAltOrientation=");
            pw.println(this.mAltOrientation);
            pw.print("  mLastWindowForcedOrientation=");
            pw.print(this.mLastWindowForcedOrientation);
            pw.print(" mLastOrientation=");
            pw.println(this.mLastOrientation);
            pw.print("  mDeferredRotationPauseCount=");
            pw.println(this.mDeferredRotationPauseCount);
            pw.print("  Animation settings: disabled=");
            pw.print(this.mAnimationsDisabled);
            pw.print(" window=");
            pw.print(this.mWindowAnimationScaleSetting);
            pw.print(" transition=");
            pw.print(this.mTransitionAnimationScaleSetting);
            pw.print(" animator=");
            pw.println(this.mAnimatorDurationScaleSetting);
            pw.print(" mSkipAppTransitionAnimation=");
            pw.println(this.mSkipAppTransitionAnimation);
            pw.println("  mLayoutToAnim:");
            this.mAppTransition.dump(pw, "    ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dumpWindows(PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        WindowList windows = new WindowList();
        if ("apps".equals(name) || "visible".equals(name) || "visible-apps".equals(name)) {
            boolean appsOnly = name.contains("apps");
            boolean visibleOnly = name.contains("visible");
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                if (appsOnly) {
                    this.dumpDisplayContentsLocked(pw, true);
                }
                int numDisplays = this.mDisplayContents.size();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                        WindowState w = (WindowState)windowList.get(winNdx);
                        if (visibleOnly && !w.mWinAnimator.getShown() || appsOnly && w.mAppToken == null) continue;
                        windows.add(w);
                    }
                }
            }
        }
        int objectId = 0;
        try {
            objectId = Integer.parseInt(name, 16);
            name = null;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState w = (WindowState)windowList.get(winNdx);
                    if (name != null) {
                        if (!w.mAttrs.getTitle().toString().contains(name)) continue;
                        windows.add(w);
                        continue;
                    }
                    if (System.identityHashCode(w) != objectId) continue;
                    windows.add(w);
                }
            }
        }
        if (windows.size() <= 0) {
            return false;
        }
        HashMap<IBinder, WindowState> hashMap2 = this.mWindowMap;
        synchronized (hashMap2) {
            this.dumpWindowsLocked(pw, dumpAll, windows);
        }
        return true;
    }

    void dumpLastANRLocked(PrintWriter pw) {
        pw.println("WINDOW MANAGER LAST ANR (dumpsys window lastanr)");
        if (this.mLastANRState == null) {
            pw.println("  <no ANR has occurred since boot>");
        } else {
            pw.println(this.mLastANRState);
        }
    }

    public void saveANRStateLocked(AppWindowToken appWindowToken, WindowState windowState, String reason) {
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
        pw.println("  ANR time: " + DateFormat.getInstance().format(new Date()));
        if (appWindowToken != null) {
            pw.println("  Application at fault: " + appWindowToken.stringName);
        }
        if (windowState != null) {
            pw.println("  Window at fault: " + windowState.mAttrs.getTitle());
        }
        if (reason != null) {
            pw.println("  Reason: " + reason);
        }
        ((PrintWriter)pw).println();
        this.dumpWindowsNoHeaderLocked(pw, true, null);
        ((PrintWriter)pw).println();
        pw.println("Last ANR continued");
        this.dumpDisplayContentsLocked(pw, true);
        ((PrintWriter)pw).close();
        this.mLastANRState = sw.toString();
        this.mH.removeMessages(38);
        this.mH.sendEmptyMessageDelayed(38, 0x6DDD00L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WindowManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        boolean dumpAll = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Window manager dump options:");
                pw.println("  [-a] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    l[astanr]: last ANR information");
                pw.println("    p[policy]: policy state");
                pw.println("    a[animator]: animator state");
                pw.println("    s[essions]: active sessions");
                pw.println("    surfaces: active surfaces (debugging enabled only)");
                pw.println("    d[isplays]: active display contents");
                pw.println("    t[okens]: token list");
                pw.println("    w[indows]: window list");
                pw.println("  cmd may also be a NAME to dump windows.  NAME may");
                pw.println("    be a partial substring in a window name, a");
                pw.println("    Window hex object identifier, or");
                pw.println("    \"all\" for all windows, or");
                pw.println("    \"visible\" for the visible windows.");
                pw.println("    \"visible-apps\" for the visible app windows.");
                pw.println("  -a: include all available server state.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("lastanr".equals(cmd) || "l".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpLastANRLocked(pw);
                }
                return;
            }
            if ("policy".equals(cmd) || "p".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpPolicyLocked(pw, args, true);
                }
                return;
            }
            if ("animator".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpAnimatorLocked(pw, args, true);
                }
                return;
            }
            if ("sessions".equals(cmd) || "s".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpSessionsLocked(pw, true);
                }
                return;
            }
            if ("surfaces".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    WindowSurfaceController.SurfaceTrace.dumpAllSurfaces(pw, null);
                }
                return;
            }
            if ("displays".equals(cmd) || "d".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpDisplayContentsLocked(pw, true);
                }
                return;
            }
            if ("tokens".equals(cmd) || "t".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpTokensLocked(pw, true);
                }
                return;
            }
            if ("windows".equals(cmd) || "w".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if ("all".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if (!this.dumpWindows(pw, cmd, args, opti, dumpAll)) {
                pw.println("Bad window command, or no windows match: " + cmd);
                pw.println("Use -h for help.");
            }
            return;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpLastANRLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPolicyLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpAnimatorLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpSessionsLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            WindowSurfaceController.SurfaceTrace.dumpAllSurfaces(pw, dumpAll ? "-------------------------------------------------------------------------------" : null);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpDisplayContentsLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpTokensLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpWindowsLocked(pw, dumpAll, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
        }
    }

    private DisplayContent newDisplayContentLocked(Display display) {
        DisplayContent displayContent = new DisplayContent(display, this);
        int displayId = display.getDisplayId();
        this.mDisplayContents.put(displayId, displayContent);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Rect rect = new Rect();
        this.mDisplaySettings.getOverscanLocked(displayInfo.name, displayInfo.uniqueId, rect);
        displayInfo.overscanLeft = rect.left;
        displayInfo.overscanTop = rect.top;
        displayInfo.overscanRight = rect.right;
        displayInfo.overscanBottom = rect.bottom;
        this.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayId, displayInfo);
        this.configureDisplayPolicyLocked(displayContent);
        if (displayId == 0) {
            displayContent.mTapDetector = new TaskTapPointerEventListener(this, displayContent);
            this.registerPointerEventListener(displayContent.mTapDetector);
            this.registerPointerEventListener(this.mMousePositionTracker);
        }
        return displayContent;
    }

    public void createDisplayContentLocked(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("getDisplayContent: display must not be null");
        }
        this.getDisplayContentLocked(display.getDisplayId());
    }

    public DisplayContent getDisplayContentLocked(int displayId) {
        Display display;
        DisplayContent displayContent = this.mDisplayContents.get(displayId);
        if (displayContent == null && (display = this.mDisplayManager.getDisplay(displayId)) != null) {
            displayContent = this.newDisplayContentLocked(display);
        }
        return displayContent;
    }

    public DisplayContent getDefaultDisplayContentLocked() {
        return this.getDisplayContentLocked(0);
    }

    public WindowList getDefaultWindowListLocked() {
        return this.getDefaultDisplayContentLocked().getWindowList();
    }

    public DisplayInfo getDefaultDisplayInfoLocked() {
        return this.getDefaultDisplayContentLocked().getDisplayInfo();
    }

    public WindowList getWindowListLocked(Display display) {
        return this.getWindowListLocked(display.getDisplayId());
    }

    public WindowList getWindowListLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        return displayContent != null ? displayContent.getWindowList() : null;
    }

    public void onDisplayAdded(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(27, displayId, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDisplayAdded(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Display display = this.mDisplayManager.getDisplay(displayId);
            if (display != null) {
                this.createDisplayContentLocked(display);
                this.displayReady(displayId);
            }
            this.mWindowPlacerLocked.requestTraversal();
        }
    }

    public void onDisplayRemoved(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(28, displayId, 0));
    }

    private void handleDisplayRemovedLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        if (displayContent != null) {
            if (displayContent.isAnimating()) {
                displayContent.mDeferredRemoval = true;
                return;
            }
            this.mDisplayContents.delete(displayId);
            displayContent.close();
            if (displayId == 0) {
                this.unregisterPointerEventListener(displayContent.mTapDetector);
                this.unregisterPointerEventListener(this.mMousePositionTracker);
            }
        }
        this.mAnimator.removeDisplayLocked(displayId);
        this.mWindowPlacerLocked.requestTraversal();
    }

    public void onDisplayChanged(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(29, displayId, 0));
    }

    private void handleDisplayChangedLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        if (displayContent != null) {
            displayContent.updateDisplayInfo();
        }
        this.mWindowPlacerLocked.requestTraversal();
    }

    @Override
    public Object getWindowManagerLock() {
        return this.mWindowMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplacingWindow(IBinder token, boolean animate) {
        AppWindowToken appWindowToken = null;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            appWindowToken = this.findAppWindowToken(token);
            if (appWindowToken == null || !appWindowToken.isVisible()) {
                Slog.w(TAG, "Attempted to set replacing window on non-existing app token " + token);
                return;
            }
            appWindowToken.setReplacingWindows(animate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplacingWindows(IBinder token, boolean childrenOnly) {
        AppWindowToken appWindowToken = null;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            appWindowToken = this.findAppWindowToken(token);
            if (appWindowToken == null || !appWindowToken.isVisible()) {
                Slog.w(TAG, "Attempted to set replacing window on non-existing app token " + token);
                return;
            }
            if (childrenOnly) {
                appWindowToken.setReplacingChildren();
            } else {
                appWindowToken.setReplacingWindows(false);
            }
            this.scheduleClearReplacingWindowIfNeeded(token, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleClearReplacingWindowIfNeeded(IBinder token, boolean replacing) {
        AppWindowToken appWindowToken = null;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            appWindowToken = this.findAppWindowToken(token);
            if (appWindowToken == null) {
                Slog.w(TAG, "Attempted to reset replacing window on non-existing app token " + token);
                return;
            }
            if (replacing) {
                this.scheduleReplacingWindowTimeouts(appWindowToken);
            } else {
                appWindowToken.resetReplacingWindows();
            }
        }
    }

    void scheduleReplacingWindowTimeouts(AppWindowToken appWindowToken) {
        if (!this.mReplacingWindowTimeouts.contains(appWindowToken)) {
            this.mReplacingWindowTimeouts.add(appWindowToken);
        }
        this.mH.removeMessages(46);
        this.mH.sendEmptyMessageDelayed(46, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDockedStackSide() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack dockedStack = this.getDefaultDisplayContentLocked().getDockedStackVisibleForUserLocked();
            return dockedStack == null ? -1 : dockedStack.getDockSide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDockedStackResizing(boolean resizing) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getDefaultDisplayContentLocked().getDockedDividerController().setResizing(resizing);
            this.requestTraversal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDockedStackDividerTouchRegion(Rect touchRegion) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getDefaultDisplayContentLocked().getDockedDividerController().setTouchRegion(touchRegion);
            this.setFocusTaskRegionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResizeDimLayer(boolean visible, int targetStackId, float alpha) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getDefaultDisplayContentLocked().getDockedDividerController().setResizeDimLayer(visible, targetStackId, alpha);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateResizePinnedStack(final Rect bounds, final int animationDuration) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            final TaskStack stack = this.mStackIdToStack.get(4);
            if (stack == null) {
                Slog.w(TAG, "animateResizePinnedStack: stackId 4 not found.");
                return;
            }
            final Rect originalBounds = new Rect();
            stack.getBounds(originalBounds);
            UiThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    WindowManagerService.this.mBoundsAnimationController.animateBounds(stack, originalBounds, bounds, animationDuration);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskResizeable(int taskId, int resizeMode) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task != null) {
                task.setResizeable(resizeMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceResizableTasks(boolean forceResizableTasks) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mForceResizableTasks = forceResizableTasks;
        }
    }

    static int dipToPixel(int dip, DisplayMetrics displayMetrics) {
        return (int)TypedValue.applyDimension(1, dip, displayMetrics);
    }

    @Override
    public void registerDockedStackListener(IDockedStackListener listener) {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerDockedStackListener()")) {
            return;
        }
        this.getDefaultDisplayContentLocked().mDividerControllerLocked.registerDockedStackListener(listener);
    }

    @Override
    public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) {
        try {
            WindowState focusedWindow = this.getFocusedWindow();
            if (focusedWindow != null && focusedWindow.mClient != null) {
                this.getFocusedWindow().mClient.requestAppKeyboardShortcuts(receiver, deviceId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStableInsets(Rect outInsets) throws RemoteException {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getStableInsetsLocked(outInsets);
        }
    }

    void getStableInsetsLocked(Rect outInsets) {
        DisplayInfo di = this.getDefaultDisplayInfoLocked();
        this.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, outInsets);
    }

    private void getNonDecorInsetsLocked(Rect outInsets) {
        DisplayInfo di = this.getDefaultDisplayInfoLocked();
        this.mPolicy.getNonDecorInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, outInsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtractStableInsets(Rect inOutBounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getStableInsetsLocked(this.mTmpRect2);
            DisplayInfo di = this.getDefaultDisplayInfoLocked();
            this.mTmpRect.set(0, 0, di.logicalWidth, di.logicalHeight);
            this.subtractInsets(this.mTmpRect, this.mTmpRect2, inOutBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtractNonDecorInsets(Rect inOutBounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getNonDecorInsetsLocked(this.mTmpRect2);
            DisplayInfo di = this.getDefaultDisplayInfoLocked();
            this.mTmpRect.set(0, 0, di.logicalWidth, di.logicalHeight);
            this.subtractInsets(this.mTmpRect, this.mTmpRect2, inOutBounds);
        }
    }

    void subtractInsets(Rect display, Rect insets, Rect inOutBounds) {
        this.mTmpRect3.set(display);
        this.mTmpRect3.inset(insets);
        inOutBounds.intersect(this.mTmpRect3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSmallestWidthForTaskBounds(Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.getDefaultDisplayContentLocked().getDockedDividerController().getSmallestWidthDpForBounds(bounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePointerIcon(IWindow client) {
        float mouseY;
        float mouseX;
        Object object = this.mMousePositionTracker;
        synchronized (object) {
            if (!this.mMousePositionTracker.mLatestEventWasMouse) {
                return;
            }
            mouseX = this.mMousePositionTracker.mLatestMouseX;
            mouseY = this.mMousePositionTracker.mLatestMouseY;
        }
        object = this.mWindowMap;
        synchronized (object) {
            if (this.mDragState != null) {
                return;
            }
            WindowState callingWin = this.windowForClientLocked(null, client, false);
            if (callingWin == null) {
                Slog.w(TAG, "Bad requesting window " + client);
                return;
            }
            DisplayContent displayContent = callingWin.getDisplayContent();
            if (displayContent == null) {
                return;
            }
            WindowState windowUnderPointer = displayContent.getTouchableWinAtPointLocked(mouseX, mouseY);
            if (windowUnderPointer != callingWin) {
                return;
            }
            try {
                windowUnderPointer.mClient.updatePointerIcon(windowUnderPointer.translateToWindowX(mouseX), windowUnderPointer.translateToWindowY(mouseY));
            }
            catch (RemoteException e) {
                Slog.w(TAG, "unable to update pointer icon");
            }
        }
    }

    void restorePointerIconLocked(DisplayContent displayContent, float latestX, float latestY) {
        this.mMousePositionTracker.updatePosition(latestX, latestY);
        WindowState windowUnderPointer = displayContent.getTouchableWinAtPointLocked(latestX, latestY);
        if (windowUnderPointer != null) {
            try {
                windowUnderPointer.mClient.updatePointerIcon(windowUnderPointer.translateToWindowX(latestX), windowUnderPointer.translateToWindowY(latestY));
            }
            catch (RemoteException e) {
                Slog.w(TAG, "unable to restore pointer icon");
            }
        } else {
            InputManager.getInstance().setPointerIconType(1000);
        }
    }

    @Override
    public void registerShortcutKey(long shortcutCode, IShortcutService shortcutKeyReceiver) throws RemoteException {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerShortcutKey")) {
            throw new SecurityException("Requires REGISTER_WINDOW_MANAGER_LISTENERS permission");
        }
        this.mPolicy.registerShortcutKey(shortcutCode, shortcutKeyReceiver);
    }

    private final class LocalService
    extends WindowManagerInternal {
        private LocalService() {
        }

        @Override
        public void requestTraversalFromDisplayManager() {
            WindowManagerService.this.requestTraversal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationSpec(MagnificationSpec spec) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    throw new IllegalStateException("Magnification callbacks not set!");
                }
                WindowManagerService.this.mAccessibilityController.setMagnificationSpecLocked(spec);
            }
            if (Binder.getCallingPid() != Process.myPid()) {
                spec.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getMagnificationRegion(Region magnificationRegion) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    throw new IllegalStateException("Magnification callbacks not set!");
                }
                WindowManagerService.this.mAccessibilityController.getMagnificationRegionLocked(magnificationRegion);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MagnificationSpec getCompatibleMagnificationSpecForWindow(IBinder windowToken) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.mWindowMap.get(windowToken);
                if (windowState == null) {
                    return null;
                }
                MagnificationSpec spec = null;
                if (WindowManagerService.this.mAccessibilityController != null) {
                    spec = WindowManagerService.this.mAccessibilityController.getMagnificationSpecForWindowLocked(windowState);
                }
                if ((spec == null || spec.isNop()) && windowState.mGlobalScale == 1.0f) {
                    return null;
                }
                spec = spec == null ? MagnificationSpec.obtain() : MagnificationSpec.obtain(spec);
                spec.scale *= windowState.mGlobalScale;
                return spec;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationCallbacks(WindowManagerInternal.MagnificationCallbacks callbacks) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                }
                WindowManagerService.this.mAccessibilityController.setMagnificationCallbacksLocked(callbacks);
                if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                    WindowManagerService.this.mAccessibilityController = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setWindowsForAccessibilityCallback(WindowManagerInternal.WindowsForAccessibilityCallback callback) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                }
                WindowManagerService.this.mAccessibilityController.setWindowsForAccessibilityCallback(callback);
                if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                    WindowManagerService.this.mAccessibilityController = null;
                }
            }
        }

        @Override
        public void setInputFilter(IInputFilter filter) {
            WindowManagerService.this.mInputManager.setInputFilter(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IBinder getFocusedWindowToken() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.getFocusedWindowLocked();
                if (windowState != null) {
                    return windowState.mClient.asBinder();
                }
                return null;
            }
        }

        @Override
        public boolean isKeyguardLocked() {
            return WindowManagerService.this.isKeyguardLocked();
        }

        @Override
        public void showGlobalActions() {
            WindowManagerService.this.showGlobalActions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getWindowFrame(IBinder token, Rect outBounds) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.mWindowMap.get(token);
                if (windowState != null) {
                    outBounds.set(windowState.mFrame);
                } else {
                    outBounds.setEmpty();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitForAllWindowsDrawn(Runnable callback, long timeout) {
            boolean allWindowsDrawn = false;
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mWaitingForDrawnCallback = callback;
                WindowList windows = WindowManagerService.this.getDefaultWindowListLocked();
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    boolean isForceHiding = WindowManagerService.this.mPolicy.isForceHiding(win.mAttrs);
                    boolean keyguard = WindowManagerService.this.mPolicy.isKeyguardHostWindow(win.mAttrs);
                    if (!win.isVisibleLw() || win.mAppToken == null && !isForceHiding && !keyguard) continue;
                    win.mWinAnimator.mDrawState = 1;
                    win.mLastContentInsets.set(-1, -1, -1, -1);
                    WindowManagerService.this.mWaitingForDrawn.add(win);
                    if (isForceHiding) break;
                }
                WindowManagerService.this.mWindowPlacerLocked.requestTraversal();
                WindowManagerService.this.mH.removeMessages(24);
                if (WindowManagerService.this.mWaitingForDrawn.isEmpty()) {
                    allWindowsDrawn = true;
                } else {
                    WindowManagerService.this.mH.sendEmptyMessageDelayed(24, timeout);
                    WindowManagerService.this.checkDrawnWindowsLocked();
                }
            }
            if (allWindowsDrawn) {
                callback.run();
            }
        }

        @Override
        public void addWindowToken(IBinder token, int type) {
            WindowManagerService.this.addWindowToken(token, type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeWindowToken(IBinder token, boolean removeWindows) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowToken wtoken;
                if (removeWindows && (wtoken = WindowManagerService.this.mTokenMap.remove(token)) != null) {
                    wtoken.removeAllWindows();
                }
                WindowManagerService.this.removeWindowToken(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerAppTransitionListener(WindowManagerInternal.AppTransitionListener listener) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mAppTransition.registerListenerLocked(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInputMethodWindowVisibleHeight() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                return WindowManagerService.this.mPolicy.getInputMethodWindowVisibleHeightLw();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveLastInputMethodWindowForTransition() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mInputMethodWindow != null) {
                    WindowManagerService.this.mPolicy.setLastInputMethodWindowLw(WindowManagerService.this.mInputMethodWindow, WindowManagerService.this.mInputMethodTarget);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearLastInputMethodWindowForTransition() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mPolicy.setLastInputMethodWindowLw(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isHardKeyboardAvailable() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                return WindowManagerService.this.mHardKeyboardAvailable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnHardKeyboardStatusChangeListener(WindowManagerInternal.OnHardKeyboardStatusChangeListener listener) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mHardKeyboardStatusChangeListener = listener;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isStackVisible(int stackId) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                return WindowManagerService.this.isStackVisibleLocked(stackId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDockedDividerResizing() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                return WindowManagerService.this.getDefaultDisplayContentLocked().getDockedDividerController().isResizing();
            }
        }
    }

    private static class MousePositionTracker
    implements WindowManagerPolicy.PointerEventListener {
        private boolean mLatestEventWasMouse;
        private float mLatestMouseX;
        private float mLatestMouseY;

        private MousePositionTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updatePosition(float x, float y) {
            MousePositionTracker mousePositionTracker = this;
            synchronized (mousePositionTracker) {
                this.mLatestEventWasMouse = true;
                this.mLatestMouseX = x;
                this.mLatestMouseY = y;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPointerEvent(MotionEvent motionEvent) {
            if (motionEvent.isFromSource(8194)) {
                this.updatePosition(motionEvent.getRawX(), motionEvent.getRawY());
            } else {
                MousePositionTracker mousePositionTracker = this;
                synchronized (mousePositionTracker) {
                    this.mLatestEventWasMouse = false;
                }
            }
        }
    }

    private static final class HideNavInputConsumer
    extends InputConsumerImpl
    implements WindowManagerPolicy.InputConsumer {
        private final InputEventReceiver mInputEventReceiver;

        HideNavInputConsumer(WindowManagerService service, Looper looper, InputEventReceiver.Factory inputEventReceiverFactory) {
            super(service, "input consumer", null);
            this.mInputEventReceiver = inputEventReceiverFactory.createInputEventReceiver(this.mClientChannel, looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dismiss() {
            if (this.mService.removeInputConsumer()) {
                HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
                synchronized (hashMap) {
                    this.mInputEventReceiver.dispose();
                    this.disposeChannelsLw();
                }
            }
        }
    }

    final class H
    extends Handler {
        public static final int REPORT_FOCUS_CHANGE = 2;
        public static final int REPORT_LOSING_FOCUS = 3;
        public static final int DO_TRAVERSAL = 4;
        public static final int ADD_STARTING = 5;
        public static final int REMOVE_STARTING = 6;
        public static final int FINISHED_STARTING = 7;
        public static final int REPORT_APPLICATION_TOKEN_WINDOWS = 8;
        public static final int REPORT_APPLICATION_TOKEN_DRAWN = 9;
        public static final int WINDOW_FREEZE_TIMEOUT = 11;
        public static final int APP_TRANSITION_TIMEOUT = 13;
        public static final int PERSIST_ANIMATION_SCALE = 14;
        public static final int FORCE_GC = 15;
        public static final int ENABLE_SCREEN = 16;
        public static final int APP_FREEZE_TIMEOUT = 17;
        public static final int SEND_NEW_CONFIGURATION = 18;
        public static final int REPORT_WINDOWS_CHANGE = 19;
        public static final int DRAG_START_TIMEOUT = 20;
        public static final int DRAG_END_TIMEOUT = 21;
        public static final int REPORT_HARD_KEYBOARD_STATUS_CHANGE = 22;
        public static final int BOOT_TIMEOUT = 23;
        public static final int WAITING_FOR_DRAWN_TIMEOUT = 24;
        public static final int SHOW_STRICT_MODE_VIOLATION = 25;
        public static final int DO_ANIMATION_CALLBACK = 26;
        public static final int DO_DISPLAY_ADDED = 27;
        public static final int DO_DISPLAY_REMOVED = 28;
        public static final int DO_DISPLAY_CHANGED = 29;
        public static final int CLIENT_FREEZE_TIMEOUT = 30;
        public static final int TAP_OUTSIDE_TASK = 31;
        public static final int NOTIFY_ACTIVITY_DRAWN = 32;
        public static final int ALL_WINDOWS_DRAWN = 33;
        public static final int NEW_ANIMATOR_SCALE = 34;
        public static final int SHOW_CIRCULAR_DISPLAY_MASK = 35;
        public static final int SHOW_EMULATOR_DISPLAY_OVERLAY = 36;
        public static final int CHECK_IF_BOOT_ANIMATION_FINISHED = 37;
        public static final int RESET_ANR_MESSAGE = 38;
        public static final int WALLPAPER_DRAW_PENDING_TIMEOUT = 39;
        public static final int FINISH_TASK_POSITIONING = 40;
        public static final int UPDATE_DOCKED_STACK_DIVIDER = 41;
        public static final int RESIZE_STACK = 42;
        public static final int RESIZE_TASK = 43;
        public static final int TWO_FINGER_SCROLL_START = 44;
        public static final int WINDOW_REPLACEMENT_TIMEOUT = 46;
        public static final int NOTIFY_APP_TRANSITION_STARTING = 47;
        public static final int NOTIFY_APP_TRANSITION_CANCELLED = 48;
        public static final int NOTIFY_APP_TRANSITION_FINISHED = 49;
        public static final int NOTIFY_STARTING_WINDOW_DRAWN = 50;
        public static final int UPDATE_ANIMATION_SCALE = 51;
        public static final int WINDOW_REMOVE_TIMEOUT = 52;
        public static final int NOTIFY_DOCKED_STACK_MINIMIZED_CHANGED = 53;
        public static final int SEAMLESS_ROTATION_TIMEOUT = 54;
        public static final int UNUSED = 0;

        H() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            block64 : switch (msg.what) {
                case 2: {
                    WindowState newFocus;
                    WindowState lastFocus;
                    AccessibilityController accessibilityController = null;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (WindowManagerService.this.mAccessibilityController != null && WindowManagerService.this.getDefaultDisplayContentLocked().getDisplayId() == 0) {
                            accessibilityController = WindowManagerService.this.mAccessibilityController;
                        }
                        if ((lastFocus = WindowManagerService.this.mLastFocus) == (newFocus = WindowManagerService.this.mCurrentFocus)) {
                            return;
                        }
                        WindowManagerService.this.mLastFocus = newFocus;
                        if (newFocus != null && lastFocus != null && !newFocus.isDisplayedLw()) {
                            WindowManagerService.this.mLosingFocus.add(lastFocus);
                            lastFocus = null;
                        }
                    }
                    if (accessibilityController != null) {
                        accessibilityController.onWindowFocusChangedNotLocked();
                    }
                    if (newFocus != null) {
                        newFocus.reportFocusChangedSerialized(true, WindowManagerService.this.mInTouchMode);
                        WindowManagerService.this.notifyFocusChanged();
                    }
                    if (lastFocus == null) break;
                    lastFocus.reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    break;
                }
                case 3: {
                    ArrayList<WindowState> losers;
                    HashMap<IBinder, WindowState> newFocus = WindowManagerService.this.mWindowMap;
                    synchronized (newFocus) {
                        losers = WindowManagerService.this.mLosingFocus;
                        WindowManagerService.this.mLosingFocus = new ArrayList();
                    }
                    int N = losers.size();
                    for (int i = 0; i < N; ++i) {
                        losers.get(i).reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    }
                    break;
                }
                case 4: {
                    HashMap<IBinder, WindowState> losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        break;
                    }
                }
                case 5: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    StartingData sd = wtoken.startingData;
                    if (sd == null) {
                        return;
                    }
                    View view = null;
                    try {
                        Configuration overrideConfig = wtoken != null && wtoken.mTask != null ? wtoken.mTask.mOverrideConfig : null;
                        view = WindowManagerService.this.mPolicy.addStartingWindow(wtoken.token, sd.pkg, sd.theme, sd.compatInfo, sd.nonLocalizedLabel, sd.labelRes, sd.icon, sd.logo, sd.windowFlags, overrideConfig);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when adding starting window", e);
                    }
                    if (view == null) break;
                    boolean abort = false;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (wtoken.removed || wtoken.startingData == null) {
                            if (wtoken.startingWindow != null) {
                                wtoken.startingWindow = null;
                                wtoken.startingData = null;
                                abort = true;
                            }
                        } else {
                            wtoken.startingView = view;
                        }
                    }
                    if (!abort) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(wtoken.token, view);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                    }
                    break;
                }
                case 6: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    IBinder token = null;
                    View view2 = null;
                    HashMap<IBinder, WindowState> abort = WindowManagerService.this.mWindowMap;
                    synchronized (abort) {
                        if (wtoken.startingWindow != null) {
                            view2 = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                            wtoken.startingDisplayed = false;
                        }
                    }
                    if (view2 == null) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(token, view2);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                    }
                    break;
                }
                case 7: {
                    IBinder token = null;
                    View view = null;
                    while (true) {
                        HashMap<IBinder, WindowState> view2 = WindowManagerService.this.mWindowMap;
                        synchronized (view2) {
                            int N = WindowManagerService.this.mFinishedStarting.size();
                            if (N <= 0) {
                                break block64;
                            }
                            AppWindowToken wtoken = WindowManagerService.this.mFinishedStarting.remove(N - 1);
                            if (wtoken.startingWindow == null) {
                                continue;
                            }
                            view = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                            wtoken.startingDisplayed = false;
                        }
                        try {
                            WindowManagerService.this.mPolicy.removeStartingWindow(token, view);
                        }
                        catch (Exception e) {
                            Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                        }
                    }
                }
                case 9: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    try {
                        wtoken.appToken.windowsDrawn();
                    }
                    catch (RemoteException view) {}
                    break;
                }
                case 8: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    boolean nowVisible = msg.arg1 != 0;
                    boolean nowGone = msg.arg2 != 0;
                    try {
                        if (nowVisible) {
                            wtoken.appToken.windowsVisible();
                            break;
                        }
                        wtoken.appToken.windowsGone();
                    }
                    catch (RemoteException N) {}
                    break;
                }
                case 11: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        Slog.w(WindowManagerService.TAG, "Window freeze timeout expired.");
                        WindowManagerService.this.mWindowsFreezingScreen = 2;
                        WindowList windows = WindowManagerService.this.getDefaultWindowListLocked();
                        int i = windows.size();
                        while (i > 0) {
                            WindowState w = (WindowState)windows.get(--i);
                            if (!w.mOrientationChanging) continue;
                            w.mOrientationChanging = false;
                            w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - WindowManagerService.this.mDisplayFreezeTime);
                            Slog.w(WindowManagerService.TAG, "Force clearing orientation change: " + w);
                        }
                        WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        break;
                    }
                }
                case 13: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        if (WindowManagerService.this.mAppTransition.isTransitionSet() || !WindowManagerService.this.mOpeningApps.isEmpty() || !WindowManagerService.this.mClosingApps.isEmpty()) {
                            WindowManagerService.this.mAppTransition.setTimeout();
                            WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        }
                        break;
                    }
                }
                case 14: {
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.this.mWindowAnimationScaleSetting);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.this.mTransitionAnimationScaleSetting);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.this.mAnimatorDurationScaleSetting);
                    break;
                }
                case 51: {
                    int mode = msg.arg1;
                    switch (mode) {
                        case 0: {
                            WindowManagerService.this.mWindowAnimationScaleSetting = Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.this.mWindowAnimationScaleSetting);
                            break;
                        }
                        case 1: {
                            WindowManagerService.this.mTransitionAnimationScaleSetting = Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.this.mTransitionAnimationScaleSetting);
                            break;
                        }
                        case 2: {
                            WindowManagerService.this.mAnimatorDurationScaleSetting = Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.this.mAnimatorDurationScaleSetting);
                            WindowManagerService.this.dispatchNewAnimatorScaleLocked(null);
                        }
                    }
                    break;
                }
                case 15: {
                    HashMap<IBinder, WindowState> mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        if (WindowManagerService.this.mAnimator.isAnimating() || WindowManagerService.this.mAnimationScheduled) {
                            this.sendEmptyMessageDelayed(15, 2000L);
                            return;
                        }
                        if (WindowManagerService.this.mDisplayFrozen) {
                            return;
                        }
                    }
                    Runtime.getRuntime().gc();
                    break;
                }
                case 16: {
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 17: {
                    HashMap<IBinder, WindowState> mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        Slog.w(WindowManagerService.TAG, "App freeze timeout expired.");
                        WindowManagerService.this.mWindowsFreezingScreen = 2;
                        int numStacks = WindowManagerService.this.mStackIdToStack.size();
                        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                            TaskStack stack = WindowManagerService.this.mStackIdToStack.valueAt(stackNdx);
                            ArrayList<Task> tasks = stack.getTasks();
                            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                                    AppWindowToken tok = (AppWindowToken)tokens.get(tokenNdx);
                                    if (!tok.mAppAnimator.freezingScreen) continue;
                                    Slog.w(WindowManagerService.TAG, "Force clearing freeze: " + tok);
                                    WindowManagerService.this.unsetAppFreezingScreenLocked(tok, true, true);
                                }
                            }
                        }
                        break;
                    }
                }
                case 30: {
                    HashMap<IBinder, WindowState> mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        if (WindowManagerService.this.mClientFreezingScreen) {
                            WindowManagerService.this.mClientFreezingScreen = false;
                            WindowManagerService.this.mLastFinishedFreezeSource = "client-timeout";
                            WindowManagerService.this.stopFreezingDisplayLocked();
                        }
                        break;
                    }
                }
                case 18: {
                    this.removeMessages(18);
                    WindowManagerService.this.sendNewConfiguration();
                    break;
                }
                case 19: {
                    if (!WindowManagerService.this.mWindowsChanged) break;
                    HashMap<IBinder, WindowState> mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        WindowManagerService.this.mWindowsChanged = false;
                    }
                    WindowManagerService.this.notifyWindowsChanged();
                    break;
                }
                case 20: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.unregister();
                            WindowManagerService.this.mInputMonitor.updateInputWindowsLw(true);
                            WindowManagerService.this.mDragState.reset();
                            WindowManagerService.this.mDragState = null;
                        }
                        break;
                    }
                }
                case 21: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.mDragResult = false;
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        break;
                    }
                }
                case 22: {
                    WindowManagerService.this.notifyHardKeyboardStatusChange();
                    break;
                }
                case 23: {
                    WindowManagerService.this.performBootTimeout();
                    break;
                }
                case 24: {
                    Runnable callback = null;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        Slog.w(WindowManagerService.TAG, "Timeout waiting for drawn: undrawn=" + WindowManagerService.this.mWaitingForDrawn);
                        WindowManagerService.this.mWaitingForDrawn.clear();
                        callback = WindowManagerService.this.mWaitingForDrawnCallback;
                        WindowManagerService.this.mWaitingForDrawnCallback = null;
                    }
                    if (callback == null) break;
                    callback.run();
                    break;
                }
                case 25: {
                    WindowManagerService.this.showStrictModeViolation(msg.arg1, msg.arg2);
                    break;
                }
                case 35: {
                    WindowManagerService.this.showCircularMask(msg.arg1 == 1);
                    break;
                }
                case 36: {
                    WindowManagerService.this.showEmulatorDisplayOverlay();
                    break;
                }
                case 26: {
                    try {
                        ((IRemoteCallback)msg.obj).sendResult(null);
                    }
                    catch (RemoteException callback) {}
                    break;
                }
                case 27: {
                    WindowManagerService.this.handleDisplayAdded(msg.arg1);
                    break;
                }
                case 28: {
                    HashMap<IBinder, WindowState> callback = WindowManagerService.this.mWindowMap;
                    synchronized (callback) {
                        WindowManagerService.this.handleDisplayRemovedLocked(msg.arg1);
                        break;
                    }
                }
                case 29: {
                    HashMap<IBinder, WindowState> callback = WindowManagerService.this.mWindowMap;
                    synchronized (callback) {
                        WindowManagerService.this.handleDisplayChangedLocked(msg.arg1);
                        break;
                    }
                }
                case 44: {
                    WindowManagerService.this.startScrollingTask((DisplayContent)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 31: {
                    WindowManagerService.this.handleTapOutsideTask((DisplayContent)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 40: {
                    WindowManagerService.this.finishPositioning();
                    break;
                }
                case 32: {
                    try {
                        WindowManagerService.this.mActivityManager.notifyActivityDrawn((IBinder)msg.obj);
                    }
                    catch (RemoteException callback) {}
                    break;
                }
                case 33: {
                    Runnable callback;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        callback = WindowManagerService.this.mWaitingForDrawnCallback;
                        WindowManagerService.this.mWaitingForDrawnCallback = null;
                    }
                    if (callback != null) {
                        callback.run();
                    }
                }
                case 34: {
                    float scale = WindowManagerService.this.getCurrentAnimatorScale();
                    ValueAnimator.setDurationScale(scale);
                    Session session = (Session)msg.obj;
                    if (session != null) {
                        try {
                            session.mCallback.onAnimatorScaleChanged(scale);
                        }
                        catch (RemoteException stackNdx) {}
                        break;
                    }
                    ArrayList<IWindowSessionCallback> callbacks = new ArrayList<IWindowSessionCallback>();
                    HashMap<IBinder, WindowState> stack = WindowManagerService.this.mWindowMap;
                    synchronized (stack) {
                        for (int i2 = 0; i2 < WindowManagerService.this.mSessions.size(); ++i2) {
                            callbacks.add(WindowManagerService.this.mSessions.valueAt((int)i2).mCallback);
                        }
                    }
                    for (int i = 0; i < callbacks.size(); ++i) {
                        try {
                            ((IWindowSessionCallback)callbacks.get(i)).onAnimatorScaleChanged(scale);
                            continue;
                        }
                        catch (RemoteException i2) {
                            // empty catch block
                        }
                    }
                    break;
                }
                case 37: {
                    boolean bootAnimationComplete;
                    HashMap<IBinder, WindowState> session = WindowManagerService.this.mWindowMap;
                    synchronized (session) {
                        bootAnimationComplete = WindowManagerService.this.checkBootAnimationCompleteLocked();
                    }
                    if (!bootAnimationComplete) break;
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 38: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        WindowManagerService.this.mLastANRState = null;
                        break;
                    }
                }
                case 39: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        if (WindowManagerService.this.mWallpaperControllerLocked.processWallpaperDrawPendingTimeout()) {
                            WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        }
                    }
                }
                case 41: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        DisplayContent displayContent = WindowManagerService.this.getDefaultDisplayContentLocked();
                        displayContent.getDockedDividerController().reevaluateVisibility(false);
                        WindowManagerService.this.adjustForImeIfNeeded(displayContent);
                        break;
                    }
                }
                case 43: {
                    try {
                        WindowManagerService.this.mActivityManager.resizeTask(msg.arg1, (Rect)msg.obj, msg.arg2);
                    }
                    catch (RemoteException bootAnimationComplete) {}
                    break;
                }
                case 42: {
                    try {
                        WindowManagerService.this.mActivityManager.resizeStack(msg.arg1, (Rect)msg.obj, msg.arg2 == 1, false, false, -1);
                    }
                    catch (RemoteException bootAnimationComplete) {}
                    break;
                }
                case 46: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        for (int i = WindowManagerService.this.mReplacingWindowTimeouts.size() - 1; i >= 0; --i) {
                            AppWindowToken token = WindowManagerService.this.mReplacingWindowTimeouts.get(i);
                            token.clearTimedoutReplacesLocked();
                        }
                        WindowManagerService.this.mReplacingWindowTimeouts.clear();
                    }
                }
                case 47: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionStarting(msg.arg1);
                    break;
                }
                case 48: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionCancelled();
                    break;
                }
                case 49: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionFinished();
                    break;
                }
                case 50: {
                    WindowManagerService.this.mAmInternal.notifyStartingWindowDrawn();
                    break;
                }
                case 52: {
                    WindowState window = (WindowState)msg.obj;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        window.mAttrs.flags &= 0xFFFFFF7F;
                        window.setDisplayLayoutNeeded();
                        WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        break;
                    }
                }
                case 53: {
                    WindowManagerService.this.mAmInternal.notifyDockedStackMinimizedChanged(msg.arg1 == 1);
                    break;
                }
                case 54: {
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        DisplayContent displayContent = WindowManagerService.this.getDefaultDisplayContentLocked();
                        WindowList windows = displayContent.getWindowList();
                        boolean layoutNeeded = false;
                        for (int i = windows.size() - 1; i >= 0; --i) {
                            WindowState w = (WindowState)windows.get(i);
                            if (w.mSeamlesslyRotated) {
                                layoutNeeded = true;
                                w.setDisplayLayoutNeeded();
                            }
                            w.mSeamlesslyRotated = false;
                        }
                        if (layoutNeeded) {
                            WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        }
                        break;
                    }
                }
            }
        }
    }

    public static interface WindowChangeListener {
        public void windowsChanged();

        public void focusChanged();
    }

    final class DragInputEventReceiver
    extends InputEventReceiver {
        private boolean mStylusButtonDownAtStart;
        private boolean mIsStartEvent;

        public DragInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
            this.mIsStartEvent = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event) {
            block27: {
                boolean handled = false;
                try {
                    HashMap<IBinder, WindowState> hashMap;
                    boolean isStylusButtonDown;
                    if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || WindowManagerService.this.mDragState == null) break block27;
                    MotionEvent motionEvent = (MotionEvent)event;
                    boolean endDrag = false;
                    float newX = motionEvent.getRawX();
                    float newY = motionEvent.getRawY();
                    boolean bl = isStylusButtonDown = (motionEvent.getButtonState() & 0x20) != 0;
                    if (this.mIsStartEvent) {
                        if (isStylusButtonDown) {
                            this.mStylusButtonDownAtStart = true;
                        }
                        this.mIsStartEvent = false;
                    }
                    switch (motionEvent.getAction()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            if (this.mStylusButtonDownAtStart && !isStylusButtonDown) {
                                hashMap = WindowManagerService.this.mWindowMap;
                                synchronized (hashMap) {
                                    endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                    break;
                                }
                            }
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                WindowManagerService.this.mDragState.notifyMoveLw(newX, newY);
                                break;
                            }
                        }
                        case 1: {
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                break;
                            }
                        }
                        case 3: {
                            endDrag = true;
                        }
                    }
                    if (endDrag) {
                        hashMap = WindowManagerService.this.mWindowMap;
                        synchronized (hashMap) {
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        this.mStylusButtonDownAtStart = false;
                        this.mIsStartEvent = true;
                    }
                    handled = true;
                }
                catch (Exception e) {
                    Slog.e(WindowManagerService.TAG, "Exception caught by drag handleMotion", e);
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri mDisplayInversionEnabledUri;
        private final Uri mWindowAnimationScaleUri;
        private final Uri mTransitionAnimationScaleUri;
        private final Uri mAnimationDurationScaleUri;

        public SettingsObserver() {
            super(new Handler());
            this.mDisplayInversionEnabledUri = Settings.Secure.getUriFor("accessibility_display_inversion_enabled");
            this.mWindowAnimationScaleUri = Settings.Global.getUriFor("window_animation_scale");
            this.mTransitionAnimationScaleUri = Settings.Global.getUriFor("transition_animation_scale");
            this.mAnimationDurationScaleUri = Settings.Global.getUriFor("animator_duration_scale");
            ContentResolver resolver = WindowManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mDisplayInversionEnabledUri, false, this, -1);
            resolver.registerContentObserver(this.mWindowAnimationScaleUri, false, this, -1);
            resolver.registerContentObserver(this.mTransitionAnimationScaleUri, false, this, -1);
            resolver.registerContentObserver(this.mAnimationDurationScaleUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (uri == null) {
                return;
            }
            if (this.mDisplayInversionEnabledUri.equals(uri)) {
                WindowManagerService.this.updateCircularDisplayMaskIfNeeded();
            } else {
                int mode;
                if (this.mWindowAnimationScaleUri.equals(uri)) {
                    mode = 0;
                } else if (this.mTransitionAnimationScaleUri.equals(uri)) {
                    mode = 1;
                } else if (this.mAnimationDurationScaleUri.equals(uri)) {
                    mode = 2;
                } else {
                    return;
                }
                Message m = WindowManagerService.this.mH.obtainMessage(51, mode, 0);
                WindowManagerService.this.mH.sendMessage(m);
            }
        }
    }

    class RotationWatcher {
        IRotationWatcher watcher;
        IBinder.DeathRecipient deathRecipient;

        RotationWatcher(IRotationWatcher w, IBinder.DeathRecipient d) {
            this.watcher = w;
            this.deathRecipient = d;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    private static @interface UpdateAnimationScaleMode {
    }
}

