/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.util.TimeUtils;
import android.view.DisplayInfo;
import android.view.Gravity;
import android.view.IApplicationToken;
import android.view.IWindow;
import android.view.IWindowFocusObserver;
import android.view.IWindowId;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import com.android.server.input.InputWindowHandle;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Session;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.HashMap;

final class WindowState
implements WindowManagerPolicy.WindowState {
    static final String TAG = "WindowManager";
    static final int MINIMUM_VISIBLE_WIDTH_IN_DP = 48;
    static final int MINIMUM_VISIBLE_HEIGHT_IN_DP = 32;
    static final int RESIZE_HANDLE_WIDTH_IN_DP = 30;
    static final boolean DEBUG_DISABLE_SAVING_SURFACES = false;
    final WindowManagerService mService;
    final WindowManagerPolicy mPolicy;
    final Context mContext;
    final Session mSession;
    final IWindow mClient;
    final int mAppOp;
    final int mOwnerUid;
    final IWindowId mWindowId;
    WindowToken mToken;
    WindowToken mRootToken;
    AppWindowToken mAppToken;
    AppWindowToken mTargetAppToken;
    final WindowManager.LayoutParams mAttrs = new WindowManager.LayoutParams();
    final DeathRecipient mDeathRecipient;
    final WindowState mAttachedWindow;
    final WindowList mChildWindows = new WindowList();
    final int mBaseLayer;
    final int mSubLayer;
    final boolean mLayoutAttached;
    final boolean mIsImWindow;
    final boolean mIsWallpaper;
    final boolean mIsFloatingLayer;
    int mSeq;
    boolean mEnforceSizeCompat;
    int mViewVisibility;
    int mSystemUiVisibility;
    boolean mPolicyVisibility = true;
    boolean mPolicyVisibilityAfterAnim = true;
    boolean mAppOpVisibility = true;
    boolean mAppFreezing;
    boolean mAttachedHidden;
    boolean mWallpaperVisible;
    boolean mDragResizing;
    boolean mDragResizingChangeReported;
    int mResizeMode;
    RemoteCallbackList<IWindowFocusObserver> mFocusCallbacks;
    int mRequestedWidth;
    int mRequestedHeight;
    int mLastRequestedWidth;
    int mLastRequestedHeight;
    int mLayer;
    boolean mHaveFrame;
    boolean mObscured;
    boolean mTurnOnScreen;
    int mLayoutSeq = -1;
    private final Configuration mTmpConfig = new Configuration();
    private Configuration mMergedConfiguration = new Configuration();
    private boolean mConfigHasChanged;
    final Point mShownPosition = new Point();
    final Rect mVisibleInsets = new Rect();
    final Rect mLastVisibleInsets = new Rect();
    boolean mVisibleInsetsChanged;
    final Rect mContentInsets = new Rect();
    final Rect mLastContentInsets = new Rect();
    boolean mContentInsetsChanged;
    final Rect mOverscanInsets = new Rect();
    final Rect mLastOverscanInsets = new Rect();
    boolean mOverscanInsetsChanged;
    final Rect mStableInsets = new Rect();
    final Rect mLastStableInsets = new Rect();
    boolean mStableInsetsChanged;
    final Rect mOutsets = new Rect();
    final Rect mLastOutsets = new Rect();
    boolean mOutsetsChanged = false;
    boolean mGivenInsetsPending;
    final Rect mGivenContentInsets = new Rect();
    final Rect mGivenVisibleInsets = new Rect();
    final Region mGivenTouchableRegion = new Region();
    int mTouchableInsets = 0;
    float mGlobalScale = 1.0f;
    float mInvGlobalScale = 1.0f;
    float mHScale = 1.0f;
    float mVScale = 1.0f;
    float mLastHScale = 1.0f;
    float mLastVScale = 1.0f;
    final Matrix mTmpMatrix = new Matrix();
    final Rect mFrame = new Rect();
    final Rect mLastFrame = new Rect();
    boolean mFrameSizeChanged = false;
    final Rect mCompatFrame = new Rect();
    final Rect mContainingFrame = new Rect();
    final Rect mParentFrame = new Rect();
    final Rect mDisplayFrame = new Rect();
    final Rect mOverscanFrame = new Rect();
    final Rect mStableFrame = new Rect();
    final Rect mDecorFrame = new Rect();
    final Rect mContentFrame = new Rect();
    final Rect mVisibleFrame = new Rect();
    final Rect mOutsetFrame = new Rect();
    final Rect mInsetFrame = new Rect();
    private static final Rect sTmpRect = new Rect();
    boolean mContentChanged;
    float mWallpaperX = -1.0f;
    float mWallpaperY = -1.0f;
    float mWallpaperXStep = -1.0f;
    float mWallpaperYStep = -1.0f;
    int mWallpaperDisplayOffsetX = Integer.MIN_VALUE;
    int mWallpaperDisplayOffsetY = Integer.MIN_VALUE;
    int mXOffset;
    int mYOffset;
    boolean mRelayoutCalled;
    boolean mInRelayout;
    boolean mLayoutNeeded;
    boolean mAnimatingExit;
    boolean mDestroying;
    boolean mRemoveOnExit;
    boolean mAppDied;
    boolean mOrientationChanging;
    int mLastVisibleLayoutRotation = -1;
    int mLastFreezeDuration;
    boolean mRemoved;
    boolean mWindowRemovalAllowed;
    boolean mRebuilding;
    final InputWindowHandle mInputWindowHandle;
    InputChannel mInputChannel;
    InputChannel mClientChannel;
    String mStringNameCache;
    CharSequence mLastTitle;
    boolean mWasExiting;
    final WindowStateAnimator mWinAnimator;
    boolean mHasSurface = false;
    boolean mNotOnAppsDisplay = false;
    DisplayContent mDisplayContent;
    private boolean mShowToOwnerOnly;
    private boolean mSurfaceSaved = false;
    private boolean mAnimatingWithSavedSurface;
    boolean mWasVisibleBeforeClientHidden;
    boolean mWillReplaceWindow = false;
    boolean mReplacingRemoveRequested = false;
    boolean mAnimateReplacingWindow = false;
    WindowState mReplacingWindow = null;
    boolean mSkipEnterAnimationForSeamlessReplacement = false;
    boolean mMovedByResize;
    PowerManager.WakeLock mDrawLock;
    private final Rect mTmpRect = new Rect();
    private boolean mJustMovedInStack;
    boolean mResizedWhileGone = false;
    private boolean mResizedWhileNotDragResizing;
    private boolean mResizedWhileNotDragResizingReported;
    boolean mSeamlesslyRotated = false;
    private DeadWindowEventReceiver mDeadWindowEventReceiver;
    static final Region sEmptyRegion = new Region();

    WindowState(WindowManagerService service, Session s, IWindow c, WindowToken token, WindowState attachedWindow, int appOp, int seq, WindowManager.LayoutParams a, int viewVisibility, DisplayContent displayContent) {
        WindowToken parent;
        this.mService = service;
        this.mSession = s;
        this.mClient = c;
        this.mAppOp = appOp;
        this.mToken = token;
        this.mOwnerUid = s.mUid;
        this.mWindowId = new IWindowId.Stub(){

            @Override
            public void registerFocusObserver(IWindowFocusObserver observer) {
                WindowState.this.registerFocusObserver(observer);
            }

            @Override
            public void unregisterFocusObserver(IWindowFocusObserver observer) {
                WindowState.this.unregisterFocusObserver(observer);
            }

            @Override
            public boolean isFocused() {
                return WindowState.this.isFocused();
            }
        };
        this.mAttrs.copyFrom(a);
        this.mViewVisibility = viewVisibility;
        this.mDisplayContent = displayContent;
        this.mPolicy = this.mService.mPolicy;
        this.mContext = this.mService.mContext;
        DeathRecipient deathRecipient = new DeathRecipient();
        this.mSeq = seq;
        this.mEnforceSizeCompat = (this.mAttrs.privateFlags & 0x80) != 0;
        try {
            c.asBinder().linkToDeath(deathRecipient, 0);
        }
        catch (RemoteException e) {
            this.mDeathRecipient = null;
            this.mAttachedWindow = null;
            this.mLayoutAttached = false;
            this.mIsImWindow = false;
            this.mIsWallpaper = false;
            this.mIsFloatingLayer = false;
            this.mBaseLayer = 0;
            this.mSubLayer = 0;
            this.mInputWindowHandle = null;
            this.mWinAnimator = null;
            return;
        }
        this.mDeathRecipient = deathRecipient;
        if (this.mAttrs.type >= 1000 && this.mAttrs.type <= 1999) {
            this.mBaseLayer = this.mPolicy.windowTypeToLayerLw(attachedWindow.mAttrs.type) * 10000 + 1000;
            this.mSubLayer = this.mPolicy.subWindowTypeToLayerLw(a.type);
            this.mAttachedWindow = attachedWindow;
            WindowList childWindows = this.mAttachedWindow.mChildWindows;
            int numChildWindows = childWindows.size();
            if (numChildWindows == 0) {
                childWindows.add(this);
            } else {
                boolean added = false;
                for (int i = 0; i < numChildWindows; ++i) {
                    int childSubLayer = ((WindowState)childWindows.get((int)i)).mSubLayer;
                    if (this.mSubLayer >= childSubLayer && (this.mSubLayer != childSubLayer || childSubLayer >= 0)) continue;
                    childWindows.add(i, this);
                    added = true;
                    break;
                }
                if (!added) {
                    childWindows.add(this);
                }
            }
            this.mLayoutAttached = this.mAttrs.type != 1003;
            this.mIsImWindow = attachedWindow.mAttrs.type == 2011 || attachedWindow.mAttrs.type == 2012;
            this.mIsWallpaper = attachedWindow.mAttrs.type == 2013;
            this.mIsFloatingLayer = this.mIsImWindow || this.mIsWallpaper;
        } else {
            this.mBaseLayer = this.mPolicy.windowTypeToLayerLw(a.type) * 10000 + 1000;
            this.mSubLayer = 0;
            this.mAttachedWindow = null;
            this.mLayoutAttached = false;
            this.mIsImWindow = this.mAttrs.type == 2011 || this.mAttrs.type == 2012;
            this.mIsWallpaper = this.mAttrs.type == 2013;
            this.mIsFloatingLayer = this.mIsImWindow || this.mIsWallpaper;
        }
        WindowState appWin = this;
        while (appWin.isChildWindow()) {
            appWin = appWin.mAttachedWindow;
        }
        WindowToken appToken = appWin.mToken;
        while (appToken.appWindowToken == null && (parent = this.mService.mTokenMap.get(appToken.token)) != null && appToken != parent) {
            appToken = parent;
        }
        this.mRootToken = appToken;
        this.mAppToken = appToken.appWindowToken;
        if (this.mAppToken != null) {
            DisplayContent appDisplay = this.getDisplayContent();
            boolean bl = this.mNotOnAppsDisplay = displayContent != appDisplay;
            if (this.mAppToken.showForAllUsers) {
                this.mAttrs.flags |= 0x80000;
            }
        }
        this.mWinAnimator = new WindowStateAnimator(this);
        this.mWinAnimator.mAlpha = a.alpha;
        this.mRequestedWidth = 0;
        this.mRequestedHeight = 0;
        this.mLastRequestedWidth = 0;
        this.mLastRequestedHeight = 0;
        this.mXOffset = 0;
        this.mYOffset = 0;
        this.mLayer = 0;
        this.mInputWindowHandle = new InputWindowHandle(this.mAppToken != null ? this.mAppToken.mInputApplicationHandle : null, this, displayContent.getDisplayId());
    }

    void attach() {
        this.mSession.windowAddedLocked();
    }

    @Override
    public int getOwningUid() {
        return this.mOwnerUid;
    }

    @Override
    public String getOwningPackage() {
        return this.mAttrs.packageName;
    }

    private void subtractInsets(Rect frame, Rect layoutFrame, Rect insetFrame, Rect displayFrame) {
        int left = Math.max(0, insetFrame.left - Math.max(layoutFrame.left, displayFrame.left));
        int top = Math.max(0, insetFrame.top - Math.max(layoutFrame.top, displayFrame.top));
        int right = Math.max(0, Math.min(layoutFrame.right, displayFrame.right) - insetFrame.right);
        int bottom = Math.max(0, Math.min(layoutFrame.bottom, displayFrame.bottom) - insetFrame.bottom);
        frame.inset(left, top, right, bottom);
    }

    @Override
    public void computeFrameLw(Rect pf, Rect df, Rect of, Rect cf, Rect vf, Rect dcf, Rect sf, Rect osf) {
        DisplayContent displayContent;
        boolean hasOutsets;
        int layoutYDiff;
        int layoutXDiff;
        Rect layoutContainingFrame;
        Rect layoutDisplayFrame;
        boolean windowsAreFloating;
        if (this.mWillReplaceWindow && (this.mAnimatingExit || !this.mReplacingRemoveRequested)) {
            return;
        }
        this.mHaveFrame = true;
        Task task = this.getTask();
        boolean fullscreenTask = !this.isInMultiWindowMode();
        boolean bl = windowsAreFloating = task != null && task.isFloating();
        if (fullscreenTask) {
            this.mInsetFrame.setEmpty();
        } else {
            task.getTempInsetBounds(this.mInsetFrame);
        }
        if (fullscreenTask || this.layoutInParentFrame()) {
            this.mContainingFrame.set(pf);
            this.mDisplayFrame.set(df);
            layoutDisplayFrame = df;
            layoutContainingFrame = pf;
            layoutXDiff = 0;
            layoutYDiff = 0;
        } else {
            WindowState imeWin;
            task.getBounds(this.mContainingFrame);
            if (this.mAppToken != null && !this.mAppToken.mFrozenBounds.isEmpty()) {
                Rect frozen = this.mAppToken.mFrozenBounds.peek();
                this.mContainingFrame.right = this.mContainingFrame.left + frozen.width();
                this.mContainingFrame.bottom = this.mContainingFrame.top + frozen.height();
            }
            if ((imeWin = this.mService.mInputMethodWindow) != null && imeWin.isVisibleNow() && this.mService.mInputMethodTarget == this) {
                if (windowsAreFloating && this.mContainingFrame.bottom > cf.bottom) {
                    this.mContainingFrame.top -= this.mContainingFrame.bottom - cf.bottom;
                } else if (this.mContainingFrame.bottom > pf.bottom) {
                    this.mContainingFrame.bottom = pf.bottom;
                }
            }
            if (windowsAreFloating && this.mContainingFrame.isEmpty()) {
                this.mContainingFrame.set(cf);
            }
            this.mDisplayFrame.set(this.mContainingFrame);
            layoutXDiff = !this.mInsetFrame.isEmpty() ? this.mInsetFrame.left - this.mContainingFrame.left : 0;
            layoutYDiff = !this.mInsetFrame.isEmpty() ? this.mInsetFrame.top - this.mContainingFrame.top : 0;
            layoutContainingFrame = !this.mInsetFrame.isEmpty() ? this.mInsetFrame : this.mContainingFrame;
            this.mTmpRect.set(0, 0, this.mDisplayContent.getDisplayInfo().logicalWidth, this.mDisplayContent.getDisplayInfo().logicalHeight);
            this.subtractInsets(this.mDisplayFrame, layoutContainingFrame, df, this.mTmpRect);
            if (!this.layoutInParentFrame()) {
                this.subtractInsets(this.mContainingFrame, layoutContainingFrame, pf, this.mTmpRect);
                this.subtractInsets(this.mInsetFrame, layoutContainingFrame, pf, this.mTmpRect);
            }
            layoutDisplayFrame = df;
            layoutDisplayFrame.intersect(layoutContainingFrame);
        }
        int pw = this.mContainingFrame.width();
        int ph = this.mContainingFrame.height();
        if (!this.mParentFrame.equals(pf)) {
            this.mParentFrame.set(pf);
            this.mContentChanged = true;
        }
        if (this.mRequestedWidth != this.mLastRequestedWidth || this.mRequestedHeight != this.mLastRequestedHeight) {
            this.mLastRequestedWidth = this.mRequestedWidth;
            this.mLastRequestedHeight = this.mRequestedHeight;
            this.mContentChanged = true;
        }
        this.mOverscanFrame.set(of);
        this.mContentFrame.set(cf);
        this.mVisibleFrame.set(vf);
        this.mDecorFrame.set(dcf);
        this.mStableFrame.set(sf);
        boolean bl2 = hasOutsets = osf != null;
        if (hasOutsets) {
            this.mOutsetFrame.set(osf);
        }
        int fw = this.mFrame.width();
        int fh = this.mFrame.height();
        this.applyGravityAndUpdateFrame(layoutContainingFrame, layoutDisplayFrame);
        if (hasOutsets) {
            this.mOutsets.set(Math.max(this.mContentFrame.left - this.mOutsetFrame.left, 0), Math.max(this.mContentFrame.top - this.mOutsetFrame.top, 0), Math.max(this.mOutsetFrame.right - this.mContentFrame.right, 0), Math.max(this.mOutsetFrame.bottom - this.mContentFrame.bottom, 0));
        } else {
            this.mOutsets.set(0, 0, 0, 0);
        }
        if (windowsAreFloating && !this.mFrame.isEmpty()) {
            int height = Math.min(this.mFrame.height(), this.mContentFrame.height());
            int width = Math.min(this.mContentFrame.width(), this.mFrame.width());
            DisplayMetrics displayMetrics = this.getDisplayContent().getDisplayMetrics();
            int minVisibleHeight = Math.min(height, WindowManagerService.dipToPixel(32, displayMetrics));
            int minVisibleWidth = Math.min(width, WindowManagerService.dipToPixel(48, displayMetrics));
            int top = Math.max(this.mContentFrame.top, Math.min(this.mFrame.top, this.mContentFrame.bottom - minVisibleHeight));
            int left = Math.max(this.mContentFrame.left + minVisibleWidth - width, Math.min(this.mFrame.left, this.mContentFrame.right - minVisibleWidth));
            this.mFrame.set(left, top, left + width, top + height);
            this.mContentFrame.set(this.mFrame);
            this.mVisibleFrame.set(this.mContentFrame);
            this.mStableFrame.set(this.mContentFrame);
        } else if (this.mAttrs.type == 2034) {
            this.mDisplayContent.getDockedDividerController().positionDockedStackedDivider(this.mFrame);
            this.mContentFrame.set(this.mFrame);
            if (!this.mFrame.equals(this.mLastFrame)) {
                this.mMovedByResize = true;
            }
        } else {
            this.mContentFrame.set(Math.max(this.mContentFrame.left, this.mFrame.left), Math.max(this.mContentFrame.top, this.mFrame.top), Math.min(this.mContentFrame.right, this.mFrame.right), Math.min(this.mContentFrame.bottom, this.mFrame.bottom));
            this.mVisibleFrame.set(Math.max(this.mVisibleFrame.left, this.mFrame.left), Math.max(this.mVisibleFrame.top, this.mFrame.top), Math.min(this.mVisibleFrame.right, this.mFrame.right), Math.min(this.mVisibleFrame.bottom, this.mFrame.bottom));
            this.mStableFrame.set(Math.max(this.mStableFrame.left, this.mFrame.left), Math.max(this.mStableFrame.top, this.mFrame.top), Math.min(this.mStableFrame.right, this.mFrame.right), Math.min(this.mStableFrame.bottom, this.mFrame.bottom));
        }
        if (fullscreenTask && !windowsAreFloating) {
            this.mOverscanInsets.set(Math.max(this.mOverscanFrame.left - layoutContainingFrame.left, 0), Math.max(this.mOverscanFrame.top - layoutContainingFrame.top, 0), Math.max(layoutContainingFrame.right - this.mOverscanFrame.right, 0), Math.max(layoutContainingFrame.bottom - this.mOverscanFrame.bottom, 0));
        }
        if (this.mAttrs.type == 2034) {
            this.mStableInsets.set(Math.max(this.mStableFrame.left - this.mDisplayFrame.left, 0), Math.max(this.mStableFrame.top - this.mDisplayFrame.top, 0), Math.max(this.mDisplayFrame.right - this.mStableFrame.right, 0), Math.max(this.mDisplayFrame.bottom - this.mStableFrame.bottom, 0));
            this.mContentInsets.setEmpty();
            this.mVisibleInsets.setEmpty();
        } else {
            this.getDisplayContent().getLogicalDisplayRect(this.mTmpRect);
            boolean overrideRightInset = !fullscreenTask && this.mFrame.right > this.mTmpRect.right;
            boolean overrideBottomInset = !fullscreenTask && this.mFrame.bottom > this.mTmpRect.bottom;
            this.mContentInsets.set(this.mContentFrame.left - this.mFrame.left, this.mContentFrame.top - this.mFrame.top, overrideRightInset ? this.mTmpRect.right - this.mContentFrame.right : this.mFrame.right - this.mContentFrame.right, overrideBottomInset ? this.mTmpRect.bottom - this.mContentFrame.bottom : this.mFrame.bottom - this.mContentFrame.bottom);
            this.mVisibleInsets.set(this.mVisibleFrame.left - this.mFrame.left, this.mVisibleFrame.top - this.mFrame.top, overrideRightInset ? this.mTmpRect.right - this.mVisibleFrame.right : this.mFrame.right - this.mVisibleFrame.right, overrideBottomInset ? this.mTmpRect.bottom - this.mVisibleFrame.bottom : this.mFrame.bottom - this.mVisibleFrame.bottom);
            this.mStableInsets.set(Math.max(this.mStableFrame.left - this.mFrame.left, 0), Math.max(this.mStableFrame.top - this.mFrame.top, 0), overrideRightInset ? Math.max(this.mTmpRect.right - this.mStableFrame.right, 0) : Math.max(this.mFrame.right - this.mStableFrame.right, 0), overrideBottomInset ? Math.max(this.mTmpRect.bottom - this.mStableFrame.bottom, 0) : Math.max(this.mFrame.bottom - this.mStableFrame.bottom, 0));
        }
        this.mFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mCompatFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mContentFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mVisibleFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mStableFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mCompatFrame.set(this.mFrame);
        if (this.mEnforceSizeCompat) {
            this.mOverscanInsets.scale(this.mInvGlobalScale);
            this.mContentInsets.scale(this.mInvGlobalScale);
            this.mVisibleInsets.scale(this.mInvGlobalScale);
            this.mStableInsets.scale(this.mInvGlobalScale);
            this.mOutsets.scale(this.mInvGlobalScale);
            this.mCompatFrame.scale(this.mInvGlobalScale);
        }
        if (this.mIsWallpaper && (fw != this.mFrame.width() || fh != this.mFrame.height()) && (displayContent = this.getDisplayContent()) != null) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            this.mService.mWallpaperControllerLocked.updateWallpaperOffset(this, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
        }
    }

    @Override
    public Rect getFrameLw() {
        return this.mFrame;
    }

    @Override
    public Point getShownPositionLw() {
        return this.mShownPosition;
    }

    @Override
    public Rect getDisplayFrameLw() {
        return this.mDisplayFrame;
    }

    @Override
    public Rect getOverscanFrameLw() {
        return this.mOverscanFrame;
    }

    @Override
    public Rect getContentFrameLw() {
        return this.mContentFrame;
    }

    @Override
    public Rect getVisibleFrameLw() {
        return this.mVisibleFrame;
    }

    @Override
    public boolean getGivenInsetsPendingLw() {
        return this.mGivenInsetsPending;
    }

    @Override
    public Rect getGivenContentInsetsLw() {
        return this.mGivenContentInsets;
    }

    @Override
    public Rect getGivenVisibleInsetsLw() {
        return this.mGivenVisibleInsets;
    }

    @Override
    public WindowManager.LayoutParams getAttrs() {
        return this.mAttrs;
    }

    @Override
    public boolean getNeedsMenuLw(WindowManagerPolicy.WindowState bottom) {
        int index = -1;
        WindowState ws = this;
        WindowList windows = this.getWindowList();
        while (ws.mAttrs.needsMenuKey == 0) {
            if (ws == bottom) {
                return false;
            }
            if (index < 0) {
                index = windows.indexOf(ws);
            }
            if (--index < 0) {
                return false;
            }
            ws = (WindowState)windows.get(index);
        }
        return ws.mAttrs.needsMenuKey == 1;
    }

    @Override
    public int getSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    @Override
    public int getSurfaceLayer() {
        return this.mLayer;
    }

    @Override
    public int getBaseType() {
        WindowState win = this;
        while (win.isChildWindow()) {
            win = win.mAttachedWindow;
        }
        return win.mAttrs.type;
    }

    @Override
    public IApplicationToken getAppToken() {
        return this.mAppToken != null ? this.mAppToken.appToken : null;
    }

    @Override
    public boolean isVoiceInteraction() {
        return this.mAppToken != null && this.mAppToken.voiceInteraction;
    }

    boolean setReportResizeHints() {
        this.mOverscanInsetsChanged |= !this.mLastOverscanInsets.equals(this.mOverscanInsets);
        this.mContentInsetsChanged |= !this.mLastContentInsets.equals(this.mContentInsets);
        this.mVisibleInsetsChanged |= !this.mLastVisibleInsets.equals(this.mVisibleInsets);
        this.mStableInsetsChanged |= !this.mLastStableInsets.equals(this.mStableInsets);
        this.mOutsetsChanged |= !this.mLastOutsets.equals(this.mOutsets);
        this.mFrameSizeChanged |= this.mLastFrame.width() != this.mFrame.width() || this.mLastFrame.height() != this.mFrame.height();
        return this.mOverscanInsetsChanged || this.mContentInsetsChanged || this.mVisibleInsetsChanged || this.mOutsetsChanged || this.mFrameSizeChanged;
    }

    public DisplayContent getDisplayContent() {
        if (this.mAppToken == null || this.mNotOnAppsDisplay) {
            return this.mDisplayContent;
        }
        TaskStack stack = this.getStack();
        return stack == null ? this.mDisplayContent : stack.getDisplayContent();
    }

    public DisplayInfo getDisplayInfo() {
        DisplayContent displayContent = this.getDisplayContent();
        return displayContent != null ? displayContent.getDisplayInfo() : null;
    }

    public int getDisplayId() {
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent == null) {
            return -1;
        }
        return displayContent.getDisplayId();
    }

    Task getTask() {
        return this.mAppToken != null ? this.mAppToken.mTask : null;
    }

    TaskStack getStack() {
        Task task = this.getTask();
        if (task != null && task.mStack != null) {
            return task.mStack;
        }
        return this.mAttrs.type >= 2000 && this.mDisplayContent != null ? this.mDisplayContent.getHomeStack() : null;
    }

    void getVisibleBounds(Rect bounds) {
        Task task = this.getTask();
        boolean intersectWithStackBounds = task != null && task.cropWindowsToStackBounds();
        bounds.setEmpty();
        this.mTmpRect.setEmpty();
        if (intersectWithStackBounds) {
            TaskStack stack = task.mStack;
            if (stack != null) {
                stack.getDimBounds(this.mTmpRect);
            } else {
                intersectWithStackBounds = false;
            }
        }
        bounds.set(this.mVisibleFrame);
        if (intersectWithStackBounds) {
            bounds.intersect(this.mTmpRect);
        }
        if (bounds.isEmpty()) {
            bounds.set(this.mFrame);
            if (intersectWithStackBounds) {
                bounds.intersect(this.mTmpRect);
            }
            return;
        }
    }

    public long getInputDispatchingTimeoutNanos() {
        return this.mAppToken != null ? this.mAppToken.inputDispatchingTimeoutNanos : 5000000000L;
    }

    @Override
    public boolean hasAppShownWindows() {
        return this.mAppToken != null && (this.mAppToken.firstWindowDrawn || this.mAppToken.startingDisplayed);
    }

    boolean isIdentityMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        if (dsdx < 0.99999f || dsdx > 1.00001f) {
            return false;
        }
        if (dtdy < 0.99999f || dtdy > 1.00001f) {
            return false;
        }
        if (dtdx < -1.0E-6f || dtdx > 1.0E-6f) {
            return false;
        }
        return !(dsdy < -1.0E-6f) && !(dsdy > 1.0E-6f);
    }

    void prelayout() {
        if (this.mEnforceSizeCompat) {
            this.mGlobalScale = this.mService.mCompatibleScreenScale;
            this.mInvGlobalScale = 1.0f / this.mGlobalScale;
        } else {
            this.mInvGlobalScale = 1.0f;
            this.mGlobalScale = 1.0f;
        }
    }

    private boolean isVisibleUnchecked() {
        return this.mHasSurface && this.mPolicyVisibility && !this.mAttachedHidden && !this.mAnimatingExit && !this.mDestroying && (!this.mIsWallpaper || this.mWallpaperVisible);
    }

    @Override
    public boolean isVisibleLw() {
        return (this.mAppToken == null || !this.mAppToken.hiddenRequested) && this.isVisibleUnchecked();
    }

    @Override
    public boolean isVisibleOrBehindKeyguardLw() {
        boolean animating;
        if (this.mRootToken.waitingToShow && this.mService.mAppTransition.isTransitionSet()) {
            return false;
        }
        AppWindowToken atoken = this.mAppToken;
        boolean bl = animating = atoken != null && atoken.mAppAnimator.animation != null;
        return this.mHasSurface && !this.mDestroying && !this.mAnimatingExit && (atoken == null ? this.mPolicyVisibility : !atoken.hiddenRequested) && (!this.mAttachedHidden && this.mViewVisibility == 0 && !this.mRootToken.hidden || this.mWinAnimator.mAnimation != null || animating);
    }

    public boolean isWinVisibleLw() {
        return (this.mAppToken == null || !this.mAppToken.hiddenRequested || this.mAppToken.mAppAnimator.animating) && this.isVisibleUnchecked();
    }

    boolean isVisibleNow() {
        return (!this.mRootToken.hidden || this.mAttrs.type == 3) && this.isVisibleUnchecked();
    }

    boolean isPotentialDragTarget() {
        return this.isVisibleNow() && !this.mRemoved && this.mInputChannel != null && this.mInputWindowHandle != null;
    }

    boolean isVisibleOrAdding() {
        AppWindowToken atoken = this.mAppToken;
        return (this.mHasSurface || !this.mRelayoutCalled && this.mViewVisibility == 0) && this.mPolicyVisibility && !this.mAttachedHidden && (atoken == null || !atoken.hiddenRequested) && !this.mAnimatingExit && !this.mDestroying;
    }

    boolean isOnScreen() {
        return this.mPolicyVisibility && this.isOnScreenIgnoringKeyguard();
    }

    boolean isOnScreenIgnoringKeyguard() {
        if (!this.mHasSurface || this.mDestroying) {
            return false;
        }
        AppWindowToken atoken = this.mAppToken;
        if (atoken != null) {
            return !this.mAttachedHidden && !atoken.hiddenRequested || this.mWinAnimator.mAnimation != null || atoken.mAppAnimator.animation != null;
        }
        return !this.mAttachedHidden || this.mWinAnimator.mAnimation != null;
    }

    boolean mightAffectAllDrawn(boolean visibleOnly) {
        boolean isViewVisible = (this.mAppToken == null || !this.mAppToken.clientHidden) && this.mViewVisibility == 0 && !this.mWindowRemovalAllowed;
        return (this.isOnScreenIgnoringKeyguard() && (!visibleOnly || isViewVisible) || this.mWinAnimator.mAttrType == 1 || this.mWinAnimator.mAttrType == 4) && !this.mAnimatingExit && !this.mDestroying;
    }

    boolean isInteresting() {
        return this.mAppToken != null && !this.mAppDied && (!this.mAppToken.mAppAnimator.freezingScreen || !this.mAppFreezing);
    }

    boolean isReadyForDisplay() {
        if (this.mRootToken.waitingToShow && this.mService.mAppTransition.isTransitionSet()) {
            return false;
        }
        return this.mHasSurface && this.mPolicyVisibility && !this.mDestroying && (!this.mAttachedHidden && this.mViewVisibility == 0 && !this.mRootToken.hidden || this.mWinAnimator.mAnimation != null || this.mAppToken != null && this.mAppToken.mAppAnimator.animation != null);
    }

    boolean isReadyForDisplayIgnoringKeyguard() {
        if (this.mRootToken.waitingToShow && this.mService.mAppTransition.isTransitionSet()) {
            return false;
        }
        AppWindowToken atoken = this.mAppToken;
        if (atoken == null && !this.mPolicyVisibility) {
            return false;
        }
        return this.mHasSurface && !this.mDestroying && (!this.mAttachedHidden && this.mViewVisibility == 0 && !this.mRootToken.hidden || this.mWinAnimator.mAnimation != null || atoken != null && atoken.mAppAnimator.animation != null && !this.mWinAnimator.isDummyAnimation() || this.isAnimatingWithSavedSurface());
    }

    @Override
    public boolean isDisplayedLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.isDrawnLw() && this.mPolicyVisibility && (!this.mAttachedHidden && (atoken == null || !atoken.hiddenRequested) || this.mWinAnimator.mAnimating || atoken != null && atoken.mAppAnimator.animation != null);
    }

    @Override
    public boolean isAnimatingLw() {
        return this.mWinAnimator.mAnimation != null || this.mAppToken != null && this.mAppToken.mAppAnimator.animation != null;
    }

    @Override
    public boolean isGoneForLayoutLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.mViewVisibility == 8 || !this.mRelayoutCalled || atoken == null && this.mRootToken.hidden || atoken != null && atoken.hiddenRequested || this.mAttachedHidden || this.mAnimatingExit && !this.isAnimatingLw() || this.mDestroying;
    }

    public boolean isDrawFinishedLw() {
        return this.mHasSurface && !this.mDestroying && (this.mWinAnimator.mDrawState == 2 || this.mWinAnimator.mDrawState == 3 || this.mWinAnimator.mDrawState == 4);
    }

    @Override
    public boolean isDrawnLw() {
        return this.mHasSurface && !this.mDestroying && (this.mWinAnimator.mDrawState == 3 || this.mWinAnimator.mDrawState == 4);
    }

    boolean isOpaqueDrawn() {
        return (!this.mIsWallpaper && this.mAttrs.format == -1 || this.mIsWallpaper && this.mWallpaperVisible) && this.isDrawnLw() && this.mWinAnimator.mAnimation == null && (this.mAppToken == null || this.mAppToken.mAppAnimator.animation == null);
    }

    boolean hasMoved() {
        return !(!this.mHasSurface || !this.mContentChanged && !this.mMovedByResize || this.mAnimatingExit || !this.mService.okToDisplay() || this.mFrame.top == this.mLastFrame.top && this.mFrame.left == this.mLastFrame.left || this.mAttachedWindow != null && this.mAttachedWindow.hasMoved());
    }

    boolean isObscuringFullscreen(DisplayInfo displayInfo) {
        Task task = this.getTask();
        if (task != null && task.mStack != null && !task.mStack.isFullscreen()) {
            return false;
        }
        return this.isOpaqueDrawn() && this.isFrameFullscreen(displayInfo);
    }

    boolean isFrameFullscreen(DisplayInfo displayInfo) {
        return this.mFrame.left <= 0 && this.mFrame.top <= 0 && this.mFrame.right >= displayInfo.appWidth && this.mFrame.bottom >= displayInfo.appHeight;
    }

    boolean isConfigChanged() {
        boolean configChanged;
        this.getMergedConfig(this.mTmpConfig);
        boolean bl = configChanged = this.mMergedConfiguration.equals(Configuration.EMPTY) || this.mTmpConfig.diff(this.mMergedConfiguration) != 0;
        if ((this.mAttrs.privateFlags & 0x400) != 0) {
            this.mConfigHasChanged |= configChanged;
            configChanged = this.mConfigHasChanged;
        }
        return configChanged;
    }

    boolean isAdjustedForMinimizedDock() {
        return this.mAppToken != null && this.mAppToken.mTask != null && this.mAppToken.mTask.mStack.isAdjustedForMinimizedDock();
    }

    void removeLocked() {
        this.disposeInputChannel();
        if (this.isChildWindow()) {
            this.mAttachedWindow.mChildWindows.remove(this);
        }
        this.mWinAnimator.destroyDeferredSurfaceLocked();
        this.mWinAnimator.destroySurfaceLocked();
        this.mSession.windowRemovedLocked();
        try {
            this.mClient.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void setHasSurface(boolean hasSurface) {
        this.mHasSurface = hasSurface;
    }

    int getAnimLayerAdjustment() {
        if (this.mTargetAppToken != null) {
            return this.mTargetAppToken.mAppAnimator.animLayerAdjustment;
        }
        if (this.mAppToken != null) {
            return this.mAppToken.mAppAnimator.animLayerAdjustment;
        }
        return 0;
    }

    void scheduleAnimationIfDimming() {
        if (this.mDisplayContent == null) {
            return;
        }
        DimLayer.DimLayerUser dimLayerUser = this.getDimLayerUser();
        if (dimLayerUser != null && this.mDisplayContent.mDimLayerController.isDimming(dimLayerUser, this.mWinAnimator)) {
            this.mService.scheduleAnimationLocked();
        }
    }

    void notifyMovedInStack() {
        this.mJustMovedInStack = true;
    }

    boolean hasJustMovedInStack() {
        return this.mJustMovedInStack;
    }

    void resetJustMovedInStack() {
        this.mJustMovedInStack = false;
    }

    void openInputChannel(InputChannel outInputChannel) {
        if (this.mInputChannel != null) {
            throw new IllegalStateException("Window already has an input channel.");
        }
        String name = this.makeInputChannelName();
        InputChannel[] inputChannels = InputChannel.openInputChannelPair(name);
        this.mInputChannel = inputChannels[0];
        this.mClientChannel = inputChannels[1];
        this.mInputWindowHandle.inputChannel = inputChannels[0];
        if (outInputChannel != null) {
            this.mClientChannel.transferTo(outInputChannel);
            this.mClientChannel.dispose();
            this.mClientChannel = null;
        } else {
            this.mDeadWindowEventReceiver = new DeadWindowEventReceiver(this.mClientChannel);
        }
        this.mService.mInputManager.registerInputChannel(this.mInputChannel, this.mInputWindowHandle);
    }

    void disposeInputChannel() {
        if (this.mDeadWindowEventReceiver != null) {
            this.mDeadWindowEventReceiver.dispose();
            this.mDeadWindowEventReceiver = null;
        }
        if (this.mInputChannel != null) {
            this.mService.mInputManager.unregisterInputChannel(this.mInputChannel);
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
        if (this.mClientChannel != null) {
            this.mClientChannel.dispose();
            this.mClientChannel = null;
        }
        this.mInputWindowHandle.inputChannel = null;
    }

    void applyDimLayerIfNeeded() {
        AppWindowToken token = this.mAppToken;
        if (token != null && token.removed) {
            return;
        }
        if (!this.mAnimatingExit && this.mAppDied) {
            this.mDisplayContent.mDimLayerController.applyDimAbove(this.getDimLayerUser(), this.mWinAnimator);
        } else if ((this.mAttrs.flags & 2) != 0 && this.mDisplayContent != null && !this.mAnimatingExit && this.isVisibleUnchecked()) {
            this.mDisplayContent.mDimLayerController.applyDimBehind(this.getDimLayerUser(), this.mWinAnimator);
        }
    }

    DimLayer.DimLayerUser getDimLayerUser() {
        Task task = this.getTask();
        if (task != null) {
            return task;
        }
        return this.getStack();
    }

    void maybeRemoveReplacedWindow() {
        if (this.mAppToken == null) {
            return;
        }
        for (int i = this.mAppToken.allAppWindows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mAppToken.allAppWindows.get(i);
            if (!win.mWillReplaceWindow || win.mReplacingWindow != this || !this.hasDrawnLw()) continue;
            if (win.isDimming()) {
                win.transferDimToReplacement();
            }
            win.mWillReplaceWindow = false;
            boolean animateReplacingWindow = win.mAnimateReplacingWindow;
            win.mAnimateReplacingWindow = false;
            win.mReplacingRemoveRequested = false;
            win.mReplacingWindow = null;
            this.mSkipEnterAnimationForSeamlessReplacement = false;
            if (!win.mAnimatingExit && animateReplacingWindow) continue;
            this.mService.removeWindowInnerLocked(win);
        }
    }

    void setDisplayLayoutNeeded() {
        if (this.mDisplayContent != null) {
            this.mDisplayContent.layoutNeeded = true;
        }
    }

    boolean inDockedWorkspace() {
        Task task = this.getTask();
        return task != null && task.inDockedWorkspace();
    }

    boolean inPinnedWorkspace() {
        Task task = this.getTask();
        return task != null && task.inPinnedWorkspace();
    }

    boolean isDockedInEffect() {
        Task task = this.getTask();
        return task != null && task.isDockedInEffect();
    }

    void applyScrollIfNeeded() {
        Task task = this.getTask();
        if (task != null) {
            task.applyScrollToWindowIfNeeded(this);
        }
    }

    void applyAdjustForImeIfNeeded() {
        Task task = this.getTask();
        if (task != null && task.mStack != null && task.mStack.isAdjustedForIme()) {
            task.mStack.applyAdjustForImeIfNeeded(task);
        }
    }

    int getTouchableRegion(Region region, int flags) {
        boolean modal;
        boolean bl = modal = (flags & 0x28) == 0;
        if (modal && this.mAppToken != null) {
            flags |= 0x20;
            DimLayer.DimLayerUser dimLayerUser = this.getDimLayerUser();
            if (dimLayerUser != null) {
                dimLayerUser.getDimBounds(this.mTmpRect);
            } else {
                this.getVisibleBounds(this.mTmpRect);
            }
            if (this.inFreeformWorkspace()) {
                DisplayMetrics displayMetrics = this.getDisplayContent().getDisplayMetrics();
                int delta = WindowManagerService.dipToPixel(30, displayMetrics);
                this.mTmpRect.inset(-delta, -delta);
            }
            region.set(this.mTmpRect);
            this.cropRegionToStackBoundsIfNeeded(region);
        } else {
            this.getTouchableRegion(region);
        }
        return flags;
    }

    void checkPolicyVisibilityChange() {
        if (this.mPolicyVisibility != this.mPolicyVisibilityAfterAnim) {
            this.mPolicyVisibility = this.mPolicyVisibilityAfterAnim;
            this.setDisplayLayoutNeeded();
            if (!this.mPolicyVisibility) {
                if (this.mService.mCurrentFocus == this) {
                    this.mService.mFocusMayChange = true;
                }
                this.mService.enableScreenIfNeededLocked();
            }
        }
    }

    void setRequestedSize(int requestedWidth, int requestedHeight) {
        if (this.mRequestedWidth != requestedWidth || this.mRequestedHeight != requestedHeight) {
            this.mLayoutNeeded = true;
            this.mRequestedWidth = requestedWidth;
            this.mRequestedHeight = requestedHeight;
        }
    }

    void prepareWindowToDisplayDuringRelayout(Configuration outConfig) {
        if ((this.mAttrs.softInputMode & 0xF0) == 16) {
            this.mLayoutNeeded = true;
        }
        if (this.isDrawnLw() && this.mService.okToDisplay()) {
            this.mWinAnimator.applyEnterAnimationLocked();
        }
        if ((this.mAttrs.flags & 0x200000) != 0) {
            this.mTurnOnScreen = true;
        }
        if (this.isConfigChanged()) {
            Configuration newConfig = this.updateConfiguration();
            outConfig.setTo(newConfig);
        }
    }

    void adjustStartingWindowFlags() {
        if (this.mAttrs.type == 1 && this.mAppToken != null && this.mAppToken.startingWindow != null) {
            int mask = 4718593;
            WindowManager.LayoutParams sa = this.mAppToken.startingWindow.mAttrs;
            sa.flags = sa.flags & 0xFFB7FFFE | this.mAttrs.flags & 0x480001;
        }
    }

    void setWindowScale(int requestedWidth, int requestedHeight) {
        boolean scaledWindow;
        boolean bl = scaledWindow = (this.mAttrs.flags & 0x4000) != 0;
        if (scaledWindow) {
            this.mHScale = this.mAttrs.width != requestedWidth ? (float)this.mAttrs.width / (float)requestedWidth : 1.0f;
            this.mVScale = this.mAttrs.height != requestedHeight ? (float)this.mAttrs.height / (float)requestedHeight : 1.0f;
        } else {
            this.mVScale = 1.0f;
            this.mHScale = 1.0f;
        }
    }

    boolean shouldKeepVisibleDeadAppWindow() {
        if (!this.isWinVisibleLw() || this.mAppToken == null || this.mAppToken.clientHidden) {
            return false;
        }
        if (this.mAttrs.token != this.mClient.asBinder()) {
            return false;
        }
        if (this.mAttrs.type == 3) {
            return false;
        }
        TaskStack stack = this.getStack();
        return stack != null && ActivityManager.StackId.keepVisibleDeadAppWindowOnScreen(stack.mStackId);
    }

    boolean canReceiveKeys() {
        return this.isVisibleOrAdding() && this.mViewVisibility == 0 && !this.mRemoveOnExit && (this.mAttrs.flags & 8) == 0 && (this.mAppToken == null || this.mAppToken.windowsAreFocusable()) && !this.isAdjustedForMinimizedDock();
    }

    @Override
    public boolean hasDrawnLw() {
        return this.mWinAnimator.mDrawState == 4;
    }

    @Override
    public boolean showLw(boolean doAnimation) {
        return this.showLw(doAnimation, true);
    }

    boolean showLw(boolean doAnimation, boolean requestAnim) {
        if (this.isHiddenFromUserLocked()) {
            return false;
        }
        if (!this.mAppOpVisibility) {
            return false;
        }
        if (this.mPolicyVisibility && this.mPolicyVisibilityAfterAnim) {
            return false;
        }
        if (doAnimation) {
            if (!this.mService.okToDisplay()) {
                doAnimation = false;
            } else if (this.mPolicyVisibility && this.mWinAnimator.mAnimation == null) {
                doAnimation = false;
            }
        }
        this.mPolicyVisibility = true;
        this.mPolicyVisibilityAfterAnim = true;
        if (doAnimation) {
            this.mWinAnimator.applyAnimationLocked(1, true);
        }
        if (requestAnim) {
            this.mService.scheduleAnimationLocked();
        }
        return true;
    }

    @Override
    public boolean hideLw(boolean doAnimation) {
        return this.hideLw(doAnimation, true);
    }

    boolean hideLw(boolean doAnimation, boolean requestAnim) {
        boolean current;
        if (doAnimation && !this.mService.okToDisplay()) {
            doAnimation = false;
        }
        boolean bl = current = doAnimation ? this.mPolicyVisibilityAfterAnim : this.mPolicyVisibility;
        if (!current) {
            return false;
        }
        if (doAnimation) {
            this.mWinAnimator.applyAnimationLocked(2, false);
            if (this.mWinAnimator.mAnimation == null) {
                doAnimation = false;
            }
        }
        if (doAnimation) {
            this.mPolicyVisibilityAfterAnim = false;
        } else {
            this.mPolicyVisibilityAfterAnim = false;
            this.mPolicyVisibility = false;
            this.mService.enableScreenIfNeededLocked();
            if (this.mService.mCurrentFocus == this) {
                this.mService.mFocusMayChange = true;
            }
        }
        if (requestAnim) {
            this.mService.scheduleAnimationLocked();
        }
        return true;
    }

    public void setAppOpVisibilityLw(boolean state) {
        if (this.mAppOpVisibility != state) {
            this.mAppOpVisibility = state;
            if (state) {
                this.showLw(true, true);
            } else {
                this.hideLw(true, true);
            }
        }
    }

    public void pokeDrawLockLw(long timeout) {
        if (this.isVisibleOrAdding()) {
            if (this.mDrawLock == null) {
                CharSequence tag = this.getWindowTag();
                this.mDrawLock = this.mService.mPowerManager.newWakeLock(128, "Window:" + tag);
                this.mDrawLock.setReferenceCounted(false);
                this.mDrawLock.setWorkSource(new WorkSource(this.mOwnerUid, this.mAttrs.packageName));
            }
            this.mDrawLock.acquire(timeout);
        }
    }

    @Override
    public boolean isAlive() {
        return this.mClient.asBinder().isBinderAlive();
    }

    boolean isClosing() {
        return this.mAnimatingExit || this.mService.mClosingApps.contains(this.mAppToken);
    }

    boolean isAnimatingWithSavedSurface() {
        return this.mAnimatingWithSavedSurface;
    }

    boolean isAnimatingInvisibleWithSavedSurface() {
        return this.mAnimatingWithSavedSurface && (this.mViewVisibility != 0 || this.mWindowRemovalAllowed);
    }

    public void setVisibleBeforeClientHidden() {
        this.mWasVisibleBeforeClientHidden |= this.mViewVisibility == 0 || this.mAnimatingWithSavedSurface;
    }

    public void clearVisibleBeforeClientHidden() {
        this.mWasVisibleBeforeClientHidden = false;
    }

    public boolean wasVisibleBeforeClientHidden() {
        return this.mWasVisibleBeforeClientHidden;
    }

    private boolean shouldSaveSurface() {
        if (this.mWinAnimator.mSurfaceController == null) {
            return false;
        }
        if (!this.mWasVisibleBeforeClientHidden) {
            return false;
        }
        if ((this.mAttrs.flags & 0x2000) != 0) {
            return false;
        }
        if (ActivityManager.isLowRamDeviceStatic()) {
            return false;
        }
        Task task = this.getTask();
        if (task == null || task.inHomeStack()) {
            return false;
        }
        AppWindowToken taskTop = task.getTopVisibleAppToken();
        if (taskTop != null && taskTop != this.mAppToken) {
            return false;
        }
        if (this.mResizedWhileGone) {
            return false;
        }
        return this.mAppToken.shouldSaveSurface();
    }

    void destroyOrSaveSurface() {
        this.mSurfaceSaved = this.shouldSaveSurface();
        if (this.mSurfaceSaved) {
            this.mSession.setTransparentRegion(this.mClient, sEmptyRegion);
            this.mWinAnimator.hide("saved surface");
            this.mWinAnimator.mDrawState = 0;
            this.setHasSurface(false);
            if (this.mWinAnimator.mSurfaceController != null) {
                this.mWinAnimator.mSurfaceController.disconnectInTransaction();
            }
            this.mAnimatingWithSavedSurface = false;
        } else {
            this.mWinAnimator.destroySurfaceLocked();
        }
        this.mAnimatingExit = false;
    }

    void destroySavedSurface() {
        if (this.mSurfaceSaved) {
            this.mWinAnimator.destroySurfaceLocked();
            this.mSurfaceSaved = false;
        }
        this.mWasVisibleBeforeClientHidden = false;
    }

    void restoreSavedSurface() {
        if (!this.mSurfaceSaved) {
            return;
        }
        if (this.mLastVisibleLayoutRotation != this.mService.mRotation) {
            this.destroySavedSurface();
            return;
        }
        this.mSurfaceSaved = false;
        if (this.mWinAnimator.mSurfaceController != null) {
            this.setHasSurface(true);
            this.mWinAnimator.mDrawState = 3;
            this.mAnimatingWithSavedSurface = true;
        } else {
            Slog.wtf(TAG, "Failed to restore saved surface: surface gone! " + this);
        }
    }

    boolean canRestoreSurface() {
        return this.mWasVisibleBeforeClientHidden && this.mSurfaceSaved;
    }

    boolean hasSavedSurface() {
        return this.mSurfaceSaved;
    }

    void clearHasSavedSurface() {
        this.mSurfaceSaved = false;
        this.mAnimatingWithSavedSurface = false;
        if (this.mWasVisibleBeforeClientHidden) {
            this.mAppToken.destroySavedSurfaces();
        }
    }

    boolean clearAnimatingWithSavedSurface() {
        if (this.mAnimatingWithSavedSurface) {
            this.mAnimatingWithSavedSurface = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultDisplay() {
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent == null) {
            return false;
        }
        return displayContent.isDefaultDisplay;
    }

    @Override
    public boolean isDimming() {
        DimLayer.DimLayerUser dimLayerUser = this.getDimLayerUser();
        return dimLayerUser != null && this.mDisplayContent != null && this.mDisplayContent.mDimLayerController.isDimming(dimLayerUser, this.mWinAnimator);
    }

    public void setShowToOwnerOnlyLocked(boolean showToOwnerOnly) {
        this.mShowToOwnerOnly = showToOwnerOnly;
    }

    boolean isHiddenFromUserLocked() {
        WindowState win = this;
        while (win.isChildWindow()) {
            win = win.mAttachedWindow;
        }
        if (win.mAttrs.type < 2000 && win.mAppToken != null && win.mAppToken.showForAllUsers && win.mFrame.left <= win.mDisplayFrame.left && win.mFrame.top <= win.mDisplayFrame.top && win.mFrame.right >= win.mStableFrame.right && win.mFrame.bottom >= win.mStableFrame.bottom) {
            return false;
        }
        return win.mShowToOwnerOnly && !this.mService.isCurrentProfileLocked(UserHandle.getUserId(win.mOwnerUid));
    }

    private static void applyInsets(Region outRegion, Rect frame, Rect inset) {
        outRegion.set(frame.left + inset.left, frame.top + inset.top, frame.right - inset.right, frame.bottom - inset.bottom);
    }

    void getTouchableRegion(Region outRegion) {
        Rect frame = this.mFrame;
        switch (this.mTouchableInsets) {
            default: {
                outRegion.set(frame);
                break;
            }
            case 1: {
                WindowState.applyInsets(outRegion, frame, this.mGivenContentInsets);
                break;
            }
            case 2: {
                WindowState.applyInsets(outRegion, frame, this.mGivenVisibleInsets);
                break;
            }
            case 3: {
                Region givenTouchableRegion = this.mGivenTouchableRegion;
                outRegion.set(givenTouchableRegion);
                outRegion.translate(frame.left, frame.top);
                break;
            }
        }
        this.cropRegionToStackBoundsIfNeeded(outRegion);
    }

    void cropRegionToStackBoundsIfNeeded(Region region) {
        Task task = this.getTask();
        if (task == null || !task.cropWindowsToStackBounds()) {
            return;
        }
        TaskStack stack = task.mStack;
        if (stack == null) {
            return;
        }
        stack.getDimBounds(this.mTmpRect);
        region.op(this.mTmpRect, Region.Op.INTERSECT);
    }

    WindowList getWindowList() {
        DisplayContent displayContent = this.getDisplayContent();
        return displayContent == null ? null : displayContent.getWindowList();
    }

    public void reportFocusChangedSerialized(boolean focused, boolean inTouchMode) {
        try {
            this.mClient.windowFocusChanged(focused, inTouchMode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mFocusCallbacks != null) {
            int N = this.mFocusCallbacks.beginBroadcast();
            for (int i = 0; i < N; ++i) {
                IWindowFocusObserver obs = this.mFocusCallbacks.getBroadcastItem(i);
                try {
                    if (focused) {
                        obs.focusGained(this.mWindowId.asBinder());
                        continue;
                    }
                    obs.focusLost(this.mWindowId.asBinder());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mFocusCallbacks.finishBroadcast();
        }
    }

    private Configuration updateConfiguration() {
        boolean configChanged = this.isConfigChanged();
        this.getMergedConfig(this.mMergedConfiguration);
        this.mConfigHasChanged = false;
        return this.mMergedConfiguration;
    }

    private void getMergedConfig(Configuration outConfig) {
        if (this.mAppToken != null && this.mAppToken.mFrozenMergedConfig.size() > 0) {
            outConfig.setTo(this.mAppToken.mFrozenMergedConfig.peek());
            return;
        }
        Task task = this.getTask();
        Configuration overrideConfig = task != null ? task.mOverrideConfig : Configuration.EMPTY;
        Configuration serviceConfig = this.mService.mCurConfiguration;
        outConfig.setTo(serviceConfig);
        if (overrideConfig != Configuration.EMPTY) {
            outConfig.updateFrom(overrideConfig);
        }
    }

    void reportResized() {
        Trace.traceBegin(32L, "wm.reportResized_" + this.getWindowTag());
        try {
            boolean reportDraw;
            final Configuration newConfig = this.isConfigChanged() ? this.updateConfiguration() : null;
            final Rect frame = this.mFrame;
            final Rect overscanInsets = this.mLastOverscanInsets;
            final Rect contentInsets = this.mLastContentInsets;
            final Rect visibleInsets = this.mLastVisibleInsets;
            final Rect stableInsets = this.mLastStableInsets;
            final Rect outsets = this.mLastOutsets;
            boolean bl = reportDraw = this.mWinAnimator.mDrawState == 1;
            if (this.mAttrs.type != 3 && this.mClient instanceof IWindow.Stub) {
                this.mService.mH.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WindowState.this.dispatchResized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, newConfig);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            } else {
                this.dispatchResized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, newConfig);
            }
            if (this.mService.mAccessibilityController != null && this.getDisplayId() == 0) {
                this.mService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
            }
            this.mOverscanInsetsChanged = false;
            this.mContentInsetsChanged = false;
            this.mVisibleInsetsChanged = false;
            this.mStableInsetsChanged = false;
            this.mOutsetsChanged = false;
            this.mFrameSizeChanged = false;
            this.mResizedWhileNotDragResizingReported = true;
            this.mWinAnimator.mSurfaceResized = false;
        }
        catch (RemoteException e) {
            this.mOrientationChanging = false;
            this.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mService.mDisplayFreezeTime);
            Slog.w(TAG, "Failed to report 'resized' to the client of " + this + ", removing this window.");
            this.mService.mPendingRemove.add(this);
            this.mService.mWindowPlacerLocked.requestTraversal();
        }
        Trace.traceEnd(32L);
    }

    Rect getBackdropFrame(Rect frame) {
        boolean resizing;
        boolean bl = resizing = this.isDragResizing() || this.isDragResizeChanged();
        if (ActivityManager.StackId.useWindowFrameForBackdrop(this.getStackId()) || !resizing) {
            return frame;
        }
        DisplayInfo displayInfo = this.getDisplayInfo();
        this.mTmpRect.set(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
        return this.mTmpRect;
    }

    @Override
    public int getStackId() {
        TaskStack stack = this.getStack();
        if (stack == null) {
            return -1;
        }
        return stack.mStackId;
    }

    private void dispatchResized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, Rect outsets, boolean reportDraw, Configuration newConfig) throws RemoteException {
        boolean forceRelayout = this.isDragResizeChanged() || this.mResizedWhileNotDragResizing;
        this.mClient.resized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, newConfig, this.getBackdropFrame(frame), forceRelayout, this.mPolicy.isNavBarForcedShownLw(this));
        this.mDragResizingChangeReported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFocusObserver(IWindowFocusObserver observer) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mFocusCallbacks == null) {
                this.mFocusCallbacks = new RemoteCallbackList();
            }
            this.mFocusCallbacks.register(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFocusObserver(IWindowFocusObserver observer) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mFocusCallbacks != null) {
                this.mFocusCallbacks.unregister(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFocused() {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            return this.mService.mCurrentFocus == this;
        }
    }

    boolean inFreeformWorkspace() {
        Task task = this.getTask();
        return task != null && task.inFreeformWorkspace();
    }

    @Override
    public boolean isInMultiWindowMode() {
        Task task = this.getTask();
        return task != null && !task.isFullscreen();
    }

    boolean isDragResizeChanged() {
        return this.mDragResizing != this.computeDragResizing();
    }

    boolean isDragResizingChangeReported() {
        return this.mDragResizingChangeReported;
    }

    void resetDragResizingChangeReported() {
        this.mDragResizingChangeReported = false;
    }

    void setResizedWhileNotDragResizing(boolean resizedWhileNotDragResizing) {
        this.mResizedWhileNotDragResizing = resizedWhileNotDragResizing;
        this.mResizedWhileNotDragResizingReported = !resizedWhileNotDragResizing;
    }

    boolean isResizedWhileNotDragResizing() {
        return this.mResizedWhileNotDragResizing;
    }

    boolean isResizedWhileNotDragResizingReported() {
        return this.mResizedWhileNotDragResizingReported;
    }

    int getResizeMode() {
        return this.mResizeMode;
    }

    boolean computeDragResizing() {
        Task task = this.getTask();
        if (task == null) {
            return false;
        }
        if (this.mAttrs.width != -1 || this.mAttrs.height != -1) {
            return false;
        }
        if (task.isDragResizing()) {
            return true;
        }
        return (this.mDisplayContent.mDividerControllerLocked.isResizing() || this.mAppToken != null && !this.mAppToken.mFrozenBounds.isEmpty()) && !task.inFreeformWorkspace() && !this.isGoneForLayoutLw();
    }

    void setDragResizing() {
        boolean resizing = this.computeDragResizing();
        if (resizing == this.mDragResizing) {
            return;
        }
        this.mDragResizing = resizing;
        Task task = this.getTask();
        this.mResizeMode = task != null && task.isDragResizing() ? task.getDragResizeMode() : (this.mDragResizing && this.mDisplayContent.mDividerControllerLocked.isResizing() ? 1 : 0);
    }

    boolean isDragResizing() {
        return this.mDragResizing;
    }

    boolean isDockedResizing() {
        return this.mDragResizing && this.getResizeMode() == 1;
    }

    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        TaskStack stack = this.getStack();
        pw.print(prefix);
        pw.print("mDisplayId=");
        pw.print(this.getDisplayId());
        if (stack != null) {
            pw.print(" stackId=");
            pw.print(stack.mStackId);
        }
        if (this.mNotOnAppsDisplay) {
            pw.print(" mNotOnAppsDisplay=");
            pw.print(this.mNotOnAppsDisplay);
        }
        pw.print(" mSession=");
        pw.print(this.mSession);
        pw.print(" mClient=");
        pw.println(this.mClient.asBinder());
        pw.print(prefix);
        pw.print("mOwnerUid=");
        pw.print(this.mOwnerUid);
        pw.print(" mShowToOwnerOnly=");
        pw.print(this.mShowToOwnerOnly);
        pw.print(" package=");
        pw.print(this.mAttrs.packageName);
        pw.print(" appop=");
        pw.println(AppOpsManager.opToName(this.mAppOp));
        pw.print(prefix);
        pw.print("mAttrs=");
        pw.println(this.mAttrs);
        pw.print(prefix);
        pw.print("Requested w=");
        pw.print(this.mRequestedWidth);
        pw.print(" h=");
        pw.print(this.mRequestedHeight);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        if (this.mRequestedWidth != this.mLastRequestedWidth || this.mRequestedHeight != this.mLastRequestedHeight) {
            pw.print(prefix);
            pw.print("LastRequested w=");
            pw.print(this.mLastRequestedWidth);
            pw.print(" h=");
            pw.println(this.mLastRequestedHeight);
        }
        if (this.isChildWindow() || this.mLayoutAttached) {
            pw.print(prefix);
            pw.print("mAttachedWindow=");
            pw.print(this.mAttachedWindow);
            pw.print(" mLayoutAttached=");
            pw.println(this.mLayoutAttached);
        }
        if (this.mIsImWindow || this.mIsWallpaper || this.mIsFloatingLayer) {
            pw.print(prefix);
            pw.print("mIsImWindow=");
            pw.print(this.mIsImWindow);
            pw.print(" mIsWallpaper=");
            pw.print(this.mIsWallpaper);
            pw.print(" mIsFloatingLayer=");
            pw.print(this.mIsFloatingLayer);
            pw.print(" mWallpaperVisible=");
            pw.println(this.mWallpaperVisible);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mBaseLayer=");
            pw.print(this.mBaseLayer);
            pw.print(" mSubLayer=");
            pw.print(this.mSubLayer);
            pw.print(" mAnimLayer=");
            pw.print(this.mLayer);
            pw.print("+");
            pw.print(this.mTargetAppToken != null ? this.mTargetAppToken.mAppAnimator.animLayerAdjustment : (this.mAppToken != null ? this.mAppToken.mAppAnimator.animLayerAdjustment : 0));
            pw.print("=");
            pw.print(this.mWinAnimator.mAnimLayer);
            pw.print(" mLastLayer=");
            pw.println(this.mWinAnimator.mLastLayer);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mToken=");
            pw.println(this.mToken);
            pw.print(prefix);
            pw.print("mRootToken=");
            pw.println(this.mRootToken);
            if (this.mAppToken != null) {
                pw.print(prefix);
                pw.print("mAppToken=");
                pw.println(this.mAppToken);
                pw.print(prefix);
                pw.print(" isAnimatingWithSavedSurface()=");
                pw.print(this.isAnimatingWithSavedSurface());
                pw.print(" mAppDied=");
                pw.println(this.mAppDied);
            }
            if (this.mTargetAppToken != null) {
                pw.print(prefix);
                pw.print("mTargetAppToken=");
                pw.println(this.mTargetAppToken);
            }
            pw.print(prefix);
            pw.print("mViewVisibility=0x");
            pw.print(Integer.toHexString(this.mViewVisibility));
            pw.print(" mHaveFrame=");
            pw.print(this.mHaveFrame);
            pw.print(" mObscured=");
            pw.println(this.mObscured);
            pw.print(prefix);
            pw.print("mSeq=");
            pw.print(this.mSeq);
            pw.print(" mSystemUiVisibility=0x");
            pw.println(Integer.toHexString(this.mSystemUiVisibility));
        }
        if (!this.mPolicyVisibility || !this.mPolicyVisibilityAfterAnim || !this.mAppOpVisibility || this.mAttachedHidden) {
            pw.print(prefix);
            pw.print("mPolicyVisibility=");
            pw.print(this.mPolicyVisibility);
            pw.print(" mPolicyVisibilityAfterAnim=");
            pw.print(this.mPolicyVisibilityAfterAnim);
            pw.print(" mAppOpVisibility=");
            pw.print(this.mAppOpVisibility);
            pw.print(" mAttachedHidden=");
            pw.println(this.mAttachedHidden);
        }
        if (!this.mRelayoutCalled || this.mLayoutNeeded) {
            pw.print(prefix);
            pw.print("mRelayoutCalled=");
            pw.print(this.mRelayoutCalled);
            pw.print(" mLayoutNeeded=");
            pw.println(this.mLayoutNeeded);
        }
        if (this.mXOffset != 0 || this.mYOffset != 0) {
            pw.print(prefix);
            pw.print("Offsets x=");
            pw.print(this.mXOffset);
            pw.print(" y=");
            pw.println(this.mYOffset);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mGivenContentInsets=");
            this.mGivenContentInsets.printShortString(pw);
            pw.print(" mGivenVisibleInsets=");
            this.mGivenVisibleInsets.printShortString(pw);
            pw.println();
            if (this.mTouchableInsets != 0 || this.mGivenInsetsPending) {
                pw.print(prefix);
                pw.print("mTouchableInsets=");
                pw.print(this.mTouchableInsets);
                pw.print(" mGivenInsetsPending=");
                pw.println(this.mGivenInsetsPending);
                Region region = new Region();
                this.getTouchableRegion(region);
                pw.print(prefix);
                pw.print("touchable region=");
                pw.println(region);
            }
            pw.print(prefix);
            pw.print("mMergedConfiguration=");
            pw.println(this.mMergedConfiguration);
        }
        pw.print(prefix);
        pw.print("mHasSurface=");
        pw.print(this.mHasSurface);
        pw.print(" mShownPosition=");
        this.mShownPosition.printShortString(pw);
        pw.print(" isReadyForDisplay()=");
        pw.print(this.isReadyForDisplay());
        pw.print(" hasSavedSurface()=");
        pw.print(this.hasSavedSurface());
        pw.print(" mWindowRemovalAllowed=");
        pw.println(this.mWindowRemovalAllowed);
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mFrame=");
            this.mFrame.printShortString(pw);
            pw.print(" last=");
            this.mLastFrame.printShortString(pw);
            pw.println();
        }
        if (this.mEnforceSizeCompat) {
            pw.print(prefix);
            pw.print("mCompatFrame=");
            this.mCompatFrame.printShortString(pw);
            pw.println();
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("Frames: containing=");
            this.mContainingFrame.printShortString(pw);
            pw.print(" parent=");
            this.mParentFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    display=");
            this.mDisplayFrame.printShortString(pw);
            pw.print(" overscan=");
            this.mOverscanFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    content=");
            this.mContentFrame.printShortString(pw);
            pw.print(" visible=");
            this.mVisibleFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    decor=");
            this.mDecorFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    outset=");
            this.mOutsetFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("Cur insets: overscan=");
            this.mOverscanInsets.printShortString(pw);
            pw.print(" content=");
            this.mContentInsets.printShortString(pw);
            pw.print(" visible=");
            this.mVisibleInsets.printShortString(pw);
            pw.print(" stable=");
            this.mStableInsets.printShortString(pw);
            pw.print(" surface=");
            this.mAttrs.surfaceInsets.printShortString(pw);
            pw.print(" outsets=");
            this.mOutsets.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("Lst insets: overscan=");
            this.mLastOverscanInsets.printShortString(pw);
            pw.print(" content=");
            this.mLastContentInsets.printShortString(pw);
            pw.print(" visible=");
            this.mLastVisibleInsets.printShortString(pw);
            pw.print(" stable=");
            this.mLastStableInsets.printShortString(pw);
            pw.print(" physical=");
            this.mLastOutsets.printShortString(pw);
            pw.print(" outset=");
            this.mLastOutsets.printShortString(pw);
            pw.println();
        }
        pw.print(prefix);
        pw.print(this.mWinAnimator);
        pw.println(":");
        this.mWinAnimator.dump(pw, prefix + "  ", dumpAll);
        if (this.mAnimatingExit || this.mRemoveOnExit || this.mDestroying || this.mRemoved) {
            pw.print(prefix);
            pw.print("mAnimatingExit=");
            pw.print(this.mAnimatingExit);
            pw.print(" mRemoveOnExit=");
            pw.print(this.mRemoveOnExit);
            pw.print(" mDestroying=");
            pw.print(this.mDestroying);
            pw.print(" mRemoved=");
            pw.println(this.mRemoved);
        }
        if (this.mOrientationChanging || this.mAppFreezing || this.mTurnOnScreen) {
            pw.print(prefix);
            pw.print("mOrientationChanging=");
            pw.print(this.mOrientationChanging);
            pw.print(" mAppFreezing=");
            pw.print(this.mAppFreezing);
            pw.print(" mTurnOnScreen=");
            pw.println(this.mTurnOnScreen);
        }
        if (this.mLastFreezeDuration != 0) {
            pw.print(prefix);
            pw.print("mLastFreezeDuration=");
            TimeUtils.formatDuration((long)this.mLastFreezeDuration, pw);
            pw.println();
        }
        if (this.mHScale != 1.0f || this.mVScale != 1.0f) {
            pw.print(prefix);
            pw.print("mHScale=");
            pw.print(this.mHScale);
            pw.print(" mVScale=");
            pw.println(this.mVScale);
        }
        if (this.mWallpaperX != -1.0f || this.mWallpaperY != -1.0f) {
            pw.print(prefix);
            pw.print("mWallpaperX=");
            pw.print(this.mWallpaperX);
            pw.print(" mWallpaperY=");
            pw.println(this.mWallpaperY);
        }
        if (this.mWallpaperXStep != -1.0f || this.mWallpaperYStep != -1.0f) {
            pw.print(prefix);
            pw.print("mWallpaperXStep=");
            pw.print(this.mWallpaperXStep);
            pw.print(" mWallpaperYStep=");
            pw.println(this.mWallpaperYStep);
        }
        if (this.mWallpaperDisplayOffsetX != Integer.MIN_VALUE || this.mWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
            pw.print(prefix);
            pw.print("mWallpaperDisplayOffsetX=");
            pw.print(this.mWallpaperDisplayOffsetX);
            pw.print(" mWallpaperDisplayOffsetY=");
            pw.println(this.mWallpaperDisplayOffsetY);
        }
        if (this.mDrawLock != null) {
            pw.print(prefix);
            pw.println("mDrawLock=" + this.mDrawLock);
        }
        if (this.isDragResizing()) {
            pw.print(prefix);
            pw.println("isDragResizing=" + this.isDragResizing());
        }
        if (this.computeDragResizing()) {
            pw.print(prefix);
            pw.println("computeDragResizing=" + this.computeDragResizing());
        }
    }

    String makeInputChannelName() {
        return Integer.toHexString(System.identityHashCode(this)) + " " + this.getWindowTag();
    }

    CharSequence getWindowTag() {
        CharSequence tag = this.mAttrs.getTitle();
        if (tag == null || tag.length() <= 0) {
            tag = this.mAttrs.packageName;
        }
        return tag;
    }

    public String toString() {
        CharSequence title = this.getWindowTag();
        if (this.mStringNameCache == null || this.mLastTitle != title || this.mWasExiting != this.mAnimatingExit) {
            this.mLastTitle = title;
            this.mWasExiting = this.mAnimatingExit;
            this.mStringNameCache = "Window{" + Integer.toHexString(System.identityHashCode(this)) + " u" + UserHandle.getUserId(this.mSession.mUid) + " " + this.mLastTitle + (this.mAnimatingExit ? " EXITING}" : "}");
        }
        return this.mStringNameCache;
    }

    void transformClipRectFromScreenToSurfaceSpace(Rect clipRect) {
        if (this.mHScale >= 0.0f) {
            clipRect.left = (int)((float)clipRect.left / this.mHScale);
            clipRect.right = (int)Math.ceil((float)clipRect.right / this.mHScale);
        }
        if (this.mVScale >= 0.0f) {
            clipRect.top = (int)((float)clipRect.top / this.mVScale);
            clipRect.bottom = (int)Math.ceil((float)clipRect.bottom / this.mVScale);
        }
    }

    void applyGravityAndUpdateFrame(Rect containingFrame, Rect displayFrame) {
        float y;
        float x;
        int h;
        int w;
        boolean fitToDisplay;
        int pw = containingFrame.width();
        int ph = containingFrame.height();
        Task task = this.getTask();
        boolean nonFullscreenTask = this.isInMultiWindowMode();
        boolean noLimits = (this.mAttrs.flags & 0x200) != 0;
        boolean bl = fitToDisplay = task == null || !nonFullscreenTask || this.isChildWindow() && !noLimits;
        if ((this.mAttrs.flags & 0x4000) != 0) {
            w = this.mAttrs.width < 0 ? pw : (this.mEnforceSizeCompat ? (int)((float)this.mAttrs.width * this.mGlobalScale + 0.5f) : this.mAttrs.width);
            h = this.mAttrs.height < 0 ? ph : (this.mEnforceSizeCompat ? (int)((float)this.mAttrs.height * this.mGlobalScale + 0.5f) : this.mAttrs.height);
        } else {
            w = this.mAttrs.width == -1 ? pw : (this.mEnforceSizeCompat ? (int)((float)this.mRequestedWidth * this.mGlobalScale + 0.5f) : this.mRequestedWidth);
            h = this.mAttrs.height == -1 ? ph : (this.mEnforceSizeCompat ? (int)((float)this.mRequestedHeight * this.mGlobalScale + 0.5f) : this.mRequestedHeight);
        }
        if (this.mEnforceSizeCompat) {
            x = (float)this.mAttrs.x * this.mGlobalScale;
            y = (float)this.mAttrs.y * this.mGlobalScale;
        } else {
            x = this.mAttrs.x;
            y = this.mAttrs.y;
        }
        if (nonFullscreenTask && !this.layoutInParentFrame()) {
            w = Math.min(w, pw);
            h = Math.min(h, ph);
        }
        Gravity.apply(this.mAttrs.gravity, w, h, containingFrame, (int)(x + this.mAttrs.horizontalMargin * (float)pw), (int)(y + this.mAttrs.verticalMargin * (float)ph), this.mFrame);
        if (fitToDisplay) {
            Gravity.applyDisplay(this.mAttrs.gravity, displayFrame, this.mFrame);
        }
        this.mCompatFrame.set(this.mFrame);
        if (this.mEnforceSizeCompat) {
            this.mCompatFrame.scale(this.mInvGlobalScale);
        }
    }

    boolean isChildWindow() {
        return this.mAttachedWindow != null;
    }

    boolean layoutInParentFrame() {
        return this.isChildWindow() && (this.mAttrs.privateFlags & 0x10000) != 0;
    }

    void setReplacing(boolean animate) {
        if ((this.mAttrs.privateFlags & 0x8000) != 0 || this.mAttrs.type == 3) {
            return;
        }
        this.mWillReplaceWindow = true;
        this.mReplacingWindow = null;
        this.mAnimateReplacingWindow = animate;
    }

    void resetReplacing() {
        this.mWillReplaceWindow = false;
        this.mReplacingWindow = null;
        this.mAnimateReplacingWindow = false;
    }

    void requestUpdateWallpaperIfNeeded() {
        if (this.mDisplayContent != null && (this.mAttrs.flags & 0x100000) != 0) {
            this.mDisplayContent.pendingLayoutChanges |= 4;
            this.mDisplayContent.layoutNeeded = true;
            this.mService.mWindowPlacerLocked.requestTraversal();
        }
    }

    float translateToWindowX(float x) {
        float winX = x - (float)this.mFrame.left;
        if (this.mEnforceSizeCompat) {
            winX *= this.mGlobalScale;
        }
        return winX;
    }

    float translateToWindowY(float y) {
        float winY = y - (float)this.mFrame.top;
        if (this.mEnforceSizeCompat) {
            winY *= this.mGlobalScale;
        }
        return winY;
    }

    void transferDimToReplacement() {
        DimLayer.DimLayerUser dimLayerUser = this.getDimLayerUser();
        if (dimLayerUser != null && this.mDisplayContent != null) {
            this.mDisplayContent.mDimLayerController.applyDim(dimLayerUser, this.mReplacingWindow.mWinAnimator, (this.mAttrs.flags & 2) != 0);
        }
    }

    boolean shouldBeReplacedWithChildren() {
        return this.isChildWindow() || this.mAttrs.type == 2 || this.mAttrs.type == 4;
    }

    @Override
    public int getRotationAnimationHint() {
        if (this.mAppToken != null) {
            return this.mAppToken.mRotationAnimationHint;
        }
        return -1;
    }

    public boolean isRtl() {
        return this.mMergedConfiguration.getLayoutDirection() == 1;
    }

    private class DeathRecipient
    implements IBinder.DeathRecipient {
        private DeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            try {
                HashMap<IBinder, WindowState> hashMap = WindowState.this.mService.mWindowMap;
                synchronized (hashMap) {
                    WindowState win = WindowState.this.mService.windowForClientLocked(WindowState.this.mSession, WindowState.this.mClient, false);
                    Slog.i(WindowState.TAG, "WIN DEATH: " + win);
                    if (win != null) {
                        WindowState.this.mService.removeWindowLocked(win, WindowState.this.shouldKeepVisibleDeadAppWindow());
                        if (win.mAttrs.type == 2034) {
                            TaskStack stack = WindowState.this.mService.mStackIdToStack.get(3);
                            if (stack != null) {
                                stack.resetDockedStackToMiddle();
                            }
                            WindowState.this.mService.setDockedStackResizing(false);
                        }
                    } else if (WindowState.this.mHasSurface) {
                        Slog.e(WindowState.TAG, "!!! LEAK !!! Window removed but surface still valid.");
                        WindowState.this.mService.removeWindowLocked(WindowState.this);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private final class DeadWindowEventReceiver
    extends InputEventReceiver {
        DeadWindowEventReceiver(InputChannel inputChannel) {
            super(inputChannel, WindowState.this.mService.mH.getLooper());
        }

        @Override
        public void onInputEvent(InputEvent event) {
            this.finishInputEvent(event, true);
        }
    }
}

