/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicBoolean
implements Serializable {
    private static final long serialVersionUID = 4654671469794556979L;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long VALUE;
    private volatile int value;

    public AtomicBoolean(boolean initialValue) {
        this.value = initialValue ? 1 : 0;
    }

    public AtomicBoolean() {
    }

    public final boolean get() {
        return this.value != 0;
    }

    public final boolean compareAndSet(boolean expect, boolean update) {
        return U.compareAndSwapInt(this, VALUE, expect ? 1 : 0, update ? 1 : 0);
    }

    public boolean weakCompareAndSet(boolean expect, boolean update) {
        return U.compareAndSwapInt(this, VALUE, expect ? 1 : 0, update ? 1 : 0);
    }

    public final void set(boolean newValue) {
        this.value = newValue ? 1 : 0;
    }

    public final void lazySet(boolean newValue) {
        U.putOrderedInt(this, VALUE, newValue ? 1 : 0);
    }

    public final boolean getAndSet(boolean newValue) {
        boolean prev;
        while (!this.compareAndSet(prev = this.get(), newValue)) {
        }
        return prev;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    static {
        try {
            VALUE = U.objectFieldOffset(AtomicBoolean.class.getDeclaredField("value"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }
}

