/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import libcore.icu.ICU;
import libcore.util.Objects;

public final class LocaleData {
    private static final HashMap<String, LocaleData> localeDataCache = new HashMap();
    public Integer firstDayOfWeek;
    public Integer minimalDaysInFirstWeek;
    public String[] amPm;
    public String[] eras;
    public String[] longMonthNames;
    public String[] shortMonthNames;
    public String[] tinyMonthNames;
    public String[] longStandAloneMonthNames;
    public String[] shortStandAloneMonthNames;
    public String[] tinyStandAloneMonthNames;
    public String[] longWeekdayNames;
    public String[] shortWeekdayNames;
    public String[] tinyWeekdayNames;
    public String[] longStandAloneWeekdayNames;
    public String[] shortStandAloneWeekdayNames;
    public String[] tinyStandAloneWeekdayNames;
    public String yesterday;
    public String today;
    public String tomorrow;
    public String fullTimeFormat;
    public String longTimeFormat;
    public String mediumTimeFormat;
    public String shortTimeFormat;
    public String fullDateFormat;
    public String longDateFormat;
    public String mediumDateFormat;
    public String shortDateFormat;
    public String narrowAm;
    public String narrowPm;
    public String shortDateFormat4;
    public String timeFormat_hm;
    public String timeFormat_Hm;
    public String timeFormat_hms;
    public String timeFormat_Hms;
    public char zeroDigit;
    public char decimalSeparator;
    public char groupingSeparator;
    public char patternSeparator;
    public String percent;
    public char perMill;
    public char monetarySeparator;
    public String minusSign;
    public String exponentSeparator;
    public String infinity;
    public String NaN;
    public String currencySymbol;
    public String internationalCurrencySymbol;
    public String numberPattern;
    public String integerPattern;
    public String currencyPattern;
    public String percentPattern;

    private LocaleData() {
    }

    public static Locale mapInvalidAndNullLocales(Locale locale) {
        if (locale == null) {
            return Locale.getDefault();
        }
        if ("und".equals(locale.toLanguageTag())) {
            return Locale.ROOT;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleData get(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        String languageTag = locale.toLanguageTag();
        HashMap<String, LocaleData> hashMap = localeDataCache;
        synchronized (hashMap) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
        }
        LocaleData newLocaleData = LocaleData.initLocaleData(locale);
        HashMap<String, LocaleData> hashMap2 = localeDataCache;
        synchronized (hashMap2) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
            localeDataCache.put(languageTag, newLocaleData);
            return newLocaleData;
        }
    }

    public String toString() {
        return Objects.toString(this);
    }

    public String getDateFormat(int style2) {
        switch (style2) {
            case 3: {
                return this.shortDateFormat;
            }
            case 2: {
                return this.mediumDateFormat;
            }
            case 1: {
                return this.longDateFormat;
            }
            case 0: {
                return this.fullDateFormat;
            }
        }
        throw new AssertionError();
    }

    public String getTimeFormat(int style2) {
        switch (style2) {
            case 3: {
                if (DateFormat.is24Hour == null) {
                    return this.shortTimeFormat;
                }
                return DateFormat.is24Hour != false ? this.timeFormat_Hm : this.timeFormat_hm;
            }
            case 2: {
                if (DateFormat.is24Hour == null) {
                    return this.mediumTimeFormat;
                }
                return DateFormat.is24Hour != false ? this.timeFormat_Hms : this.timeFormat_hms;
            }
            case 1: {
                return this.longTimeFormat;
            }
            case 0: {
                return this.fullTimeFormat;
            }
        }
        throw new AssertionError();
    }

    private static LocaleData initLocaleData(Locale locale) {
        LocaleData localeData = new LocaleData();
        if (!ICU.initLocaleDataNative(locale.toLanguageTag(), localeData)) {
            throw new AssertionError((Object)("couldn't initialize LocaleData for locale " + locale));
        }
        localeData.timeFormat_hm = ICU.getBestDateTimePattern("hm", locale);
        localeData.timeFormat_Hm = ICU.getBestDateTimePattern("Hm", locale);
        localeData.timeFormat_hms = ICU.getBestDateTimePattern("hms", locale);
        localeData.timeFormat_Hms = ICU.getBestDateTimePattern("Hms", locale);
        if (localeData.fullTimeFormat != null) {
            localeData.fullTimeFormat = localeData.fullTimeFormat.replace('v', 'z');
        }
        if (localeData.numberPattern != null) {
            localeData.integerPattern = localeData.numberPattern.replaceAll("\\.[#,]*", "");
        }
        localeData.shortDateFormat4 = localeData.shortDateFormat.replaceAll("\\byy\\b", "y");
        return localeData;
    }

    static {
        LocaleData.get(Locale.ROOT);
        LocaleData.get(Locale.US);
        LocaleData.get(Locale.getDefault());
    }
}

