/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public final class Base64 {
    private static final byte[] BASE_64_ALPHABET = Base64.initializeBase64Alphabet();
    private static final int FIRST_OUTPUT_BYTE_MASK = 0xFC0000;
    private static final int SECOND_OUTPUT_BYTE_MASK = 258048;
    private static final int THIRD_OUTPUT_BYTE_MASK = 4032;
    private static final int FOURTH_OUTPUT_BYTE_MASK = 63;
    private static final byte PAD_AS_BYTE = -1;
    private static final byte WHITESPACE_AS_BYTE = -2;
    private static final byte END_OF_INPUT = -3;

    private static byte[] initializeBase64Alphabet() {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(StandardCharsets.US_ASCII);
    }

    private Base64() {
    }

    public static String encode(byte[] in) {
        int len = in.length;
        int outputLen = Base64.computeEncodingOutputLen(len);
        byte[] output = new byte[outputLen];
        int outputIndex = 0;
        for (int i = 0; i < len; i += 3) {
            int byteTripletAsInt = in[i] & 0xFF;
            if (i + 1 < len) {
                byteTripletAsInt <<= 8;
                byteTripletAsInt |= in[i + 1] & 0xFF;
                if (i + 2 < len) {
                    byteTripletAsInt <<= 8;
                    byteTripletAsInt |= in[i + 2] & 0xFF;
                } else {
                    byteTripletAsInt <<= 2;
                }
            } else {
                byteTripletAsInt <<= 4;
            }
            if (i + 2 < len) {
                output[outputIndex++] = BASE_64_ALPHABET[(byteTripletAsInt & 0xFC0000) >>> 18];
            }
            if (i + 1 < len) {
                output[outputIndex++] = BASE_64_ALPHABET[(byteTripletAsInt & 0x3F000) >>> 12];
            }
            output[outputIndex++] = BASE_64_ALPHABET[(byteTripletAsInt & 0xFC0) >>> 6];
            output[outputIndex++] = BASE_64_ALPHABET[byteTripletAsInt & 0x3F];
        }
        int inLengthMod3 = len % 3;
        if (inLengthMod3 > 0) {
            output[outputIndex++] = 61;
            if (inLengthMod3 == 1) {
                output[outputIndex++] = 61;
            }
        }
        return new String(output, StandardCharsets.US_ASCII);
    }

    private static int computeEncodingOutputLen(int inLength) {
        int inLengthMod3 = inLength % 3;
        int outputLen = inLength / 3 * 4;
        if (inLengthMod3 == 2) {
            outputLen += 4;
        } else if (inLengthMod3 == 1) {
            outputLen += 4;
        }
        return outputLen;
    }

    public static byte[] decode(byte[] in) {
        return Base64.decode(in, in.length);
    }

    public static byte[] decode(byte[] in, int len) {
        int inLength = Math.min(in.length, len);
        ByteArrayOutputStream output = new ByteArrayOutputStream(inLength / 4 * 3 + 3);
        int[] pos = new int[1];
        try {
            while (pos[0] < inLength) {
                int byteTripletAsInt = 0;
                for (int j = 0; j < 4; ++j) {
                    byte c = Base64.getNextByte(in, pos, inLength);
                    if (c == -3 || c == -1) {
                        switch (j) {
                            case 0: 
                            case 1: {
                                return c == -3 ? output.toByteArray() : null;
                            }
                            case 2: {
                                if (c == -3) {
                                    return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                                }
                                pos[0] = pos[0] + 1;
                                c = Base64.getNextByte(in, pos, inLength);
                                if (c == -3) {
                                    return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                                }
                                if (c == -1) {
                                    output.write(byteTripletAsInt >>= 4);
                                    return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                                }
                                return null;
                            }
                            case 3: {
                                if (c == -1) {
                                    output.write((byteTripletAsInt >>= 2) >> 8);
                                    output.write(byteTripletAsInt & 0xFF);
                                }
                                return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                            }
                        }
                        continue;
                    }
                    byteTripletAsInt <<= 6;
                    byteTripletAsInt += c & 0xFF;
                    pos[0] = pos[0] + 1;
                }
                output.write(byteTripletAsInt >> 16);
                output.write(byteTripletAsInt >> 8 & 0xFF);
                output.write(byteTripletAsInt & 0xFF);
            }
            return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
        }
        catch (InvalidBase64ByteException e) {
            return null;
        }
    }

    private static byte getNextByte(byte[] in, int[] pos, int inLength) throws InvalidBase64ByteException {
        while (pos[0] < inLength) {
            byte c = Base64.base64AlphabetToNumericalValue(in[pos[0]]);
            if (c != -2) {
                return c;
            }
            pos[0] = pos[0] + 1;
        }
        return -3;
    }

    private static byte[] checkNoTrailingAndReturn(ByteArrayOutputStream output, byte[] in, int i, int inLength) throws InvalidBase64ByteException {
        while (i < inLength) {
            byte c = Base64.base64AlphabetToNumericalValue(in[i]);
            if (c != -2 && c != -1) {
                return null;
            }
            ++i;
        }
        return output.toByteArray();
    }

    private static byte base64AlphabetToNumericalValue(byte c) throws InvalidBase64ByteException {
        if (65 <= c && c <= 90) {
            return (byte)(c - 65);
        }
        if (97 <= c && c <= 122) {
            return (byte)(c - 97 + 26);
        }
        if (48 <= c && c <= 57) {
            return (byte)(c - 48 + 52);
        }
        if (c == 43) {
            return 62;
        }
        if (c == 47) {
            return 63;
        }
        if (c == 61) {
            return -1;
        }
        if (c == 32 || c == 9 || c == 13 || c == 10) {
            return -2;
        }
        throw new InvalidBase64ByteException();
    }

    private static class InvalidBase64ByteException
    extends Exception {
        private InvalidBase64ByteException() {
        }
    }
}

