/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import libcore.tzdata.update.FileUtils;

public final class ConfigBundle {
    public static final String TZ_DATA_VERSION_FILE_NAME = "tzdata_version";
    public static final String CHECKSUMS_FILE_NAME = "checksums";
    public static final String ZONEINFO_FILE_NAME = "tzdata";
    public static final String ICU_DATA_FILE_NAME = "icu/icu_tzdata.dat";
    private static final int BUFFER_SIZE = 8192;
    private final byte[] bytes;

    public ConfigBundle(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBundleBytes() {
        return this.bytes;
    }

    public void extractTo(File targetDir) throws IOException {
        ConfigBundle.extractZipSafely(new ByteArrayInputStream(this.bytes), targetDir, true);
    }

    static void extractZipSafely(InputStream is, File targetDir, boolean makeWorldReadable) throws IOException {
        FileUtils.ensureDirectoriesExist(targetDir, makeWorldReadable);
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                File entryFile = FileUtils.createSubFile(targetDir, name);
                if (entry.isDirectory()) {
                    FileUtils.ensureDirectoriesExist(entryFile, makeWorldReadable);
                    continue;
                }
                if (!entryFile.getParentFile().exists()) {
                    FileUtils.ensureDirectoriesExist(entryFile.getParentFile(), makeWorldReadable);
                }
                try (FileOutputStream fos = new FileOutputStream(entryFile);){
                    int count;
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        fos.write(buffer, 0, count);
                    }
                    fos.getFD().sync();
                }
                if (!makeWorldReadable) continue;
                FileUtils.makeWorldReadable(entryFile);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigBundle that = (ConfigBundle)o;
        return Arrays.equals(this.bytes, that.bytes);
    }
}

