/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Build;
import android.os.Trace;
import android.util.ArrayMap;
import com.android.internal.os.PathClassLoaderFactory;
import dalvik.system.PathClassLoader;

public class ApplicationLoaders {
    private final ArrayMap<String, ClassLoader> mLoaders = new ArrayMap();
    private static final ApplicationLoaders gApplicationLoaders = new ApplicationLoaders();

    public static ApplicationLoaders getDefault() {
        return gApplicationLoaders;
    }

    ClassLoader getClassLoader(String zip, int targetSdkVersion, boolean isBundled, String librarySearchPath, String libraryPermittedPath, ClassLoader parent) {
        return this.getClassLoader(zip, targetSdkVersion, isBundled, librarySearchPath, libraryPermittedPath, parent, zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(String zip, int targetSdkVersion, boolean isBundled, String librarySearchPath, String libraryPermittedPath, ClassLoader parent, String cacheKey) {
        ClassLoader baseParent = ClassLoader.getSystemClassLoader().getParent();
        ArrayMap<String, ClassLoader> arrayMap = this.mLoaders;
        synchronized (arrayMap) {
            if (parent == null) {
                parent = baseParent;
            }
            if (parent == baseParent) {
                ClassLoader loader = this.mLoaders.get(cacheKey);
                if (loader != null) {
                    return loader;
                }
                Trace.traceBegin(64L, zip);
                PathClassLoader pathClassloader = PathClassLoaderFactory.createClassLoader(zip, librarySearchPath, libraryPermittedPath, parent, targetSdkVersion, isBundled);
                Trace.traceEnd(64L);
                Trace.traceBegin(64L, "setupVulkanLayerPath");
                ApplicationLoaders.setupVulkanLayerPath(pathClassloader, librarySearchPath);
                Trace.traceEnd(64L);
                this.mLoaders.put(cacheKey, pathClassloader);
                return pathClassloader;
            }
            Trace.traceBegin(64L, zip);
            PathClassLoader pathClassloader = new PathClassLoader(zip, parent);
            Trace.traceEnd(64L);
            return pathClassloader;
        }
    }

    public ClassLoader createAndCacheWebViewClassLoader(String packagePath, String libsPath, String cacheKey) {
        return this.getClassLoader(packagePath, Build.VERSION.SDK_INT, false, libsPath, null, null, cacheKey);
    }

    private static native void setupVulkanLayerPath(ClassLoader var0, String var1);

    void addPath(ClassLoader classLoader, String dexPath) {
        if (!(classLoader instanceof PathClassLoader)) {
            throw new IllegalStateException("class loader is not a PathClassLoader");
        }
        PathClassLoader baseDexClassLoader = (PathClassLoader)classLoader;
        baseDexClassLoader.addDexPath(dexPath);
    }
}

