/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IInstantAppResolver;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.InstantAppResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.os.SomeArgs;
import java.util.Arrays;
import java.util.List;

public abstract class InstantAppResolverService
extends Service {
    private static final boolean DEBUG_EPHEMERAL = Build.IS_DEBUGGABLE;
    private static final String TAG = "PackageManager";
    public static final String EXTRA_RESOLVE_INFO = "android.app.extra.RESOLVE_INFO";
    public static final String EXTRA_SEQUENCE = "android.app.extra.SEQUENCE";
    Handler mHandler;

    public void onGetInstantAppResolveInfo(int[] digestPrefix, String token, InstantAppResolutionCallback callback) {
        throw new IllegalStateException("Must define");
    }

    public void onGetInstantAppIntentFilter(int[] digestPrefix, String token, InstantAppResolutionCallback callback) {
        throw new IllegalStateException("Must define");
    }

    Looper getLooper() {
        return this.getBaseContext().getMainLooper();
    }

    @Override
    public final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new ServiceHandler(this.getLooper());
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IInstantAppResolver.Stub(){

            @Override
            public void getInstantAppResolveInfoList(int[] digestPrefix, String token, int sequence, IRemoteCallback callback) {
                if (DEBUG_EPHEMERAL) {
                    Slog.v(InstantAppResolverService.TAG, "[" + token + "] Phase1 called; posting");
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callback;
                args.arg2 = digestPrefix;
                args.arg3 = token;
                InstantAppResolverService.this.mHandler.obtainMessage(1, sequence, 0, args).sendToTarget();
            }

            @Override
            public void getInstantAppIntentFilterList(int[] digestPrefix, String token, String hostName, IRemoteCallback callback) {
                if (DEBUG_EPHEMERAL) {
                    Slog.v(InstantAppResolverService.TAG, "[" + token + "] Phase2 called; posting");
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callback;
                args.arg2 = digestPrefix;
                args.arg3 = token;
                args.arg4 = hostName;
                InstantAppResolverService.this.mHandler.obtainMessage(2, callback).sendToTarget();
            }
        };
    }

    @Deprecated
    void _onGetInstantAppResolveInfo(int[] digestPrefix, String token, InstantAppResolutionCallback callback) {
        if (DEBUG_EPHEMERAL) {
            Slog.d(TAG, "[" + token + "] Phase1 request;" + " prefix: " + Arrays.toString(digestPrefix));
        }
        this.onGetInstantAppResolveInfo(digestPrefix, token, callback);
    }

    @Deprecated
    void _onGetInstantAppIntentFilter(int[] digestPrefix, String token, String hostName, InstantAppResolutionCallback callback) {
        if (DEBUG_EPHEMERAL) {
            Slog.d(TAG, "[" + token + "] Phase2 request;" + " prefix: " + Arrays.toString(digestPrefix));
        }
        this.onGetInstantAppIntentFilter(digestPrefix, token, callback);
    }

    private final class ServiceHandler
    extends Handler {
        public static final int MSG_GET_INSTANT_APP_RESOLVE_INFO = 1;
        public static final int MSG_GET_INSTANT_APP_INTENT_FILTER = 2;

        public ServiceHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message message) {
            int action = message.what;
            switch (action) {
                case 1: {
                    SomeArgs args = (SomeArgs)message.obj;
                    IRemoteCallback callback = (IRemoteCallback)args.arg1;
                    int[] digestPrefix = (int[])args.arg2;
                    String token = (String)args.arg3;
                    int sequence = message.arg1;
                    InstantAppResolverService.this._onGetInstantAppResolveInfo(digestPrefix, token, new InstantAppResolutionCallback(sequence, callback));
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)message.obj;
                    IRemoteCallback callback = (IRemoteCallback)args.arg1;
                    int[] digestPrefix = (int[])args.arg2;
                    String token = (String)args.arg3;
                    String hostName = (String)args.arg4;
                    InstantAppResolverService.this._onGetInstantAppIntentFilter(digestPrefix, token, hostName, new InstantAppResolutionCallback(-1, callback));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + action);
                }
            }
        }
    }

    public static final class InstantAppResolutionCallback {
        private final IRemoteCallback mCallback;
        private final int mSequence;

        InstantAppResolutionCallback(int sequence, IRemoteCallback callback) {
            this.mCallback = callback;
            this.mSequence = sequence;
        }

        public void onInstantAppResolveInfo(List<InstantAppResolveInfo> resolveInfo) {
            Bundle data = new Bundle();
            data.putParcelableList(InstantAppResolverService.EXTRA_RESOLVE_INFO, resolveInfo);
            data.putInt(InstantAppResolverService.EXTRA_SEQUENCE, this.mSequence);
            try {
                this.mCallback.sendResult(data);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

