/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntDef;
import android.app.AutomaticZenRule;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.UserHandle;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationManager {
    private static String TAG = "NotificationManager";
    private static boolean localLOGV = false;
    public static final String ACTION_EFFECTS_SUPPRESSOR_CHANGED = "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED = "android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_CHANGED = "android.app.action.NOTIFICATION_POLICY_CHANGED";
    public static final String ACTION_INTERRUPTION_FILTER_CHANGED = "android.app.action.INTERRUPTION_FILTER_CHANGED";
    public static final String ACTION_INTERRUPTION_FILTER_CHANGED_INTERNAL = "android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL";
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int INTERRUPTION_FILTER_ALARMS = 4;
    public static final int INTERRUPTION_FILTER_UNKNOWN = 0;
    public static final int VISIBILITY_NO_OVERRIDE = -1000;
    public static final int IMPORTANCE_UNSPECIFIED = -1000;
    public static final int IMPORTANCE_NONE = 0;
    public static final int IMPORTANCE_MIN = 1;
    public static final int IMPORTANCE_LOW = 2;
    public static final int IMPORTANCE_DEFAULT = 3;
    public static final int IMPORTANCE_HIGH = 4;
    public static final int IMPORTANCE_MAX = 5;
    private static INotificationManager sService;
    private Context mContext;

    public static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("notification");
        sService = INotificationManager.Stub.asInterface(b);
        return sService;
    }

    NotificationManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public static NotificationManager from(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    public void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    public void notify(String tag, int id2, Notification notification) {
        this.notifyAsUser(tag, id2, notification, new UserHandle(UserHandle.myUserId()));
    }

    public void notifyAsUser(String tag, int id2, Notification notification, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        Notification.addFieldsFromContext(this.mContext, notification);
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        this.fixLegacySmallIcon(notification, pkg);
        if (this.mContext.getApplicationInfo().targetSdkVersion > 22 && notification.getSmallIcon() == null) {
            throw new IllegalArgumentException("Invalid notification (no valid small icon): " + notification);
        }
        if (localLOGV) {
            Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
        }
        Notification copy = Notification.Builder.maybeCloneStrippedForDelivery(notification);
        try {
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, copy, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void fixLegacySmallIcon(Notification n, String pkg) {
        if (n.getSmallIcon() == null && n.icon != 0) {
            n.setSmallIcon(Icon.createWithResource(pkg, n.icon));
        }
    }

    public void cancel(int id2) {
        this.cancel(null, id2);
    }

    public void cancel(String tag, int id2) {
        this.cancelAsUser(tag, id2, new UserHandle(UserHandle.myUserId()));
    }

    public void cancelAsUser(String tag, int id2, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, tag, id2, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void cancelAll() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancelAll()");
        }
        try {
            service.cancelAllNotifications(pkg, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createNotificationChannelGroup(NotificationChannelGroup group) {
        this.createNotificationChannelGroups(Arrays.asList(group));
    }

    public void createNotificationChannelGroups(List<NotificationChannelGroup> groups) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.createNotificationChannelGroups(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannelGroup>(groups));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createNotificationChannel(NotificationChannel channel) {
        this.createNotificationChannels(Arrays.asList(channel));
    }

    public void createNotificationChannels(List<NotificationChannel> channels) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.createNotificationChannels(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannel>(channels));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NotificationChannel getNotificationChannel(String channelId) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannel(this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<NotificationChannel> getNotificationChannels() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannels(this.mContext.getPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void deleteNotificationChannel(String channelId) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.deleteNotificationChannel(this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<NotificationChannelGroup> getNotificationChannelGroups() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannelGroups(this.mContext.getPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void deleteNotificationChannelGroup(String groupId) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.deleteNotificationChannelGroup(this.mContext.getPackageName(), groupId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ComponentName getEffectsSuppressor() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEffectsSuppressor();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean matchesCallFilter(Bundle extras) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.matchesCallFilter(extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSystemConditionProviderEnabled(String path) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isSystemConditionProviderEnabled(path);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setZenMode(int mode, Uri conditionId, String reason) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setZenMode(mode, conditionId, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getZenMode() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ZenModeConfig getZenModeConfig() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenModeConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getRuleInstanceCount(ComponentName owner) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getRuleInstanceCount(owner);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Map<String, AutomaticZenRule> getAutomaticZenRules() {
        INotificationManager service = NotificationManager.getService();
        try {
            List<ZenModeConfig.ZenRule> rules = service.getZenRules();
            HashMap<String, AutomaticZenRule> ruleMap = new HashMap<String, AutomaticZenRule>();
            for (ZenModeConfig.ZenRule rule : rules) {
                ruleMap.put(rule.id, new AutomaticZenRule(rule.name, rule.component, rule.conditionId, NotificationManager.zenModeToInterruptionFilter(rule.zenMode), rule.enabled, rule.creationTime));
            }
            return ruleMap;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public AutomaticZenRule getAutomaticZenRule(String id2) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getAutomaticZenRule(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.addAutomaticZenRule(automaticZenRule);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.updateAutomaticZenRule(id2, automaticZenRule);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean removeAutomaticZenRule(String id2) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.removeAutomaticZenRule(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean removeAutomaticZenRules(String packageName) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.removeAutomaticZenRules(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getImportance() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getPackageImportance(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areNotificationsEnabled() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.areNotificationsEnabled(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationPolicyAccessGranted() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGranted(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGrantedForPackage(pkg);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Policy getNotificationPolicy() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationPolicy(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationPolicy(Policy policy) {
        NotificationManager.checkRequired("policy", policy);
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicy(this.mContext.getOpPackageName(), policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationPolicyAccessGranted(String pkg, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicyAccessGranted(pkg, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ArraySet<String> getPackagesRequestingNotificationPolicyAccess() {
        INotificationManager service = NotificationManager.getService();
        try {
            String[] pkgs = service.getPackagesRequestingNotificationPolicyAccess();
            if (pkgs != null && pkgs.length > 0) {
                ArraySet<String> rt = new ArraySet<String>(pkgs.length);
                for (int i = 0; i < pkgs.length; ++i) {
                    rt.add(pkgs[i]);
                }
                return rt;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new ArraySet<String>();
    }

    private static void checkRequired(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " is required");
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        try {
            ParceledListSlice parceledList = service.getAppActiveNotifications(pkg, UserHandle.myUserId());
            List list = parceledList.getList();
            return list.toArray(new StatusBarNotification[list.size()]);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public final int getCurrentInterruptionFilter() {
        INotificationManager service = NotificationManager.getService();
        try {
            return NotificationManager.zenModeToInterruptionFilter(service.getZenMode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public final void setInterruptionFilter(int interruptionFilter) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setInterruptionFilter(this.mContext.getOpPackageName(), interruptionFilter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int zenModeToInterruptionFilter(int zen) {
        switch (zen) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public static int zenModeFromInterruptionFilter(int interruptionFilter, int defValue) {
        switch (interruptionFilter) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return defValue;
    }

    public static class Policy
    implements Parcelable {
        public static final int PRIORITY_CATEGORY_REMINDERS = 1;
        public static final int PRIORITY_CATEGORY_EVENTS = 2;
        public static final int PRIORITY_CATEGORY_MESSAGES = 4;
        public static final int PRIORITY_CATEGORY_CALLS = 8;
        public static final int PRIORITY_CATEGORY_REPEAT_CALLERS = 16;
        private static final int[] ALL_PRIORITY_CATEGORIES = new int[]{1, 2, 4, 8, 16};
        public static final int PRIORITY_SENDERS_ANY = 0;
        public static final int PRIORITY_SENDERS_CONTACTS = 1;
        public static final int PRIORITY_SENDERS_STARRED = 2;
        public final int priorityCategories;
        public final int priorityCallSenders;
        public final int priorityMessageSenders;
        public static final int SUPPRESSED_EFFECTS_UNSET = -1;
        public static final int SUPPRESSED_EFFECT_SCREEN_OFF = 1;
        public static final int SUPPRESSED_EFFECT_SCREEN_ON = 2;
        private static final int[] ALL_SUPPRESSED_EFFECTS = new int[]{1, 2};
        public final int suppressedVisualEffects;
        public static final Parcelable.Creator<Policy> CREATOR = new Parcelable.Creator<Policy>(){

            @Override
            public Policy createFromParcel(Parcel in) {
                return new Policy(in);
            }

            public Policy[] newArray(int size) {
                return new Policy[size];
            }
        };

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders) {
            this(priorityCategories, priorityCallSenders, priorityMessageSenders, -1);
        }

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects) {
            this.priorityCategories = priorityCategories;
            this.priorityCallSenders = priorityCallSenders;
            this.priorityMessageSenders = priorityMessageSenders;
            this.suppressedVisualEffects = suppressedVisualEffects;
        }

        public Policy(Parcel source) {
            this(source.readInt(), source.readInt(), source.readInt(), source.readInt());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.priorityCategories);
            dest.writeInt(this.priorityCallSenders);
            dest.writeInt(this.priorityMessageSenders);
            dest.writeInt(this.suppressedVisualEffects);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.priorityCategories, this.priorityCallSenders, this.priorityMessageSenders, this.suppressedVisualEffects);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Policy)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Policy other = (Policy)o;
            return other.priorityCategories == this.priorityCategories && other.priorityCallSenders == this.priorityCallSenders && other.priorityMessageSenders == this.priorityMessageSenders && other.suppressedVisualEffects == this.suppressedVisualEffects;
        }

        public String toString() {
            return "NotificationManager.Policy[priorityCategories=" + Policy.priorityCategoriesToString(this.priorityCategories) + ",priorityCallSenders=" + Policy.prioritySendersToString(this.priorityCallSenders) + ",priorityMessageSenders=" + Policy.prioritySendersToString(this.priorityMessageSenders) + ",suppressedVisualEffects=" + Policy.suppressedEffectsToString(this.suppressedVisualEffects) + "]";
        }

        public static String suppressedEffectsToString(int effects) {
            if (effects <= 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                int effect = ALL_SUPPRESSED_EFFECTS[i];
                if ((effects & effect) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.effectToString(effect));
                }
                effects &= ~effect;
            }
            if (effects != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("UNKNOWN_").append(effects);
            }
            return sb.toString();
        }

        public static String priorityCategoriesToString(int priorityCategories) {
            if (priorityCategories == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_PRIORITY_CATEGORIES.length; ++i) {
                int priorityCategory = ALL_PRIORITY_CATEGORIES[i];
                if ((priorityCategories & priorityCategory) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.priorityCategoryToString(priorityCategory));
                }
                priorityCategories &= ~priorityCategory;
            }
            if (priorityCategories != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("PRIORITY_CATEGORY_UNKNOWN_").append(priorityCategories);
            }
            return sb.toString();
        }

        private static String effectToString(int effect) {
            switch (effect) {
                case 1: {
                    return "SUPPRESSED_EFFECT_SCREEN_OFF";
                }
                case 2: {
                    return "SUPPRESSED_EFFECT_SCREEN_ON";
                }
                case -1: {
                    return "SUPPRESSED_EFFECTS_UNSET";
                }
            }
            return "UNKNOWN_" + effect;
        }

        private static String priorityCategoryToString(int priorityCategory) {
            switch (priorityCategory) {
                case 1: {
                    return "PRIORITY_CATEGORY_REMINDERS";
                }
                case 2: {
                    return "PRIORITY_CATEGORY_EVENTS";
                }
                case 4: {
                    return "PRIORITY_CATEGORY_MESSAGES";
                }
                case 8: {
                    return "PRIORITY_CATEGORY_CALLS";
                }
                case 16: {
                    return "PRIORITY_CATEGORY_REPEAT_CALLERS";
                }
            }
            return "PRIORITY_CATEGORY_UNKNOWN_" + priorityCategory;
        }

        public static String prioritySendersToString(int prioritySenders) {
            switch (prioritySenders) {
                case 0: {
                    return "PRIORITY_SENDERS_ANY";
                }
                case 1: {
                    return "PRIORITY_SENDERS_CONTACTS";
                }
                case 2: {
                    return "PRIORITY_SENDERS_STARRED";
                }
            }
            return "PRIORITY_SENDERS_UNKNOWN_" + prioritySenders;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(prefix={"IMPORTANCE_"}, value={-1000L, 0L, 1L, 2L, 3L, 4L})
    public static @interface Importance {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(prefix={"INTERRUPTION_FILTER_"}, value={3L, 2L, 4L, 1L, 0L})
    public static @interface InterruptionFilter {
    }
}

