/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.WallpaperManager;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Slog;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;

public class WallpaperBackupHelper
extends FileBackupHelperBase
implements BackupHelper {
    private static final String TAG = "WallpaperBackupHelper";
    private static final boolean DEBUG = false;
    private static final boolean REJECT_OUTSIZED_RESTORE = false;
    private static final double MAX_HEIGHT_RATIO = 1.35;
    private static final double MIN_HEIGHT_RATIO = 0.0;
    public static final String WALLPAPER_IMAGE = new File(Environment.getUserSystemDirectory(0), "wallpaper").getAbsolutePath();
    public static final String WALLPAPER_ORIG_IMAGE = new File(Environment.getUserSystemDirectory(0), "wallpaper_orig").getAbsolutePath();
    public static final String WALLPAPER_INFO = new File(Environment.getUserSystemDirectory(0), "wallpaper_info.xml").getAbsolutePath();
    public static final String WALLPAPER_IMAGE_KEY = "/data/data/com.android.settings/files/wallpaper";
    public static final String WALLPAPER_INFO_KEY = "/data/system/wallpaper_info.xml";
    private static final String STAGE_FILE = new File(Environment.getUserSystemDirectory(0), "wallpaper-tmp").getAbsolutePath();
    Context mContext;
    String[] mFiles;
    String[] mKeys;
    double mDesiredMinWidth;
    double mDesiredMinHeight;

    public WallpaperBackupHelper(Context context, String[] files, String[] keys) {
        super(context);
        this.mContext = context;
        this.mFiles = files;
        this.mKeys = keys;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        WallpaperManager wpm = (WallpaperManager)context.getSystemService("wallpaper");
        Display d = wm.getDefaultDisplay();
        Point size = new Point();
        d.getSize(size);
        this.mDesiredMinWidth = Math.min(size.x, size.y);
        this.mDesiredMinHeight = wpm.getDesiredMinimumHeight();
        if (this.mDesiredMinHeight <= 0.0) {
            this.mDesiredMinHeight = size.y;
        }
    }

    @Override
    public void performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
        WallpaperBackupHelper.performBackup_checked(oldState, data, newState, this.mFiles, this.mKeys);
    }

    @Override
    public void restoreEntity(BackupDataInputStream data) {
        String key = data.getKey();
        if (this.isKeyInList(key, this.mKeys)) {
            if (key.equals(WALLPAPER_IMAGE_KEY)) {
                File f = new File(STAGE_FILE);
                if (this.writeFile(f, data)) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile(STAGE_FILE, options);
                }
            } else if (key.equals(WALLPAPER_INFO_KEY)) {
                File f = new File(WALLPAPER_INFO);
                this.writeFile(f, data);
            }
        }
    }

    public void onRestoreFinished() {
        File f = new File(STAGE_FILE);
        if (f.exists()) {
            Slog.d(TAG, "Applying restored wallpaper image.");
            f.renameTo(new File(WALLPAPER_ORIG_IMAGE));
        }
    }
}

