/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.IntDef;
import android.content.ClipData;
import android.content.ComponentName;
import android.net.Uri;
import android.os.BaseBundle;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.Log;
import android.util.TimeUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class JobInfo
implements Parcelable {
    private static String TAG = "JobInfo";
    public static final int NETWORK_TYPE_NONE = 0;
    public static final int NETWORK_TYPE_ANY = 1;
    public static final int NETWORK_TYPE_UNMETERED = 2;
    public static final int NETWORK_TYPE_NOT_ROAMING = 3;
    public static final int NETWORK_TYPE_METERED = 4;
    public static final long DEFAULT_INITIAL_BACKOFF_MILLIS = 30000L;
    public static final long MAX_BACKOFF_DELAY_MILLIS = 18000000L;
    public static final int BACKOFF_POLICY_LINEAR = 0;
    public static final int BACKOFF_POLICY_EXPONENTIAL = 1;
    private static final long MIN_PERIOD_MILLIS = 900000L;
    private static final long MIN_FLEX_MILLIS = 300000L;
    public static final long MIN_BACKOFF_MILLIS = 10000L;
    public static final int DEFAULT_BACKOFF_POLICY = 1;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_SYNC_EXPEDITED = 10;
    public static final int PRIORITY_SYNC_INITIALIZATION = 20;
    public static final int PRIORITY_FOREGROUND_APP = 30;
    public static final int PRIORITY_TOP_APP = 40;
    public static final int PRIORITY_ADJ_OFTEN_RUNNING = -40;
    public static final int PRIORITY_ADJ_ALWAYS_RUNNING = -80;
    public static final int FLAG_WILL_BE_FOREGROUND = 1;
    public static final int CONSTRAINT_FLAG_CHARGING = 1;
    public static final int CONSTRAINT_FLAG_BATTERY_NOT_LOW = 2;
    public static final int CONSTRAINT_FLAG_DEVICE_IDLE = 4;
    public static final int CONSTRAINT_FLAG_STORAGE_NOT_LOW = 8;
    private final int jobId;
    private final PersistableBundle extras;
    private final Bundle transientExtras;
    private final ClipData clipData;
    private final int clipGrantFlags;
    private final ComponentName service;
    private final int constraintFlags;
    private final TriggerContentUri[] triggerContentUris;
    private final long triggerContentUpdateDelay;
    private final long triggerContentMaxDelay;
    private final boolean hasEarlyConstraint;
    private final boolean hasLateConstraint;
    private final int networkType;
    private final long minLatencyMillis;
    private final long maxExecutionDelayMillis;
    private final boolean isPeriodic;
    private final boolean isPersisted;
    private final long intervalMillis;
    private final long flexMillis;
    private final long initialBackoffMillis;
    private final int backoffPolicy;
    private final int priority;
    private final int flags;
    public static final Parcelable.Creator<JobInfo> CREATOR = new Parcelable.Creator<JobInfo>(){

        @Override
        public JobInfo createFromParcel(Parcel in) {
            return new JobInfo(in);
        }

        public JobInfo[] newArray(int size) {
            return new JobInfo[size];
        }
    };

    public static final long getMinPeriodMillis() {
        return 900000L;
    }

    public static final long getMinFlexMillis() {
        return 300000L;
    }

    public static final long getMinBackoffMillis() {
        return 10000L;
    }

    public int getId() {
        return this.jobId;
    }

    public PersistableBundle getExtras() {
        return this.extras;
    }

    public Bundle getTransientExtras() {
        return this.transientExtras;
    }

    public ClipData getClipData() {
        return this.clipData;
    }

    public int getClipGrantFlags() {
        return this.clipGrantFlags;
    }

    public ComponentName getService() {
        return this.service;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isRequireCharging() {
        return (this.constraintFlags & 1) != 0;
    }

    public boolean isRequireBatteryNotLow() {
        return (this.constraintFlags & 2) != 0;
    }

    public boolean isRequireDeviceIdle() {
        return (this.constraintFlags & 4) != 0;
    }

    public boolean isRequireStorageNotLow() {
        return (this.constraintFlags & 8) != 0;
    }

    public int getConstraintFlags() {
        return this.constraintFlags;
    }

    public TriggerContentUri[] getTriggerContentUris() {
        return this.triggerContentUris;
    }

    public long getTriggerContentUpdateDelay() {
        return this.triggerContentUpdateDelay;
    }

    public long getTriggerContentMaxDelay() {
        return this.triggerContentMaxDelay;
    }

    public int getNetworkType() {
        return this.networkType;
    }

    public long getMinLatencyMillis() {
        return this.minLatencyMillis;
    }

    public long getMaxExecutionDelayMillis() {
        return this.maxExecutionDelayMillis;
    }

    public boolean isPeriodic() {
        return this.isPeriodic;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public long getIntervalMillis() {
        long minInterval = JobInfo.getMinPeriodMillis();
        return this.intervalMillis >= minInterval ? this.intervalMillis : minInterval;
    }

    public long getFlexMillis() {
        long interval = this.getIntervalMillis();
        long percentClamp = 5L * interval / 100L;
        long clampedFlex = Math.max(this.flexMillis, Math.max(percentClamp, JobInfo.getMinFlexMillis()));
        return clampedFlex <= interval ? clampedFlex : interval;
    }

    public long getInitialBackoffMillis() {
        long minBackoff = JobInfo.getMinBackoffMillis();
        return this.initialBackoffMillis >= minBackoff ? this.initialBackoffMillis : minBackoff;
    }

    public int getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public boolean hasEarlyConstraint() {
        return this.hasEarlyConstraint;
    }

    public boolean hasLateConstraint() {
        return this.hasLateConstraint;
    }

    private static boolean kindofEqualsBundle(BaseBundle a, BaseBundle b) {
        return a == b || a != null && a.kindofEquals(b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JobInfo)) {
            return false;
        }
        JobInfo j = (JobInfo)o;
        if (this.jobId != j.jobId) {
            return false;
        }
        if (!JobInfo.kindofEqualsBundle(this.extras, j.extras)) {
            return false;
        }
        if (!JobInfo.kindofEqualsBundle(this.transientExtras, j.transientExtras)) {
            return false;
        }
        if (this.clipData != j.clipData) {
            return false;
        }
        if (this.clipGrantFlags != j.clipGrantFlags) {
            return false;
        }
        if (!Objects.equals(this.service, j.service)) {
            return false;
        }
        if (this.constraintFlags != j.constraintFlags) {
            return false;
        }
        if (!Arrays.equals(this.triggerContentUris, j.triggerContentUris)) {
            return false;
        }
        if (this.triggerContentUpdateDelay != j.triggerContentUpdateDelay) {
            return false;
        }
        if (this.triggerContentMaxDelay != j.triggerContentMaxDelay) {
            return false;
        }
        if (this.hasEarlyConstraint != j.hasEarlyConstraint) {
            return false;
        }
        if (this.hasLateConstraint != j.hasLateConstraint) {
            return false;
        }
        if (this.networkType != j.networkType) {
            return false;
        }
        if (this.minLatencyMillis != j.minLatencyMillis) {
            return false;
        }
        if (this.maxExecutionDelayMillis != j.maxExecutionDelayMillis) {
            return false;
        }
        if (this.isPeriodic != j.isPeriodic) {
            return false;
        }
        if (this.isPersisted != j.isPersisted) {
            return false;
        }
        if (this.intervalMillis != j.intervalMillis) {
            return false;
        }
        if (this.flexMillis != j.flexMillis) {
            return false;
        }
        if (this.initialBackoffMillis != j.initialBackoffMillis) {
            return false;
        }
        if (this.backoffPolicy != j.backoffPolicy) {
            return false;
        }
        if (this.priority != j.priority) {
            return false;
        }
        return this.flags == j.flags;
    }

    public int hashCode() {
        int hashCode = this.jobId;
        if (this.extras != null) {
            hashCode = 31 * hashCode + this.extras.hashCode();
        }
        if (this.transientExtras != null) {
            hashCode = 31 * hashCode + this.transientExtras.hashCode();
        }
        if (this.clipData != null) {
            hashCode = 31 * hashCode + this.clipData.hashCode();
        }
        hashCode = 31 * hashCode + this.clipGrantFlags;
        if (this.service != null) {
            hashCode = 31 * hashCode + this.service.hashCode();
        }
        hashCode = 31 * hashCode + this.constraintFlags;
        if (this.triggerContentUris != null) {
            hashCode = 31 * hashCode + Arrays.hashCode(this.triggerContentUris);
        }
        hashCode = 31 * hashCode + Long.hashCode(this.triggerContentUpdateDelay);
        hashCode = 31 * hashCode + Long.hashCode(this.triggerContentMaxDelay);
        hashCode = 31 * hashCode + Boolean.hashCode(this.hasEarlyConstraint);
        hashCode = 31 * hashCode + Boolean.hashCode(this.hasLateConstraint);
        hashCode = 31 * hashCode + this.networkType;
        hashCode = 31 * hashCode + Long.hashCode(this.minLatencyMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.maxExecutionDelayMillis);
        hashCode = 31 * hashCode + Boolean.hashCode(this.isPeriodic);
        hashCode = 31 * hashCode + Boolean.hashCode(this.isPersisted);
        hashCode = 31 * hashCode + Long.hashCode(this.intervalMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.flexMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.initialBackoffMillis);
        hashCode = 31 * hashCode + this.backoffPolicy;
        hashCode = 31 * hashCode + this.priority;
        hashCode = 31 * hashCode + this.flags;
        return hashCode;
    }

    private JobInfo(Parcel in) {
        this.jobId = in.readInt();
        this.extras = in.readPersistableBundle();
        this.transientExtras = in.readBundle();
        if (in.readInt() != 0) {
            this.clipData = ClipData.CREATOR.createFromParcel(in);
            this.clipGrantFlags = in.readInt();
        } else {
            this.clipData = null;
            this.clipGrantFlags = 0;
        }
        this.service = (ComponentName)in.readParcelable(null);
        this.constraintFlags = in.readInt();
        this.triggerContentUris = in.createTypedArray(TriggerContentUri.CREATOR);
        this.triggerContentUpdateDelay = in.readLong();
        this.triggerContentMaxDelay = in.readLong();
        this.networkType = in.readInt();
        this.minLatencyMillis = in.readLong();
        this.maxExecutionDelayMillis = in.readLong();
        this.isPeriodic = in.readInt() == 1;
        this.isPersisted = in.readInt() == 1;
        this.intervalMillis = in.readLong();
        this.flexMillis = in.readLong();
        this.initialBackoffMillis = in.readLong();
        this.backoffPolicy = in.readInt();
        this.hasEarlyConstraint = in.readInt() == 1;
        this.hasLateConstraint = in.readInt() == 1;
        this.priority = in.readInt();
        this.flags = in.readInt();
    }

    private JobInfo(Builder b) {
        this.jobId = b.mJobId;
        this.extras = b.mExtras.deepCopy();
        this.transientExtras = b.mTransientExtras.deepCopy();
        this.clipData = b.mClipData;
        this.clipGrantFlags = b.mClipGrantFlags;
        this.service = b.mJobService;
        this.constraintFlags = b.mConstraintFlags;
        this.triggerContentUris = b.mTriggerContentUris != null ? b.mTriggerContentUris.toArray(new TriggerContentUri[b.mTriggerContentUris.size()]) : null;
        this.triggerContentUpdateDelay = b.mTriggerContentUpdateDelay;
        this.triggerContentMaxDelay = b.mTriggerContentMaxDelay;
        this.networkType = b.mNetworkType;
        this.minLatencyMillis = b.mMinLatencyMillis;
        this.maxExecutionDelayMillis = b.mMaxExecutionDelayMillis;
        this.isPeriodic = b.mIsPeriodic;
        this.isPersisted = b.mIsPersisted;
        this.intervalMillis = b.mIntervalMillis;
        this.flexMillis = b.mFlexMillis;
        this.initialBackoffMillis = b.mInitialBackoffMillis;
        this.backoffPolicy = b.mBackoffPolicy;
        this.hasEarlyConstraint = b.mHasEarlyConstraint;
        this.hasLateConstraint = b.mHasLateConstraint;
        this.priority = b.mPriority;
        this.flags = b.mFlags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.jobId);
        out.writePersistableBundle(this.extras);
        out.writeBundle(this.transientExtras);
        if (this.clipData != null) {
            out.writeInt(1);
            this.clipData.writeToParcel(out, flags);
            out.writeInt(this.clipGrantFlags);
        } else {
            out.writeInt(0);
        }
        out.writeParcelable(this.service, flags);
        out.writeInt(this.constraintFlags);
        out.writeTypedArray(this.triggerContentUris, flags);
        out.writeLong(this.triggerContentUpdateDelay);
        out.writeLong(this.triggerContentMaxDelay);
        out.writeInt(this.networkType);
        out.writeLong(this.minLatencyMillis);
        out.writeLong(this.maxExecutionDelayMillis);
        out.writeInt(this.isPeriodic ? 1 : 0);
        out.writeInt(this.isPersisted ? 1 : 0);
        out.writeLong(this.intervalMillis);
        out.writeLong(this.flexMillis);
        out.writeLong(this.initialBackoffMillis);
        out.writeInt(this.backoffPolicy);
        out.writeInt(this.hasEarlyConstraint ? 1 : 0);
        out.writeInt(this.hasLateConstraint ? 1 : 0);
        out.writeInt(this.priority);
        out.writeInt(this.flags);
    }

    public String toString() {
        return "(job:" + this.jobId + "/" + this.service.flattenToShortString() + ")";
    }

    public static final class Builder {
        private final int mJobId;
        private final ComponentName mJobService;
        private PersistableBundle mExtras = PersistableBundle.EMPTY;
        private Bundle mTransientExtras = Bundle.EMPTY;
        private ClipData mClipData;
        private int mClipGrantFlags;
        private int mPriority = 0;
        private int mFlags;
        private int mConstraintFlags;
        private int mNetworkType;
        private ArrayList<TriggerContentUri> mTriggerContentUris;
        private long mTriggerContentUpdateDelay = -1L;
        private long mTriggerContentMaxDelay = -1L;
        private boolean mIsPersisted;
        private long mMinLatencyMillis;
        private long mMaxExecutionDelayMillis;
        private boolean mIsPeriodic;
        private boolean mHasEarlyConstraint;
        private boolean mHasLateConstraint;
        private long mIntervalMillis;
        private long mFlexMillis;
        private long mInitialBackoffMillis = 30000L;
        private int mBackoffPolicy = 1;
        private boolean mBackoffPolicySet = false;

        public Builder(int jobId, ComponentName jobService) {
            this.mJobService = jobService;
            this.mJobId = jobId;
        }

        public Builder setPriority(int priority) {
            this.mPriority = priority;
            return this;
        }

        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        public Builder setExtras(PersistableBundle extras) {
            this.mExtras = extras;
            return this;
        }

        public Builder setTransientExtras(Bundle extras) {
            this.mTransientExtras = extras;
            return this;
        }

        public Builder setClipData(ClipData clip, int grantFlags) {
            this.mClipData = clip;
            this.mClipGrantFlags = grantFlags;
            return this;
        }

        public Builder setRequiredNetworkType(int networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        public Builder setRequiresCharging(boolean requiresCharging) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFE | (requiresCharging ? 1 : 0);
            return this;
        }

        public Builder setRequiresBatteryNotLow(boolean batteryNotLow) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFD | (batteryNotLow ? 2 : 0);
            return this;
        }

        public Builder setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFB | (requiresDeviceIdle ? 4 : 0);
            return this;
        }

        public Builder setRequiresStorageNotLow(boolean storageNotLow) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFF7 | (storageNotLow ? 8 : 0);
            return this;
        }

        public Builder addTriggerContentUri(TriggerContentUri uri) {
            if (this.mTriggerContentUris == null) {
                this.mTriggerContentUris = new ArrayList();
            }
            this.mTriggerContentUris.add(uri);
            return this;
        }

        public Builder setTriggerContentUpdateDelay(long durationMs) {
            this.mTriggerContentUpdateDelay = durationMs;
            return this;
        }

        public Builder setTriggerContentMaxDelay(long durationMs) {
            this.mTriggerContentMaxDelay = durationMs;
            return this;
        }

        public Builder setPeriodic(long intervalMillis) {
            return this.setPeriodic(intervalMillis, intervalMillis);
        }

        public Builder setPeriodic(long intervalMillis, long flexMillis) {
            this.mIsPeriodic = true;
            this.mIntervalMillis = intervalMillis;
            this.mFlexMillis = flexMillis;
            this.mHasLateConstraint = true;
            this.mHasEarlyConstraint = true;
            return this;
        }

        public Builder setMinimumLatency(long minLatencyMillis) {
            this.mMinLatencyMillis = minLatencyMillis;
            this.mHasEarlyConstraint = true;
            return this;
        }

        public Builder setOverrideDeadline(long maxExecutionDelayMillis) {
            this.mMaxExecutionDelayMillis = maxExecutionDelayMillis;
            this.mHasLateConstraint = true;
            return this;
        }

        public Builder setBackoffCriteria(long initialBackoffMillis, int backoffPolicy) {
            this.mBackoffPolicySet = true;
            this.mInitialBackoffMillis = initialBackoffMillis;
            this.mBackoffPolicy = backoffPolicy;
            return this;
        }

        public Builder setPersisted(boolean isPersisted) {
            this.mIsPersisted = isPersisted;
            return this;
        }

        public JobInfo build() {
            if (!this.mHasEarlyConstraint && !this.mHasLateConstraint && this.mConstraintFlags == 0 && this.mNetworkType == 0 && this.mTriggerContentUris == null) {
                throw new IllegalArgumentException("You're trying to build a job with no constraints, this is not allowed.");
            }
            if (this.mIsPeriodic) {
                if (this.mMaxExecutionDelayMillis != 0L) {
                    throw new IllegalArgumentException("Can't call setOverrideDeadline() on a periodic job.");
                }
                if (this.mMinLatencyMillis != 0L) {
                    throw new IllegalArgumentException("Can't call setMinimumLatency() on a periodic job");
                }
                if (this.mTriggerContentUris != null) {
                    throw new IllegalArgumentException("Can't call addTriggerContentUri() on a periodic job");
                }
            }
            if (this.mIsPersisted) {
                if (this.mTriggerContentUris != null) {
                    throw new IllegalArgumentException("Can't call addTriggerContentUri() on a persisted job");
                }
                if (!this.mTransientExtras.isEmpty()) {
                    throw new IllegalArgumentException("Can't call setTransientExtras() on a persisted job");
                }
                if (this.mClipData != null) {
                    throw new IllegalArgumentException("Can't call setClipData() on a persisted job");
                }
            }
            if (this.mBackoffPolicySet && (this.mConstraintFlags & 4) != 0) {
                throw new IllegalArgumentException("An idle mode job will not respect any back-off policy, so calling setBackoffCriteria with setRequiresDeviceIdle is an error.");
            }
            JobInfo job = new JobInfo(this);
            if (job.isPeriodic()) {
                StringBuilder builder;
                if (job.intervalMillis != job.getIntervalMillis()) {
                    builder = new StringBuilder();
                    builder.append("Specified interval for ").append(String.valueOf(this.mJobId)).append(" is ");
                    TimeUtils.formatDuration(this.mIntervalMillis, builder);
                    builder.append(". Clamped to ");
                    TimeUtils.formatDuration(job.getIntervalMillis(), builder);
                    Log.w(TAG, builder.toString());
                }
                if (job.flexMillis != job.getFlexMillis()) {
                    builder = new StringBuilder();
                    builder.append("Specified flex for ").append(String.valueOf(this.mJobId)).append(" is ");
                    TimeUtils.formatDuration(this.mFlexMillis, builder);
                    builder.append(". Clamped to ");
                    TimeUtils.formatDuration(job.getFlexMillis(), builder);
                    Log.w(TAG, builder.toString());
                }
            }
            return job;
        }
    }

    public static final class TriggerContentUri
    implements Parcelable {
        private final Uri mUri;
        private final int mFlags;
        public static final int FLAG_NOTIFY_FOR_DESCENDANTS = 1;
        public static final Parcelable.Creator<TriggerContentUri> CREATOR = new Parcelable.Creator<TriggerContentUri>(){

            @Override
            public TriggerContentUri createFromParcel(Parcel in) {
                return new TriggerContentUri(in);
            }

            public TriggerContentUri[] newArray(int size) {
                return new TriggerContentUri[size];
            }
        };

        public TriggerContentUri(Uri uri, int flags) {
            this.mUri = uri;
            this.mFlags = flags;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TriggerContentUri)) {
                return false;
            }
            TriggerContentUri t = (TriggerContentUri)o;
            return Objects.equals(t.mUri, this.mUri) && t.mFlags == this.mFlags;
        }

        public int hashCode() {
            return (this.mUri == null ? 0 : this.mUri.hashCode()) ^ this.mFlags;
        }

        private TriggerContentUri(Parcel in) {
            this.mUri = Uri.CREATOR.createFromParcel(in);
            this.mFlags = in.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            this.mUri.writeToParcel(out, flags);
            out.writeInt(this.mFlags);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(flag=true, prefix={"FLAG_"}, value={1L})
        public static @interface Flags {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(prefix={"BACKOFF_POLICY_"}, value={0L, 1L})
    public static @interface BackoffPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(prefix={"NETWORK_TYPE_"}, value={0L, 1L, 2L, 3L, 4L})
    public static @interface NetworkType {
    }
}

