/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.os.Parcel;
import android.os.Parcelable;

public final class AdvertisingSetParameters
implements Parcelable {
    public static final int INTERVAL_HIGH = 1600;
    public static final int INTERVAL_MEDIUM = 400;
    public static final int INTERVAL_LOW = 160;
    public static final int INTERVAL_MIN = 160;
    public static final int INTERVAL_MAX = 0xFFFFFF;
    public static final int TX_POWER_ULTRA_LOW = -21;
    public static final int TX_POWER_LOW = -15;
    public static final int TX_POWER_MEDIUM = -7;
    public static final int TX_POWER_HIGH = 1;
    public static final int TX_POWER_MIN = -127;
    public static final int TX_POWER_MAX = 1;
    private static final int LIMITED_ADVERTISING_MAX_MILLIS = 180000;
    private final boolean isLegacy;
    private final boolean isAnonymous;
    private final boolean includeTxPower;
    private final int primaryPhy;
    private final int secondaryPhy;
    private final boolean connectable;
    private final boolean scannable;
    private final int interval;
    private final int txPowerLevel;
    public static final Parcelable.Creator<AdvertisingSetParameters> CREATOR = new Parcelable.Creator<AdvertisingSetParameters>(){

        public AdvertisingSetParameters[] newArray(int size) {
            return new AdvertisingSetParameters[size];
        }

        @Override
        public AdvertisingSetParameters createFromParcel(Parcel in) {
            return new AdvertisingSetParameters(in);
        }
    };

    private AdvertisingSetParameters(boolean connectable, boolean scannable, boolean isLegacy, boolean isAnonymous, boolean includeTxPower, int primaryPhy, int secondaryPhy, int interval, int txPowerLevel) {
        this.connectable = connectable;
        this.scannable = scannable;
        this.isLegacy = isLegacy;
        this.isAnonymous = isAnonymous;
        this.includeTxPower = includeTxPower;
        this.primaryPhy = primaryPhy;
        this.secondaryPhy = secondaryPhy;
        this.interval = interval;
        this.txPowerLevel = txPowerLevel;
    }

    private AdvertisingSetParameters(Parcel in) {
        this.connectable = in.readInt() != 0;
        this.scannable = in.readInt() != 0;
        this.isLegacy = in.readInt() != 0;
        this.isAnonymous = in.readInt() != 0;
        this.includeTxPower = in.readInt() != 0;
        this.primaryPhy = in.readInt();
        this.secondaryPhy = in.readInt();
        this.interval = in.readInt();
        this.txPowerLevel = in.readInt();
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public boolean isScannable() {
        return this.scannable;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean includeTxPower() {
        return this.includeTxPower;
    }

    public int getPrimaryPhy() {
        return this.primaryPhy;
    }

    public int getSecondaryPhy() {
        return this.secondaryPhy;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getTxPowerLevel() {
        return this.txPowerLevel;
    }

    public String toString() {
        return "AdvertisingSetParameters [connectable=" + this.connectable + ", isLegacy=" + this.isLegacy + ", isAnonymous=" + this.isAnonymous + ", includeTxPower=" + this.includeTxPower + ", primaryPhy=" + this.primaryPhy + ", secondaryPhy=" + this.secondaryPhy + ", interval=" + this.interval + ", txPowerLevel=" + this.txPowerLevel + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.connectable ? 1 : 0);
        dest.writeInt(this.scannable ? 1 : 0);
        dest.writeInt(this.isLegacy ? 1 : 0);
        dest.writeInt(this.isAnonymous ? 1 : 0);
        dest.writeInt(this.includeTxPower ? 1 : 0);
        dest.writeInt(this.primaryPhy);
        dest.writeInt(this.secondaryPhy);
        dest.writeInt(this.interval);
        dest.writeInt(this.txPowerLevel);
    }

    public static final class Builder {
        private boolean connectable = false;
        private boolean scannable = false;
        private boolean isLegacy = false;
        private boolean isAnonymous = false;
        private boolean includeTxPower = false;
        private int primaryPhy = 1;
        private int secondaryPhy = 1;
        private int interval = 160;
        private int txPowerLevel = -7;

        public Builder setConnectable(boolean connectable) {
            this.connectable = connectable;
            return this;
        }

        public Builder setScannable(boolean scannable) {
            this.scannable = scannable;
            return this;
        }

        public Builder setLegacyMode(boolean isLegacy) {
            this.isLegacy = isLegacy;
            return this;
        }

        public Builder setAnonymous(boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        public Builder setIncludeTxPower(boolean includeTxPower) {
            this.includeTxPower = includeTxPower;
            return this;
        }

        public Builder setPrimaryPhy(int primaryPhy) {
            if (primaryPhy != 1 && primaryPhy != 3) {
                throw new IllegalArgumentException("bad primaryPhy " + primaryPhy);
            }
            this.primaryPhy = primaryPhy;
            return this;
        }

        public Builder setSecondaryPhy(int secondaryPhy) {
            if (secondaryPhy != 1 && secondaryPhy != 2 && secondaryPhy != 3) {
                throw new IllegalArgumentException("bad secondaryPhy " + secondaryPhy);
            }
            this.secondaryPhy = secondaryPhy;
            return this;
        }

        public Builder setInterval(int interval) {
            if (interval < 160 || interval > 0xFFFFFF) {
                throw new IllegalArgumentException("unknown interval " + interval);
            }
            this.interval = interval;
            return this;
        }

        public Builder setTxPowerLevel(int txPowerLevel) {
            if (txPowerLevel < -127 || txPowerLevel > 1) {
                throw new IllegalArgumentException("unknown txPowerLevel " + txPowerLevel);
            }
            this.txPowerLevel = txPowerLevel;
            return this;
        }

        public AdvertisingSetParameters build() {
            if (this.isLegacy) {
                if (this.isAnonymous) {
                    throw new IllegalArgumentException("Legacy advertising can't be anonymous");
                }
                if (this.connectable && !this.scannable) {
                    throw new IllegalStateException("Legacy advertisement can't be connectable and non-scannable");
                }
                if (this.includeTxPower) {
                    throw new IllegalStateException("Legacy advertising can't include TX power level in header");
                }
            } else {
                if (this.connectable && this.scannable) {
                    throw new IllegalStateException("Advertising can't be both connectable and scannable");
                }
                if (this.isAnonymous && this.connectable) {
                    throw new IllegalStateException("Advertising can't be both connectable and anonymous");
                }
            }
            return new AdvertisingSetParameters(this.connectable, this.scannable, this.isLegacy, this.isAnonymous, this.includeTxPower, this.primaryPhy, this.secondaryPhy, this.interval, this.txPowerLevel);
        }
    }
}

