/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

abstract class BaseParceledListSlice<T>
implements Parcelable {
    private static String TAG = "ParceledListSlice";
    private static boolean DEBUG = false;
    private static final int MAX_IPC_SIZE = 65536;
    private final List<T> mList;
    private int mInlineCountLimit = Integer.MAX_VALUE;

    public BaseParceledListSlice(List<T> list) {
        this.mList = list;
    }

    BaseParceledListSlice(Parcel p, ClassLoader loader) {
        int i;
        int N = p.readInt();
        this.mList = new ArrayList<T>(N);
        if (DEBUG) {
            Log.d(TAG, "Retrieving " + N + " items");
        }
        if (N <= 0) {
            return;
        }
        Parcelable.Creator<?> creator = this.readParcelableCreator(p, loader);
        Class<?> listElementClass = null;
        for (i = 0; i < N && p.readInt() != 0; ++i) {
            T parcelable = this.readCreator(creator, p, loader);
            if (listElementClass == null) {
                listElementClass = parcelable.getClass();
            } else {
                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
            }
            this.mList.add(parcelable);
            if (!DEBUG) continue;
            Log.d(TAG, "Read inline #" + i + ": " + this.mList.get(this.mList.size() - 1));
        }
        if (i >= N) {
            return;
        }
        IBinder retriever = p.readStrongBinder();
        while (i < N) {
            if (DEBUG) {
                Log.d(TAG, "Reading more @" + i + " of " + N + ": retriever=" + retriever);
            }
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            data.writeInt(i);
            try {
                retriever.transact(1, data, reply, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failure retrieving array; only received " + i + " of " + N, e);
                return;
            }
            while (i < N && reply.readInt() != 0) {
                Object parcelable = reply.readCreator(creator, loader);
                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.mList.add(parcelable);
                if (DEBUG) {
                    Log.d(TAG, "Read extra #" + i + ": " + this.mList.get(this.mList.size() - 1));
                }
                ++i;
            }
            reply.recycle();
            data.recycle();
        }
    }

    private T readCreator(Parcelable.Creator<?> creator, Parcel p, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return classLoaderCreator.createFromParcel(p, loader);
        }
        return (T)creator.createFromParcel(p);
    }

    private static void verifySameType(Class<?> expected, Class<?> actual) {
        if (!actual.equals(expected)) {
            throw new IllegalArgumentException("Can't unparcel type " + actual.getName() + " in list of type " + expected.getName());
        }
    }

    public List<T> getList() {
        return this.mList;
    }

    public void setInlineCountLimit(int maxCount) {
        this.mInlineCountLimit = maxCount;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        final int N = this.mList.size();
        final int callFlags = flags;
        dest.writeInt(N);
        if (DEBUG) {
            Log.d(TAG, "Writing " + N + " items");
        }
        if (N > 0) {
            int i;
            final Class<?> listElementClass = this.mList.get(0).getClass();
            this.writeParcelableCreator(this.mList.get(0), dest);
            for (i = 0; i < N && i < this.mInlineCountLimit && dest.dataSize() < 65536; ++i) {
                dest.writeInt(1);
                T parcelable = this.mList.get(i);
                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.writeElement(parcelable, dest, callFlags);
                if (!DEBUG) continue;
                Log.d(TAG, "Wrote inline #" + i + ": " + this.mList.get(i));
            }
            if (i < N) {
                dest.writeInt(0);
                Binder retriever = new Binder(){

                    @Override
                    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                        if (code != 1) {
                            return super.onTransact(code, data, reply, flags);
                        }
                        int i = data.readInt();
                        if (DEBUG) {
                            Log.d(TAG, "Writing more @" + i + " of " + N);
                        }
                        while (i < N && reply.dataSize() < 65536) {
                            reply.writeInt(1);
                            Object parcelable = BaseParceledListSlice.this.mList.get(i);
                            BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                            BaseParceledListSlice.this.writeElement(parcelable, reply, callFlags);
                            if (DEBUG) {
                                Log.d(TAG, "Wrote extra #" + i + ": " + BaseParceledListSlice.this.mList.get(i));
                            }
                            ++i;
                        }
                        if (i < N) {
                            if (DEBUG) {
                                Log.d(TAG, "Breaking @" + i + " of " + N);
                            }
                            reply.writeInt(0);
                        }
                        return true;
                    }
                };
                if (DEBUG) {
                    Log.d(TAG, "Breaking @" + i + " of " + N + ": retriever=" + retriever);
                }
                dest.writeStrongBinder(retriever);
            }
        }
    }

    protected abstract void writeElement(T var1, Parcel var2, int var3);

    protected abstract void writeParcelableCreator(T var1, Parcel var2);

    protected abstract Parcelable.Creator<?> readParcelableCreator(Parcel var1, ClassLoader var2);
}

