/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.OrientedBoundingBox;
import android.graphics.RectF;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public final class GestureUtils {
    private static final float SCALING_THRESHOLD = 0.26f;
    private static final float NONUNIFORM_SCALE = (float)Math.sqrt(2.0);

    private GestureUtils() {
    }

    static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Log.e("Gestures", "Could not close stream", e);
            }
        }
    }

    public static float[] spatialSampling(Gesture gesture, int bitmapSize) {
        return GestureUtils.spatialSampling(gesture, bitmapSize, false);
    }

    public static float[] spatialSampling(Gesture gesture, int bitmapSize, boolean keepAspectRatio) {
        float targetPatchSize = bitmapSize - 1;
        float[] sample = new float[bitmapSize * bitmapSize];
        Arrays.fill(sample, 0.0f);
        RectF rect = gesture.getBoundingBox();
        float gestureWidth = rect.width();
        float gestureHeight = rect.height();
        float sx = targetPatchSize / gestureWidth;
        float sy = targetPatchSize / gestureHeight;
        if (keepAspectRatio) {
            float scale;
            sx = scale = sx < sy ? sx : sy;
            sy = scale;
        } else {
            float scale;
            float aspectRatio = gestureWidth / gestureHeight;
            if (aspectRatio > 1.0f) {
                aspectRatio = 1.0f / aspectRatio;
            }
            if (aspectRatio < 0.26f) {
                sx = scale = sx < sy ? sx : sy;
                sy = scale;
            } else if (sx > sy) {
                scale = sy * NONUNIFORM_SCALE;
                if (scale < sx) {
                    sx = scale;
                }
            } else {
                scale = sx * NONUNIFORM_SCALE;
                if (scale < sy) {
                    sy = scale;
                }
            }
        }
        float preDx = -rect.centerX();
        float preDy = -rect.centerY();
        float postDx = targetPatchSize / 2.0f;
        float postDy = targetPatchSize / 2.0f;
        ArrayList<GestureStroke> strokes = gesture.getStrokes();
        int count = strokes.size();
        for (int index = 0; index < count; ++index) {
            GestureStroke stroke = strokes.get(index);
            float[] strokepoints = stroke.points;
            int size = strokepoints.length;
            float[] pts = new float[size];
            for (int i = 0; i < size; i += 2) {
                pts[i] = (strokepoints[i] + preDx) * sx + postDx;
                pts[i + 1] = (strokepoints[i + 1] + preDy) * sy + postDy;
            }
            float segmentEndX = -1.0f;
            float segmentEndY = -1.0f;
            for (int i = 0; i < size; i += 2) {
                float segmentStartY;
                float segmentStartX = pts[i] < 0.0f ? 0.0f : pts[i];
                float f = segmentStartY = pts[i + 1] < 0.0f ? 0.0f : pts[i + 1];
                if (segmentStartX > targetPatchSize) {
                    segmentStartX = targetPatchSize;
                }
                if (segmentStartY > targetPatchSize) {
                    segmentStartY = targetPatchSize;
                }
                GestureUtils.plot(segmentStartX, segmentStartY, sample, bitmapSize);
                if (segmentEndX != -1.0f) {
                    float invertSlope;
                    float ypos;
                    float xpos;
                    float slope;
                    if (segmentEndX > segmentStartX) {
                        slope = (segmentEndY - segmentStartY) / (segmentEndX - segmentStartX);
                        for (xpos = (float)Math.ceil(segmentStartX); xpos < segmentEndX; xpos += 1.0f) {
                            ypos = slope * (xpos - segmentStartX) + segmentStartY;
                            GestureUtils.plot(xpos, ypos, sample, bitmapSize);
                        }
                    } else if (segmentEndX < segmentStartX) {
                        slope = (segmentEndY - segmentStartY) / (segmentEndX - segmentStartX);
                        for (xpos = (float)Math.ceil(segmentEndX); xpos < segmentStartX; xpos += 1.0f) {
                            ypos = slope * (xpos - segmentStartX) + segmentStartY;
                            GestureUtils.plot(xpos, ypos, sample, bitmapSize);
                        }
                    }
                    if (segmentEndY > segmentStartY) {
                        invertSlope = (segmentEndX - segmentStartX) / (segmentEndY - segmentStartY);
                        for (ypos = (float)Math.ceil(segmentStartY); ypos < segmentEndY; ypos += 1.0f) {
                            xpos = invertSlope * (ypos - segmentStartY) + segmentStartX;
                            GestureUtils.plot(xpos, ypos, sample, bitmapSize);
                        }
                    } else if (segmentEndY < segmentStartY) {
                        invertSlope = (segmentEndX - segmentStartX) / (segmentEndY - segmentStartY);
                        for (ypos = (float)Math.ceil(segmentEndY); ypos < segmentStartY; ypos += 1.0f) {
                            xpos = invertSlope * (ypos - segmentStartY) + segmentStartX;
                            GestureUtils.plot(xpos, ypos, sample, bitmapSize);
                        }
                    }
                }
                segmentEndX = segmentStartX;
                segmentEndY = segmentStartY;
            }
        }
        return sample;
    }

    private static void plot(float x, float y, float[] sample, int sampleSize) {
        x = x < 0.0f ? 0.0f : x;
        y = y < 0.0f ? 0.0f : y;
        int xFloor = (int)Math.floor(x);
        int xCeiling = (int)Math.ceil(x);
        int yFloor = (int)Math.floor(y);
        int yCeiling = (int)Math.ceil(y);
        if (x == (float)xFloor && y == (float)yFloor) {
            int index = yCeiling * sampleSize + xCeiling;
            if (sample[index] < 1.0f) {
                sample[index] = 1.0f;
            }
        } else {
            int index;
            float btmRight;
            float btmLeft;
            float topRight;
            float sum;
            double xFloorSq = Math.pow((float)xFloor - x, 2.0);
            double yFloorSq = Math.pow((float)yFloor - y, 2.0);
            double xCeilingSq = Math.pow((float)xCeiling - x, 2.0);
            double yCeilingSq = Math.pow((float)yCeiling - y, 2.0);
            float topLeft = (float)Math.sqrt(xFloorSq + yFloorSq);
            float value = topLeft / (sum = topLeft + (topRight = (float)Math.sqrt(xCeilingSq + yFloorSq)) + (btmLeft = (float)Math.sqrt(xFloorSq + yCeilingSq)) + (btmRight = (float)Math.sqrt(xCeilingSq + yCeilingSq)));
            if (value > sample[index = yFloor * sampleSize + xFloor]) {
                sample[index] = value;
            }
            if ((value = topRight / sum) > sample[index = yFloor * sampleSize + xCeiling]) {
                sample[index] = value;
            }
            if ((value = btmLeft / sum) > sample[index = yCeiling * sampleSize + xFloor]) {
                sample[index] = value;
            }
            if ((value = btmRight / sum) > sample[index = yCeiling * sampleSize + xCeiling]) {
                sample[index] = value;
            }
        }
    }

    public static float[] temporalSampling(GestureStroke stroke, int numPoints) {
        float increment = stroke.length / (float)(numPoints - 1);
        int vectorLength = numPoints * 2;
        float[] vector = new float[vectorLength];
        float distanceSoFar = 0.0f;
        float[] pts = stroke.points;
        float lstPointX = pts[0];
        float lstPointY = pts[1];
        int index = 0;
        float currentPointX = Float.MIN_VALUE;
        float currentPointY = Float.MIN_VALUE;
        vector[index] = lstPointX;
        vector[++index] = lstPointY;
        ++index;
        int i = 0;
        int count = pts.length / 2;
        while (i < count) {
            float deltaY;
            float deltaX;
            float distance;
            if (currentPointX == Float.MIN_VALUE) {
                if (++i >= count) break;
                currentPointX = pts[i * 2];
                currentPointY = pts[i * 2 + 1];
            }
            if (distanceSoFar + (distance = (float)Math.hypot(deltaX = currentPointX - lstPointX, deltaY = currentPointY - lstPointY)) >= increment) {
                float ratio = (increment - distanceSoFar) / distance;
                float nx = lstPointX + ratio * deltaX;
                float ny = lstPointY + ratio * deltaY;
                vector[index] = nx;
                vector[++index] = ny;
                ++index;
                lstPointX = nx;
                lstPointY = ny;
                distanceSoFar = 0.0f;
                continue;
            }
            lstPointX = currentPointX;
            lstPointY = currentPointY;
            currentPointX = Float.MIN_VALUE;
            currentPointY = Float.MIN_VALUE;
            distanceSoFar += distance;
        }
        for (i = index; i < vectorLength; i += 2) {
            vector[i] = lstPointX;
            vector[i + 1] = lstPointY;
        }
        return vector;
    }

    static float[] computeCentroid(float[] points) {
        float centerX = 0.0f;
        float centerY = 0.0f;
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            centerX += points[i];
            centerY += points[++i];
        }
        float[] center = new float[]{2.0f * centerX / (float)count, 2.0f * centerY / (float)count};
        return center;
    }

    private static float[][] computeCoVariance(float[] points) {
        float[][] array2 = new float[2][2];
        array2[0][0] = 0.0f;
        array2[0][1] = 0.0f;
        array2[1][0] = 0.0f;
        array2[1][1] = 0.0f;
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            float x = points[i];
            float y = points[++i];
            float[] fArray = array2[0];
            fArray[0] = fArray[0] + x * x;
            float[] fArray2 = array2[0];
            fArray2[1] = fArray2[1] + x * y;
            array2[1][0] = array2[0][1];
            float[] fArray3 = array2[1];
            fArray3[1] = fArray3[1] + y * y;
        }
        float[] fArray = array2[0];
        fArray[0] = fArray[0] / (float)(count / 2);
        float[] fArray4 = array2[0];
        fArray4[1] = fArray4[1] / (float)(count / 2);
        float[] fArray5 = array2[1];
        fArray5[0] = fArray5[0] / (float)(count / 2);
        float[] fArray6 = array2[1];
        fArray6[1] = fArray6[1] / (float)(count / 2);
        return array2;
    }

    static float computeTotalLength(float[] points) {
        float sum = 0.0f;
        int count = points.length - 4;
        for (int i = 0; i < count; i += 2) {
            float dx = points[i + 2] - points[i];
            float dy = points[i + 3] - points[i + 1];
            sum = (float)((double)sum + Math.hypot(dx, dy));
        }
        return sum;
    }

    static float computeStraightness(float[] points) {
        float totalLen = GestureUtils.computeTotalLength(points);
        float dx = points[2] - points[0];
        float dy = points[3] - points[1];
        return (float)Math.hypot(dx, dy) / totalLen;
    }

    static float computeStraightness(float[] points, float totalLen) {
        float dx = points[2] - points[0];
        float dy = points[3] - points[1];
        return (float)Math.hypot(dx, dy) / totalLen;
    }

    static float squaredEuclideanDistance(float[] vector1, float[] vector2) {
        float squaredDistance = 0.0f;
        int size = vector1.length;
        for (int i = 0; i < size; ++i) {
            float difference = vector1[i] - vector2[i];
            squaredDistance += difference * difference;
        }
        return squaredDistance / (float)size;
    }

    static float cosineDistance(float[] vector1, float[] vector2) {
        float sum = 0.0f;
        int len = vector1.length;
        for (int i = 0; i < len; ++i) {
            sum += vector1[i] * vector2[i];
        }
        return (float)Math.acos(sum);
    }

    static float minimumCosineDistance(float[] vector1, float[] vector2, int numOrientations) {
        int len = vector1.length;
        float a = 0.0f;
        float b = 0.0f;
        for (int i = 0; i < len; i += 2) {
            a += vector1[i] * vector2[i] + vector1[i + 1] * vector2[i + 1];
            b += vector1[i] * vector2[i + 1] - vector1[i + 1] * vector2[i];
        }
        if (a != 0.0f) {
            float tan = b / a;
            double angle = Math.atan(tan);
            if (numOrientations > 2 && Math.abs(angle) >= Math.PI / (double)numOrientations) {
                return (float)Math.acos(a);
            }
            double cosine = Math.cos(angle);
            double sine = cosine * (double)tan;
            return (float)Math.acos((double)a * cosine + (double)b * sine);
        }
        return 1.5707964f;
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(ArrayList<GesturePoint> originalPoints) {
        int count = originalPoints.size();
        float[] points = new float[count * 2];
        for (int i = 0; i < count; ++i) {
            GesturePoint point = originalPoints.get(i);
            int index = i * 2;
            points[index] = point.x;
            points[index + 1] = point.y;
        }
        float[] meanVector = GestureUtils.computeCentroid(points);
        return GestureUtils.computeOrientedBoundingBox(points, meanVector);
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(float[] originalPoints) {
        int size = originalPoints.length;
        float[] points = new float[size];
        for (int i = 0; i < size; ++i) {
            points[i] = originalPoints[i];
        }
        float[] meanVector = GestureUtils.computeCentroid(points);
        return GestureUtils.computeOrientedBoundingBox(points, meanVector);
    }

    private static OrientedBoundingBox computeOrientedBoundingBox(float[] points, float[] centroid) {
        float angle;
        GestureUtils.translate(points, -centroid[0], -centroid[1]);
        float[][] array2 = GestureUtils.computeCoVariance(points);
        float[] targetVector = GestureUtils.computeOrientation(array2);
        if (targetVector[0] == 0.0f && targetVector[1] == 0.0f) {
            angle = -1.5707964f;
        } else {
            angle = (float)Math.atan2(targetVector[1], targetVector[0]);
            GestureUtils.rotate(points, -angle);
        }
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float maxx = Float.MIN_VALUE;
        float maxy = Float.MIN_VALUE;
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            if (points[i] < minx) {
                minx = points[i];
            }
            if (points[i] > maxx) {
                maxx = points[i];
            }
            if (points[++i] < miny) {
                miny = points[i];
            }
            if (!(points[i] > maxy)) continue;
            maxy = points[i];
        }
        return new OrientedBoundingBox((float)((double)(angle * 180.0f) / Math.PI), centroid[0], centroid[1], maxx - minx, maxy - miny);
    }

    private static float[] computeOrientation(float[][] covarianceMatrix) {
        float lambda2;
        float[] targetVector = new float[2];
        if (covarianceMatrix[0][1] == 0.0f || covarianceMatrix[1][0] == 0.0f) {
            targetVector[0] = 1.0f;
            targetVector[1] = 0.0f;
        }
        float a = -covarianceMatrix[0][0] - covarianceMatrix[1][1];
        float b = covarianceMatrix[0][0] * covarianceMatrix[1][1] - covarianceMatrix[0][1] * covarianceMatrix[1][0];
        float value = a / 2.0f;
        float rightside = (float)Math.sqrt(Math.pow(value, 2.0) - (double)b);
        float lambda1 = -value + rightside;
        if (lambda1 == (lambda2 = -value - rightside)) {
            targetVector[0] = 0.0f;
            targetVector[1] = 0.0f;
        } else {
            float lambda = lambda1 > lambda2 ? lambda1 : lambda2;
            targetVector[0] = 1.0f;
            targetVector[1] = (lambda - covarianceMatrix[0][0]) / covarianceMatrix[0][1];
        }
        return targetVector;
    }

    static float[] rotate(float[] points, float angle) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        int size = points.length;
        for (int i = 0; i < size; i += 2) {
            float x = points[i] * cos - points[i + 1] * sin;
            float y = points[i] * sin + points[i + 1] * cos;
            points[i] = x;
            points[i + 1] = y;
        }
        return points;
    }

    static float[] translate(float[] points, float dx, float dy) {
        int size = points.length;
        for (int i = 0; i < size; i += 2) {
            int n = i;
            points[n] = points[n] + dx;
            int n2 = i + 1;
            points[n2] = points[n2] + dy;
        }
        return points;
    }

    static float[] scale(float[] points, float sx, float sy) {
        int size = points.length;
        for (int i = 0; i < size; i += 2) {
            int n = i;
            points[n] = points[n] * sx;
            int n2 = i + 1;
            points[n2] = points[n2] * sy;
        }
        return points;
    }
}

