/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.fonts.FontVariationAxis;
import android.os.LocaleList;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.internal.annotations.GuardedBy;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import libcore.util.NativeAllocationRegistry;

public class Paint {
    private long mNativePaint;
    private long mNativeShader;
    private long mNativeColorFilter;
    private static final long NATIVE_PAINT_SIZE = 98L;
    public long mNativeTypeface;
    private ColorFilter mColorFilter;
    private MaskFilter mMaskFilter;
    private PathEffect mPathEffect;
    private Shader mShader;
    private Typeface mTypeface;
    private Xfermode mXfermode;
    private boolean mHasCompatScaling;
    private float mCompatScaling;
    private float mInvCompatScaling;
    private LocaleList mLocales;
    private String mFontFeatureSettings;
    private String mFontVariationSettings;
    private static final Object sCacheLock = new Object();
    @GuardedBy(value="sCacheLock")
    private static final HashMap<String, Integer> sMinikinLangListIdCache = new HashMap();
    public int mBidiFlags = 2;
    static final Style[] sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
    static final Cap[] sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
    static final Join[] sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
    static final Align[] sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int DITHER_FLAG = 4;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    public static final int LCD_RENDER_TEXT_FLAG = 512;
    public static final int EMBEDDED_BITMAP_TEXT_FLAG = 1024;
    public static final int AUTO_HINTING_TEXT_FLAG = 2048;
    public static final int VERTICAL_TEXT_FLAG = 4096;
    static final int HIDDEN_DEFAULT_PAINT_FLAGS = 1280;
    public static final int HINTING_OFF = 0;
    public static final int HINTING_ON = 1;
    public static final int BIDI_LTR = 0;
    public static final int BIDI_RTL = 1;
    public static final int BIDI_DEFAULT_LTR = 2;
    public static final int BIDI_DEFAULT_RTL = 3;
    public static final int BIDI_FORCE_LTR = 4;
    public static final int BIDI_FORCE_RTL = 5;
    private static final int BIDI_MAX_FLAG_VALUE = 5;
    private static final int BIDI_FLAG_MASK = 7;
    public static final int DIRECTION_LTR = 0;
    public static final int DIRECTION_RTL = 1;
    public static final int CURSOR_AFTER = 0;
    public static final int CURSOR_AT_OR_AFTER = 1;
    public static final int CURSOR_BEFORE = 2;
    public static final int CURSOR_AT_OR_BEFORE = 3;
    public static final int CURSOR_AT = 4;
    private static final int CURSOR_OPT_MAX_VALUE = 4;
    public static final int HYPHENEDIT_MASK_END_OF_LINE = 7;
    public static final int HYPHENEDIT_MASK_START_OF_LINE = 24;

    public Paint() {
        this(0);
    }

    public Paint(int flags) {
        this.mNativePaint = Paint.nInit();
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativePaint);
        this.setFlags(flags | 0x500);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
        this.setTextLocales(LocaleList.getAdjustedDefault());
    }

    public Paint(Paint paint) {
        this.mNativePaint = Paint.nInitWithPaint(paint.getNativeInstance());
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativePaint);
        this.setClassVariablesFrom(paint);
    }

    public void reset() {
        Paint.nReset(this.mNativePaint);
        this.setFlags(1280);
        this.mColorFilter = null;
        this.mMaskFilter = null;
        this.mPathEffect = null;
        this.mShader = null;
        this.mNativeShader = 0L;
        this.mTypeface = null;
        this.mNativeTypeface = 0L;
        this.mXfermode = null;
        this.mHasCompatScaling = false;
        this.mCompatScaling = 1.0f;
        this.mInvCompatScaling = 1.0f;
        this.mBidiFlags = 2;
        this.setTextLocales(LocaleList.getAdjustedDefault());
        this.setElegantTextHeight(false);
        this.mFontFeatureSettings = null;
        this.mFontVariationSettings = null;
    }

    public void set(Paint src) {
        if (this != src) {
            Paint.nSet(this.mNativePaint, src.mNativePaint);
            this.setClassVariablesFrom(src);
        }
    }

    private void setClassVariablesFrom(Paint paint) {
        this.mColorFilter = paint.mColorFilter;
        this.mMaskFilter = paint.mMaskFilter;
        this.mPathEffect = paint.mPathEffect;
        this.mShader = paint.mShader;
        this.mNativeShader = paint.mNativeShader;
        this.mTypeface = paint.mTypeface;
        this.mNativeTypeface = paint.mNativeTypeface;
        this.mXfermode = paint.mXfermode;
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
        this.mBidiFlags = paint.mBidiFlags;
        this.mLocales = paint.mLocales;
        this.mFontFeatureSettings = paint.mFontFeatureSettings;
        this.mFontVariationSettings = paint.mFontVariationSettings;
    }

    public void setCompatibilityScaling(float factor) {
        if ((double)factor == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
        } else {
            this.mHasCompatScaling = true;
            this.mCompatScaling = factor;
            this.mInvCompatScaling = 1.0f / factor;
        }
    }

    public long getNativeInstance() {
        long newNativeColorFilter;
        long newNativeShader;
        long l = newNativeShader = this.mShader == null ? 0L : this.mShader.getNativeInstance();
        if (newNativeShader != this.mNativeShader) {
            this.mNativeShader = newNativeShader;
            Paint.nSetShader(this.mNativePaint, this.mNativeShader);
        }
        long l2 = newNativeColorFilter = this.mColorFilter == null ? 0L : this.mColorFilter.getNativeInstance();
        if (newNativeColorFilter != this.mNativeColorFilter) {
            this.mNativeColorFilter = newNativeColorFilter;
            Paint.nSetColorFilter(this.mNativePaint, this.mNativeColorFilter);
        }
        return this.mNativePaint;
    }

    public int getBidiFlags() {
        return this.mBidiFlags;
    }

    public void setBidiFlags(int flags) {
        if ((flags &= 7) > 5) {
            throw new IllegalArgumentException("unknown bidi flag: " + flags);
        }
        this.mBidiFlags = flags;
    }

    public int getFlags() {
        return Paint.nGetFlags(this.mNativePaint);
    }

    public void setFlags(int flags) {
        Paint.nSetFlags(this.mNativePaint, flags);
    }

    public int getHinting() {
        return Paint.nGetHinting(this.mNativePaint);
    }

    public void setHinting(int mode) {
        Paint.nSetHinting(this.mNativePaint, mode);
    }

    public final boolean isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    public void setAntiAlias(boolean aa) {
        Paint.nSetAntiAlias(this.mNativePaint, aa);
    }

    public final boolean isDither() {
        return (this.getFlags() & 4) != 0;
    }

    public void setDither(boolean dither) {
        Paint.nSetDither(this.mNativePaint, dither);
    }

    public final boolean isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    public void setLinearText(boolean linearText) {
        Paint.nSetLinearText(this.mNativePaint, linearText);
    }

    public final boolean isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    public void setSubpixelText(boolean subpixelText) {
        Paint.nSetSubpixelText(this.mNativePaint, subpixelText);
    }

    public final boolean isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    public void setUnderlineText(boolean underlineText) {
        Paint.nSetUnderlineText(this.mNativePaint, underlineText);
    }

    public final boolean isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    public void setStrikeThruText(boolean strikeThruText) {
        Paint.nSetStrikeThruText(this.mNativePaint, strikeThruText);
    }

    public final boolean isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setFakeBoldText(boolean fakeBoldText) {
        Paint.nSetFakeBoldText(this.mNativePaint, fakeBoldText);
    }

    public final boolean isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    public void setFilterBitmap(boolean filter) {
        Paint.nSetFilterBitmap(this.mNativePaint, filter);
    }

    public Style getStyle() {
        return sStyleArray[Paint.nGetStyle(this.mNativePaint)];
    }

    public void setStyle(Style style2) {
        Paint.nSetStyle(this.mNativePaint, style2.nativeInt);
    }

    public int getColor() {
        return Paint.nGetColor(this.mNativePaint);
    }

    public void setColor(int color2) {
        Paint.nSetColor(this.mNativePaint, color2);
    }

    public int getAlpha() {
        return Paint.nGetAlpha(this.mNativePaint);
    }

    public void setAlpha(int a) {
        Paint.nSetAlpha(this.mNativePaint, a);
    }

    public void setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    public float getStrokeWidth() {
        return Paint.nGetStrokeWidth(this.mNativePaint);
    }

    public void setStrokeWidth(float width) {
        Paint.nSetStrokeWidth(this.mNativePaint, width);
    }

    public float getStrokeMiter() {
        return Paint.nGetStrokeMiter(this.mNativePaint);
    }

    public void setStrokeMiter(float miter) {
        Paint.nSetStrokeMiter(this.mNativePaint, miter);
    }

    public Cap getStrokeCap() {
        return sCapArray[Paint.nGetStrokeCap(this.mNativePaint)];
    }

    public void setStrokeCap(Cap cap) {
        Paint.nSetStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    public Join getStrokeJoin() {
        return sJoinArray[Paint.nGetStrokeJoin(this.mNativePaint)];
    }

    public void setStrokeJoin(Join join) {
        Paint.nSetStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    public boolean getFillPath(Path src, Path dst) {
        return Paint.nGetFillPath(this.mNativePaint, src.readOnlyNI(), dst.mutateNI());
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Shader setShader(Shader shader) {
        if (this.mShader != shader) {
            this.mNativeShader = -1L;
            Paint.nSetShader(this.mNativePaint, 0L);
        }
        this.mShader = shader;
        return shader;
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public ColorFilter setColorFilter(ColorFilter filter) {
        if (this.mColorFilter != filter) {
            this.mNativeColorFilter = -1L;
        }
        this.mColorFilter = filter;
        return filter;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        int curMode;
        int newMode = xfermode != null ? xfermode.porterDuffMode : Xfermode.DEFAULT;
        int n = curMode = this.mXfermode != null ? this.mXfermode.porterDuffMode : Xfermode.DEFAULT;
        if (newMode != curMode) {
            Paint.nSetXfermode(this.mNativePaint, newMode);
        }
        this.mXfermode = xfermode;
        return xfermode;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public PathEffect setPathEffect(PathEffect effect) {
        long effectNative = 0L;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        Paint.nSetPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public MaskFilter setMaskFilter(MaskFilter maskfilter) {
        long maskfilterNative = 0L;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        Paint.nSetMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Typeface setTypeface(Typeface typeface) {
        long typefaceNative = 0L;
        if (typeface != null) {
            typefaceNative = typeface.native_instance;
        }
        Paint.nSetTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        this.mNativeTypeface = typefaceNative;
        return typeface;
    }

    @Deprecated
    public Rasterizer getRasterizer() {
        return null;
    }

    @Deprecated
    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        return rasterizer;
    }

    public void setShadowLayer(float radius, float dx, float dy, int shadowColor) {
        Paint.nSetShadowLayer(this.mNativePaint, radius, dx, dy, shadowColor);
    }

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public boolean hasShadowLayer() {
        return Paint.nHasShadowLayer(this.mNativePaint);
    }

    public Align getTextAlign() {
        return sAlignArray[Paint.nGetTextAlign(this.mNativePaint)];
    }

    public void setTextAlign(Align align) {
        Paint.nSetTextAlign(this.mNativePaint, align.nativeInt);
    }

    public Locale getTextLocale() {
        return this.mLocales.get(0);
    }

    public LocaleList getTextLocales() {
        return this.mLocales;
    }

    public void setTextLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        if (this.mLocales != null && this.mLocales.size() == 1 && locale.equals(this.mLocales.get(0))) {
            return;
        }
        this.mLocales = new LocaleList(locale);
        this.syncTextLocalesWithMinikin();
    }

    public void setTextLocales(LocaleList locales) {
        if (locales == null || locales.isEmpty()) {
            throw new IllegalArgumentException("locales cannot be null or empty");
        }
        if (locales.equals(this.mLocales)) {
            return;
        }
        this.mLocales = locales;
        this.syncTextLocalesWithMinikin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTextLocalesWithMinikin() {
        Integer minikinLangListId;
        String languageTags = this.mLocales.toLanguageTags();
        Object object = sCacheLock;
        synchronized (object) {
            minikinLangListId = sMinikinLangListIdCache.get(languageTags);
            if (minikinLangListId == null) {
                int newID = Paint.nSetTextLocales(this.mNativePaint, languageTags);
                sMinikinLangListIdCache.put(languageTags, newID);
                return;
            }
        }
        Paint.nSetTextLocalesByMinikinLangListId(this.mNativePaint, minikinLangListId);
    }

    public boolean isElegantTextHeight() {
        return Paint.nIsElegantTextHeight(this.mNativePaint);
    }

    public void setElegantTextHeight(boolean elegant) {
        Paint.nSetElegantTextHeight(this.mNativePaint, elegant);
    }

    public float getTextSize() {
        return Paint.nGetTextSize(this.mNativePaint);
    }

    public void setTextSize(float textSize) {
        Paint.nSetTextSize(this.mNativePaint, textSize);
    }

    public float getTextScaleX() {
        return Paint.nGetTextScaleX(this.mNativePaint);
    }

    public void setTextScaleX(float scaleX) {
        Paint.nSetTextScaleX(this.mNativePaint, scaleX);
    }

    public float getTextSkewX() {
        return Paint.nGetTextSkewX(this.mNativePaint);
    }

    public void setTextSkewX(float skewX) {
        Paint.nSetTextSkewX(this.mNativePaint, skewX);
    }

    public float getLetterSpacing() {
        return Paint.nGetLetterSpacing(this.mNativePaint);
    }

    public void setLetterSpacing(float letterSpacing) {
        Paint.nSetLetterSpacing(this.mNativePaint, letterSpacing);
    }

    public float getWordSpacing() {
        return Paint.nGetWordSpacing(this.mNativePaint);
    }

    public void setWordSpacing(float wordSpacing) {
        Paint.nSetWordSpacing(this.mNativePaint, wordSpacing);
    }

    public String getFontFeatureSettings() {
        return this.mFontFeatureSettings;
    }

    public void setFontFeatureSettings(String settings) {
        if (settings != null && settings.equals("")) {
            settings = null;
        }
        if (settings == null && this.mFontFeatureSettings == null || settings != null && settings.equals(this.mFontFeatureSettings)) {
            return;
        }
        this.mFontFeatureSettings = settings;
        Paint.nSetFontFeatureSettings(this.mNativePaint, settings);
    }

    public String getFontVariationSettings() {
        return this.mFontVariationSettings;
    }

    public boolean setFontVariationSettings(String fontVariationSettings) {
        String settings = TextUtils.nullIfEmpty(fontVariationSettings);
        if (settings == this.mFontVariationSettings || settings != null && settings.equals(this.mFontVariationSettings)) {
            return true;
        }
        if (settings == null || settings.length() == 0) {
            this.mFontVariationSettings = null;
            this.setTypeface(Typeface.createFromTypefaceWithVariation(this.mTypeface, Collections.emptyList()));
            return true;
        }
        Typeface targetTypeface = this.mTypeface == null ? Typeface.DEFAULT : this.mTypeface;
        FontVariationAxis[] axes = FontVariationAxis.fromFontVariationSettings(settings);
        ArrayList<FontVariationAxis> filteredAxes = new ArrayList<FontVariationAxis>();
        for (FontVariationAxis axis : axes) {
            if (!targetTypeface.isSupportedAxes(axis.getOpenTypeTagValue())) continue;
            filteredAxes.add(axis);
        }
        if (filteredAxes.isEmpty()) {
            return false;
        }
        this.mFontVariationSettings = settings;
        this.setTypeface(Typeface.createFromTypefaceWithVariation(targetTypeface, filteredAxes));
        return true;
    }

    public int getHyphenEdit() {
        return Paint.nGetHyphenEdit(this.mNativePaint);
    }

    public void setHyphenEdit(int hyphen) {
        Paint.nSetHyphenEdit(this.mNativePaint, hyphen);
    }

    public float ascent() {
        return Paint.nAscent(this.mNativePaint, this.mNativeTypeface);
    }

    public float descent() {
        return Paint.nDescent(this.mNativePaint, this.mNativeTypeface);
    }

    public float getFontMetrics(FontMetrics metrics) {
        return Paint.nGetFontMetrics(this.mNativePaint, this.mNativeTypeface, metrics);
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    public int getFontMetricsInt(FontMetricsInt fmi) {
        return Paint.nGetFontMetricsInt(this.mNativePaint, this.mNativeTypeface, fmi);
    }

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public float measureText(char[] text, int index, int count) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    public float measureText(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    public float measureText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        return this.measureText(text, 0, text.length());
    }

    public float measureText(CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(text.toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (index < 0 || text.length - index < Math.abs(count)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    public int breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (text.length() == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    public int getTextWidths(char[] text, int index, int count, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, widths, 0);
            return count;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < count) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return count;
    }

    public int getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(text.toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getTextWidths(String text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, widths, 0);
            return end - start;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < end - start) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return end - start;
    }

    public int getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    public float getTextRunAdvances(char[] chars, int index, int count, int contextIndex, int contextCount, boolean isRtl, float[] advances, int advancesIndex) {
        if (chars == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count | contextIndex | contextCount | advancesIndex | index - contextIndex | contextCount - count | contextIndex + contextCount - (index + count) | chars.length - (contextIndex + contextCount) | (advances == null ? 0 : advances.length - (advancesIndex + count))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (chars.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float res = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + count;
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return res * this.mInvCompatScaling;
    }

    public float getTextRunAdvances(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String) {
            return this.getTextRunAdvances((String)text, start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunAdvances(text.toString(), start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunAdvances(start, end, contextStart, contextEnd, isRtl, advances, advancesIndex, this);
        }
        if (text.length() == 0 || end == start) {
            return 0.0f;
        }
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, isRtl, advances, advancesIndex);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public float getTextRunAdvances(String text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl ? 5 : 4, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float totalAdvance = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl ? 5 : 4, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + (end - start);
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return totalAdvance * this.mInvCompatScaling;
    }

    public int getTextRunCursor(char[] text, int contextStart, int contextLength, int dir, int offset, int cursorOpt) {
        int contextEnd = contextStart + contextLength;
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, this.mNativeTypeface, text, contextStart, contextLength, dir, offset, cursorOpt);
    }

    public int getTextRunCursor(CharSequence text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunCursor(text.toString(), contextStart, contextEnd, dir, offset, cursorOpt);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunCursor(contextStart, contextEnd, dir, offset, cursorOpt, this);
        }
        int contextLen = contextEnd - contextStart;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int relPos = this.getTextRunCursor(buf, 0, contextLen, dir, offset - contextStart, cursorOpt);
        TemporaryBuffer.recycle(buf);
        return relPos == -1 ? -1 : relPos + contextStart;
    }

    public int getTextRunCursor(String text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length() - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, this.mNativeTypeface, text, contextStart, contextEnd, dir, offset, cursorOpt);
    }

    public void getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, index, count, x, y, path.mutateNI());
    }

    public void getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, start, end, x, y, path.mutateNI());
    }

    public void getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetStringBounds(this.mNativePaint, this.mNativeTypeface, text, start, end, this.mBidiFlags, bounds);
    }

    public void getTextBounds(CharSequence text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        this.getTextBounds(buf, 0, end - start, bounds);
        TemporaryBuffer.recycle(buf);
    }

    public void getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetCharArrayBounds(this.mNativePaint, this.mNativeTypeface, text, index, count, this.mBidiFlags, bounds);
    }

    public boolean hasGlyph(String string2) {
        return Paint.nHasGlyph(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, string2);
    }

    public float getRunAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        return Paint.nGetRunAdvance(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, offset);
    }

    public float getRunAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getRunAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, offset - contextStart);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getOffsetForAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return Paint.nGetOffsetForAdvance(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, advance);
    }

    public int getOffsetForAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int result = this.getOffsetForAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, advance) + contextStart;
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private static native long nGetNativeFinalizer();

    private static native long nInit();

    private static native long nInitWithPaint(long var0);

    private static native int nBreakText(long var0, long var2, char[] var4, int var5, int var6, float var7, int var8, float[] var9);

    private static native int nBreakText(long var0, long var2, String var4, boolean var5, float var6, int var7, float[] var8);

    private static native float nGetTextAdvances(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    private static native float nGetTextAdvances(long var0, long var2, String var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    private native int nGetTextRunCursor(long var1, long var3, char[] var5, int var6, int var7, int var8, int var9, int var10);

    private native int nGetTextRunCursor(long var1, long var3, String var5, int var6, int var7, int var8, int var9, int var10);

    private static native void nGetTextPath(long var0, long var2, int var4, char[] var5, int var6, int var7, float var8, float var9, long var10);

    private static native void nGetTextPath(long var0, long var2, int var4, String var5, int var6, int var7, float var8, float var9, long var10);

    private static native void nGetStringBounds(long var0, long var2, String var4, int var5, int var6, int var7, Rect var8);

    private static native void nGetCharArrayBounds(long var0, long var2, char[] var4, int var5, int var6, int var7, Rect var8);

    private static native boolean nHasGlyph(long var0, long var2, int var4, String var5);

    private static native float nGetRunAdvance(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, int var10);

    private static native int nGetOffsetForAdvance(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

    @FastNative
    private static native int nSetTextLocales(long var0, String var2);

    @FastNative
    private static native void nSetFontFeatureSettings(long var0, String var2);

    @FastNative
    private static native float nGetFontMetrics(long var0, long var2, FontMetrics var4);

    @FastNative
    private static native int nGetFontMetricsInt(long var0, long var2, FontMetricsInt var4);

    @CriticalNative
    private static native void nReset(long var0);

    @CriticalNative
    private static native void nSet(long var0, long var2);

    @CriticalNative
    private static native int nGetStyle(long var0);

    @CriticalNative
    private static native void nSetStyle(long var0, int var2);

    @CriticalNative
    private static native int nGetStrokeCap(long var0);

    @CriticalNative
    private static native void nSetStrokeCap(long var0, int var2);

    @CriticalNative
    private static native int nGetStrokeJoin(long var0);

    @CriticalNative
    private static native void nSetStrokeJoin(long var0, int var2);

    @CriticalNative
    private static native boolean nGetFillPath(long var0, long var2, long var4);

    @CriticalNative
    private static native long nSetShader(long var0, long var2);

    @CriticalNative
    private static native long nSetColorFilter(long var0, long var2);

    @CriticalNative
    private static native void nSetXfermode(long var0, int var2);

    @CriticalNative
    private static native long nSetPathEffect(long var0, long var2);

    @CriticalNative
    private static native long nSetMaskFilter(long var0, long var2);

    @CriticalNative
    private static native long nSetTypeface(long var0, long var2);

    @CriticalNative
    private static native int nGetTextAlign(long var0);

    @CriticalNative
    private static native void nSetTextAlign(long var0, int var2);

    @CriticalNative
    private static native void nSetTextLocalesByMinikinLangListId(long var0, int var2);

    @CriticalNative
    private static native void nSetShadowLayer(long var0, float var2, float var3, float var4, int var5);

    @CriticalNative
    private static native boolean nHasShadowLayer(long var0);

    @CriticalNative
    private static native float nGetLetterSpacing(long var0);

    @CriticalNative
    private static native void nSetLetterSpacing(long var0, float var2);

    @CriticalNative
    private static native float nGetWordSpacing(long var0);

    @CriticalNative
    private static native void nSetWordSpacing(long var0, float var2);

    @CriticalNative
    private static native int nGetHyphenEdit(long var0);

    @CriticalNative
    private static native void nSetHyphenEdit(long var0, int var2);

    @CriticalNative
    private static native void nSetStrokeMiter(long var0, float var2);

    @CriticalNative
    private static native float nGetStrokeMiter(long var0);

    @CriticalNative
    private static native void nSetStrokeWidth(long var0, float var2);

    @CriticalNative
    private static native float nGetStrokeWidth(long var0);

    @CriticalNative
    private static native void nSetAlpha(long var0, int var2);

    @CriticalNative
    private static native void nSetDither(long var0, boolean var2);

    @CriticalNative
    private static native int nGetFlags(long var0);

    @CriticalNative
    private static native void nSetFlags(long var0, int var2);

    @CriticalNative
    private static native int nGetHinting(long var0);

    @CriticalNative
    private static native void nSetHinting(long var0, int var2);

    @CriticalNative
    private static native void nSetAntiAlias(long var0, boolean var2);

    @CriticalNative
    private static native void nSetLinearText(long var0, boolean var2);

    @CriticalNative
    private static native void nSetSubpixelText(long var0, boolean var2);

    @CriticalNative
    private static native void nSetUnderlineText(long var0, boolean var2);

    @CriticalNative
    private static native void nSetFakeBoldText(long var0, boolean var2);

    @CriticalNative
    private static native void nSetFilterBitmap(long var0, boolean var2);

    @CriticalNative
    private static native int nGetColor(long var0);

    @CriticalNative
    private static native void nSetColor(long var0, int var2);

    @CriticalNative
    private static native int nGetAlpha(long var0);

    @CriticalNative
    private static native void nSetStrikeThruText(long var0, boolean var2);

    @CriticalNative
    private static native boolean nIsElegantTextHeight(long var0);

    @CriticalNative
    private static native void nSetElegantTextHeight(long var0, boolean var2);

    @CriticalNative
    private static native float nGetTextSize(long var0);

    @CriticalNative
    private static native float nGetTextScaleX(long var0);

    @CriticalNative
    private static native void nSetTextScaleX(long var0, float var2);

    @CriticalNative
    private static native float nGetTextSkewX(long var0);

    @CriticalNative
    private static native void nSetTextSkewX(long var0, float var2);

    @CriticalNative
    private static native float nAscent(long var0, long var2);

    @CriticalNative
    private static native float nDescent(long var0, long var2);

    @CriticalNative
    private static native void nSetTextSize(long var0, float var2);

    static /* synthetic */ long access$000() {
        return Paint.nGetNativeFinalizer();
    }

    public static class FontMetricsInt {
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        public String toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }
    }

    public static class FontMetrics {
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;
    }

    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        final int nativeInt;

        private Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        final int nativeInt;

        private Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        final int nativeInt;

        private Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        final int nativeInt;

        private Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Paint.class.getClassLoader(), Paint.access$000(), 98L);

        private NoImagePreloadHolder() {
        }
    }
}

