/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.PorterDuff;

public class PorterDuffColorFilter
extends ColorFilter {
    private int mColor;
    private PorterDuff.Mode mMode;

    public PorterDuffColorFilter(int color2, PorterDuff.Mode mode) {
        this.mColor = color2;
        this.mMode = mode;
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color2) {
        if (this.mColor != color2) {
            this.mColor = color2;
            this.discardNativeInstance();
        }
    }

    public PorterDuff.Mode getMode() {
        return this.mMode;
    }

    public void setMode(PorterDuff.Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must be non-null");
        }
        this.mMode = mode;
        this.discardNativeInstance();
    }

    @Override
    long createNativeInstance() {
        return PorterDuffColorFilter.native_CreatePorterDuffFilter(this.mColor, this.mMode.nativeInt);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PorterDuffColorFilter other = (PorterDuffColorFilter)object;
        return this.mColor == other.mColor && this.mMode.nativeInt == other.mMode.nativeInt;
    }

    public int hashCode() {
        return 31 * this.mMode.hashCode() + this.mColor;
    }

    private static native long native_CreatePorterDuffFilter(int var0, int var1);
}

