/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;

public class RadialGradient
extends Shader {
    private static final int TYPE_COLORS_AND_POSITIONS = 1;
    private static final int TYPE_COLOR_CENTER_AND_COLOR_EDGE = 2;
    private int mType;
    private float mX;
    private float mY;
    private float mRadius;
    private int[] mColors;
    private float[] mPositions;
    private int mCenterColor;
    private int mEdgeColor;
    private Shader.TileMode mTileMode;

    public RadialGradient(float centerX, float centerY, float radius, int[] colors, float[] stops, Shader.TileMode tileMode) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be > 0");
        }
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (stops != null && colors.length != stops.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mType = 1;
        this.mX = centerX;
        this.mY = centerY;
        this.mRadius = radius;
        this.mColors = (int[])colors.clone();
        this.mPositions = stops != null ? (float[])stops.clone() : null;
        this.mTileMode = tileMode;
    }

    public RadialGradient(float centerX, float centerY, float radius, int centerColor, int edgeColor, Shader.TileMode tileMode) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be > 0");
        }
        this.mType = 2;
        this.mX = centerX;
        this.mY = centerY;
        this.mRadius = radius;
        this.mCenterColor = centerColor;
        this.mEdgeColor = edgeColor;
        this.mTileMode = tileMode;
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        if (this.mType == 1) {
            return RadialGradient.nativeCreate1(nativeMatrix, this.mX, this.mY, this.mRadius, this.mColors, this.mPositions, this.mTileMode.nativeInt);
        }
        return RadialGradient.nativeCreate2(nativeMatrix, this.mX, this.mY, this.mRadius, this.mCenterColor, this.mEdgeColor, this.mTileMode.nativeInt);
    }

    @Override
    protected Shader copy() {
        RadialGradient copy = this.mType == 1 ? new RadialGradient(this.mX, this.mY, this.mRadius, (int[])this.mColors.clone(), this.mPositions != null ? (float[])this.mPositions.clone() : null, this.mTileMode) : new RadialGradient(this.mX, this.mY, this.mRadius, this.mCenterColor, this.mEdgeColor, this.mTileMode);
        this.copyLocalMatrix(copy);
        return copy;
    }

    private static native long nativeCreate1(long var0, float var2, float var3, float var4, int[] var5, float[] var6, int var7);

    private static native long nativeCreate2(long var0, float var2, float var3, float var4, int var5, int var6, int var7);
}

