/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.IntDef;
import android.hardware.camera2.CaptureRequest;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CaptureFailure {
    public static final int REASON_ERROR = 0;
    public static final int REASON_FLUSHED = 1;
    private final CaptureRequest mRequest;
    private final int mReason;
    private final boolean mDropped;
    private final int mSequenceId;
    private final long mFrameNumber;

    public CaptureFailure(CaptureRequest request, int reason, boolean dropped, int sequenceId, long frameNumber) {
        this.mRequest = request;
        this.mReason = reason;
        this.mDropped = dropped;
        this.mSequenceId = sequenceId;
        this.mFrameNumber = frameNumber;
    }

    public CaptureRequest getRequest() {
        return this.mRequest;
    }

    public long getFrameNumber() {
        return this.mFrameNumber;
    }

    public int getReason() {
        return this.mReason;
    }

    public boolean wasImageCaptured() {
        return !this.mDropped;
    }

    public int getSequenceId() {
        return this.mSequenceId;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(prefix={"REASON_"}, value={0L, 1L})
    public static @interface FailureReason {
    }
}

