/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.dispatch.Dispatchable;
import android.hardware.camera2.dispatch.MethodNameInvoker;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.view.Surface;
import com.android.internal.util.Preconditions;

public class CallbackProxies {
    private CallbackProxies() {
        throw new AssertionError();
    }

    public static class SessionStateCallbackProxy
    extends CameraCaptureSession.StateCallback {
        private final MethodNameInvoker<CameraCaptureSession.StateCallback> mProxy;

        public SessionStateCallbackProxy(Dispatchable<CameraCaptureSession.StateCallback> dispatchTarget) {
            dispatchTarget = Preconditions.checkNotNull(dispatchTarget, "dispatchTarget must not be null");
            this.mProxy = new MethodNameInvoker<CameraCaptureSession.StateCallback>(dispatchTarget, CameraCaptureSession.StateCallback.class);
        }

        @Override
        public void onConfigured(CameraCaptureSession session) {
            this.mProxy.invoke("onConfigured", session);
        }

        @Override
        public void onConfigureFailed(CameraCaptureSession session) {
            this.mProxy.invoke("onConfigureFailed", session);
        }

        @Override
        public void onReady(CameraCaptureSession session) {
            this.mProxy.invoke("onReady", session);
        }

        @Override
        public void onActive(CameraCaptureSession session) {
            this.mProxy.invoke("onActive", session);
        }

        @Override
        public void onCaptureQueueEmpty(CameraCaptureSession session) {
            this.mProxy.invoke("onCaptureQueueEmpty", session);
        }

        @Override
        public void onClosed(CameraCaptureSession session) {
            this.mProxy.invoke("onClosed", session);
        }

        @Override
        public void onSurfacePrepared(CameraCaptureSession session, Surface surface) {
            this.mProxy.invoke("onSurfacePrepared", session, surface);
        }
    }

    public static class DeviceCaptureCallbackProxy
    implements CameraDeviceImpl.CaptureCallback {
        private final MethodNameInvoker<CameraDeviceImpl.CaptureCallback> mProxy;

        public DeviceCaptureCallbackProxy(Dispatchable<CameraDeviceImpl.CaptureCallback> dispatchTarget) {
            dispatchTarget = Preconditions.checkNotNull(dispatchTarget, "dispatchTarget must not be null");
            this.mProxy = new MethodNameInvoker<CameraDeviceImpl.CaptureCallback>(dispatchTarget, CameraDeviceImpl.CaptureCallback.class);
        }

        @Override
        public void onCaptureStarted(CameraDevice camera, CaptureRequest request, long timestamp, long frameNumber) {
            this.mProxy.invoke("onCaptureStarted", camera, request, timestamp, frameNumber);
        }

        @Override
        public void onCapturePartial(CameraDevice camera, CaptureRequest request, CaptureResult result) {
            this.mProxy.invoke("onCapturePartial", camera, request, result);
        }

        @Override
        public void onCaptureProgressed(CameraDevice camera, CaptureRequest request, CaptureResult partialResult) {
            this.mProxy.invoke("onCaptureProgressed", camera, request, partialResult);
        }

        @Override
        public void onCaptureCompleted(CameraDevice camera, CaptureRequest request, TotalCaptureResult result) {
            this.mProxy.invoke("onCaptureCompleted", camera, request, result);
        }

        @Override
        public void onCaptureFailed(CameraDevice camera, CaptureRequest request, CaptureFailure failure) {
            this.mProxy.invoke("onCaptureFailed", camera, request, failure);
        }

        @Override
        public void onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
            this.mProxy.invoke("onCaptureSequenceCompleted", camera, sequenceId, frameNumber);
        }

        @Override
        public void onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
            this.mProxy.invoke("onCaptureSequenceAborted", camera, sequenceId);
        }

        @Override
        public void onCaptureBufferLost(CameraDevice camera, CaptureRequest request, Surface target, long frameNumber) {
            this.mProxy.invoke("onCaptureBufferLost", camera, request, target, frameNumber);
        }
    }

    public static class DeviceStateCallbackProxy
    extends CameraDeviceImpl.StateCallbackKK {
        private final MethodNameInvoker<CameraDeviceImpl.StateCallbackKK> mProxy;

        public DeviceStateCallbackProxy(Dispatchable<CameraDeviceImpl.StateCallbackKK> dispatchTarget) {
            dispatchTarget = Preconditions.checkNotNull(dispatchTarget, "dispatchTarget must not be null");
            this.mProxy = new MethodNameInvoker<CameraDeviceImpl.StateCallbackKK>(dispatchTarget, CameraDeviceImpl.StateCallbackKK.class);
        }

        @Override
        public void onOpened(CameraDevice camera) {
            this.mProxy.invoke("onOpened", camera);
        }

        @Override
        public void onDisconnected(CameraDevice camera) {
            this.mProxy.invoke("onDisconnected", camera);
        }

        @Override
        public void onError(CameraDevice camera, int error) {
            this.mProxy.invoke("onError", camera, error);
        }

        @Override
        public void onUnconfigured(CameraDevice camera) {
            this.mProxy.invoke("onUnconfigured", camera);
        }

        @Override
        public void onActive(CameraDevice camera) {
            this.mProxy.invoke("onActive", camera);
        }

        @Override
        public void onBusy(CameraDevice camera) {
            this.mProxy.invoke("onBusy", camera);
        }

        @Override
        public void onClosed(CameraDevice camera) {
            this.mProxy.invoke("onClosed", camera);
        }

        @Override
        public void onIdle(CameraDevice camera) {
            this.mProxy.invoke("onIdle", camera);
        }
    }
}

