/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.dispatch.ArgumentReplacingDispatcher;
import android.hardware.camera2.dispatch.BroadcastDispatcher;
import android.hardware.camera2.dispatch.DuckTypingDispatcher;
import android.hardware.camera2.dispatch.HandlerDispatcher;
import android.hardware.camera2.dispatch.InvokeDispatcher;
import android.hardware.camera2.impl.CallbackProxies;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.TaskDrainer;
import android.hardware.camera2.utils.TaskSingleDrainer;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.List;

public class CameraCaptureSessionImpl
extends CameraCaptureSession
implements CameraCaptureSessionCore {
    private static final String TAG = "CameraCaptureSession";
    private static final boolean DEBUG = false;
    private final int mId;
    private final String mIdString;
    private final Surface mInput;
    private final CameraCaptureSession.StateCallback mStateCallback;
    private final Handler mStateHandler;
    private final CameraDeviceImpl mDeviceImpl;
    private final Handler mDeviceHandler;
    private final TaskDrainer<Integer> mSequenceDrainer;
    private final TaskSingleDrainer mIdleDrainer;
    private final TaskSingleDrainer mAbortDrainer;
    private boolean mClosed = false;
    private final boolean mConfigureSuccess;
    private boolean mSkipUnconfigure = false;
    private volatile boolean mAborting;

    CameraCaptureSessionImpl(int id2, Surface input, CameraCaptureSession.StateCallback callback, Handler stateHandler, CameraDeviceImpl deviceImpl, Handler deviceStateHandler, boolean configureSuccess) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.mId = id2;
        this.mIdString = String.format("Session %d: ", this.mId);
        this.mInput = input;
        this.mStateHandler = CameraDeviceImpl.checkHandler(stateHandler);
        this.mStateCallback = this.createUserStateCallbackProxy(this.mStateHandler, callback);
        this.mDeviceHandler = Preconditions.checkNotNull(deviceStateHandler, "deviceStateHandler must not be null");
        this.mDeviceImpl = Preconditions.checkNotNull(deviceImpl, "deviceImpl must not be null");
        this.mSequenceDrainer = new TaskDrainer(this.mDeviceHandler, new SequenceDrainListener(), "seq");
        this.mIdleDrainer = new TaskSingleDrainer(this.mDeviceHandler, new IdleDrainListener(), "idle");
        this.mAbortDrainer = new TaskSingleDrainer(this.mDeviceHandler, new AbortDrainListener(), "abort");
        if (configureSuccess) {
            this.mStateCallback.onConfigured(this);
            this.mConfigureSuccess = true;
        } else {
            this.mStateCallback.onConfigureFailed(this);
            this.mClosed = true;
            Log.e(TAG, this.mIdString + "Failed to create capture session; configuration failed");
            this.mConfigureSuccess = false;
        }
    }

    @Override
    public CameraDevice getDevice() {
        return this.mDeviceImpl;
    }

    @Override
    public void prepare(Surface surface) throws CameraAccessException {
        this.mDeviceImpl.prepare(surface);
    }

    @Override
    public void prepare(int maxCount, Surface surface) throws CameraAccessException {
        this.mDeviceImpl.prepare(maxCount, surface);
    }

    @Override
    public void tearDown(Surface surface) throws CameraAccessException {
        this.mDeviceImpl.tearDown(surface);
    }

    @Override
    public void finalizeOutputConfigurations(List<OutputConfiguration> outputConfigs) throws CameraAccessException {
        this.mDeviceImpl.finalizeOutputConfigs(outputConfigs);
    }

    @Override
    public synchronized int capture(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isReprocess() && !this.isReprocessable()) {
            throw new IllegalArgumentException("this capture session cannot handle reprocess requests");
        }
        if (request.isReprocess() && request.getReprocessableSessionId() != this.mId) {
            throw new IllegalArgumentException("capture request was created for another session");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.capture(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized int captureBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null) {
            throw new IllegalArgumentException("Requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("Requests must have at least one element");
        }
        for (CaptureRequest request : requests) {
            if (!request.isReprocess()) continue;
            if (!this.isReprocessable()) {
                throw new IllegalArgumentException("This capture session cannot handle reprocess requests");
            }
            if (request.getReprocessableSessionId() == this.mId) continue;
            throw new IllegalArgumentException("Capture request was created for another session");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.captureBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized int setRepeatingRequest(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isReprocess()) {
            throw new IllegalArgumentException("repeating reprocess requests are not supported");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.setRepeatingRequest(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized int setRepeatingBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("requests must have at least one element");
        }
        for (CaptureRequest r : requests) {
            if (!r.isReprocess()) continue;
            throw new IllegalArgumentException("repeating reprocess burst requests are not supported");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.setRepeatingBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized void stopRepeating() throws CameraAccessException {
        this.checkNotClosed();
        this.mDeviceImpl.stopRepeating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortCaptures() throws CameraAccessException {
        Object object = this;
        synchronized (object) {
            this.checkNotClosed();
            if (this.mAborting) {
                Log.w(TAG, this.mIdString + "abortCaptures - Session is already aborting; doing nothing");
                return;
            }
            this.mAborting = true;
            this.mAbortDrainer.taskStarted();
        }
        object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            CameraCaptureSessionImpl cameraCaptureSessionImpl = this;
            synchronized (cameraCaptureSessionImpl) {
                this.mDeviceImpl.flush();
            }
        }
    }

    @Override
    public boolean isReprocessable() {
        return this.mInput != null;
    }

    @Override
    public Surface getInputSurface() {
        return this.mInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSessionClose() {
        CameraCaptureSessionImpl cameraCaptureSessionImpl = this;
        synchronized (cameraCaptureSessionImpl) {
            this.mSkipUnconfigure = true;
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
        }
        object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            CameraCaptureSessionImpl cameraCaptureSessionImpl = this;
            synchronized (cameraCaptureSessionImpl) {
                try {
                    this.mDeviceImpl.stopRepeating();
                }
                catch (IllegalStateException e) {
                    this.mStateCallback.onClosed(this);
                    return;
                }
                catch (CameraAccessException e) {
                    Log.e(TAG, this.mIdString + "Exception while stopping repeating: ", e);
                }
            }
        }
        object = this;
        synchronized (object) {
            this.mSequenceDrainer.beginDrain();
        }
    }

    @Override
    public boolean isAborting() {
        return this.mAborting;
    }

    private CameraCaptureSession.StateCallback createUserStateCallbackProxy(Handler handler, CameraCaptureSession.StateCallback callback) {
        InvokeDispatcher<CameraCaptureSession.StateCallback> userCallbackSink = new InvokeDispatcher<CameraCaptureSession.StateCallback>(callback);
        HandlerDispatcher<CameraCaptureSession.StateCallback> handlerPassthrough = new HandlerDispatcher<CameraCaptureSession.StateCallback>(userCallbackSink, handler);
        return new CallbackProxies.SessionStateCallbackProxy(handlerPassthrough);
    }

    private CameraDeviceImpl.CaptureCallback createCaptureCallbackProxy(Handler handler, CameraCaptureSession.CaptureCallback callback) {
        CameraDeviceImpl.CaptureCallback localCallback = new CameraDeviceImpl.CaptureCallback(){

            @Override
            public void onCaptureStarted(CameraDevice camera, CaptureRequest request, long timestamp, long frameNumber) {
            }

            @Override
            public void onCapturePartial(CameraDevice camera, CaptureRequest request, CaptureResult result) {
            }

            @Override
            public void onCaptureProgressed(CameraDevice camera, CaptureRequest request, CaptureResult partialResult) {
            }

            @Override
            public void onCaptureCompleted(CameraDevice camera, CaptureRequest request, TotalCaptureResult result) {
            }

            @Override
            public void onCaptureFailed(CameraDevice camera, CaptureRequest request, CaptureFailure failure) {
            }

            @Override
            public void onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
                CameraCaptureSessionImpl.this.finishPendingSequence(sequenceId);
            }

            @Override
            public void onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
                CameraCaptureSessionImpl.this.finishPendingSequence(sequenceId);
            }

            @Override
            public void onCaptureBufferLost(CameraDevice camera, CaptureRequest request, Surface target, long frameNumber) {
            }
        };
        if (callback == null) {
            return localCallback;
        }
        InvokeDispatcher<1> localSink = new InvokeDispatcher<1>(localCallback);
        InvokeDispatcher<CameraCaptureSession.CaptureCallback> userCallbackSink = new InvokeDispatcher<CameraCaptureSession.CaptureCallback>(callback);
        HandlerDispatcher<CameraCaptureSession.CaptureCallback> handlerPassthrough = new HandlerDispatcher<CameraCaptureSession.CaptureCallback>(userCallbackSink, handler);
        DuckTypingDispatcher duckToSession = new DuckTypingDispatcher(handlerPassthrough, CameraCaptureSession.CaptureCallback.class);
        ArgumentReplacingDispatcher replaceDeviceWithSession = new ArgumentReplacingDispatcher(duckToSession, 0, this);
        BroadcastDispatcher<CameraDeviceImpl.CaptureCallback> broadcaster = new BroadcastDispatcher<CameraDeviceImpl.CaptureCallback>(replaceDeviceWithSession, localSink);
        return new CallbackProxies.DeviceCaptureCallbackProxy(broadcaster);
    }

    @Override
    public CameraDeviceImpl.StateCallbackKK getDeviceStateCallback() {
        final CameraCaptureSessionImpl session = this;
        return new CameraDeviceImpl.StateCallbackKK(){
            private boolean mBusy = false;
            private boolean mActive = false;

            @Override
            public void onOpened(CameraDevice camera) {
                throw new AssertionError((Object)"Camera must already be open before creating a session");
            }

            @Override
            public void onDisconnected(CameraDevice camera) {
                CameraCaptureSessionImpl.this.close();
            }

            @Override
            public void onError(CameraDevice camera, int error) {
                Log.wtf(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Got device error " + error);
            }

            @Override
            public void onActive(CameraDevice camera) {
                CameraCaptureSessionImpl.this.mIdleDrainer.taskStarted();
                this.mActive = true;
                CameraCaptureSessionImpl.this.mStateCallback.onActive(session);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIdle(CameraDevice camera) {
                boolean isAborting;
                CameraCaptureSession cameraCaptureSession = session;
                synchronized (cameraCaptureSession) {
                    isAborting = CameraCaptureSessionImpl.this.mAborting;
                }
                if (this.mBusy && isAborting) {
                    CameraCaptureSessionImpl.this.mAbortDrainer.taskFinished();
                    cameraCaptureSession = session;
                    synchronized (cameraCaptureSession) {
                        CameraCaptureSessionImpl.this.mAborting = false;
                    }
                }
                if (this.mActive) {
                    CameraCaptureSessionImpl.this.mIdleDrainer.taskFinished();
                }
                this.mBusy = false;
                this.mActive = false;
                CameraCaptureSessionImpl.this.mStateCallback.onReady(session);
            }

            @Override
            public void onBusy(CameraDevice camera) {
                this.mBusy = true;
            }

            @Override
            public void onUnconfigured(CameraDevice camera) {
            }

            @Override
            public void onRequestQueueEmpty() {
                CameraCaptureSessionImpl.this.mStateCallback.onCaptureQueueEmpty(session);
            }

            @Override
            public void onSurfacePrepared(Surface surface) {
                CameraCaptureSessionImpl.this.mStateCallback.onSurfacePrepared(session, surface);
            }
        };
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Session has been closed; further changes are illegal.");
        }
    }

    private int addPendingSequence(int sequenceId) {
        this.mSequenceDrainer.taskStarted(sequenceId);
        return sequenceId;
    }

    private void finishPendingSequence(int sequenceId) {
        try {
            this.mSequenceDrainer.taskFinished(sequenceId);
        }
        catch (IllegalStateException e) {
            Log.w(TAG, e.getMessage());
        }
    }

    private class IdleDrainListener
    implements TaskDrainer.DrainListener {
        private IdleDrainListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDrained() {
            Object object = ((CameraCaptureSessionImpl)CameraCaptureSessionImpl.this).mDeviceImpl.mInterfaceLock;
            synchronized (object) {
                CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
                synchronized (cameraCaptureSessionImpl) {
                    if (CameraCaptureSessionImpl.this.mSkipUnconfigure) {
                        return;
                    }
                    try {
                        CameraCaptureSessionImpl.this.mDeviceImpl.configureStreamsChecked(null, null, 0);
                    }
                    catch (CameraAccessException e) {
                        Log.e(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Exception while unconfiguring outputs: ", e);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class AbortDrainListener
    implements TaskDrainer.DrainListener {
        private AbortDrainListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDrained() {
            CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
            synchronized (cameraCaptureSessionImpl) {
                if (CameraCaptureSessionImpl.this.mSkipUnconfigure) {
                    return;
                }
                CameraCaptureSessionImpl.this.mIdleDrainer.beginDrain();
            }
        }
    }

    private class SequenceDrainListener
    implements TaskDrainer.DrainListener {
        private SequenceDrainListener() {
        }

        @Override
        public void onDrained() {
            CameraCaptureSessionImpl.this.mStateCallback.onClosed(CameraCaptureSessionImpl.this);
            if (CameraCaptureSessionImpl.this.mSkipUnconfigure) {
                return;
            }
            CameraCaptureSessionImpl.this.mAbortDrainer.beginDrain();
        }
    }
}

