/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public final class ContextHubManager {
    private static final String TAG = "ContextHubManager";
    private final Looper mMainLooper;
    private final IContextHubService mService;
    private Callback mCallback;
    private Handler mCallbackHandler;
    @Deprecated
    private ICallback mLocalCallback;
    private final IContextHubCallback.Stub mClientCallback = new IContextHubCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageReceipt(final int hubId, final int nanoAppId, final ContextHubMessage message) {
            if (ContextHubManager.this.mCallback != null) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    final Callback callback = ContextHubManager.this.mCallback;
                    Handler handler = ContextHubManager.this.mCallbackHandler == null ? new Handler(ContextHubManager.this.mMainLooper) : ContextHubManager.this.mCallbackHandler;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onMessageReceipt(hubId, nanoAppId, message);
                        }
                    });
                }
            } else if (ContextHubManager.this.mLocalCallback != null) {
                1 var4_5 = this;
                synchronized (var4_5) {
                    ContextHubManager.this.mLocalCallback.onMessageReceipt(hubId, nanoAppId, message);
                }
            } else {
                Log.d(ContextHubManager.TAG, "Context hub manager client callback is NULL");
            }
        }
    };

    public int[] getContextHubHandles() {
        try {
            return this.mService.getContextHubHandles();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ContextHubInfo getContextHubInfo(int hubHandle) {
        try {
            return this.mService.getContextHubInfo(hubHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int loadNanoApp(int hubHandle, NanoApp app) {
        try {
            return this.mService.loadNanoApp(hubHandle, app);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int unloadNanoApp(int nanoAppHandle) {
        try {
            return this.mService.unloadNanoApp(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) {
        try {
            return this.mService.getNanoAppInstanceInfo(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int[] findNanoAppOnHub(int hubHandle, NanoAppFilter filter) {
        try {
            return this.mService.findNanoAppOnHub(hubHandle, filter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int sendMessage(int hubHandle, int nanoAppHandle, ContextHubMessage message) {
        try {
            return this.mService.sendMessage(hubHandle, nanoAppHandle, message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"Doclava125"})
    public int registerCallback(Callback callback) {
        return this.registerCallback(callback, null);
    }

    @Deprecated
    public int registerCallback(ICallback callback) {
        if (this.mLocalCallback != null) {
            Log.w(TAG, "Max number of local callbacks reached!");
            return -1;
        }
        this.mLocalCallback = callback;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Doclava125"})
    public int registerCallback(Callback callback, Handler handler) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (this.mCallback != null) {
                Log.w(TAG, "Max number of callbacks reached!");
                return -1;
            }
            this.mCallback = callback;
            this.mCallbackHandler = handler;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Doclava125"})
    public int unregisterCallback(Callback callback) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (callback != this.mCallback) {
                Log.w(TAG, "Cannot recognize callback!");
                return -1;
            }
            this.mCallback = null;
            this.mCallbackHandler = null;
        }
        return 0;
    }

    @Deprecated
    public synchronized int unregisterCallback(ICallback callback) {
        if (callback != this.mLocalCallback) {
            Log.w(TAG, "Cannot recognize local callback!");
            return -1;
        }
        this.mLocalCallback = null;
        return 0;
    }

    public ContextHubManager(Context context, Looper mainLooper) throws ServiceManager.ServiceNotFoundException {
        this.mMainLooper = mainLooper;
        this.mService = IContextHubService.Stub.asInterface(ServiceManager.getServiceOrThrow("contexthub"));
        try {
            this.mService.registerCallback(this.mClientCallback);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not register callback:" + e);
        }
    }

    @Deprecated
    public static interface ICallback {
        public void onMessageReceipt(int var1, int var2, ContextHubMessage var3);
    }

    public static abstract class Callback {
        protected Callback() {
        }

        public abstract void onMessageReceipt(int var1, int var2, ContextHubMessage var3);
    }
}

