/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

public final class UsbPort
implements Parcelable {
    private final String mId;
    private final int mSupportedModes;
    public static final int MODE_NONE = 0;
    public static final int MODE_DFP = 2;
    public static final int MODE_UFP = 1;
    public static final int MODE_DUAL = 3;
    public static final int POWER_ROLE_NONE = 0;
    public static final int POWER_ROLE_SOURCE = 1;
    public static final int POWER_ROLE_SINK = 2;
    public static final int DATA_ROLE_NONE = 0;
    public static final int DATA_ROLE_HOST = 1;
    public static final int DATA_ROLE_DEVICE = 2;
    private static final int NUM_DATA_ROLES = 3;
    private static final int POWER_ROLE_OFFSET = 0;
    public static final Parcelable.Creator<UsbPort> CREATOR = new Parcelable.Creator<UsbPort>(){

        @Override
        public UsbPort createFromParcel(Parcel in) {
            String id2 = in.readString();
            int supportedModes = in.readInt();
            return new UsbPort(id2, supportedModes);
        }

        public UsbPort[] newArray(int size) {
            return new UsbPort[size];
        }
    };

    public UsbPort(String id2, int supportedModes) {
        this.mId = id2;
        this.mSupportedModes = supportedModes;
    }

    public String getId() {
        return this.mId;
    }

    public int getSupportedModes() {
        return this.mSupportedModes;
    }

    public static int combineRolesAsBit(int powerRole, int dataRole) {
        UsbPort.checkRoles(powerRole, dataRole);
        int index = (powerRole - 0) * 3 + dataRole;
        return 1 << index;
    }

    public static String modeToString(int mode) {
        switch (mode) {
            case 0: {
                return "none";
            }
            case 2: {
                return "dfp";
            }
            case 1: {
                return "ufp";
            }
            case 3: {
                return "dual";
            }
        }
        return Integer.toString(mode);
    }

    public static String powerRoleToString(int role) {
        switch (role) {
            case 0: {
                return "no-power";
            }
            case 1: {
                return "source";
            }
            case 2: {
                return "sink";
            }
        }
        return Integer.toString(role);
    }

    public static String dataRoleToString(int role) {
        switch (role) {
            case 0: {
                return "no-data";
            }
            case 1: {
                return "host";
            }
            case 2: {
                return "device";
            }
        }
        return Integer.toString(role);
    }

    public static String roleCombinationsToString(int combo) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        boolean first = true;
        while (combo != 0) {
            int index = Integer.numberOfTrailingZeros(combo);
            combo &= ~(1 << index);
            int powerRole = index / 3 + 0;
            int dataRole = index % 3;
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(UsbPort.powerRoleToString(powerRole));
            result.append(':');
            result.append(UsbPort.dataRoleToString(dataRole));
        }
        result.append("]");
        return result.toString();
    }

    public static void checkMode(int powerRole) {
        Preconditions.checkArgumentInRange(powerRole, 0, 3, "portMode");
    }

    public static void checkPowerRole(int dataRole) {
        Preconditions.checkArgumentInRange(dataRole, 0, 2, "powerRole");
    }

    public static void checkDataRole(int mode) {
        Preconditions.checkArgumentInRange(mode, 0, 2, "powerRole");
    }

    public static void checkRoles(int powerRole, int dataRole) {
        Preconditions.checkArgumentInRange(powerRole, 0, 2, "powerRole");
        Preconditions.checkArgumentInRange(dataRole, 0, 2, "dataRole");
    }

    public String toString() {
        return "UsbPort{id=" + this.mId + ", supportedModes=" + UsbPort.modeToString(this.mSupportedModes) + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mSupportedModes);
    }
}

