/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.ICas;
import android.media.ICasListener;
import android.media.IDescrambler;
import android.media.MediaCas;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IMediaCasService
extends IInterface {
    public MediaCas.ParcelableCasPluginDescriptor[] enumeratePlugins() throws RemoteException;

    public boolean isSystemIdSupported(int var1) throws RemoteException;

    public ICas createPlugin(int var1, ICasListener var2) throws RemoteException;

    public boolean isDescramblerSupported(int var1) throws RemoteException;

    public IDescrambler createDescrambler(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaCasService {
        private static final String DESCRIPTOR = "android.media.IMediaCasService";
        static final int TRANSACTION_enumeratePlugins = 1;
        static final int TRANSACTION_isSystemIdSupported = 2;
        static final int TRANSACTION_createPlugin = 3;
        static final int TRANSACTION_isDescramblerSupported = 4;
        static final int TRANSACTION_createDescrambler = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaCasService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaCasService) {
                return (IMediaCasService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    Parcelable[] _result = this.enumeratePlugins();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _result = this.isSystemIdSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    ICasListener _arg1 = ICasListener.Stub.asInterface(data.readStrongBinder());
                    ICas _result = this.createPlugin(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _result = this.isDescramblerSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    IDescrambler _result = this.createDescrambler(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IMediaCasService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaCas.ParcelableCasPluginDescriptor[] enumeratePlugins() throws RemoteException {
                MediaCas.ParcelableCasPluginDescriptor[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(MediaCas.ParcelableCasPluginDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSystemIdSupported(int CA_system_id) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(CA_system_id);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICas createPlugin(int CA_system_id, ICasListener listener) throws RemoteException {
                ICas _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(CA_system_id);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = ICas.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDescramblerSupported(int CA_system_id) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(CA_system_id);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IDescrambler createDescrambler(int CA_system_id) throws RemoteException {
                IDescrambler _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(CA_system_id);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = IDescrambler.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

