/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.ICas;
import android.media.ICasListener;
import android.media.IMediaCasService;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Singleton;

public final class MediaCas
implements AutoCloseable {
    private static final String TAG = "MediaCas";
    private final ParcelableCasData mCasData;
    private ICas mICas;
    private EventListener mListener;
    private HandlerThread mHandlerThread;
    private EventHandler mEventHandler;
    private static final Singleton<IMediaCasService> gDefault = new Singleton<IMediaCasService>(){

        @Override
        protected IMediaCasService create() {
            return IMediaCasService.Stub.asInterface(ServiceManager.getService("media.cas"));
        }
    };
    private final ICasListener.Stub mBinder;

    static IMediaCasService getService() {
        return gDefault.get();
    }

    private void validateInternalStates() {
        if (this.mICas == null) {
            throw new IllegalStateException();
        }
    }

    private void cleanupAndRethrowIllegalState() {
        this.mICas = null;
        throw new IllegalStateException();
    }

    Session createFromSessionId(byte[] sessionId) {
        if (sessionId == null || sessionId.length == 0) {
            return null;
        }
        return new Session(sessionId);
    }

    public static boolean isSystemIdSupported(int CA_system_id) {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                return service.isSystemIdSupported(CA_system_id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public static PluginDescriptor[] enumeratePlugins() {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                ParcelableCasPluginDescriptor[] descriptors = service.enumeratePlugins();
                if (descriptors.length == 0) {
                    return null;
                }
                PluginDescriptor[] results = new PluginDescriptor[descriptors.length];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = descriptors[i];
                }
                return results;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public MediaCas(int CA_system_id) throws MediaCasException.UnsupportedCasException {
        block5: {
            this.mCasData = new ParcelableCasData();
            this.mBinder = new ICasListener.Stub(){

                @Override
                public void onEvent(int event, int arg, byte[] data) throws RemoteException {
                    MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(0, event, arg, data));
                }
            };
            try {
                this.mICas = MediaCas.getService().createPlugin(CA_system_id, this.mBinder);
            }
            catch (Exception e) {
                Log.e(TAG, "Failed to create plugin: " + e);
                this.mICas = null;
                return this.mICas;
            }
            finally {
                if (this.mICas != null) break block5;
                throw new MediaCasException.UnsupportedCasException("Unsupported CA_system_id " + CA_system_id);
            }
        }
    }

    IBinder getBinder() {
        this.validateInternalStates();
        return this.mICas.asBinder();
    }

    public void setEventListener(EventListener listener, Handler handler) {
        Looper looper;
        this.mListener = listener;
        if (this.mListener == null) {
            this.mEventHandler = null;
            return;
        }
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null && (looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
            if (this.mHandlerThread == null || !this.mHandlerThread.isAlive()) {
                this.mHandlerThread = new HandlerThread("MediaCasEventThread", -2);
                this.mHandlerThread.start();
            }
            looper = this.mHandlerThread.getLooper();
        }
        this.mEventHandler = new EventHandler(looper);
    }

    public void setPrivateData(byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.setPrivateData(data);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public Session openSession() throws MediaCasException {
        this.validateInternalStates();
        try {
            return this.createFromSessionId(this.mICas.openSession());
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
        return null;
    }

    public void processEmm(byte[] data, int offset, int length) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mCasData.set(data, offset, length);
            this.mICas.processEmm(this.mCasData);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void processEmm(byte[] data) throws MediaCasException {
        this.processEmm(data, 0, data.length);
    }

    public void sendEvent(int event, int arg, byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.sendEvent(event, arg, data);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void provision(String provisionString) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.provision(provisionString);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void refreshEntitlements(int refreshType, byte[] refreshData) throws MediaCasException {
        this.validateInternalStates();
        try {
            this.mICas.refreshEntitlements(refreshType, refreshData);
        }
        catch (ServiceSpecificException e) {
            MediaCasException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    @Override
    public void close() {
        if (this.mICas != null) {
            try {
                this.mICas.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mICas = null;
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public static interface EventListener {
        public void onEvent(MediaCas var1, int var2, int var3, byte[] var4);
    }

    static class ParcelableCasPluginDescriptor
    extends PluginDescriptor
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableCasPluginDescriptor> CREATOR = new Parcelable.Creator<ParcelableCasPluginDescriptor>(){

            @Override
            public ParcelableCasPluginDescriptor createFromParcel(Parcel in) {
                int CA_system_id = in.readInt();
                String name = in.readString();
                return new ParcelableCasPluginDescriptor(CA_system_id, name);
            }

            public ParcelableCasPluginDescriptor[] newArray(int size) {
                return new ParcelableCasPluginDescriptor[size];
            }
        };

        private ParcelableCasPluginDescriptor(int CA_system_id, String name) {
            super(CA_system_id, name);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            Log.w(MediaCas.TAG, "ParcelableCasPluginDescriptor.writeToParcel shouldn't be called!");
        }
    }

    public final class Session
    implements AutoCloseable {
        final byte[] mSessionId;

        Session(byte[] sessionId) {
            this.mSessionId = sessionId;
        }

        public void setPrivateData(byte[] data) throws MediaCasException {
            MediaCas.this.validateInternalStates();
            try {
                MediaCas.this.mICas.setSessionPrivateData(this.mSessionId, data);
            }
            catch (ServiceSpecificException e) {
                MediaCasException.throwExceptions(e);
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(byte[] data, int offset, int length) throws MediaCasException {
            MediaCas.this.validateInternalStates();
            try {
                MediaCas.this.mCasData.set(data, offset, length);
                MediaCas.this.mICas.processEcm(this.mSessionId, MediaCas.this.mCasData);
            }
            catch (ServiceSpecificException e) {
                MediaCasException.throwExceptions(e);
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(byte[] data) throws MediaCasException {
            this.processEcm(data, 0, data.length);
        }

        @Override
        public void close() {
            MediaCas.this.validateInternalStates();
            try {
                MediaCas.this.mICas.closeSession(this.mSessionId);
            }
            catch (ServiceSpecificException e) {
                MediaCasStateException.throwExceptions(e);
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }
    }

    public static class PluginDescriptor {
        private final int mCASystemId;
        private final String mName;

        private PluginDescriptor() {
            this.mCASystemId = 65535;
            this.mName = null;
        }

        PluginDescriptor(int CA_system_id, String name) {
            this.mCASystemId = CA_system_id;
            this.mName = name;
        }

        public int getSystemId() {
            return this.mCASystemId;
        }

        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "PluginDescriptor {" + this.mCASystemId + ", " + this.mName + "}";
        }
    }

    static class ParcelableCasData
    implements Parcelable {
        private byte[] mData = null;
        private int mOffset = 0;
        private int mLength = 0;
        public static final Parcelable.Creator<ParcelableCasData> CREATOR = new Parcelable.Creator<ParcelableCasData>(){

            @Override
            public ParcelableCasData createFromParcel(Parcel in) {
                return new ParcelableCasData(in);
            }

            public ParcelableCasData[] newArray(int size) {
                return new ParcelableCasData[size];
            }
        };

        ParcelableCasData() {
        }

        private ParcelableCasData(Parcel in) {
            this();
        }

        void set(byte[] data, int offset, int length) {
            this.mData = data;
            this.mOffset = offset;
            this.mLength = length;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByteArray(this.mData, this.mOffset, this.mLength);
        }
    }

    private class EventHandler
    extends Handler {
        private static final int MSG_CAS_EVENT = 0;

        public EventHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                MediaCas.this.mListener.onEvent(MediaCas.this, msg.arg1, msg.arg2, (byte[])msg.obj);
            }
        }
    }
}

