/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.ServiceSpecificException;

public class MediaCasStateException
extends IllegalStateException {
    private final int mErrorCode;
    private final String mDiagnosticInfo;

    public MediaCasStateException(int err, String msg, String diagnosticInfo) {
        super(msg);
        this.mErrorCode = err;
        this.mDiagnosticInfo = diagnosticInfo;
    }

    static void throwExceptions(ServiceSpecificException e) {
        String diagnosticInfo = "";
        switch (e.errorCode) {
            case -2000: {
                diagnosticInfo = "General CAS error";
                break;
            }
            case -2001: {
                diagnosticInfo = "No license";
                break;
            }
            case -2002: {
                diagnosticInfo = "License expired";
                break;
            }
            case -2003: {
                diagnosticInfo = "Session not opened";
                break;
            }
            case -2004: {
                diagnosticInfo = "Not initialized";
                break;
            }
            case -2005: {
                diagnosticInfo = "Decrypt error";
                break;
            }
            case -2006: {
                diagnosticInfo = "Unsupported scheme or data format";
                break;
            }
            case -2007: {
                diagnosticInfo = "Tamper detected";
                break;
            }
            default: {
                diagnosticInfo = "Unknown CAS state exception";
            }
        }
        throw new MediaCasStateException(e.errorCode, e.getMessage(), String.format("%s (err=%d)", diagnosticInfo, e.errorCode));
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public String getDiagnosticInfo() {
        return this.mDiagnosticInfo;
    }
}

