/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.graphics.Rect;
import android.media.AudioSystem;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaDescrambler;
import android.media.MediaFormat;
import android.media.Utils;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.view.Surface;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MediaCodec {
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int BUFFER_FLAG_KEY_FRAME = 1;
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int BUFFER_FLAG_PARTIAL_FRAME = 8;
    private EventHandler mEventHandler;
    private EventHandler mOnFrameRenderedHandler;
    private EventHandler mCallbackHandler;
    private Callback mCallback;
    private OnFrameRenderedListener mOnFrameRenderedListener;
    private Object mListenerLock = new Object();
    private static final int EVENT_CALLBACK = 1;
    private static final int EVENT_SET_CALLBACK = 2;
    private static final int EVENT_FRAME_RENDERED = 3;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_ERROR = 3;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    private boolean mHasSurface = false;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int CRYPTO_MODE_AES_CBC = 2;
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    private ByteBuffer[] mCachedInputBuffers;
    private ByteBuffer[] mCachedOutputBuffers;
    private final BufferMap mDequeuedInputBuffers = new BufferMap();
    private final BufferMap mDequeuedOutputBuffers = new BufferMap();
    private final Map<Integer, BufferInfo> mDequeuedOutputInfos = new HashMap<Integer, BufferInfo>();
    private final Object mBufferLock;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    private long mNativeContext;

    public static MediaCodec createDecoderByType(String type) throws IOException {
        return new MediaCodec(type, true, false);
    }

    public static MediaCodec createEncoderByType(String type) throws IOException {
        return new MediaCodec(type, true, true);
    }

    public static MediaCodec createByCodecName(String name) throws IOException {
        return new MediaCodec(name, false, false);
    }

    private MediaCodec(String name, boolean nameIsType, boolean encoder) {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mCallbackHandler = this.mEventHandler;
        this.mOnFrameRenderedHandler = this.mEventHandler;
        this.mBufferLock = new Object();
        this.native_setup(name, nameIsType, encoder);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public final void reset() {
        this.freeAllTrackedBuffers();
        this.native_reset();
    }

    private final native void native_reset();

    public final void release() {
        this.freeAllTrackedBuffers();
        this.native_release();
    }

    private final native void native_release();

    public void configure(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        this.configure(format, surface, crypto, null, flags);
    }

    public void configure(MediaFormat format, Surface surface, int flags, MediaDescrambler descrambler) {
        this.configure(format, surface, null, descrambler != null ? descrambler.getBinder() : null, flags);
    }

    private void configure(MediaFormat format, Surface surface, MediaCrypto crypto, IBinder descramblerBinder, int flags) {
        if (crypto != null && descramblerBinder != null) {
            throw new IllegalArgumentException("Can't use crypto and descrambler together!");
        }
        String[] keys = null;
        Object[] values = null;
        if (format != null) {
            Map<String, Object> formatMap = format.getMap();
            keys = new String[formatMap.size()];
            values = new Object[formatMap.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                if (entry.getKey().equals("audio-session-id")) {
                    int sessionId = 0;
                    try {
                        sessionId = (Integer)entry.getValue();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Wrong Session ID Parameter!");
                    }
                    keys[i] = "audio-hw-sync";
                    values[i] = AudioSystem.getAudioHwSyncForSession(sessionId);
                } else {
                    keys[i] = entry.getKey();
                    values[i] = entry.getValue();
                }
                ++i;
            }
        }
        this.mHasSurface = surface != null;
        this.native_configure(keys, values, surface, crypto, descramblerBinder, flags);
    }

    public void setOutputSurface(Surface surface) {
        if (!this.mHasSurface) {
            throw new IllegalStateException("codec was not configured for an output surface");
        }
        this.native_setSurface(surface);
    }

    private native void native_setSurface(Surface var1);

    public static Surface createPersistentInputSurface() {
        return MediaCodec.native_createPersistentInputSurface();
    }

    public void setInputSurface(Surface surface) {
        if (!(surface instanceof PersistentSurface)) {
            throw new IllegalArgumentException("not a PersistentSurface");
        }
        this.native_setInputSurface(surface);
    }

    private static final native PersistentSurface native_createPersistentInputSurface();

    private static final native void native_releasePersistentInputSurface(Surface var0);

    private final native void native_setInputSurface(Surface var1);

    private final native void native_setCallback(Callback var1);

    private final native void native_configure(String[] var1, Object[] var2, Surface var3, MediaCrypto var4, IBinder var5, int var6);

    public final native Surface createInputSurface();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.native_start();
        Object object = this.mBufferLock;
        synchronized (object) {
            this.cacheBuffers(true);
            this.cacheBuffers(false);
        }
    }

    private final native void native_start();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.native_stop();
        this.freeAllTrackedBuffers();
        Object object = this.mListenerLock;
        synchronized (object) {
            if (this.mCallbackHandler != null) {
                this.mCallbackHandler.removeMessages(2);
                this.mCallbackHandler.removeMessages(1);
            }
            if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
        }
    }

    private final native void native_stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffers(this.mCachedInputBuffers);
            this.invalidateByteBuffers(this.mCachedOutputBuffers);
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
        this.native_flush();
    }

    private final native void native_flush();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private final native void native_queueInputBuffer(int var1, int var2, int var3, long var4, int var6) throws CryptoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private final native void native_queueSecureInputBuffer(int var1, int var2, CryptoInfo var3, long var4, int var6) throws CryptoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int dequeueInputBuffer(long timeoutUs) {
        int res = this.native_dequeueInputBuffer(timeoutUs);
        if (res >= 0) {
            Object object = this.mBufferLock;
            synchronized (object) {
                this.validateInputByteBuffer(this.mCachedInputBuffers, res);
            }
        }
        return res;
    }

    private final native int native_dequeueInputBuffer(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int dequeueOutputBuffer(BufferInfo info, long timeoutUs) {
        int res = this.native_dequeueOutputBuffer(info, timeoutUs);
        Object object = this.mBufferLock;
        synchronized (object) {
            if (res == -3) {
                this.cacheBuffers(false);
            } else if (res >= 0) {
                this.validateOutputByteBuffer(this.mCachedOutputBuffers, res, info);
                if (this.mHasSurface) {
                    this.mDequeuedOutputInfos.put(res, info.dup());
                }
            }
        }
        return res;
    }

    private final native int native_dequeueOutputBuffer(BufferInfo var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseOutputBuffer(int index, boolean render) {
        BufferInfo info = null;
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.remove(index);
            if (this.mHasSurface) {
                info = this.mDequeuedOutputInfos.remove(index);
            }
        }
        this.releaseOutputBuffer(index, render, false, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseOutputBuffer(int index, long renderTimestampNs) {
        BufferInfo info = null;
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.remove(index);
            if (this.mHasSurface) {
                info = this.mDequeuedOutputInfos.remove(index);
            }
        }
        this.releaseOutputBuffer(index, true, true, renderTimestampNs);
    }

    private final native void releaseOutputBuffer(int var1, boolean var2, boolean var3, long var4);

    public final native void signalEndOfInputStream();

    public final MediaFormat getOutputFormat() {
        return new MediaFormat(this.getFormatNative(false));
    }

    public final MediaFormat getInputFormat() {
        return new MediaFormat(this.getFormatNative(true));
    }

    public final MediaFormat getOutputFormat(int index) {
        return new MediaFormat(this.getOutputFormatNative(index));
    }

    private final native Map<String, Object> getFormatNative(boolean var1);

    private final native Map<String, Object> getOutputFormatNative(int var1);

    private final void invalidateByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(false);
        }
    }

    private final void validateInputByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void revalidateByteBuffer(ByteBuffer[] buffers, int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            ByteBuffer buffer;
            if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
                buffer.setAccessible(true);
            }
        }
    }

    private final void validateOutputByteBuffer(ByteBuffer[] buffers, int index, BufferInfo info) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.limit(info.offset + info.size).position(info.offset);
        }
    }

    private final void invalidateByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                if (buffer == null) continue;
                buffer.setAccessible(false);
            }
        }
    }

    private final void freeByteBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            NioUtils.freeDirectBuffer(buffer);
        }
    }

    private final void freeByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                this.freeByteBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void freeAllTrackedBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.freeByteBuffers(this.mCachedInputBuffers);
            this.freeByteBuffers(this.mCachedOutputBuffers);
            this.mCachedInputBuffers = null;
            this.mCachedOutputBuffers = null;
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
    }

    private final void cacheBuffers(boolean input) {
        ByteBuffer[] buffers = null;
        try {
            buffers = this.getBuffers(input);
            this.invalidateByteBuffers(buffers);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (input) {
            this.mCachedInputBuffers = buffers;
        } else {
            this.mCachedOutputBuffers = buffers;
        }
    }

    public ByteBuffer[] getInputBuffers() {
        if (this.mCachedInputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedInputBuffers;
    }

    public ByteBuffer[] getOutputBuffers() {
        if (this.mCachedOutputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedOutputBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getInputBuffer(int index) {
        ByteBuffer newBuffer = this.getBuffer(true, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getInputImage(int index) {
        Image newImage = this.getImage(true, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newImage);
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getOutputBuffer(int index) {
        ByteBuffer newBuffer = this.getBuffer(false, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getOutputImage(int index) {
        Image newImage = this.getImage(false, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newImage);
        }
        return newImage;
    }

    public final native void setVideoScalingMode(int var1);

    public final native String getName();

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private native PersistableBundle native_getMetrics();

    public final void setParameters(Bundle params) {
        if (params == null) {
            return;
        }
        String[] keys = new String[params.size()];
        Object[] values = new Object[params.size()];
        int i = 0;
        Iterator<String> iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            keys[i] = key = iterator.next();
            values[i] = params.get(key);
            ++i;
        }
        this.setParameters(keys, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback cb, Handler handler) {
        if (cb != null) {
            Object object = this.mListenerLock;
            synchronized (object) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mCallbackHandler);
                if (newHandler != this.mCallbackHandler) {
                    this.mCallbackHandler.removeMessages(2);
                    this.mCallbackHandler.removeMessages(1);
                    this.mCallbackHandler = newHandler;
                }
            }
        } else if (this.mCallbackHandler != null) {
            this.mCallbackHandler.removeMessages(2);
            this.mCallbackHandler.removeMessages(1);
        }
        if (this.mCallbackHandler != null) {
            Message msg = this.mCallbackHandler.obtainMessage(2, 0, 0, cb);
            this.mCallbackHandler.sendMessage(msg);
            this.native_setCallback(cb);
        }
    }

    public void setCallback(Callback cb) {
        this.setCallback(cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnFrameRenderedListener(OnFrameRenderedListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mOnFrameRenderedListener = listener;
            if (listener != null) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mOnFrameRenderedHandler);
                if (newHandler != this.mOnFrameRenderedHandler) {
                    this.mOnFrameRenderedHandler.removeMessages(3);
                }
                this.mOnFrameRenderedHandler = newHandler;
            } else if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
            this.native_enableOnFrameRenderedListener(listener != null);
        }
    }

    private native void native_enableOnFrameRenderedListener(boolean var1);

    private EventHandler getEventHandlerOn(Handler handler, EventHandler lastHandler) {
        if (handler == null) {
            return this.mEventHandler;
        }
        Looper looper = handler.getLooper();
        if (lastHandler.getLooper() == looper) {
            return lastHandler;
        }
        return new EventHandler(this, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEventFromNative(int what, int arg1, int arg2, Object obj) {
        Object object = this.mListenerLock;
        synchronized (object) {
            EventHandler handler = this.mEventHandler;
            if (what == 1) {
                handler = this.mCallbackHandler;
            } else if (what == 3) {
                handler = this.mOnFrameRenderedHandler;
            }
            if (handler != null) {
                Message msg = handler.obtainMessage(what, arg1, arg2, obj);
                handler.sendMessage(msg);
            }
        }
    }

    private final native void setParameters(String[] var1, Object[] var2);

    public MediaCodecInfo getCodecInfo() {
        return MediaCodecList.getInfoFor(this.getName());
    }

    private final native ByteBuffer[] getBuffers(boolean var1);

    private final native ByteBuffer getBuffer(boolean var1, int var2);

    private final native Image getImage(boolean var1, int var2);

    private static final native void native_init();

    private final native void native_setup(String var1, boolean var2, boolean var3);

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        MediaCodec.native_init();
    }

    public static final class MetricsConstants {
        public static final String CODEC = "android.media.mediacodec.codec";
        public static final String MIME_TYPE = "android.media.mediacodec.mime";
        public static final String MODE = "android.media.mediacodec.mode";
        public static final String MODE_AUDIO = "audio";
        public static final String MODE_VIDEO = "video";
        public static final String ENCODER = "android.media.mediacodec.encoder";
        public static final String SECURE = "android.media.mediacodec.secure";
        public static final String WIDTH = "android.media.mediacodec.width";
        public static final String HEIGHT = "android.media.mediacodec.height";
        public static final String ROTATION = "android.media.mediacodec.rotation";

        private MetricsConstants() {
        }
    }

    public static class MediaImage
    extends Image {
        private final boolean mIsReadOnly;
        private final int mWidth;
        private final int mHeight;
        private final int mFormat;
        private long mTimestamp;
        private final Image.Plane[] mPlanes;
        private final ByteBuffer mBuffer;
        private final ByteBuffer mInfo;
        private final int mXOffset;
        private final int mYOffset;
        private static final int TYPE_YUV = 1;

        @Override
        public int getFormat() {
            this.throwISEIfImageIsInvalid();
            return this.mFormat;
        }

        @Override
        public int getHeight() {
            this.throwISEIfImageIsInvalid();
            return this.mHeight;
        }

        @Override
        public int getWidth() {
            this.throwISEIfImageIsInvalid();
            return this.mWidth;
        }

        @Override
        public long getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.throwISEIfImageIsInvalid();
            return Arrays.copyOf(this.mPlanes, this.mPlanes.length);
        }

        @Override
        public void close() {
            if (this.mIsImageValid) {
                NioUtils.freeDirectBuffer(this.mBuffer);
                this.mIsImageValid = false;
            }
        }

        @Override
        public void setCropRect(Rect cropRect) {
            if (this.mIsReadOnly) {
                throw new ReadOnlyBufferException();
            }
            super.setCropRect(cropRect);
        }

        public MediaImage(ByteBuffer buffer, ByteBuffer info, boolean readOnly, long timestamp, int xOffset, int yOffset, Rect cropRect) {
            this.mFormat = 35;
            this.mTimestamp = timestamp;
            this.mIsImageValid = true;
            this.mIsReadOnly = buffer.isReadOnly();
            this.mBuffer = buffer.duplicate();
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            this.mInfo = info;
            if (info.remaining() == 104) {
                int type = info.getInt();
                if (type != 1) {
                    throw new UnsupportedOperationException("unsupported type: " + type);
                }
                int numPlanes = info.getInt();
                if (numPlanes != 3) {
                    throw new RuntimeException("unexpected number of planes: " + numPlanes);
                }
                this.mWidth = info.getInt();
                this.mHeight = info.getInt();
                if (this.mWidth < 1 || this.mHeight < 1) {
                    throw new UnsupportedOperationException("unsupported size: " + this.mWidth + "x" + this.mHeight);
                }
                int bitDepth = info.getInt();
                if (bitDepth != 8) {
                    throw new UnsupportedOperationException("unsupported bit depth: " + bitDepth);
                }
                int bitDepthAllocated = info.getInt();
                if (bitDepthAllocated != 8) {
                    throw new UnsupportedOperationException("unsupported allocated bit depth: " + bitDepthAllocated);
                }
                this.mPlanes = new MediaPlane[numPlanes];
                for (int ix = 0; ix < numPlanes; ++ix) {
                    int vert;
                    int planeOffset = info.getInt();
                    int colInc = info.getInt();
                    int rowInc = info.getInt();
                    int horiz = info.getInt();
                    if (horiz != (vert = info.getInt()) || horiz != (ix == 0 ? 1 : 2)) {
                        throw new UnsupportedOperationException("unexpected subsampling: " + horiz + "x" + vert + " on plane " + ix);
                    }
                    if (colInc < 1 || rowInc < 1) {
                        throw new UnsupportedOperationException("unexpected strides: " + colInc + " pixel, " + rowInc + " row on plane " + ix);
                    }
                    buffer.clear();
                    buffer.position(this.mBuffer.position() + planeOffset + xOffset / horiz * colInc + yOffset / vert * rowInc);
                    buffer.limit(buffer.position() + Utils.divUp(bitDepth, 8) + (this.mHeight / vert - 1) * rowInc + (this.mWidth / horiz - 1) * colInc);
                    this.mPlanes[ix] = new MediaPlane(buffer.slice(), rowInc, colInc);
                }
            } else {
                throw new UnsupportedOperationException("unsupported info length: " + info.remaining());
            }
            if (cropRect == null) {
                cropRect = new Rect(0, 0, this.mWidth, this.mHeight);
            }
            cropRect.offset(-xOffset, -yOffset);
            super.setCropRect(cropRect);
        }

        private class MediaPlane
        extends Image.Plane {
            private final int mRowInc;
            private final int mColInc;
            private final ByteBuffer mData;

            public MediaPlane(ByteBuffer buffer, int rowInc, int colInc) {
                this.mData = buffer;
                this.mRowInc = rowInc;
                this.mColInc = colInc;
            }

            @Override
            public int getRowStride() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mRowInc;
            }

            @Override
            public int getPixelStride() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mColInc;
            }

            @Override
            public ByteBuffer getBuffer() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mData;
            }
        }
    }

    public static abstract class Callback {
        public abstract void onInputBufferAvailable(MediaCodec var1, int var2);

        public abstract void onOutputBufferAvailable(MediaCodec var1, int var2, BufferInfo var3);

        public abstract void onError(MediaCodec var1, CodecException var2);

        public abstract void onOutputFormatChanged(MediaCodec var1, MediaFormat var2);
    }

    public static interface OnFrameRenderedListener {
        public void onFrameRendered(MediaCodec var1, long var2, long var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L})
    public static @interface VideoScalingMode {
    }

    private static class BufferMap {
        private final Map<Integer, CodecBuffer> mMap = new HashMap<Integer, CodecBuffer>();

        private BufferMap() {
        }

        public void remove(int index) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer != null) {
                buffer.free();
                this.mMap.remove(index);
            }
        }

        public void put(int index, ByteBuffer newBuffer) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setByteBuffer(newBuffer);
        }

        public void put(int index, Image newImage) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setImage(newImage);
        }

        public void clear() {
            for (CodecBuffer buffer : this.mMap.values()) {
                buffer.free();
            }
            this.mMap.clear();
        }

        private static class CodecBuffer {
            private Image mImage;
            private ByteBuffer mByteBuffer;

            private CodecBuffer() {
            }

            public void free() {
                if (this.mByteBuffer != null) {
                    NioUtils.freeDirectBuffer(this.mByteBuffer);
                    this.mByteBuffer = null;
                }
                if (this.mImage != null) {
                    this.mImage.close();
                    this.mImage = null;
                }
            }

            public void setImage(Image image) {
                this.free();
                this.mImage = image;
            }

            public void setByteBuffer(ByteBuffer buffer) {
                this.free();
                this.mByteBuffer = buffer;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={-1L, -2L, -3L})
    public static @interface OutputBufferInfo {
    }

    public static final class CryptoInfo {
        public int numSubSamples;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public byte[] key;
        public byte[] iv;
        public int mode;
        private Pattern pattern;

        public void set(int newNumSubSamples, int[] newNumBytesOfClearData, int[] newNumBytesOfEncryptedData, byte[] newKey, byte[] newIV, int newMode) {
            this.numSubSamples = newNumSubSamples;
            this.numBytesOfClearData = newNumBytesOfClearData;
            this.numBytesOfEncryptedData = newNumBytesOfEncryptedData;
            this.key = newKey;
            this.iv = newIV;
            this.mode = newMode;
            this.pattern = new Pattern(0, 0);
        }

        public void setPattern(Pattern newPattern) {
            this.pattern = newPattern;
        }

        public String toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(this.numSubSamples + " subsamples, key [");
            String hexdigits = "0123456789abcdef";
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.key[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.key[i] & 0xF));
            }
            builder.append("], iv [");
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.iv[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.iv[i] & 0xF));
            }
            builder.append("], clear ");
            builder.append(Arrays.toString(this.numBytesOfClearData));
            builder.append(", encrypted ");
            builder.append(Arrays.toString(this.numBytesOfEncryptedData));
            return builder.toString();
        }

        public static final class Pattern {
            private int mEncryptBlocks;
            private int mSkipBlocks;

            public Pattern(int blocksToEncrypt, int blocksToSkip) {
                this.set(blocksToEncrypt, blocksToSkip);
            }

            public void set(int blocksToEncrypt, int blocksToSkip) {
                this.mEncryptBlocks = blocksToEncrypt;
                this.mSkipBlocks = blocksToSkip;
            }

            public int getSkipBlocks() {
                return this.mSkipBlocks;
            }

            public int getEncryptBlocks() {
                return this.mEncryptBlocks;
            }
        }
    }

    public static final class CryptoException
    extends RuntimeException {
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_RESOURCE_BUSY = 3;
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        public static final int ERROR_SESSION_NOT_OPENED = 5;
        public static final int ERROR_UNSUPPORTED_OPERATION = 6;
        private int mErrorCode;

        public CryptoException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={1L, 2L, 3L, 4L, 5L, 6L})
        public static @interface CryptoErrorCode {
        }
    }

    public static final class CodecException
    extends IllegalStateException {
        public static final int ERROR_INSUFFICIENT_RESOURCE = 1100;
        public static final int ERROR_RECLAIMED = 1101;
        private static final int ACTION_TRANSIENT = 1;
        private static final int ACTION_RECOVERABLE = 2;
        private final String mDiagnosticInfo;
        private final int mErrorCode;
        private final int mActionCode;

        CodecException(int errorCode, int actionCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
            this.mActionCode = actionCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaCodec.error_" + sign + Math.abs(errorCode);
        }

        public boolean isTransient() {
            return this.mActionCode == 1;
        }

        public boolean isRecoverable() {
            return this.mActionCode == 2;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={1100L, 1101L})
        public static @interface ReasonCode {
        }
    }

    static class PersistentSurface
    extends Surface {
        private long mPersistentObject;

        PersistentSurface() {
        }

        @Override
        public void release() {
            MediaCodec.native_releasePersistentInputSurface(this);
            super.release();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L})
    public static @interface ConfigureFlag {
    }

    private class EventHandler
    extends Handler {
        private MediaCodec mCodec;

        public EventHandler(MediaCodec codec, Looper looper) {
            super(looper);
            this.mCodec = codec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.handleCallback(msg);
                    break;
                }
                case 2: {
                    MediaCodec.this.mCallback = (Callback)msg.obj;
                    break;
                }
                case 3: {
                    Object object = MediaCodec.this.mListenerLock;
                    synchronized (object) {
                        Map map = (Map)msg.obj;
                        int i = 0;
                        while (true) {
                            Object mediaTimeUs = map.get(i + "-media-time-us");
                            Object systemNano = map.get(i + "-system-nano");
                            if (mediaTimeUs == null || systemNano == null || MediaCodec.this.mOnFrameRenderedListener == null) break;
                            MediaCodec.this.mOnFrameRenderedListener.onFrameRendered(this.mCodec, (Long)mediaTimeUs, (Long)systemNano);
                            ++i;
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCallback(Message msg) {
            if (MediaCodec.this.mCallback == null) {
                return;
            }
            switch (msg.arg1) {
                case 1: {
                    int index = msg.arg2;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        MediaCodec.this.validateInputByteBuffer(MediaCodec.this.mCachedInputBuffers, index);
                    }
                    MediaCodec.this.mCallback.onInputBufferAvailable(this.mCodec, index);
                    break;
                }
                case 2: {
                    int index = msg.arg2;
                    BufferInfo info = (BufferInfo)msg.obj;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        MediaCodec.this.validateOutputByteBuffer(MediaCodec.this.mCachedOutputBuffers, index, info);
                    }
                    MediaCodec.this.mCallback.onOutputBufferAvailable(this.mCodec, index, info);
                    break;
                }
                case 3: {
                    MediaCodec.this.mCallback.onError(this.mCodec, (CodecException)msg.obj);
                    break;
                }
                case 4: {
                    MediaCodec.this.mCallback.onOutputFormatChanged(this.mCodec, new MediaFormat((Map)msg.obj));
                    break;
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 1L, 2L, 4L, 8L})
    public static @interface BufferFlag {
    }

    public static final class BufferInfo {
        public int offset;
        public int size;
        public long presentationTimeUs;
        public int flags;

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            this.offset = newOffset;
            this.size = newSize;
            this.presentationTimeUs = newTimeUs;
            this.flags = newFlags;
        }

        public BufferInfo dup() {
            BufferInfo copy = new BufferInfo();
            copy.set(this.offset, this.size, this.presentationTimeUs, this.flags);
            return copy;
        }
    }
}

