/*
 * Decompiled with CFR 0.152.
 */
package android.metrics;

import android.metrics.LogMaker;
import android.util.EventLog;
import com.android.internal.logging.MetricsLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class MetricsReader {
    private Queue<LogMaker> mPendingQueue = new LinkedList<LogMaker>();
    private Queue<LogMaker> mSeenQueue = new LinkedList<LogMaker>();
    private int[] LOGTAGS = new int[]{524292};
    private LogReader mReader = new LogReader();
    private int mCheckpointTag = -1;

    public void setLogReader(LogReader reader) {
        this.mReader = reader;
    }

    public void read(long horizonMs) {
        ArrayList<Event> nativeEvents = new ArrayList<Event>();
        try {
            this.mReader.readEvents(this.LOGTAGS, horizonMs, nativeEvents);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mPendingQueue.clear();
        this.mSeenQueue.clear();
        for (Event event : nativeEvents) {
            long eventTimestampMs = event.getTimeMillis();
            Object data = event.getData();
            Object[] objects = data instanceof Object[] ? (Object[])data : new Object[]{data};
            LogMaker log = new LogMaker(objects).setTimestamp(eventTimestampMs).setUid(event.getUid()).setProcessId(event.getProcessId());
            if (log.getCategory() == 920) {
                if (log.getSubtype() != this.mCheckpointTag) continue;
                this.mPendingQueue.clear();
                continue;
            }
            this.mPendingQueue.offer(log);
        }
    }

    public void checkpoint() {
        this.mCheckpointTag = (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
        this.mReader.writeCheckpoint(this.mCheckpointTag);
        this.mPendingQueue.clear();
        this.mSeenQueue.clear();
    }

    public void reset() {
        this.mSeenQueue.addAll(this.mPendingQueue);
        this.mPendingQueue.clear();
        this.mCheckpointTag = -1;
        Queue<LogMaker> tmp = this.mPendingQueue;
        this.mPendingQueue = this.mSeenQueue;
        this.mSeenQueue = tmp;
    }

    public boolean hasNext() {
        return !this.mPendingQueue.isEmpty();
    }

    public LogMaker next() {
        LogMaker next = this.mPendingQueue.poll();
        if (next != null) {
            this.mSeenQueue.offer(next);
        }
        return next;
    }

    public static class LogReader {
        public void readEvents(int[] tags, long horizonMs, Collection<Event> events) throws IOException {
            ArrayList<EventLog.Event> nativeEvents = new ArrayList<EventLog.Event>();
            long horizonNs = TimeUnit.NANOSECONDS.convert(horizonMs, TimeUnit.MILLISECONDS);
            EventLog.readEventsOnWrapping(tags, horizonNs, nativeEvents);
            for (EventLog.Event nativeEvent : nativeEvents) {
                Event event = new Event(nativeEvent);
                events.add(event);
            }
        }

        public void writeCheckpoint(int tag) {
            MetricsLogger logger = new MetricsLogger();
            logger.action(920, tag);
        }
    }

    public static class Event {
        long mTimeMillis;
        int mPid;
        int mUid;
        Object mData;

        public Event(long timeMillis, int pid, int uid, Object data) {
            this.mTimeMillis = timeMillis;
            this.mPid = pid;
            this.mUid = uid;
            this.mData = data;
        }

        Event(EventLog.Event nativeEvent) {
            this.mTimeMillis = TimeUnit.MILLISECONDS.convert(nativeEvent.getTimeNanos(), TimeUnit.NANOSECONDS);
            this.mPid = nativeEvent.getProcessId();
            this.mUid = nativeEvent.getUid();
            this.mData = nativeEvent.getData();
        }

        public long getTimeMillis() {
            return this.mTimeMillis;
        }

        public int getProcessId() {
            return this.mPid;
        }

        public int getUid() {
            return this.mUid;
        }

        public Object getData() {
            return this.mData;
        }

        public void setData(Object data) {
            this.mData = data;
        }
    }
}

