/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpSecAlgorithm;
import android.net.Network;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpSecConfig
implements Parcelable {
    private static final String TAG = "IpSecConfig";
    int mode;
    InetAddress localAddress;
    InetAddress remoteAddress;
    Network network;
    Flow[] flow = new Flow[]{new Flow(), new Flow()};
    int encapType;
    int encapLocalPort;
    int encapRemotePort;
    int nattKeepaliveInterval;
    public static final Parcelable.Creator<IpSecConfig> CREATOR = new Parcelable.Creator<IpSecConfig>(){

        @Override
        public IpSecConfig createFromParcel(Parcel in) {
            return new IpSecConfig(in);
        }

        public IpSecConfig[] newArray(int size) {
            return new IpSecConfig[size];
        }
    };

    public int getMode() {
        return this.mode;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getSpi(int direction) {
        return this.flow[direction].spi;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public IpSecAlgorithm getEncryption(int direction) {
        return this.flow[direction].encryption;
    }

    public IpSecAlgorithm getAuthentication(int direction) {
        return this.flow[direction].authentication;
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getEncapType() {
        return this.encapType;
    }

    public int getEncapLocalPort() {
        return this.encapLocalPort;
    }

    public int getEncapRemotePort() {
        return this.encapRemotePort;
    }

    public int getNattKeepaliveInterval() {
        return this.nattKeepaliveInterval;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.localAddress != null ? this.localAddress.getHostAddress() : null);
        out.writeString(this.remoteAddress != null ? this.remoteAddress.getHostAddress() : null);
        out.writeParcelable(this.network, flags);
        out.writeInt(this.flow[0].spi);
        out.writeParcelable(this.flow[0].encryption, flags);
        out.writeParcelable(this.flow[0].authentication, flags);
        out.writeInt(this.flow[1].spi);
        out.writeParcelable(this.flow[1].encryption, flags);
        out.writeParcelable(this.flow[1].authentication, flags);
        out.writeInt(this.encapType);
        out.writeInt(this.encapLocalPort);
        out.writeInt(this.encapRemotePort);
    }

    IpSecConfig() {
    }

    private static InetAddress readInetAddressFromParcel(Parcel in) {
        String addrString = in.readString();
        if (addrString == null) {
            return null;
        }
        try {
            return InetAddress.getByName(addrString);
        }
        catch (UnknownHostException e) {
            Log.wtf(TAG, "Invalid IpAddress " + addrString);
            return null;
        }
    }

    private IpSecConfig(Parcel in) {
        this.localAddress = IpSecConfig.readInetAddressFromParcel(in);
        this.remoteAddress = IpSecConfig.readInetAddressFromParcel(in);
        this.network = (Network)in.readParcelable(Network.class.getClassLoader());
        this.flow[0].spi = in.readInt();
        this.flow[0].encryption = (IpSecAlgorithm)in.readParcelable(IpSecAlgorithm.class.getClassLoader());
        this.flow[0].authentication = (IpSecAlgorithm)in.readParcelable(IpSecAlgorithm.class.getClassLoader());
        this.flow[1].spi = in.readInt();
        this.flow[1].encryption = (IpSecAlgorithm)in.readParcelable(IpSecAlgorithm.class.getClassLoader());
        this.flow[1].authentication = (IpSecAlgorithm)in.readParcelable(IpSecAlgorithm.class.getClassLoader());
        this.encapType = in.readInt();
        this.encapLocalPort = in.readInt();
        this.encapRemotePort = in.readInt();
    }

    public static class Flow {
        int spi;
        IpSecAlgorithm encryption;
        IpSecAlgorithm authentication;
    }
}

