/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.INetworkRecommendationProvider;
import android.net.NetworkKey;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.concurrent.Executor;

public abstract class NetworkRecommendationProvider {
    private static final String TAG = "NetworkRecProvider";
    private static final boolean VERBOSE = Build.IS_DEBUGGABLE && Log.isLoggable("NetworkRecProvider", 2);
    private final IBinder mService;

    public NetworkRecommendationProvider(Context context, Executor executor) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(executor);
        this.mService = new ServiceWrapper(context, executor);
    }

    public abstract void onRequestScores(NetworkKey[] var1);

    public final IBinder getBinder() {
        return this.mService;
    }

    private final class ServiceWrapper
    extends INetworkRecommendationProvider.Stub {
        private final Context mContext;
        private final Executor mExecutor;
        private final Handler mHandler;

        ServiceWrapper(Context context, Executor executor) {
            this.mContext = context;
            this.mExecutor = executor;
            this.mHandler = null;
        }

        @Override
        public void requestScores(final NetworkKey[] networks) throws RemoteException {
            this.enforceCallingPermission();
            if (networks != null && networks.length > 0) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        NetworkRecommendationProvider.this.onRequestScores(networks);
                    }
                });
            }
        }

        private void execute(Runnable command) {
            if (this.mExecutor != null) {
                this.mExecutor.execute(command);
            } else {
                this.mHandler.post(command);
            }
        }

        private void enforceCallingPermission() {
            if (this.mContext != null) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES", "Permission denied.");
            }
        }
    }
}

