/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.NetworkCapabilities;
import com.android.internal.util.BitUtils;
import java.util.Arrays;

public final class DnsEvent {
    private static final int SIZE_LIMIT = 20000;
    public final int netId;
    public final long transports;
    public int eventCount;
    public byte[] eventTypes;
    public byte[] returnCodes;
    public int[] latenciesMs;

    public DnsEvent(int netId, long transports, int initialCapacity) {
        this.netId = netId;
        this.transports = transports;
        this.eventTypes = new byte[initialCapacity];
        this.returnCodes = new byte[initialCapacity];
        this.latenciesMs = new int[initialCapacity];
    }

    public void addResult(byte eventType, byte returnCode, int latencyMs) {
        if (this.eventCount >= 20000) {
            return;
        }
        if (this.eventCount == this.eventTypes.length) {
            this.resize((int)(1.4 * (double)this.eventCount));
        }
        this.eventTypes[this.eventCount] = eventType;
        this.returnCodes[this.eventCount] = returnCode;
        this.latenciesMs[this.eventCount] = latencyMs;
        ++this.eventCount;
    }

    public void resize(int newLength) {
        this.eventTypes = Arrays.copyOf(this.eventTypes, newLength);
        this.returnCodes = Arrays.copyOf(this.returnCodes, newLength);
        this.latenciesMs = Arrays.copyOf(this.latenciesMs, newLength);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DnsEvent(").append(this.netId).append(", ");
        for (int t : BitUtils.unpackBits(this.transports)) {
            builder.append(NetworkCapabilities.transportNameOf(t)).append(", ");
        }
        return builder.append(this.eventCount).append(" events)").toString();
    }
}

