/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.INetworkScoreCache;
import android.net.NetworkKey;
import android.net.ScoredNetwork;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Process;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WifiNetworkScoreCache
extends INetworkScoreCache.Stub {
    private static final String TAG = "WifiNetworkScoreCache";
    private static final boolean DBG = Log.isLoggable("WifiNetworkScoreCache", 3);
    public static final int INVALID_NETWORK_SCORE = -128;
    @GuardedBy(value="mCacheLock")
    private CacheListener mListener;
    private final Context mContext;
    private final Object mCacheLock = new Object();
    private final Map<String, ScoredNetwork> mNetworkCache;

    public WifiNetworkScoreCache(Context context) {
        this(context, null);
    }

    public WifiNetworkScoreCache(Context context, CacheListener listener) {
        this.mContext = context.getApplicationContext();
        this.mListener = listener;
        this.mNetworkCache = new HashMap<String, ScoredNetwork>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateScores(List<ScoredNetwork> networks) {
        if (networks == null || networks.isEmpty()) {
            return;
        }
        if (DBG) {
            Log.d(TAG, "updateScores list size=" + networks.size());
        }
        boolean changed = false;
        Object object = this.mNetworkCache;
        synchronized (object) {
            for (ScoredNetwork network : networks) {
                String networkKey = this.buildNetworkKey(network);
                if (networkKey == null) {
                    if (!DBG) continue;
                    Log.d(TAG, "Failed to build network key for ScoredNetwork" + network);
                    continue;
                }
                this.mNetworkCache.put(networkKey, network);
                changed = true;
            }
        }
        object = this.mCacheLock;
        synchronized (object) {
            if (this.mListener != null && changed) {
                this.mListener.post(networks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearScores() {
        Map<String, ScoredNetwork> map = this.mNetworkCache;
        synchronized (map) {
            this.mNetworkCache.clear();
        }
    }

    public boolean isScoredNetwork(ScanResult result) {
        return this.getScoredNetwork(result) != null;
    }

    public boolean hasScoreCurve(ScanResult result) {
        ScoredNetwork network = this.getScoredNetwork(result);
        return network != null && network.rssiCurve != null;
    }

    public int getNetworkScore(ScanResult result) {
        int score = -128;
        ScoredNetwork network = this.getScoredNetwork(result);
        if (network != null && network.rssiCurve != null) {
            score = network.rssiCurve.lookupScore(result.level);
            if (DBG) {
                Log.d(TAG, "getNetworkScore found scored network " + network.networkKey + " score " + Integer.toString(score) + " RSSI " + result.level);
            }
        }
        return score;
    }

    public boolean getMeteredHint(ScanResult result) {
        ScoredNetwork network = this.getScoredNetwork(result);
        return network != null && network.meteredHint;
    }

    public int getNetworkScore(ScanResult result, boolean isActiveNetwork) {
        int score = -128;
        ScoredNetwork network = this.getScoredNetwork(result);
        if (network != null && network.rssiCurve != null) {
            score = network.rssiCurve.lookupScore(result.level, isActiveNetwork);
            if (DBG) {
                Log.d(TAG, "getNetworkScore found scored network " + network.networkKey + " score " + Integer.toString(score) + " RSSI " + result.level + " isActiveNetwork " + isActiveNetwork);
            }
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoredNetwork getScoredNetwork(ScanResult result) {
        String key = this.buildNetworkKey(result);
        if (key == null) {
            return null;
        }
        Map<String, ScoredNetwork> map = this.mNetworkCache;
        synchronized (map) {
            ScoredNetwork network = this.mNetworkCache.get(key);
            return network;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoredNetwork getScoredNetwork(NetworkKey networkKey) {
        String key = this.buildNetworkKey(networkKey);
        if (key == null) {
            if (DBG) {
                Log.d(TAG, "Could not build key string for Network Key: " + networkKey);
            }
            return null;
        }
        Map<String, ScoredNetwork> map = this.mNetworkCache;
        synchronized (map) {
            return this.mNetworkCache.get(key);
        }
    }

    private String buildNetworkKey(ScoredNetwork network) {
        if (network == null) {
            return null;
        }
        return this.buildNetworkKey(network.networkKey);
    }

    private String buildNetworkKey(NetworkKey networkKey) {
        if (networkKey == null) {
            return null;
        }
        if (networkKey.wifiKey == null) {
            return null;
        }
        if (networkKey.type == 1) {
            String key = networkKey.wifiKey.ssid;
            if (key == null) {
                return null;
            }
            if (networkKey.wifiKey.bssid != null) {
                key = key + networkKey.wifiKey.bssid;
            }
            return key;
        }
        return null;
    }

    private String buildNetworkKey(ScanResult result) {
        if (result == null || result.SSID == null) {
            return null;
        }
        StringBuilder key = new StringBuilder("\"");
        key.append(result.SSID);
        key.append("\"");
        if (result.BSSID != null) {
            key.append(result.BSSID);
        }
        return key.toString();
    }

    @Override
    protected final void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        String header = String.format("WifiNetworkScoreCache (%s/%d)", this.mContext.getPackageName(), Process.myUid());
        writer.println(header);
        writer.println("  All score curves:");
        for (ScoredNetwork score : this.mNetworkCache.values()) {
            writer.println("    " + score);
        }
        writer.println("  Current network scores:");
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        for (ScanResult scanResult : wifiManager.getScanResults()) {
            writer.println("    " + this.buildNetworkKey(scanResult) + ": " + this.getNetworkScore(scanResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(CacheListener listener) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener() {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mListener = null;
        }
    }

    public static abstract class CacheListener {
        private Handler mHandler;

        public CacheListener(Handler handler) {
            Preconditions.checkNotNull(handler);
            this.mHandler = handler;
        }

        void post(final List<ScoredNetwork> updatedNetworks) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    this.networkCacheUpdated(updatedNetworks);
                }
            });
        }

        public abstract void networkCacheUpdated(List<ScoredNetwork> var1);
    }
}

