/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public final class WifiAwareNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    public static final int NETWORK_SPECIFIER_TYPE_IB = 0;
    public static final int NETWORK_SPECIFIER_TYPE_IB_ANY_PEER = 1;
    public static final int NETWORK_SPECIFIER_TYPE_OOB = 2;
    public static final int NETWORK_SPECIFIER_TYPE_OOB_ANY_PEER = 3;
    public static final int NETWORK_SPECIFIER_TYPE_MAX_VALID = 3;
    public final int type;
    public final int role;
    public final int clientId;
    public final int sessionId;
    public final int peerId;
    public final byte[] peerMac;
    public final byte[] pmk;
    public final String passphrase;
    public static final Parcelable.Creator<WifiAwareNetworkSpecifier> CREATOR = new Parcelable.Creator<WifiAwareNetworkSpecifier>(){

        @Override
        public WifiAwareNetworkSpecifier createFromParcel(Parcel in) {
            return new WifiAwareNetworkSpecifier(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.createByteArray(), in.createByteArray(), in.readString());
        }

        public WifiAwareNetworkSpecifier[] newArray(int size) {
            return new WifiAwareNetworkSpecifier[size];
        }
    };

    public WifiAwareNetworkSpecifier(int type, int role, int clientId, int sessionId, int peerId, byte[] peerMac, byte[] pmk, String passphrase) {
        this.type = type;
        this.role = role;
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.peerId = peerId;
        this.peerMac = peerMac;
        this.pmk = pmk;
        this.passphrase = passphrase;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeInt(this.role);
        dest.writeInt(this.clientId);
        dest.writeInt(this.sessionId);
        dest.writeInt(this.peerId);
        dest.writeByteArray(this.peerMac);
        dest.writeByteArray(this.pmk);
        dest.writeString(this.passphrase);
    }

    @Override
    public boolean satisfiedBy(NetworkSpecifier other) {
        return this.equals(other);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.type;
        result = 31 * result + this.role;
        result = 31 * result + this.clientId;
        result = 31 * result + this.sessionId;
        result = 31 * result + this.peerId;
        result = 31 * result + Arrays.hashCode(this.peerMac);
        result = 31 * result + Arrays.hashCode(this.pmk);
        result = 31 * result + Objects.hashCode(this.passphrase);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiAwareNetworkSpecifier)) {
            return false;
        }
        WifiAwareNetworkSpecifier lhs = (WifiAwareNetworkSpecifier)obj;
        return this.type == lhs.type && this.role == lhs.role && this.clientId == lhs.clientId && this.sessionId == lhs.sessionId && this.peerId == lhs.peerId && Arrays.equals(this.peerMac, lhs.peerMac) && Arrays.equals(this.pmk, lhs.pmk) && Objects.equals(this.passphrase, lhs.passphrase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WifiAwareNetworkSpecifier [");
        sb.append("type=").append(this.type).append(", role=").append(this.role).append(", clientId=").append(this.clientId).append(", sessionId=").append(this.sessionId).append(", peerId=").append(this.peerId).append(", peerMac=").append(this.peerMac == null ? "<null>" : "<non-null>").append(", pmk=").append(this.pmk == null ? "<null>" : "<non-null>").append(", passphrase=").append(this.passphrase == null ? "<null>" : "<non-null>").append("]");
        return sb.toString();
    }
}

