/*
 * Decompiled with CFR 0.152.
 */
package android.os.health;

import android.content.Context;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.health.HealthStats;
import android.os.health.HealthStatsParceler;
import com.android.internal.app.IBatteryStats;

public class SystemHealthManager {
    private final IBatteryStats mBatteryStats;

    public SystemHealthManager() {
        this(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")));
    }

    public SystemHealthManager(IBatteryStats batteryStats) {
        this.mBatteryStats = batteryStats;
    }

    public static SystemHealthManager from(Context context) {
        return (SystemHealthManager)context.getSystemService("systemhealth");
    }

    public HealthStats takeUidSnapshot(int uid) {
        try {
            HealthStatsParceler parceler = this.mBatteryStats.takeUidSnapshot(uid);
            return parceler.getHealthStats();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public HealthStats takeMyUidSnapshot() {
        return this.takeUidSnapshot(Process.myUid());
    }

    public HealthStats[] takeUidSnapshots(int[] uids) {
        try {
            HealthStatsParceler[] parcelers = this.mBatteryStats.takeUidSnapshots(uids);
            HealthStats[] results = new HealthStats[uids.length];
            int N = uids.length;
            for (int i = 0; i < N; ++i) {
                results[i] = parcelers[i].getHealthStats();
            }
            return results;
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }
}

