/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.animation.LayoutTransition;
import android.app.Fragment;
import android.app.FragmentBreadCrumbs;
import android.app.FragmentTransaction;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class PreferenceActivity
extends ListActivity
implements PreferenceManager.OnPreferenceTreeClickListener,
PreferenceFragment.OnPreferenceStartFragmentCallback {
    private static final String TAG = "PreferenceActivity";
    private static final String HEADERS_TAG = ":android:headers";
    private static final String CUR_HEADER_TAG = ":android:cur_header";
    private static final String PREFERENCES_TAG = ":android:preferences";
    public static final String EXTRA_SHOW_FRAGMENT = ":android:show_fragment";
    public static final String EXTRA_SHOW_FRAGMENT_ARGUMENTS = ":android:show_fragment_args";
    public static final String EXTRA_SHOW_FRAGMENT_TITLE = ":android:show_fragment_title";
    public static final String EXTRA_SHOW_FRAGMENT_SHORT_TITLE = ":android:show_fragment_short_title";
    public static final String EXTRA_NO_HEADERS = ":android:no_headers";
    private static final String BACK_STACK_PREFS = ":android:prefs";
    private static final String EXTRA_PREFS_SHOW_BUTTON_BAR = "extra_prefs_show_button_bar";
    private static final String EXTRA_PREFS_SHOW_SKIP = "extra_prefs_show_skip";
    private static final String EXTRA_PREFS_SET_NEXT_TEXT = "extra_prefs_set_next_text";
    private static final String EXTRA_PREFS_SET_BACK_TEXT = "extra_prefs_set_back_text";
    private final ArrayList<Header> mHeaders = new ArrayList();
    private FrameLayout mListFooter;
    private ViewGroup mPrefsContainer;
    private CharSequence mActivityTitle;
    private ViewGroup mHeadersContainer;
    private FragmentBreadCrumbs mFragmentBreadCrumbs;
    private boolean mSinglePane;
    private Header mCurHeader;
    private PreferenceManager mPreferenceManager;
    private Bundle mSavedInstanceState;
    private Button mNextButton;
    private int mPreferenceHeaderItemResId = 0;
    private boolean mPreferenceHeaderRemoveEmptyIcon = false;
    private static final int FIRST_REQUEST_CODE = 100;
    private static final int MSG_BIND_PREFERENCES = 1;
    private static final int MSG_BUILD_HEADERS = 2;
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PreferenceActivity.this.bindPreferences();
                    break;
                }
                case 2: {
                    Header mappedHeader;
                    Header header;
                    ArrayList<Header> oldHeaders = new ArrayList<Header>(PreferenceActivity.this.mHeaders);
                    PreferenceActivity.this.mHeaders.clear();
                    PreferenceActivity.this.onBuildHeaders(PreferenceActivity.this.mHeaders);
                    if (PreferenceActivity.this.mAdapter instanceof BaseAdapter) {
                        ((BaseAdapter)PreferenceActivity.this.mAdapter).notifyDataSetChanged();
                    }
                    if ((header = PreferenceActivity.this.onGetNewHeader()) != null && header.fragment != null) {
                        Header mappedHeader2 = PreferenceActivity.this.findBestMatchingHeader(header, oldHeaders);
                        if (mappedHeader2 != null && PreferenceActivity.this.mCurHeader == mappedHeader2) break;
                        PreferenceActivity.this.switchToHeader(header);
                        break;
                    }
                    if (PreferenceActivity.this.mCurHeader == null || (mappedHeader = PreferenceActivity.this.findBestMatchingHeader(PreferenceActivity.this.mCurHeader, PreferenceActivity.this.mHeaders)) == null) break;
                    PreferenceActivity.this.setSelectedHeader(mappedHeader);
                }
            }
        }
    };
    public static final long HEADER_ID_UNDEFINED = -1L;

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TypedArray sa = this.obtainStyledAttributes(null, R.styleable.PreferenceActivity, 17891480, 0);
        int layoutResId = sa.getResourceId(0, 17367221);
        this.mPreferenceHeaderItemResId = sa.getResourceId(1, 17367215);
        this.mPreferenceHeaderRemoveEmptyIcon = sa.getBoolean(2, false);
        sa.recycle();
        this.setContentView(layoutResId);
        this.mListFooter = (FrameLayout)this.findViewById(16909013);
        this.mPrefsContainer = (ViewGroup)this.findViewById(16909167);
        this.mHeadersContainer = (ViewGroup)this.findViewById(16908926);
        boolean hidingHeaders = this.onIsHidingHeaders();
        this.mSinglePane = hidingHeaders || !this.onIsMultiPane();
        String initialFragment = this.getIntent().getStringExtra(EXTRA_SHOW_FRAGMENT);
        Bundle initialArguments = this.getIntent().getBundleExtra(EXTRA_SHOW_FRAGMENT_ARGUMENTS);
        int initialTitle = this.getIntent().getIntExtra(EXTRA_SHOW_FRAGMENT_TITLE, 0);
        int initialShortTitle = this.getIntent().getIntExtra(EXTRA_SHOW_FRAGMENT_SHORT_TITLE, 0);
        this.mActivityTitle = this.getTitle();
        if (savedInstanceState != null) {
            ArrayList headers = savedInstanceState.getParcelableArrayList(HEADERS_TAG);
            if (headers != null) {
                this.mHeaders.addAll(headers);
                int curHeader = savedInstanceState.getInt(CUR_HEADER_TAG, -1);
                if (curHeader >= 0 && curHeader < this.mHeaders.size()) {
                    this.setSelectedHeader(this.mHeaders.get(curHeader));
                } else if (!this.mSinglePane && initialFragment == null) {
                    this.switchToHeader(this.onGetInitialHeader());
                }
            } else {
                this.showBreadCrumbs(this.getTitle(), null);
            }
        } else {
            if (!this.onIsHidingHeaders()) {
                this.onBuildHeaders(this.mHeaders);
            }
            if (initialFragment != null) {
                this.switchToHeader(initialFragment, initialArguments);
            } else if (!this.mSinglePane && this.mHeaders.size() > 0) {
                this.switchToHeader(this.onGetInitialHeader());
            }
        }
        if (this.mHeaders.size() > 0) {
            this.setListAdapter(new HeaderAdapter((Context)this, this.mHeaders, this.mPreferenceHeaderItemResId, this.mPreferenceHeaderRemoveEmptyIcon));
            if (!this.mSinglePane) {
                this.getListView().setChoiceMode(1);
            }
        }
        if (this.mSinglePane && initialFragment != null && initialTitle != 0) {
            CharSequence initialTitleStr = this.getText(initialTitle);
            CharSequence initialShortTitleStr = initialShortTitle != 0 ? this.getText(initialShortTitle) : null;
            this.showBreadCrumbs(initialTitleStr, initialShortTitleStr);
        }
        if (this.mHeaders.size() == 0 && initialFragment == null) {
            this.setContentView(17367223);
            this.mListFooter = (FrameLayout)this.findViewById(16909013);
            this.mPrefsContainer = (ViewGroup)this.findViewById(16909165);
            this.mPreferenceManager = new PreferenceManager(this, 100);
            this.mPreferenceManager.setOnPreferenceTreeClickListener(this);
            this.mHeadersContainer = null;
        } else if (this.mSinglePane) {
            if (initialFragment != null || this.mCurHeader != null) {
                this.mHeadersContainer.setVisibility(8);
            } else {
                this.mPrefsContainer.setVisibility(8);
            }
            ViewGroup container = (ViewGroup)this.findViewById(16909166);
            container.setLayoutTransition(new LayoutTransition());
        } else if (this.mHeaders.size() > 0 && this.mCurHeader != null) {
            this.setSelectedHeader(this.mCurHeader);
        }
        Intent intent = this.getIntent();
        if (intent.getBooleanExtra(EXTRA_PREFS_SHOW_BUTTON_BAR, false)) {
            String buttonText;
            ((View)this.findViewById(16908758)).setVisibility(0);
            Button backButton = (Button)this.findViewById(16908732);
            backButton.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    PreferenceActivity.this.setResult(0);
                    PreferenceActivity.this.finish();
                }
            });
            Button skipButton = (Button)this.findViewById(16909277);
            skipButton.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    PreferenceActivity.this.setResult(-1);
                    PreferenceActivity.this.finish();
                }
            });
            this.mNextButton = (Button)this.findViewById(16909075);
            this.mNextButton.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    PreferenceActivity.this.setResult(-1);
                    PreferenceActivity.this.finish();
                }
            });
            if (intent.hasExtra(EXTRA_PREFS_SET_NEXT_TEXT)) {
                buttonText = intent.getStringExtra(EXTRA_PREFS_SET_NEXT_TEXT);
                if (TextUtils.isEmpty(buttonText)) {
                    this.mNextButton.setVisibility(8);
                } else {
                    this.mNextButton.setText(buttonText);
                }
            }
            if (intent.hasExtra(EXTRA_PREFS_SET_BACK_TEXT)) {
                buttonText = intent.getStringExtra(EXTRA_PREFS_SET_BACK_TEXT);
                if (TextUtils.isEmpty(buttonText)) {
                    backButton.setVisibility(8);
                } else {
                    backButton.setText(buttonText);
                }
            }
            if (intent.getBooleanExtra(EXTRA_PREFS_SHOW_SKIP, false)) {
                skipButton.setVisibility(0);
            }
        }
    }

    @Override
    public void onBackPressed() {
        if (this.mCurHeader != null && this.mSinglePane && this.getFragmentManager().getBackStackEntryCount() == 0 && this.getIntent().getStringExtra(EXTRA_SHOW_FRAGMENT) == null) {
            this.mCurHeader = null;
            this.mPrefsContainer.setVisibility(8);
            this.mHeadersContainer.setVisibility(0);
            if (this.mActivityTitle != null) {
                this.showBreadCrumbs(this.mActivityTitle, null);
            }
            this.getListView().clearChoices();
        } else {
            super.onBackPressed();
        }
    }

    public boolean hasHeaders() {
        return this.mHeadersContainer != null && this.mHeadersContainer.getVisibility() == 0;
    }

    public List<Header> getHeaders() {
        return this.mHeaders;
    }

    public boolean isMultiPane() {
        return !this.mSinglePane;
    }

    public boolean onIsMultiPane() {
        boolean preferMultiPane = this.getResources().getBoolean(17957071);
        return preferMultiPane;
    }

    public boolean onIsHidingHeaders() {
        return this.getIntent().getBooleanExtra(EXTRA_NO_HEADERS, false);
    }

    public Header onGetInitialHeader() {
        for (int i = 0; i < this.mHeaders.size(); ++i) {
            Header h = this.mHeaders.get(i);
            if (h.fragment == null) continue;
            return h;
        }
        throw new IllegalStateException("Must have at least one header with a fragment");
    }

    public Header onGetNewHeader() {
        return null;
    }

    public void onBuildHeaders(List<Header> target) {
    }

    public void invalidateHeaders() {
        if (!this.mHandler.hasMessages(2)) {
            this.mHandler.sendEmptyMessage(2);
        }
    }

    public void loadHeadersFromResource(int resid, List<Header> target) {
        try (XmlResourceParser parser = null;){
            int type;
            parser = this.getResources().getXml(resid);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"preference-headers".equals(nodeName)) {
                throw new RuntimeException("XML document must start with <preference-headers> tag; found" + nodeName + " at " + parser.getPositionDescription());
            }
            Bundle curBundle = null;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                nodeName = parser.getName();
                if ("header".equals(nodeName)) {
                    Header header = new Header();
                    TypedArray sa = this.obtainStyledAttributes(attrs, R.styleable.PreferenceHeader);
                    header.id = sa.getResourceId(1, -1);
                    TypedValue tv = sa.peekValue(2);
                    if (tv != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.titleRes = tv.resourceId;
                        } else {
                            header.title = tv.string;
                        }
                    }
                    if ((tv = sa.peekValue(3)) != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.summaryRes = tv.resourceId;
                        } else {
                            header.summary = tv.string;
                        }
                    }
                    if ((tv = sa.peekValue(5)) != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.breadCrumbTitleRes = tv.resourceId;
                        } else {
                            header.breadCrumbTitle = tv.string;
                        }
                    }
                    if ((tv = sa.peekValue(6)) != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.breadCrumbShortTitleRes = tv.resourceId;
                        } else {
                            header.breadCrumbShortTitle = tv.string;
                        }
                    }
                    header.iconRes = sa.getResourceId(0, 0);
                    header.fragment = sa.getString(4);
                    sa.recycle();
                    if (curBundle == null) {
                        curBundle = new Bundle();
                    }
                    int innerDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                        if (type == 3 || type == 4) continue;
                        String innerNodeName = parser.getName();
                        if (innerNodeName.equals("extra")) {
                            this.getResources().parseBundleExtra("extra", attrs, curBundle);
                            XmlUtils.skipCurrentTag(parser);
                            continue;
                        }
                        if (innerNodeName.equals("intent")) {
                            header.intent = Intent.parseIntent(this.getResources(), parser, attrs);
                            continue;
                        }
                        XmlUtils.skipCurrentTag(parser);
                    }
                    if (curBundle.size() > 0) {
                        header.fragmentArguments = curBundle;
                        curBundle = null;
                    }
                    target.add(header);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
            }
        }
    }

    protected boolean isValidFragment(String fragmentName) {
        if (this.getApplicationInfo().targetSdkVersion >= 19) {
            throw new RuntimeException("Subclasses of PreferenceActivity must override isValidFragment(String) to verify that the Fragment class is valid! " + this.getClass().getName() + " has not checked if fragment " + fragmentName + " is valid.");
        }
        return true;
    }

    public void setListFooter(View view) {
        this.mListFooter.removeAllViews();
        this.mListFooter.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityStop();
        }
    }

    @Override
    protected void onDestroy() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        super.onDestroy();
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityDestroy();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        PreferenceScreen preferenceScreen;
        super.onSaveInstanceState(outState);
        if (this.mHeaders.size() > 0) {
            int index;
            outState.putParcelableArrayList(HEADERS_TAG, this.mHeaders);
            if (this.mCurHeader != null && (index = this.mHeaders.indexOf(this.mCurHeader)) >= 0) {
                outState.putInt(CUR_HEADER_TAG, index);
            }
        }
        if (this.mPreferenceManager != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            Bundle container = new Bundle();
            preferenceScreen.saveHierarchyState(container);
            outState.putBundle(PREFERENCES_TAG, container);
        }
    }

    @Override
    protected void onRestoreInstanceState(Bundle state) {
        PreferenceScreen preferenceScreen;
        Bundle container;
        if (this.mPreferenceManager != null && (container = state.getBundle(PREFERENCES_TAG)) != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            preferenceScreen.restoreHierarchyState(container);
            this.mSavedInstanceState = state;
            return;
        }
        super.onRestoreInstanceState(state);
        if (!this.mSinglePane && this.mCurHeader != null) {
            this.setSelectedHeader(this.mCurHeader);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        if (this.mPreferenceManager != null) {
            this.postBindPreferences();
        }
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Object item;
        if (!this.isResumed()) {
            return;
        }
        super.onListItemClick(l, v, position, id2);
        if (this.mAdapter != null && (item = this.mAdapter.getItem(position)) instanceof Header) {
            this.onHeaderClick((Header)item, position);
        }
    }

    public void onHeaderClick(Header header, int position) {
        if (header.fragment != null) {
            this.switchToHeader(header);
        } else if (header.intent != null) {
            this.startActivity(header.intent);
        }
    }

    public Intent onBuildStartFragmentIntent(String fragmentName, Bundle args, int titleRes, int shortTitleRes) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setClass(this, this.getClass());
        intent.putExtra(EXTRA_SHOW_FRAGMENT, fragmentName);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_ARGUMENTS, args);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_TITLE, titleRes);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_SHORT_TITLE, shortTitleRes);
        intent.putExtra(EXTRA_NO_HEADERS, true);
        return intent;
    }

    public void startWithFragment(String fragmentName, Bundle args, Fragment resultTo, int resultRequestCode) {
        this.startWithFragment(fragmentName, args, resultTo, resultRequestCode, 0, 0);
    }

    public void startWithFragment(String fragmentName, Bundle args, Fragment resultTo, int resultRequestCode, int titleRes, int shortTitleRes) {
        Intent intent = this.onBuildStartFragmentIntent(fragmentName, args, titleRes, shortTitleRes);
        if (resultTo == null) {
            this.startActivity(intent);
        } else {
            resultTo.startActivityForResult(intent, resultRequestCode);
        }
    }

    public void showBreadCrumbs(CharSequence title, CharSequence shortTitle) {
        if (this.mFragmentBreadCrumbs == null) {
            Object crumbs = this.findViewById(16908310);
            try {
                this.mFragmentBreadCrumbs = (FragmentBreadCrumbs)crumbs;
            }
            catch (ClassCastException e) {
                this.setTitle(title);
                return;
            }
            if (this.mFragmentBreadCrumbs == null) {
                if (title != null) {
                    this.setTitle(title);
                }
                return;
            }
            if (this.mSinglePane) {
                this.mFragmentBreadCrumbs.setVisibility(8);
                Object bcSection = this.findViewById(16908747);
                if (bcSection != null) {
                    ((View)bcSection).setVisibility(8);
                }
                this.setTitle(title);
            }
            this.mFragmentBreadCrumbs.setMaxVisible(2);
            this.mFragmentBreadCrumbs.setActivity(this);
        }
        if (this.mFragmentBreadCrumbs.getVisibility() != 0) {
            this.setTitle(title);
        } else {
            this.mFragmentBreadCrumbs.setTitle(title, shortTitle);
            this.mFragmentBreadCrumbs.setParentTitle(null, null, null);
        }
    }

    public void setParentTitle(CharSequence title, CharSequence shortTitle, View.OnClickListener listener) {
        if (this.mFragmentBreadCrumbs != null) {
            this.mFragmentBreadCrumbs.setParentTitle(title, shortTitle, listener);
        }
    }

    void setSelectedHeader(Header header) {
        this.mCurHeader = header;
        int index = this.mHeaders.indexOf(header);
        if (index >= 0) {
            this.getListView().setItemChecked(index, true);
        } else {
            this.getListView().clearChoices();
        }
        this.showBreadCrumbs(header);
    }

    void showBreadCrumbs(Header header) {
        if (header != null) {
            CharSequence title = header.getBreadCrumbTitle(this.getResources());
            if (title == null) {
                title = header.getTitle(this.getResources());
            }
            if (title == null) {
                title = this.getTitle();
            }
            this.showBreadCrumbs(title, header.getBreadCrumbShortTitle(this.getResources()));
        } else {
            this.showBreadCrumbs(this.getTitle(), null);
        }
    }

    private void switchToHeaderInner(String fragmentName, Bundle args) {
        this.getFragmentManager().popBackStack(BACK_STACK_PREFS, 1);
        if (!this.isValidFragment(fragmentName)) {
            throw new IllegalArgumentException("Invalid fragment for this activity: " + fragmentName);
        }
        Fragment f = Fragment.instantiate(this, fragmentName, args);
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        transaction.setTransition(this.mSinglePane ? 0 : 4099);
        transaction.replace(16909165, f);
        transaction.commitAllowingStateLoss();
        if (this.mSinglePane && this.mPrefsContainer.getVisibility() == 8) {
            this.mPrefsContainer.setVisibility(0);
            this.mHeadersContainer.setVisibility(8);
        }
    }

    public void switchToHeader(String fragmentName, Bundle args) {
        Header selectedHeader = null;
        for (int i = 0; i < this.mHeaders.size(); ++i) {
            if (!fragmentName.equals(this.mHeaders.get((int)i).fragment)) continue;
            selectedHeader = this.mHeaders.get(i);
            break;
        }
        this.setSelectedHeader(selectedHeader);
        this.switchToHeaderInner(fragmentName, args);
    }

    public void switchToHeader(Header header) {
        if (this.mCurHeader == header) {
            this.getFragmentManager().popBackStack(BACK_STACK_PREFS, 1);
        } else {
            if (header.fragment == null) {
                throw new IllegalStateException("can't switch to header that has no fragment");
            }
            this.switchToHeaderInner(header.fragment, header.fragmentArguments);
            this.setSelectedHeader(header);
        }
    }

    Header findBestMatchingHeader(Header cur, ArrayList<Header> from) {
        int NM;
        ArrayList<Header> matches = new ArrayList<Header>();
        for (int j = 0; j < from.size(); ++j) {
            Header oh = from.get(j);
            if (cur == oh || cur.id != -1L && cur.id == oh.id) {
                matches.clear();
                matches.add(oh);
                break;
            }
            if (cur.fragment != null) {
                if (!cur.fragment.equals(oh.fragment)) continue;
                matches.add(oh);
                continue;
            }
            if (cur.intent != null) {
                if (!cur.intent.equals(oh.intent)) continue;
                matches.add(oh);
                continue;
            }
            if (cur.title == null || !cur.title.equals(oh.title)) continue;
            matches.add(oh);
        }
        if ((NM = matches.size()) == 1) {
            return (Header)matches.get(0);
        }
        if (NM > 1) {
            for (int j = 0; j < NM; ++j) {
                Header oh = (Header)matches.get(j);
                if (cur.fragmentArguments != null && cur.fragmentArguments.equals(oh.fragmentArguments)) {
                    return oh;
                }
                if (cur.extras != null && cur.extras.equals(oh.extras)) {
                    return oh;
                }
                if (cur.title == null || !cur.title.equals(oh.title)) continue;
                return oh;
            }
        }
        return null;
    }

    public void startPreferenceFragment(Fragment fragment, boolean push) {
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        transaction.replace(16909165, fragment);
        if (push) {
            transaction.setTransition(4097);
            transaction.addToBackStack(BACK_STACK_PREFS);
        } else {
            transaction.setTransition(4099);
        }
        transaction.commitAllowingStateLoss();
    }

    public void startPreferencePanel(String fragmentClass, Bundle args, int titleRes, CharSequence titleText, Fragment resultTo, int resultRequestCode) {
        Fragment f = Fragment.instantiate(this, fragmentClass, args);
        if (resultTo != null) {
            f.setTargetFragment(resultTo, resultRequestCode);
        }
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        transaction.replace(16909165, f);
        if (titleRes != 0) {
            transaction.setBreadCrumbTitle(titleRes);
        } else if (titleText != null) {
            transaction.setBreadCrumbTitle(titleText);
        }
        transaction.setTransition(4097);
        transaction.addToBackStack(BACK_STACK_PREFS);
        transaction.commitAllowingStateLoss();
    }

    public void finishPreferencePanel(Fragment caller, int resultCode, Intent resultData) {
        this.onBackPressed();
        if (caller != null && caller.getTargetFragment() != null) {
            caller.getTargetFragment().onActivityResult(caller.getTargetRequestCode(), resultCode, resultData);
        }
    }

    @Override
    public boolean onPreferenceStartFragment(PreferenceFragment caller, Preference pref) {
        this.startPreferencePanel(pref.getFragment(), pref.getExtras(), pref.getTitleRes(), pref.getTitle(), null, 0);
        return true;
    }

    private void postBindPreferences() {
        if (this.mHandler.hasMessages(1)) {
            return;
        }
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void bindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            preferenceScreen.bind(this.getListView());
            if (this.mSavedInstanceState != null) {
                super.onRestoreInstanceState(this.mSavedInstanceState);
                this.mSavedInstanceState = null;
            }
        }
    }

    @Deprecated
    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    private void requirePreferenceManager() {
        if (this.mPreferenceManager == null) {
            if (this.mAdapter == null) {
                throw new RuntimeException("This should be called after super.onCreate.");
            }
            throw new RuntimeException("Modern two-pane PreferenceActivity requires use of a PreferenceFragment");
        }
    }

    @Deprecated
    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        this.requirePreferenceManager();
        if (this.mPreferenceManager.setPreferences(preferenceScreen) && preferenceScreen != null) {
            this.postBindPreferences();
            CharSequence title = this.getPreferenceScreen().getTitle();
            if (title != null) {
                this.setTitle(title);
            }
        }
    }

    @Deprecated
    public PreferenceScreen getPreferenceScreen() {
        if (this.mPreferenceManager != null) {
            return this.mPreferenceManager.getPreferenceScreen();
        }
        return null;
    }

    @Deprecated
    public void addPreferencesFromIntent(Intent intent) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromIntent(intent, this.getPreferenceScreen()));
    }

    @Deprecated
    public void addPreferencesFromResource(int preferencesResId) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromResource(this, preferencesResId, this.getPreferenceScreen()));
    }

    @Override
    @Deprecated
    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        return false;
    }

    @Deprecated
    public Preference findPreference(CharSequence key) {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(key);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchNewIntent(intent);
        }
    }

    protected boolean hasNextButton() {
        return this.mNextButton != null;
    }

    protected Button getNextButton() {
        return this.mNextButton;
    }

    public static final class Header
    implements Parcelable {
        public long id = -1L;
        public int titleRes;
        public CharSequence title;
        public int summaryRes;
        public CharSequence summary;
        public int breadCrumbTitleRes;
        public CharSequence breadCrumbTitle;
        public int breadCrumbShortTitleRes;
        public CharSequence breadCrumbShortTitle;
        public int iconRes;
        public String fragment;
        public Bundle fragmentArguments;
        public Intent intent;
        public Bundle extras;
        public static final Parcelable.Creator<Header> CREATOR = new Parcelable.Creator<Header>(){

            @Override
            public Header createFromParcel(Parcel source) {
                return new Header(source);
            }

            public Header[] newArray(int size) {
                return new Header[size];
            }
        };

        public Header() {
        }

        public CharSequence getTitle(Resources res) {
            if (this.titleRes != 0) {
                return res.getText(this.titleRes);
            }
            return this.title;
        }

        public CharSequence getSummary(Resources res) {
            if (this.summaryRes != 0) {
                return res.getText(this.summaryRes);
            }
            return this.summary;
        }

        public CharSequence getBreadCrumbTitle(Resources res) {
            if (this.breadCrumbTitleRes != 0) {
                return res.getText(this.breadCrumbTitleRes);
            }
            return this.breadCrumbTitle;
        }

        public CharSequence getBreadCrumbShortTitle(Resources res) {
            if (this.breadCrumbShortTitleRes != 0) {
                return res.getText(this.breadCrumbShortTitleRes);
            }
            return this.breadCrumbShortTitle;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.id);
            dest.writeInt(this.titleRes);
            TextUtils.writeToParcel(this.title, dest, flags);
            dest.writeInt(this.summaryRes);
            TextUtils.writeToParcel(this.summary, dest, flags);
            dest.writeInt(this.breadCrumbTitleRes);
            TextUtils.writeToParcel(this.breadCrumbTitle, dest, flags);
            dest.writeInt(this.breadCrumbShortTitleRes);
            TextUtils.writeToParcel(this.breadCrumbShortTitle, dest, flags);
            dest.writeInt(this.iconRes);
            dest.writeString(this.fragment);
            dest.writeBundle(this.fragmentArguments);
            if (this.intent != null) {
                dest.writeInt(1);
                this.intent.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
            dest.writeBundle(this.extras);
        }

        public void readFromParcel(Parcel in) {
            this.id = in.readLong();
            this.titleRes = in.readInt();
            this.title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.summaryRes = in.readInt();
            this.summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.breadCrumbTitleRes = in.readInt();
            this.breadCrumbTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.breadCrumbShortTitleRes = in.readInt();
            this.breadCrumbShortTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.iconRes = in.readInt();
            this.fragment = in.readString();
            this.fragmentArguments = in.readBundle();
            if (in.readInt() != 0) {
                this.intent = Intent.CREATOR.createFromParcel(in);
            }
            this.extras = in.readBundle();
        }

        Header(Parcel in) {
            this.readFromParcel(in);
        }
    }

    private static class HeaderAdapter
    extends ArrayAdapter<Header> {
        private LayoutInflater mInflater;
        private int mLayoutResId;
        private boolean mRemoveIconIfEmpty;

        public HeaderAdapter(Context context, List<Header> objects, int layoutResId, boolean removeIconBehavior) {
            super(context, 0, objects);
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mLayoutResId = layoutResId;
            this.mRemoveIconIfEmpty = removeIconBehavior;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            HeaderViewHolder holder;
            View view;
            if (convertView == null) {
                view = this.mInflater.inflate(this.mLayoutResId, parent, false);
                holder = new HeaderViewHolder();
                holder.icon = (ImageView)view.findViewById(16908294);
                holder.title = (TextView)view.findViewById(16908310);
                holder.summary = (TextView)view.findViewById(0x1020010);
                view.setTag(holder);
            } else {
                view = convertView;
                holder = (HeaderViewHolder)view.getTag();
            }
            Header header = (Header)this.getItem(position);
            if (this.mRemoveIconIfEmpty) {
                if (header.iconRes == 0) {
                    holder.icon.setVisibility(8);
                } else {
                    holder.icon.setVisibility(0);
                    holder.icon.setImageResource(header.iconRes);
                }
            } else {
                holder.icon.setImageResource(header.iconRes);
            }
            holder.title.setText(header.getTitle(this.getContext().getResources()));
            CharSequence summary = header.getSummary(this.getContext().getResources());
            if (!TextUtils.isEmpty(summary)) {
                holder.summary.setVisibility(0);
                holder.summary.setText(summary);
            } else {
                holder.summary.setVisibility(8);
            }
            return view;
        }

        private static class HeaderViewHolder {
            ImageView icon;
            TextView title;
            TextView summary;

            private HeaderViewHolder() {
            }
        }
    }
}

