/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import libcore.util.EmptyArray;

public abstract class ArrayUtils {
    private ArrayUtils() {
    }

    public static String[] nullToEmpty(String[] array2) {
        return array2 != null ? array2 : EmptyArray.STRING;
    }

    public static String[] cloneIfNotEmpty(String[] array2) {
        return array2 != null && array2.length > 0 ? (String[])array2.clone() : array2;
    }

    public static byte[] cloneIfNotEmpty(byte[] array2) {
        return array2 != null && array2.length > 0 ? (byte[])array2.clone() : array2;
    }

    public static byte[] concat(byte[] arr1, byte[] arr2) {
        return ArrayUtils.concat(arr1, 0, arr1 != null ? arr1.length : 0, arr2, 0, arr2 != null ? arr2.length : 0);
    }

    public static byte[] concat(byte[] arr1, int offset1, int len1, byte[] arr2, int offset2, int len2) {
        if (len1 == 0) {
            return ArrayUtils.subarray(arr2, offset2, len2);
        }
        if (len2 == 0) {
            return ArrayUtils.subarray(arr1, offset1, len1);
        }
        byte[] result = new byte[len1 + len2];
        System.arraycopy((byte[])arr1, (int)offset1, (byte[])result, (int)0, (int)len1);
        System.arraycopy((byte[])arr2, (int)offset2, (byte[])result, (int)len1, (int)len2);
        return result;
    }

    public static byte[] subarray(byte[] arr, int offset, int len) {
        if (len == 0) {
            return EmptyArray.BYTE;
        }
        if (offset == 0 && len == arr.length) {
            return arr;
        }
        byte[] result = new byte[len];
        System.arraycopy((byte[])arr, (int)offset, (byte[])result, (int)0, (int)len);
        return result;
    }

    public static int[] concat(int[] arr1, int[] arr2) {
        if (arr1 == null || arr1.length == 0) {
            return arr2;
        }
        if (arr2 == null || arr2.length == 0) {
            return arr1;
        }
        int[] result = new int[arr1.length + arr2.length];
        System.arraycopy((int[])arr1, (int)0, (int[])result, (int)0, (int)arr1.length);
        System.arraycopy((int[])arr2, (int)0, (int[])result, (int)arr1.length, (int)arr2.length);
        return result;
    }
}

