/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.ApplicationConfig;
import android.security.net.config.KeyStoreConfigSource;
import android.security.net.config.NetworkSecurityConfig;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class RootTrustManagerFactorySpi
extends TrustManagerFactorySpi {
    private ApplicationConfig mApplicationConfig;
    private NetworkSecurityConfig mConfig;

    @Override
    public void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        if (!(spec instanceof ApplicationConfigParameters)) {
            throw new InvalidAlgorithmParameterException("Unsupported spec: " + spec + ". Only " + ApplicationConfigParameters.class.getName() + " supported");
        }
        this.mApplicationConfig = ((ApplicationConfigParameters)spec).config;
    }

    @Override
    public void engineInit(KeyStore ks) throws KeyStoreException {
        this.mApplicationConfig = ks != null ? new ApplicationConfig(new KeyStoreConfigSource(ks)) : ApplicationConfig.getDefaultInstance();
    }

    @Override
    public TrustManager[] engineGetTrustManagers() {
        if (this.mApplicationConfig == null) {
            throw new IllegalStateException("TrustManagerFactory not initialized");
        }
        return new TrustManager[]{this.mApplicationConfig.getTrustManager()};
    }

    public static final class ApplicationConfigParameters
    implements ManagerFactoryParameters {
        public final ApplicationConfig config;

        public ApplicationConfigParameters(ApplicationConfig config) {
            this.config = config;
        }
    }
}

