/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.annotation.IntDef;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.FillContext;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public final class FillRequest
implements Parcelable {
    public static final int FLAG_MANUAL_REQUEST = 1;
    public static final int INVALID_REQUEST_ID = Integer.MIN_VALUE;
    private final int mId;
    private final int mFlags;
    private final ArrayList<FillContext> mContexts;
    private final Bundle mClientState;
    public static final Parcelable.Creator<FillRequest> CREATOR = new Parcelable.Creator<FillRequest>(){

        @Override
        public FillRequest createFromParcel(Parcel parcel) {
            return new FillRequest(parcel);
        }

        public FillRequest[] newArray(int size) {
            return new FillRequest[size];
        }
    };

    private FillRequest(Parcel parcel) {
        this.mId = parcel.readInt();
        this.mContexts = new ArrayList();
        parcel.readParcelableList(this.mContexts, null);
        this.mClientState = parcel.readBundle();
        this.mFlags = parcel.readInt();
    }

    public FillRequest(int id2, ArrayList<FillContext> contexts, Bundle clientState, int flags) {
        this.mId = id2;
        this.mFlags = Preconditions.checkFlagsArgument(flags, 1);
        this.mContexts = Preconditions.checkCollectionElementsNotNull(contexts, "contexts");
        this.mClientState = clientState;
    }

    public int getId() {
        return this.mId;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public List<FillContext> getFillContexts() {
        return this.mContexts;
    }

    public Bundle getClientState() {
        return this.mClientState;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mId);
        parcel.writeParcelableList(this.mContexts, flags);
        parcel.writeBundle(this.mClientState);
        parcel.writeInt(this.mFlags);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L})
    static @interface RequestFlags {
    }
}

