/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.annotation.IntDef;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DebugUtils;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public final class SaveInfo
implements Parcelable {
    public static final int SAVE_DATA_TYPE_GENERIC = 0;
    public static final int SAVE_DATA_TYPE_PASSWORD = 1;
    public static final int SAVE_DATA_TYPE_ADDRESS = 2;
    public static final int SAVE_DATA_TYPE_CREDIT_CARD = 4;
    public static final int SAVE_DATA_TYPE_USERNAME = 8;
    public static final int SAVE_DATA_TYPE_EMAIL_ADDRESS = 16;
    public static final int NEGATIVE_BUTTON_STYLE_CANCEL = 0;
    public static final int NEGATIVE_BUTTON_STYLE_REJECT = 1;
    public static final int FLAG_SAVE_ON_ALL_VIEWS_INVISIBLE = 1;
    private final int mType;
    private final int mNegativeButtonStyle;
    private final IntentSender mNegativeActionListener;
    private final AutofillId[] mRequiredIds;
    private final AutofillId[] mOptionalIds;
    private final CharSequence mDescription;
    private final int mFlags;
    public static final Parcelable.Creator<SaveInfo> CREATOR = new Parcelable.Creator<SaveInfo>(){

        @Override
        public SaveInfo createFromParcel(Parcel parcel) {
            Builder builder = new Builder(parcel.readInt(), (AutofillId[])parcel.readParcelableArray(null, AutofillId.class));
            builder.setNegativeAction(parcel.readInt(), (IntentSender)parcel.readParcelable(null));
            AutofillId[] optionalIds = (AutofillId[])parcel.readParcelableArray(null, AutofillId.class);
            if (optionalIds != null) {
                builder.setOptionalIds(optionalIds);
            }
            builder.setDescription(parcel.readCharSequence());
            builder.setFlags(parcel.readInt());
            return builder.build();
        }

        public SaveInfo[] newArray(int size) {
            return new SaveInfo[size];
        }
    };

    private SaveInfo(Builder builder) {
        this.mType = builder.mType;
        this.mNegativeButtonStyle = builder.mNegativeButtonStyle;
        this.mNegativeActionListener = builder.mNegativeActionListener;
        this.mRequiredIds = builder.mRequiredIds;
        this.mOptionalIds = builder.mOptionalIds;
        this.mDescription = builder.mDescription;
        this.mFlags = builder.mFlags;
    }

    public int getNegativeActionStyle() {
        return this.mNegativeButtonStyle;
    }

    public IntentSender getNegativeActionListener() {
        return this.mNegativeActionListener;
    }

    public AutofillId[] getRequiredIds() {
        return this.mRequiredIds;
    }

    public AutofillId[] getOptionalIds() {
        return this.mOptionalIds;
    }

    public int getType() {
        return this.mType;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public CharSequence getDescription() {
        return this.mDescription;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "SaveInfo: [type=" + DebugUtils.flagsToString(SaveInfo.class, "SAVE_DATA_TYPE_", this.mType) + ", requiredIds=" + Arrays.toString(this.mRequiredIds) + ", optionalIds=" + Arrays.toString(this.mOptionalIds) + ", description=" + this.mDescription + DebugUtils.flagsToString(SaveInfo.class, "NEGATIVE_BUTTON_STYLE_", this.mNegativeButtonStyle) + ", mFlags=" + this.mFlags + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeParcelableArray(this.mRequiredIds, flags);
        parcel.writeInt(this.mNegativeButtonStyle);
        parcel.writeParcelable(this.mNegativeActionListener, flags);
        parcel.writeParcelableArray(this.mOptionalIds, flags);
        parcel.writeCharSequence(this.mDescription);
        parcel.writeInt(this.mFlags);
    }

    public static final class Builder {
        private final int mType;
        private int mNegativeButtonStyle = 0;
        private IntentSender mNegativeActionListener;
        private final AutofillId[] mRequiredIds;
        private AutofillId[] mOptionalIds;
        private CharSequence mDescription;
        private boolean mDestroyed;
        private int mFlags;

        public Builder(int type, AutofillId[] requiredIds) {
            this.mType = type;
            this.mRequiredIds = this.assertValid(requiredIds);
        }

        private AutofillId[] assertValid(AutofillId[] ids) {
            Preconditions.checkArgument(ids != null && ids.length > 0, "must have at least one id: " + Arrays.toString(ids));
            for (int i = 0; i < ids.length; ++i) {
                AutofillId id2 = ids[i];
                Preconditions.checkArgument(id2 != null, "cannot have null id: " + Arrays.toString(ids));
            }
            return ids;
        }

        public Builder setFlags(int flags) {
            this.throwIfDestroyed();
            this.mFlags = Preconditions.checkFlagsArgument(flags, 1);
            return this;
        }

        public Builder setOptionalIds(AutofillId[] ids) {
            this.throwIfDestroyed();
            this.mOptionalIds = this.assertValid(ids);
            return this;
        }

        public Builder setDescription(CharSequence description) {
            this.throwIfDestroyed();
            this.mDescription = description;
            return this;
        }

        public Builder setNegativeAction(int style2, IntentSender listener) {
            this.throwIfDestroyed();
            if (style2 != 0 && style2 != 1) {
                throw new IllegalArgumentException("Invalid style: " + style2);
            }
            this.mNegativeButtonStyle = style2;
            this.mNegativeActionListener = listener;
            return this;
        }

        public SaveInfo build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new SaveInfo(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L})
    static @interface SaveInfoFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={0L, 1L, 2L, 4L, 8L, 16L})
    static @interface SaveDataType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    static @interface NegativeButtonStyle {
    }
}

