/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.voice.AlwaysOnHotwordDetector;
import android.service.voice.IVoiceInteractionService;
import com.android.internal.app.IVoiceInteractionManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Locale;

public class VoiceInteractionService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.voice.VoiceInteractionService";
    public static final String SERVICE_META_DATA = "android.voice_interaction";
    IVoiceInteractionService mInterface = new IVoiceInteractionService.Stub(){

        @Override
        public void ready() {
            VoiceInteractionService.this.mHandler.sendEmptyMessage(1);
        }

        @Override
        public void shutdown() {
            VoiceInteractionService.this.mHandler.sendEmptyMessage(2);
        }

        @Override
        public void soundModelsChanged() {
            VoiceInteractionService.this.mHandler.sendEmptyMessage(3);
        }

        @Override
        public void launchVoiceAssistFromKeyguard() throws RemoteException {
            VoiceInteractionService.this.mHandler.sendEmptyMessage(4);
        }
    };
    MyHandler mHandler;
    IVoiceInteractionManagerService mSystemService;
    private final Object mLock = new Object();
    private KeyphraseEnrollmentInfo mKeyphraseEnrollmentInfo;
    private AlwaysOnHotwordDetector mHotwordDetector;
    static final int MSG_READY = 1;
    static final int MSG_SHUTDOWN = 2;
    static final int MSG_SOUND_MODELS_CHANGED = 3;
    static final int MSG_LAUNCH_VOICE_ASSIST_FROM_KEYGUARD = 4;

    public void onLaunchVoiceAssistFromKeyguard() {
    }

    public static boolean isActiveService(Context context, ComponentName service) {
        String cur = Settings.Secure.getString(context.getContentResolver(), "voice_interaction_service");
        if (cur == null || cur.isEmpty()) {
            return false;
        }
        ComponentName curComp = ComponentName.unflattenFromString(cur);
        if (curComp == null) {
            return false;
        }
        return curComp.equals(service);
    }

    public void setDisabledShowContext(int flags) {
        try {
            this.mSystemService.setDisabledShowContext(flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getDisabledShowContext() {
        try {
            return this.mSystemService.getDisabledShowContext();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void showSession(Bundle args, int flags) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        try {
            this.mSystemService.showSession(this.mInterface, args, flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.mHandler = new MyHandler();
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        return null;
    }

    public void onReady() {
        this.mSystemService = IVoiceInteractionManagerService.Stub.asInterface(ServiceManager.getService("voiceinteraction"));
        this.mKeyphraseEnrollmentInfo = new KeyphraseEnrollmentInfo(this.getPackageManager());
    }

    private void onShutdownInternal() {
        this.onShutdown();
        this.safelyShutdownHotwordDetector();
    }

    public void onShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSoundModelsChangedInternal() {
        VoiceInteractionService voiceInteractionService = this;
        synchronized (voiceInteractionService) {
            if (this.mHotwordDetector != null) {
                this.mHotwordDetector.onSoundModelsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AlwaysOnHotwordDetector createAlwaysOnHotwordDetector(String keyphrase, Locale locale, AlwaysOnHotwordDetector.Callback callback) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.safelyShutdownHotwordDetector();
            this.mHotwordDetector = new AlwaysOnHotwordDetector(keyphrase, locale, callback, this.mKeyphraseEnrollmentInfo, this.mInterface, this.mSystemService);
        }
        return this.mHotwordDetector;
    }

    protected final KeyphraseEnrollmentInfo getKeyphraseEnrollmentInfo() {
        return this.mKeyphraseEnrollmentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyShutdownHotwordDetector() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHotwordDetector != null) {
                    this.mHotwordDetector.stopRecognition();
                    this.mHotwordDetector.invalidate();
                    this.mHotwordDetector = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("VOICE INTERACTION");
        Object object = this.mLock;
        synchronized (object) {
            pw.println("  AlwaysOnHotwordDetector");
            if (this.mHotwordDetector == null) {
                pw.println("    NULL");
            } else {
                this.mHotwordDetector.dump("    ", pw);
            }
        }
    }

    class MyHandler
    extends Handler {
        MyHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    VoiceInteractionService.this.onReady();
                    break;
                }
                case 2: {
                    VoiceInteractionService.this.onShutdownInternal();
                    break;
                }
                case 3: {
                    VoiceInteractionService.this.onSoundModelsChangedInternal();
                    break;
                }
                case 4: {
                    VoiceInteractionService.this.onLaunchVoiceAssistFromKeyguard();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

