/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioTrack;
import android.speech.tts.AbstractEventLogger;
import android.speech.tts.BlockingAudioTrack;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class SynthesisPlaybackQueueItem
extends PlaybackQueueItem
implements AudioTrack.OnPlaybackPositionUpdateListener {
    private static final String TAG = "TTS.SynthQueueItem";
    private static final boolean DBG = false;
    private static final long MAX_UNCONSUMED_AUDIO_MS = 500L;
    private final Lock mListLock = new ReentrantLock();
    private final Condition mReadReady = this.mListLock.newCondition();
    private final Condition mNotFull = this.mListLock.newCondition();
    private final LinkedList<ListEntry> mDataBufferList = new LinkedList();
    private int mUnconsumedBytes = 0;
    private volatile boolean mStopped = false;
    private volatile boolean mDone = false;
    private volatile int mStatusCode = 0;
    private final BlockingAudioTrack mAudioTrack;
    private final AbstractEventLogger mLogger;
    private ConcurrentLinkedQueue<ProgressMarker> markerList = new ConcurrentLinkedQueue();

    SynthesisPlaybackQueueItem(TextToSpeechService.AudioOutputParams audioParams, int sampleRate, int audioFormat, int channelCount, TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, AbstractEventLogger logger) {
        super(dispatcher, callerIdentity);
        this.mAudioTrack = new BlockingAudioTrack(audioParams, sampleRate, audioFormat, channelCount);
        this.mLogger = logger;
    }

    @Override
    public void run() {
        TextToSpeechService.UtteranceProgressDispatcher dispatcher = this.getDispatcher();
        dispatcher.dispatchOnStart();
        if (!this.mAudioTrack.init()) {
            dispatcher.dispatchOnError(-5);
            return;
        }
        this.mAudioTrack.setPlaybackPositionUpdateListener(this);
        this.updateMarker();
        try {
            byte[] buffer = null;
            while ((buffer = this.take()) != null) {
                this.mAudioTrack.write(buffer);
                this.mLogger.onAudioDataWritten();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mAudioTrack.waitAndRelease();
        if (this.mStatusCode == 0) {
            dispatcher.dispatchOnSuccess();
        } else if (this.mStatusCode == -2) {
            dispatcher.dispatchOnStop();
        } else {
            dispatcher.dispatchOnError(this.mStatusCode);
        }
        this.mLogger.onCompleted(this.mStatusCode);
    }

    @Override
    void stop(int statusCode) {
        try {
            this.mListLock.lock();
            this.mStopped = true;
            this.mStatusCode = statusCode;
            this.mReadReady.signal();
            this.mNotFull.signal();
        }
        finally {
            this.mListLock.unlock();
        }
        this.mAudioTrack.stop();
    }

    void done() {
        try {
            this.mListLock.lock();
            this.mDone = true;
            this.mReadReady.signal();
            this.mNotFull.signal();
        }
        finally {
            this.mListLock.unlock();
        }
    }

    void updateMarker() {
        ProgressMarker marker = this.markerList.peek();
        if (marker != null) {
            int markerInFrames = marker.frames == 0 ? 1 : marker.frames;
            this.mAudioTrack.setNotificationMarkerPosition(markerInFrames);
        }
    }

    void rangeStart(int markerInFrames, int start, int end) {
        this.markerList.add(new ProgressMarker(markerInFrames, start, end));
        this.updateMarker();
    }

    @Override
    public void onMarkerReached(AudioTrack track) {
        ProgressMarker marker = this.markerList.poll();
        if (marker == null) {
            Log.e(TAG, "onMarkerReached reached called but no marker in queue");
            return;
        }
        this.getDispatcher().dispatchOnRangeStart(marker.start, marker.end, marker.frames);
        this.updateMarker();
    }

    @Override
    public void onPeriodicNotification(AudioTrack track) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(byte[] buffer) throws InterruptedException {
        try {
            this.mListLock.lock();
            long unconsumedAudioMs = 0L;
            while ((unconsumedAudioMs = this.mAudioTrack.getAudioLengthMs(this.mUnconsumedBytes)) > 500L && !this.mStopped) {
                this.mNotFull.await();
            }
            if (this.mStopped) {
                return;
            }
            this.mDataBufferList.add(new ListEntry(buffer));
            this.mUnconsumedBytes += buffer.length;
            this.mReadReady.signal();
        }
        finally {
            this.mListLock.unlock();
        }
    }

    private byte[] take() throws InterruptedException {
        try {
            this.mListLock.lock();
            while (this.mDataBufferList.size() == 0 && !this.mStopped && !this.mDone) {
                this.mReadReady.await();
            }
            if (this.mStopped) {
                byte[] byArray = null;
                return byArray;
            }
            ListEntry entry = this.mDataBufferList.poll();
            if (entry == null) {
                byte[] byArray = null;
                return byArray;
            }
            this.mUnconsumedBytes -= entry.mBytes.length;
            this.mNotFull.signal();
            byte[] byArray = entry.mBytes;
            return byArray;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    static final class ListEntry {
        final byte[] mBytes;

        ListEntry(byte[] bytes) {
            this.mBytes = bytes;
        }
    }

    private class ProgressMarker {
        public final int frames;
        public final int start;
        public final int end;

        public ProgressMarker(int frames, int start, int end) {
            this.frames = frames;
            this.start = start;
            this.end = end;
        }
    }
}

