/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.IntDef;
import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class ImsFeature {
    private static final String LOG_TAG = "ImsFeature";
    public static final String ACTION_IMS_SERVICE_UP = "com.android.ims.IMS_SERVICE_UP";
    public static final String ACTION_IMS_SERVICE_DOWN = "com.android.ims.IMS_SERVICE_DOWN";
    public static final String EXTRA_PHONE_ID = "android:phone_id";
    public static final int INVALID = -1;
    public static final int EMERGENCY_MMTEL = 0;
    public static final int MMTEL = 1;
    public static final int RCS = 2;
    public static final int MAX = 3;
    public static final int STATE_NOT_AVAILABLE = 0;
    public static final int STATE_INITIALIZING = 1;
    public static final int STATE_READY = 2;
    private List<INotifyFeatureRemoved> mRemovedListeners = new ArrayList<INotifyFeatureRemoved>();
    private final Set<IImsFeatureStatusCallback> mStatusCallbacks = Collections.newSetFromMap(new WeakHashMap());
    private int mState = 0;
    private int mSlotId = -1;
    private Context mContext;

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setSlotId(int slotId) {
        this.mSlotId = slotId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatureRemovedListener(INotifyFeatureRemoved listener) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatureRemovedListener(INotifyFeatureRemoved listener) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFeatureRemoved(int slotId) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.forEach(l -> l.onFeatureRemoved(slotId));
            this.onFeatureRemoved();
        }
    }

    public int getFeatureState() {
        return this.mState;
    }

    protected final void setFeatureState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.notifyFeatureState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        if (c == null) {
            return;
        }
        try {
            c.notifyImsFeatureStatus(this.mState);
            Set<IImsFeatureStatusCallback> set = this.mStatusCallbacks;
            synchronized (set) {
                this.mStatusCallbacks.add(c);
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Couldn't notify feature state: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        if (c == null) {
            return;
        }
        Set<IImsFeatureStatusCallback> set = this.mStatusCallbacks;
        synchronized (set) {
            this.mStatusCallbacks.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFeatureState(int state) {
        Set<IImsFeatureStatusCallback> set = this.mStatusCallbacks;
        synchronized (set) {
            Iterator<IImsFeatureStatusCallback> iter = this.mStatusCallbacks.iterator();
            while (iter.hasNext()) {
                IImsFeatureStatusCallback callback = iter.next();
                try {
                    Log.i(LOG_TAG, "notifying ImsFeatureState=" + state);
                    callback.notifyImsFeatureStatus(state);
                }
                catch (RemoteException e) {
                    iter.remove();
                    Log.w(LOG_TAG, "Couldn't notify feature state: " + e.getMessage());
                }
            }
        }
        this.sendImsServiceIntent(state);
    }

    private void sendImsServiceIntent(int state) {
        Intent intent;
        if (this.mContext == null || this.mSlotId == -1) {
            return;
        }
        switch (state) {
            case 0: 
            case 1: {
                intent = new Intent(ACTION_IMS_SERVICE_DOWN);
                break;
            }
            case 2: {
                intent = new Intent(ACTION_IMS_SERVICE_UP);
                break;
            }
            default: {
                intent = new Intent(ACTION_IMS_SERVICE_DOWN);
            }
        }
        intent.putExtra(EXTRA_PHONE_ID, this.mSlotId);
        this.mContext.sendBroadcast(intent);
    }

    public abstract void onFeatureRemoved();

    public static interface INotifyFeatureRemoved {
        public void onFeatureRemoved(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={0L, 1L, 2L})
    public static @interface ImsState {
    }
}

