/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Layout;

public class AndroidBidi {
    public static int bidi(int dir, char[] chs, byte[] chInfo, int n, boolean haveInfo) {
        if (chs == null || chInfo == null) {
            throw new NullPointerException();
        }
        if (n < 0 || chs.length < n || chInfo.length < n) {
            throw new IndexOutOfBoundsException();
        }
        switch (dir) {
            case 1: {
                dir = 0;
                break;
            }
            case -1: {
                dir = 1;
                break;
            }
            case 2: {
                dir = -2;
                break;
            }
            case -2: {
                dir = -1;
                break;
            }
            default: {
                dir = 0;
            }
        }
        int result = AndroidBidi.runBidi(dir, chs, chInfo, n, haveInfo);
        result = (result & 1) == 0 ? 1 : -1;
        return result;
    }

    public static Layout.Directions directions(int dir, byte[] levels, int lstart, char[] chars, int cstart, int len) {
        boolean swap;
        int i;
        int curLevel;
        if (len == 0) {
            return Layout.DIRS_ALL_LEFT_TO_RIGHT;
        }
        int baseLevel = dir == 1 ? 0 : 1;
        int minLevel = curLevel = levels[lstart];
        int runCount = 1;
        int e = lstart + len;
        for (int i2 = lstart + 1; i2 < e; ++i2) {
            int level = levels[i2];
            if (level == curLevel) continue;
            curLevel = level;
            ++runCount;
        }
        int visLen = len;
        if ((curLevel & 1) != (baseLevel & 1)) {
            while (--visLen >= 0) {
                char ch = chars[cstart + visLen];
                if (ch == '\n') {
                    --visLen;
                    break;
                }
                if (ch == ' ' || ch == '\t') continue;
                break;
            }
            if (++visLen != len) {
                ++runCount;
            }
        }
        if (runCount == 1 && minLevel == baseLevel) {
            if ((minLevel & 1) != 0) {
                return Layout.DIRS_ALL_RIGHT_TO_LEFT;
            }
            return Layout.DIRS_ALL_LEFT_TO_RIGHT;
        }
        int[] ld = new int[runCount * 2];
        int maxLevel = minLevel;
        int levelBits = minLevel << 26;
        int n = 1;
        int prev = lstart;
        curLevel = minLevel;
        int e2 = lstart + visLen;
        for (i = lstart; i < e2; ++i) {
            int level = levels[i];
            if (level == curLevel) continue;
            curLevel = level;
            if (level > maxLevel) {
                maxLevel = level;
            } else if (level < minLevel) {
                minLevel = level;
            }
            ld[n++] = i - prev | levelBits;
            ld[n++] = i - lstart;
            levelBits = curLevel << 26;
            prev = i;
        }
        ld[n] = lstart + visLen - prev | levelBits;
        if (visLen < len) {
            ld[++n] = visLen;
            ld[++n] = len - visLen | baseLevel << 26;
        }
        if ((minLevel & 1) == baseLevel) {
            swap = maxLevel > ++minLevel;
        } else {
            boolean bl = swap = runCount > 1;
        }
        if (swap) {
            for (int level = maxLevel - 1; level >= minLevel; --level) {
                for (i = 0; i < ld.length; i += 2) {
                    if (levels[ld[i]] < level) continue;
                    for (e2 = i + 2; e2 < ld.length && levels[ld[e2]] >= level; e2 += 2) {
                    }
                    int low = i;
                    for (int hi = e2 - 2; low < hi; low += 2, hi -= 2) {
                        int x = ld[low];
                        ld[low] = ld[hi];
                        ld[hi] = x;
                        x = ld[low + 1];
                        ld[low + 1] = ld[hi + 1];
                        ld[hi + 1] = x;
                    }
                    i = e2 + 2;
                }
            }
        }
        return new Layout.Directions(ld);
    }

    private static native int runBidi(int var0, char[] var1, byte[] var2, int var3, boolean var4);
}

