/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.IntDef;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class FontConfig {
    private final Family[] mFamilies;
    private final Alias[] mAliases;

    public FontConfig(Family[] families, Alias[] aliases) {
        this.mFamilies = families;
        this.mAliases = aliases;
    }

    public Family[] getFamilies() {
        return this.mFamilies;
    }

    public Alias[] getAliases() {
        return this.mAliases;
    }

    public static final class Family {
        private final String mName;
        private final Font[] mFonts;
        private final String mLanguage;
        public static final int VARIANT_DEFAULT = 0;
        public static final int VARIANT_COMPACT = 1;
        public static final int VARIANT_ELEGANT = 2;
        private final int mVariant;

        public Family(String name, Font[] fonts, String language, int variant) {
            this.mName = name;
            this.mFonts = fonts;
            this.mLanguage = language;
            this.mVariant = variant;
        }

        public String getName() {
            return this.mName;
        }

        public Font[] getFonts() {
            return this.mFonts;
        }

        public String getLanguage() {
            return this.mLanguage;
        }

        public int getVariant() {
            return this.mVariant;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L})
        public static @interface Variant {
        }
    }

    public static final class Alias {
        private final String mName;
        private final String mToName;
        private final int mWeight;

        public Alias(String name, String toName, int weight) {
            this.mName = name;
            this.mToName = toName;
            this.mWeight = weight;
        }

        public String getName() {
            return this.mName;
        }

        public String getToName() {
            return this.mToName;
        }

        public int getWeight() {
            return this.mWeight;
        }
    }

    public static final class Font {
        private final String mFontName;
        private final int mTtcIndex;
        private final FontVariationAxis[] mAxes;
        private final int mWeight;
        private final boolean mIsItalic;
        private Uri mUri;

        public Font(String fontName, int ttcIndex, FontVariationAxis[] axes, int weight, boolean isItalic) {
            this.mFontName = fontName;
            this.mTtcIndex = ttcIndex;
            this.mAxes = axes;
            this.mWeight = weight;
            this.mIsItalic = isItalic;
        }

        public String getFontName() {
            return this.mFontName;
        }

        public int getTtcIndex() {
            return this.mTtcIndex;
        }

        public FontVariationAxis[] getAxes() {
            return this.mAxes;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mIsItalic;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public void setUri(Uri uri) {
            this.mUri = uri;
        }
    }
}

